#ifndef MENU_H
#define MENU_H
#include "global.h"
#include "Data.h"
#include "Drawer.h"

enum mim_main { mim_quickrace=0, mim_career, mim_options, mim_records, mim_exit, 
	mim_opt_controls, mim_opt_graphics, mim_opt_sound, mim_opt_language, mim_opt_language_value, mim_opt_about,
	mim_controls_assign_keys,mim_controls_use_joystick,mim_controls_use_joystick_value,mim_controls_assign_joystick,
	mim_graphics_particles, mim_graphics_particles_value, mim_graphics_textures, mim_graphics_textures_value, mim_graphics_resolution, mim_graphics_resolution_value, mim_graphics_fullscreen, mim_graphics_fullscreen_value,
	mim_sound_fx_on, mim_sound_fx_on_value, mim_sound_fx_vol, mim_sound_fx_vol_value, mim_sound_music_on, mim_sound_music_on_value, mim_sound_music_vol, mim_sound_music_vol_value,
//	mim_sound,mim_sound_value,mim_particles,mim_particles_value,mim_textures,mim_textures_value,mim_mode,mim_mode_value,
	mim_practice, mim_single_race, mim_championship, mim_setup_bike, mim_change_profile, mim_help_career,
	mim_count };
enum prev_main { prev_quit, prev_options, prev_main };

class Menu :public Drawer {
private:
	struct menu_item {
		string help[3];
		string label;
		bool visible;
		int tostart;
		unsigned int charsdone;
		int pos[2];
		int sel_level;
		bool selected;
		bool is_top;
		bool is_bottom;
		bool is_double;
		bool is_value;
		void Set(int menu_type, int ipos, string alabel, bool abottom, bool adouble, bool avalue, string hlp1="",string hlp2="",string hlp3="") {
			charsdone=0;
			selected=false; sel_level=0;
			if (menu_type==0) {
				tostart=ipos*5*char_speed+40;
				pos[0]=mx-m1w/2*my_global_scale+140;
				pos[1]=my-m1w/2*my_global_scale+62+(45)*(ipos+1);
				visible=true;
			} else {
				tostart=0; visible=false;
				if (avalue)
					pos[0]=screen_w-20;
				else
					pos[0]=screen_w-250;
				if (menu_type==1)
					pos[1]=135+(55)*(ipos+1);
				else if (menu_type==2)
					pos[1]=135+(45)*(ipos+1);
			}
			label=alabel;
			is_top=ipos==0;
			is_bottom=abottom;
			is_double=adouble;
			is_value=avalue;
			help[0]=hlp1;
			help[1]=hlp2;
			help[2]=hlp3;
		}
	};
		
	
	Sprite lsprite; int lw,lh;
	declare_wh(bl);
	Image m1image; Sprite m1sprite; real main_h;
	declare_wh(m2); int second_w; bool show_second;
	declare_wh(s);
	declare_wh(w);
	declare_wh(b);
	declare_fade;
	
	static int my_global_scale;
	void Reload();
	real la;
	string sversion;
	
	static int mx,my,m1w,m1h;
	int sel_fnum;
	int last_move_time;
	int second_x,second_y;
	real sel_target_x, sel_target_y;
	
	string second_title;
	bool in_options;
	bool show_help;
	
//	string help[mim_count+profile_max][3];
//	string items[mim_count+profile_max];
//	bool visible[mim_count+profile_max];
//	int tostart[mim_count+profile_max];
//	unsigned int charsdone[mim_count+profile_max];
//	int pos[mim_count+profile_max][2];
//	int sel_level[mim_count+profile_max];
//	bool selected[mim_count+profile_max];
//	bool is_top[mim_count+profile_max];
//	bool is_bottom[mim_count+profile_max];
//	bool is_double[mim_count+profile_max];
//	bool align_right[mim_count+profile_max];
	menu_item items[mim_count+profile_max];
	bool main_done;
	int selection, prev_menu;
	
public:
	
	Menu();
	void Reset(bool all=true);
	void SetMenu();
	void Main();
	void Draw();
	void SelMove(bool up);
	void SelOk();
	void SelOkMain();
	void SelOkOptions(bool up);
	void SelChangeOptions(bool up);
	void SelOkProfile();
	void SelSide(bool right);
	void SelCancel();
	void Delete();
	void Profile();
	void ReloadProfiles();
	void ReloadOptions();
	void ViewSecond(bool move_from_sel, string title, int i1, int i2, int is=0);
	
};

#endif

