#include "Intro.h"
#include "global.h"
#include <iostream>
#include "Config.h"
using namespace std;

#define load(pref) \
	Image img##pref; img##pref.LoadFromFile(fix_image_file("data/intro/" #pref ".png")); \
	Sprite pref; pref.SetImage(img##pref); pref.SetScale(global_scale,global_scale);

#define loadf(pref,file) \
	Image img##pref; img##pref.LoadFromFile(fix_image_file(file)); \
	Sprite pref; pref.SetImage(img##pref); pref.SetScale(global_scale,global_scale);
			
#define center(pref) \
	pref.SetCenter(img##pref.GetWidth()/2,img##pref.GetHeight()/2); \
	pref.SetPosition(screen_w/2,screen_h/2)

#define display {\
	sf::Event event; \
	while(App->GetEvent(event)) \
		if(event.Type == event.Closed) \
			return false; \
	if(App->GetInput().IsKeyDown(sf::Key::Escape)) \
		return false; \
	if(App->GetInput().IsKeyDown(sf::Key::Return)) \
		return false;\
	} App->TimedDisplay()

Intro::Intro() {
	if (config->music_on||config->sound_on) {
		song.OpenFromFile("data/music/gtintro.ogg");
		song.SetVolume(100*vol_music);
		song.SetLoop(false);
		song.Play();
	}
}

Intro::~Intro() {
	song.Stop();
}

bool Intro::Run() {
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	
	if (!Scroll("pista2",1,3)) return false;
	if (!Show("msg1",5,4)) return false;
	if (!Garage()) return false;
	if (!Show("msg2",7,4)) return false;
	if (!Triple()) return false;
//	if (!Show("pista1",5,6)) return false;
	if (!Show("garage2",7,4)) return false;
	if (!Dimm()) return false;
	if (!Girl()) return false;
	if (!Blur()) return false;
	return true;
}

bool Intro::Triple() {
	load(mono1); 
	for (int i=0;i<100;i+=8) {
		mono1.SetPosition(0,-screen_h+screen_h-(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); App->Draw(mono1); display;
	}
	mono1.SetPosition(0,0); App->Clear(Color(0,0,0)); App->Draw(mono1); display;
	load(casco1);
	for (int i=0;i<100;i+=8) {
		casco1.SetPosition(275,screen_h-screen_h+(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); App->Draw(mono1); App->Draw(casco1); display;
	}
	mono1.SetPosition(0,0); casco1.SetPosition(275,0); 
	App->Clear(Color(0,0,0)); App->Draw(mono1); App->Draw(casco1); display;
	load(guantes1);
	for (int i=0;i<100;i+=8) {
		guantes1.SetPosition(550,-screen_h+screen_h-(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); 
		App->Draw(guantes1); App->Draw(mono1); App->Draw(casco1); display;
	}
	mono1.SetPosition(0,0); casco1.SetPosition(275,0); guantes1.SetPosition(550,0); 
	App->Clear(Color(0,0,0)); App->Draw(casco1); App->Draw(mono1); App->Draw(guantes1); display;
	
	for (int i=100;i>0;i-=6) {
		mono1.SetPosition(0,screen_h-screen_h+(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); 
		App->Draw(casco1); 
		App->Draw(guantes1); 
		App->Draw(mono1); 
		display;
	}
	for (int i=100;i>0;i-=6) {
		casco1.SetPosition(275,-screen_h+screen_h-(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); 
		App->Draw(guantes1); 
		App->Draw(casco1); 
		display;
	}
	for (int i=100;i>0;i-=6) {
		guantes1.SetPosition(550,screen_h-screen_h+(100-i)*(100-i)*screen_h/100/100);
		App->Clear(Color(0,0,0)); 
		App->Draw(guantes1); display;
	}
	App->Clear(Color(0,0,0)); display;
	return true;
}

bool Intro::Show(string file, int spin, int spout) {
	if (spout<0) spout=spin;
	file=string("data/intro/")+file+".png";
	loadf(spr,file); center(spr);
	for (int i=0;i<256;i+=spin) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	spr.SetColor(Color(255,255,255,255));
	App->Draw(spr);
	display;
	for (int i=255;i>=0;i-=spout) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	return true;
}

bool Intro::Dimm() {
	loadf(spr,"data/intro/largada1.png"); center(spr);
	loadf(spr2,"data/intro/largada1b.png"); center(spr2);
	for (int i=0;i<256;i+=6) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	for (int i=0;i<256;i+=4) {
		spr2.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		App->Draw(spr2);
		display;
	}
	spr2.SetColor(Color(255,255,255,255));
	App->Draw(spr2);
	display;
	for (int i=255;i>=0;i-=6) {
		App->Clear(Color(0,0,0));
		spr2.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr2);
		display;
	}
	return true;
}

bool Intro::Girl() {
	loadf(spr,"data/intro/largada2.png"); center(spr);
	spr.SetScale(2.5*global_scale,2.5*global_scale); spr.SetCenter(220/global_scale,120/global_scale);
	int x1=270,y1=700;
	int x2=290,y2=160;
	int x3=780,y3=260;
	int x4=485,y4=295;
	int di=0, pi=0;
	for (int i=0;i<256;i+=di/2) {
		if (pi||di++==23) { di--; pi=1; }
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		spr.SetCenter((x1*(256-i)+i*x2)/256/global_scale,(y1*(256-i)+i*y2)/256/global_scale);
		App->Draw(spr);
		display;
	}
	spr.SetColor(Color(255,255,255,255));
	di=0; pi=0;
	for (int i=0;i<256;i+=di) {
		if (pi||di++==16) { di--; pi=1; }
		spr.SetCenter((x2*(256-i)+i*x3)/256/global_scale,(y2*(256-i)+i*y3)/256/global_scale);
		App->Draw(spr);
		display;
	}
	di=0; pi=0;
	for (int i=0;i<256;i+=di) {
		if (pi||di++==16) { di--; pi=1; }
		spr.SetCenter((x3*(256-i)+i*x4)/256/global_scale,(y3*(256-i)+i*y4)/256/global_scale);
		App->Draw(spr);
		display;
	}
	for (int i=0;i<256;i+=10) {
		spr.SetCenter((x4*(256-i)+i*imgspr.GetWidth()/2*global_scale)/256/global_scale,(y4*(256-i)+i*imgspr.GetHeight()/2*global_scale)/256/global_scale);
		spr.SetScale((2.5*(256-i)+.767*i)/256*global_scale,(2.5*(256-i)+.767*i)/256*global_scale);
		App->Draw(spr);
		display;
	}
	App->Draw(spr);
	display;
	for (int i=255;i>=0;i-=8) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	return true;
}

bool Intro::Garage() {
	loadf(spr,"data/intro/garage1.png"); center(spr);
	loadf(p,"data/intro/garage1_puerta.png"); 
	for (int i=0;i<256;i+=2) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,i*i/256));
//		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		p.SetPosition(-10.f*i/256,-230.f*i/256);
		App->Draw(p);
		display;
	}
	spr.SetColor(Color(255,255,255,255));
	App->Draw(spr);
	display;
	for (int i=255;i>=0;i-=6) {
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	return true;
}

bool Intro::Blur() {
	load(inside1); center(inside1);
	for (int i=0;i<256;i+=4) {
		App->Clear(Color(0,0,0));
		inside1.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(inside1);
		display;
	}
	inside1.SetColor(Color(255,255,255,255));
	load(blur1); center(blur1); 
	Color grnd=imgblur1.GetPixel(imgblur1.GetWidth()/2,imgblur1.GetHeight()-1);
	for (int i=0;i<256;i+=4) {
		App->Clear(grnd);
		blur1.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		blur1.SetPosition(screen_w/2,screen_h/2-real((255-i)*(255-i))/255*120/255);
		App->Draw(blur1);
		App->Draw(inside1);
		display;
	}
	blur1.SetColor(Color(255,255,255,255));
	App->Draw(blur1);
	App->Draw(inside1);
	display;
	load(blur2); center(blur2);
	for (int i=0;i<256;i+=20) {
		blur2.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(blur1);
		App->Draw(inside1);
		App->Draw(blur2);
		display;
	}
	blur2.SetColor(Color(255,255,255,255));
	App->Draw(blur2);
	display;
	loadf(logo,"data/misc/logom.png"); center(logo);
	for (int i=255;i>=0;i-=1) {
		App->Clear(Color(0,0,0));
		App->Draw(logo);
		blur2.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(blur2);
		display;
	}
	for (int i=0;i<30;i++) {
		App->Clear(Color(0,0,0));
		App->Draw(logo);
		display;
	}
	return true;
}

bool Intro::Scroll(string file, int spin, int spout) {
	file=string("data/intro/")+file+".png";
	loadf(spr,file); center(spr);
	real dx=real(imgspr.GetWidth()*global_scale-screen_w)/(256/spin+256/spout);
	real x=(screen_w+screen_w-imgspr.GetWidth()*global_scale)/2;
	for (int i=0;i<256;i+=spin) {
		x+=dx;
		spr.SetPosition(x,screen_h/2);
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	for (int i=255;i>=0;i-=spout) {
		x+=dx;
		spr.SetPosition(x,screen_h/2);
		App->Clear(Color(0,0,0));
		spr.SetColor(Color(255,255,255,255-(255-i)*(255-i)/255));
		App->Draw(spr);
		display;
	}
	return true;
}


