#include "HiddenDriver.h"
#include "Config.h"
#include "Jukebox.h"
#include "MyFont.h"

HiddenDriver *hidden=NULL;

HiddenDriver::HiddenDriver() {
	Reload();
}

void HiddenDriver::Reload() {
	load_wh(b,fix_image_file("data/hidden/back.png"),1,1);
	bsprite.SetPosition(screen_w/2,screen_h/2);
//	load_wh(f,fix_image_file("data/hidden/face.png"),1,1);
	load_fade;
}

void HiddenDriver::Run(/*Drawable *d, */string str, string image, int ix, int iy) {
	text=str;
	line_count=0; l[0]=0;
	for (unsigned int i=0;i<text.size();i++)
		if (text[i]=='\n') l[++line_count]=i+1;
	have_image=image.size();
	if (have_image) {
		load_wh(i,fix_image_file(image),1,1);
		isprite.SetCenter(0,iimage.GetHeight());
		isprite.SetPosition(ix,screen_h-iy);
//		isprite.SetScale(global_scale,global_scale);
		isprite.SetColor(Color(255,255,255,0));
	}
	cur_line=config->extra_fx?-20:0; cur_char=0;
	FloatRect rect(0,0,screen_w,screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	Fade(true);
	while (true) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				return;
			if(App->GetInput().IsKeyDown(sf::Key::Escape) && last_key!=sf::Key::Escape) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Escape; Fade(false); return;
			} else if(App->GetInput().IsKeyDown(sf::Key::Return) && last_key!=sf::Key::Return) {
				if (config->sound_on) music->snd_selcancel.Play();
				last_key=sf::Key::Return; Fade(false); return;
			} else {
				last_key=sf::Key::Count;
			}
		}
		Draw();
		App->TimedDisplay();
	}
}

void HiddenDriver::Draw() {
	App->Draw(bsprite);
	if (cur_line<0) cur_line++;
	for (int i=cur_line;i>=0;i--) {
		string s = text.substr(l[i], l[i+1]-l[i]-1);
		if (i==cur_line && i<line_count && cur_char++>s.size()) {
			cur_char=0; cur_line++;
		}
		if (!s.size()) continue;
		if (i==cur_line && cur_char<s.size())
			font->RenderPartial(70,70+i*35,.45,s,cur_char);
		else
			font->RenderSmall(70,70+i*35,.45,s.c_str());
	}
	if (have_image) {
//		if (cur_line>=0 && cur_char>=0) cerr<<(l[cur_line]+cur_char)*255/text.size()<<endl;
		if (cur_line>=0 && cur_char>=0) isprite.SetColor(Color(255,255,255,(l[cur_line]+cur_char)*255/text.size()));
		App->Draw(isprite);
	}
}

implement_fade(HiddenDriver);
