#include "Data.h"
#include "Jukebox.h"
#include "Particulas.h"
#include "Shader.h"
#include <cstdlib>
#include <sstream>
#include <iomanip>
#include "ChampionshipData.h"
#include "Profile.h"
#include "Config.h"
using namespace std;

Data *data;
Racer *racers;

int pts_champ[3][10] = {
	{ 10,  9,  8,  7,  6,  5,  4,  3,  2,  1 },
	{ 15, 12, 10,  8,  6,  4,  3,  2,  1,  0 },
	{ 20, 16, 13, 10,  7,  5,  3,  1,  0,  0 } 
};

int pts_bike[3][3] = {
	{ 3,  2,  1 },
	{ 5,  4,  3 },
	{ 7,  6,  5 }
};

int champ_avail_tracks[3] = { 8,10,12 };

Data::Data() {
	LoadTracks();
	LoadBikes();
	LoadProfiles();
	
}

void Data::LoadTracks() {
	for (int i=0;i<track_max;i++) {
		tracks[i].best_name=(config&&config->spanish)?"<nadie>":"<nobody>";
		tracks[i].best_time=-1;
	}
	ifstream fil("data/tracks/tracks.lst");
	string s,s1,s2,s3,s4;
	track_count=0; int i;
	while (getline(fil,s)) {
		size_t p =s.find("=");
		if (!s.size()||s[0]=='#'||p==string::npos) continue;
		s1=s.substr(0,p); s=s.substr(p+1); 
		p =s.find("="); if (p==string::npos) continue;
		s2=s.substr(0,p); s3=s.substr(p+1);
		p =s3.find("="); 
		if (p==string::npos) {
			tracks[track_count].weather='s';
		} else {
			tracks[track_count].weather=s3[p+1];
			s3=s3.substr(0,p);
		}
		tracks[track_count].id=s1;
		tracks[track_count].name=s2;
		tracks[track_count].dir=s3;
		if (tracks[track_count].dir[tracks[track_count].dir.size()-1]!='/')
			tracks[track_count].dir+="/";
		track_count++;
	}
	fil.close();
	champ_records_count=0;
	ifstream fil2((home_dir+"records.dat").c_str());
	while (getline(fil2,s)) {
		size_t p =s.find("=");
		if (!s.size()||s[0]=='#'||p==string::npos) continue;
		s1=s.substr(0,p); s=s.substr(p+1); 
		p =s.find("="); if (p==string::npos) continue;
		s2=s.substr(0,p); s3=s.substr(p+1);
		if (s1=="chmp") {
			champ_records[champ_records_count].name=s2;
			champ_records[champ_records_count].pts=atoi(s3.c_str());
			champ_records_count++;
		} else if ((i=FindTrack(s1))>=0) {
			tracks[i].best_name=s2;
			tracks[i].best_time=atof(s3.c_str());
		}
	}
	SortChampRecords();
	records_changed=false;
	fil2.close();
}

int Data::FindTrack(string id) {
	int i=track_count-1; 
	while (i>0&&tracks[i].id!=id) i--;
	return i;
}

int Data::FindBike(string id) {
	int i=bike_count-1; 
	while (i>0&&bikes[i].id!=id) i--;
	return i;
}

void Data::SetRecord(string id, string n, real t) {
	int i=FindTrack(id); if (i<0) return;
	tracks[i].best_name=n;
	tracks[i].best_time=t;
	records_changed=true;
}

void Data::SaveRecords() {
	if (!records_changed) return;
	ofstream fil((home_dir+"records.dat").c_str(),ios::trunc);
	for (int i=0;i<track_count;i++) {
		if (tracks[i].best_time>0)
			fil<<tracks[i].id<<"="<<tracks[i].best_name<<"="<<tracks[i].best_time<<endl;
	}
	for (int i=0;i<champ_records_count;i++) {
		if (tracks[i].best_time>0)
			fil<<"chmp"<<"="<<champ_records[i].name<<"="<<champ_records[i].pts<<endl;
	}
	fil.close();
}

void Data::LoadBikes() {
	ifstream fil("data/bikes/bikes.lst");
	string s,s1,s2,s3;
	bike_count=0;
	while (getline(fil,s)) {
		size_t p =s.find("=");
		if (!s.size()||s[0]=='#'||p==string::npos) continue;
		s1=s.substr(0,p); s=s.substr(p+1); 
		p =s.find("="); if (p==string::npos) continue;
		s2=s.substr(0,p); s3=s.substr(p+1);
		bikes[bike_count].id=s1;
		bikes[bike_count].name=s2;
		bikes[bike_count].dir=s3;
		if (bikes[bike_count].dir[bikes[bike_count].dir.size()-1]!='/')
			bikes[bike_count].dir+="/";
		bike_count++;
	}
	fil.close();
}

void Data::LoadProfiles() {
	ifstream fil((home_dir+"profiles.lst").c_str());
	profile_count=0;
	if (fil.is_open()) {
		string s;
		while (getline(fil,s)) {
			size_t p =s.find("=");
			if (!s.size()||s[0]=='#'||p==string::npos) continue;
			profile_names[profile_count]=s.substr(0,p);
			profile_files[profile_count]=s.substr(p+1);
			profile_count++;
		}
		fil.close();
	}
	if (profile_count<profile_max) {
		profile_names[profile_count]=(config&&config->spanish)?"<nuevo perfil>":"<new profile>";
		profile_files[profile_count]="";
		profile_count++;
	}
	profile_order_changed=false;
}

void Data::SaveProfiles() {
	ofstream fil((home_dir+"profiles.lst").c_str(),ios::trunc);
	for (int i=0;i<profile_count;i++)
		if (profile_files[i].size())
			fil<<profile_names[i]<<"="<<profile_files[i]<<endl;
	fil.close();
}

bool Data::ProfileExists(string name) {
	for (int i=0;i<profile_count;i++) {
		if (name.size()!=profile_names[i].size()) continue;
		unsigned int j;
		for (j=0;j<name.size();j++)
			if (toupper(name[j])!=toupper(profile_names[i][j]))
				break;
		if (j==name.size()) return true;
	}
	return false;
}

string Data::NewProfile(string name) {
	if (profile_files[profile_count-1]=="") profile_count--;
	string pfile;
	int num=0; 
	while (true) {
		stringstream ss;
		ss<<"prof"<<setw(3)<<setfill('0')<<num<<".prf";
		pfile=ss.str();
		ifstream ft((home_dir+pfile).c_str());
		if (!ft.is_open()) break;
		ft.close(); num++;
	}
	profile_files[profile_count]=pfile;
	profile_names[profile_count]=name;
	profile_count++;
	if (profile_count<profile_max) {
		profile_files[profile_count]="";
		profile_names[profile_count]=config->spanish?"<nuevo perfil>":"<new profile>";
		profile_count++;
	}
	SaveProfiles();
	ofstream fil((home_dir+pfile).c_str(),ios::trunc);
	fil<<"name="<<name<<endl;
	fil<<"bike="<<bikes[rand()%bike_count].id<<endl;
	fil.close();
	return pfile;
}

void Data::SelectProfile(string file) {
	if (file.size()) {
		for (int i=0;i<profile_count;i++) {
			if (profile_files[i]==file) {
				if (i) {
					profile_order_changed=true;
					string pfile=profile_files[i];
					string pname=profile_names[i];
					for (int j=i;j>0;j--) {
						profile_files[j]=profile_files[j-1];
						profile_names[j]=profile_names[j-1];
					}
					profile_files[0]=pfile;
					profile_names[0]=pname;
				}
				break;
			}
		}
	}
	if (profile) delete profile;
	if (file.size())
		profile=new Profile(home_dir+file);
	else 
		profile=NULL;
}

void Data::DeleteProfile(int n) {
	for (int i=n+1;i<profile_count;i++) {
		profile_files[i-1]=profile_files[i];
		profile_names[i-1]=profile_names[i];
	}
	profile_count--; SaveProfiles();
}

void Racer::SetUnnamedPlayer(int num) {
	accel=brake=turn=vel=10;
	start_pos=num+1; controller=0; 
	name=config->spanish?"Jugador":"Player"; dir=data->bikes[num].dir;
}
void Racer::SetForQuickrace(int num) {
	int lb = -2;
	accel=lb+3+rand()%5; brake=lb+rand()%5;
	turn=lb+rand()%5; vel=lb+rand()%5;
	name=data->bikes[num].name; controller=num+1;
	dir=data->bikes[num].dir; start_pos=num+1;
	idx=num;
}
void Racer::SetFromProfile(int num) {
	idx=profile->bike;
	accel=profile->accel/2; brake=profile->brake/2;
	turn=profile->turn/2; vel=profile->vel/2;
	name=profile->name; controller=0;
	dir=data->bikes[profile->bike].dir; start_pos=num+1;
}
void Racer::SetRandom(int num, int level) {
	int lb = level==3?10:(level==2?0:-10);
	accel=lb+3+rand()%5; brake=lb+rand()%5;
	turn=lb+rand()%5; vel=lb+rand()%5;
	name=data->bikes[num].name; controller=num+1;
	dir=data->bikes[num].dir; start_pos=num+1;
	idx=num;
}

void Racer::SetFromChampionship(int num, int level) {
	int lb = level==3?14:(level==2?3:-14);
	ChampionshipData::cBike &b=championship_data->bikes[num];
	accel=lb+b.accel; turn=lb+b.turn;
	vel=lb+b.vel; brake=lb+b.brake;
	controller=b.idx+1; start_pos=b.idx+1;
	dir=data->bikes[b.idx].dir;
	name=data->bikes[b.idx].name;
	idx=b.idx;
}

void Data::SortChampRecords() {
	sort(champ_records,champ_records+champ_records_count);
}

void Data::SaveSomething() {
	if (profile_order_changed) SaveProfiles();
}

bool Data::SetChampRecord(string name, int pts) {
	if (data->champ_records_count<champ_records_max || // si es uno de los mejores puntajes
		data->champ_records[data->champ_records_count-1].pts<pts) {
			if (data->champ_records_count<champ_records_max) data->champ_records_count++;
			data->champ_records[data->champ_records_count-1].pts=pts;
			data->champ_records[data->champ_records_count-1].name=name;
			data->SortChampRecords();
			records_changed=true;
			return true;
		}
	return false;
}
