#include "Config.h"
#include "global.h"
#include "Shader.h"
#include "Particulas.h"
#include "Jukebox.h"
#include "version.h"

Config *config;

static int str2int(string s) {
	unsigned int i=0, r=0;
	if (s[0]=='-') i++;
	while (i<s.size() && s[i]>='0' && s[i]<='9')
		r=r*10+s[i++]-'0';
	return s[0]=='-'?-r:r;
}

void Config::LoadModes() {
	
	int aux_modes=VideoMode::GetModesCount();
	modes_w=new int[aux_modes];
	modes_h=new int[aux_modes];
	num_modes=0; int j,mh,mw;
	for (int i=0;i<aux_modes;i++) {
		if (VideoMode::GetMode(i).BitsPerPixel!=32) continue;
		mh=VideoMode::GetMode(i).Height;
		mw=VideoMode::GetMode(i).Width;
		for (j=0;j<num_modes;j++) {
			if (modes_h[j]==mh && modes_w[j]==mw)
				break;
		}
		if (j==num_modes) {
			modes_w[num_modes]=mw;
			modes_h[num_modes]=mh;
			num_modes++;
		}
	}
	int mmode, aux;
	for (int i=0;i<num_modes-1;i++) {
		mmode=i;
		for (j=i+1;j<num_modes;j++) {
			if (modes_w[j]<modes_w[mmode] || (modes_w[j]==modes_w[mmode] && modes_h[j]<modes_h[mmode]))
				mmode=j;
		}
		if (j==i) continue;
		aux=modes_w[mmode]; modes_w[mmode]=modes_w[i]; modes_w[i]=aux;
		aux=modes_h[mmode]; modes_h[mmode]=modes_h[i]; modes_h[i]=aux;
	}
	
	cur_mode=0;
	while (cur_mode<num_modes) {
		if (modes_h[cur_mode]==real_h && modes_w[cur_mode]==real_w) {
			break;
		}
		cur_mode++;
	}
	old_mode=cur_mode;
	old_fullscreen=fullscreen;
}

Config::Config() {
	key_accel=Key::Up;
	key_brake=Key::Down;
	key_left=Key::Left;
	key_right=Key::Right;
	joystick=0;
	joy_accel_ib=true; joy_accel=1;
	joy_brake_ib=true; joy_brake=2;
	joy_right_ib=false; joy_right=Joy::AxisX+1;
	joy_left_ib=false; joy_left=joy_left;
	know_lang=spanish=false;
	sound_vol=2*MAX_VOLUME/3;
	music_vol=MAX_VOLUME/2;
	changed=false; real_w=800; real_h=600;
	particles_low=250; particles_hi=600;
	sound_on=extra_fx=music_on=true; 
	low_textures=fullscreen=shaders_on=false;
	version=0;
	
	ifstream fil((home_dir+"settings.lst").c_str());
	string s,k,v;
	if (!fil.is_open()) { changed=true; Save(); return; }
	while (getline(fil,s)) {
		if (!s.size() || s[0]=='#') continue;
		size_t p=s.find('=');
		if (p==string::npos) continue;
		k=s.substr(0,p);
		v=s.substr(p+1);
		if (k=="version") version=str2int(v);
		else if (k=="sound") sound_on=v=="1";
		else if (k=="sound_vol") sound_vol=str2int(v);
		else if (k=="music") music_on=v=="1";
		else if (k=="music_vol") music_vol=str2int(v);
		else if (k=="language") { know_lang=true; spanish=v=="es"; }
		else if (k=="extra_fx") extra_fx=v=="1";
		else if (k=="shaders") shaders_on=v=="1";
		else if (k=="low_textures") low_textures=v=="1";
		else if (k=="fullscreen") fullscreen=v=="1";
		else if (k=="particles_low") particles_low=str2int(v);
		else if (k=="particles_hi") particles_hi=str2int(v);
		else if (k=="screen_w") real_w=str2int(v);
		else if (k=="screen_h") real_h=str2int(v);
		else if (k=="key_accel") key_accel=(Key::Code)str2int(v);
		else if (k=="key_brake") key_brake=(Key::Code)str2int(v);
		else if (k=="key_left") key_left=(Key::Code)str2int(v);
		else if (k=="key_right") key_right=(Key::Code)str2int(v);
		else if (k=="joystick") joystick=str2int(v);
		else if (k=="joy_accel_ib") joy_accel_ib=v=="1";
		else if (k=="joy_accel") joy_accel=str2int(v);
		else if (k=="joy_brake_ib") joy_brake_ib=v=="1";
		else if (k=="joy_brake") joy_brake=str2int(v);
		else if (k=="joy_left_ib") joy_left_ib=v=="1";
		else if (k=="joy_left") joy_left=str2int(v);
		else if (k=="joy_right_ib") joy_right_ib=v=="1";
		else if (k=="joy_right") joy_right=str2int(v);
	}
	fil.close();
	
	global_scale=low_textures?2:1;
	
	LoadModes();
	
}

Config::~Config() {
	delete [] modes_h;
	delete [] modes_w;
}

void Config::ChangeTextures(bool up) {
	low_textures=!low_textures;
	global_scale=low_textures?2:1;
	changed=true;
}

void Config::ChangeFullscreen(bool up) {
		fullscreen=!fullscreen;
		changed=true;
}

void Config::ChangeResolution(bool up) {
	if (cur_mode!=num_modes) cur_mode+=up?1:num_modes-1;
	cur_mode=cur_mode%num_modes;
	real_w=modes_w[cur_mode];
	real_h=modes_h[cur_mode];
	changed=true;
}

void Config::ChangeSound(bool up) {
	sound_on=!sound_on;
	changed=true;
}

void Config::ChangeSoundVol(bool up) {
	if (up) {
		if (sound_vol==MAX_VOLUME) return;
		sound_vol++;
		changed=true;
	} else {
		if (sound_vol==0) return;
		sound_vol--;
		changed=true;
	}
	music->SetVolumes();
}

void Config::ChangeMusic(bool up) {
	music_on=!music_on;
	changed=true;
}

void Config::ChangeMusicVol(bool up) {
	if (up) {
		if (music_vol==MAX_VOLUME) return;
		music_vol++;
		changed=true;
	} else {
		if (music_vol==0) return;
		music_vol--;
		changed=true;
	}
	music->SetVolumes();
}

void Config::ChangeParticles(bool up) {
	changed=true;
	if (up) {
		if (!shaders_on && !extra_fx && particles_low==0 && particles_hi==0) {
			particles_low=50; particles_hi=100;
		} else if (!shaders_on && !extra_fx && particles_low==50 && particles_hi==100) {
			extra_fx=true; particles_low=100; particles_hi=300; extra_fx=true;
		} else if (!shaders_on && extra_fx && particles_low==100 && particles_hi==300) {
			particles_low=250; particles_hi=600;
		} else if (sf::PostFX::CanUsePostFX() && !shaders_on && extra_fx && particles_low==250 && particles_hi==600) {
			shaders_on=true;
		} else {
			shaders_on=false; extra_fx=false; particles_low=0; particles_hi=0;
		}
	} else {
		if (!shaders_on && !extra_fx && particles_low==0 && particles_hi==0) {
			particles_low=250; particles_hi=600; extra_fx=true; shaders_on=sf::PostFX::CanUsePostFX();
		} else if (!shaders_on && !extra_fx && particles_low==50 && particles_hi==100) {
			particles_low=0; particles_hi=0;
		} else if (!shaders_on && extra_fx && particles_low==100 && particles_hi==300) {
			particles_low=50; particles_hi=100; extra_fx=false;
		} else if (!shaders_on && extra_fx && particles_low==250 && particles_hi==600) {
			particles_low=100; particles_hi=300;
		} else {
			particles_low=250; particles_hi=600; shaders_on=false; extra_fx=true;
		}
		
	}
	if (shaders_on && !shaders) shaders=new Shaders(); 
	if (!shaders_on && shaders) { delete shaders; shaders=NULL; } 
	humo->Resize(particles_low);
	marca->Resize(particles_hi);
	tierra->Resize(particles_low);
	chispa->Resize(particles_low);
	lluvia->Resize(particles_hi);
}

void Config::Save(bool forced) {
	CERR("Config::Save...");
	if (changed||forced) {
		old_mode=cur_mode;
		old_fullscreen=fullscreen;
		changed=false;
		ofstream fil((home_dir+"settings.lst").c_str(),ios::trunc);
		fil<<"version="<<(config->version=VERSION)<<endl;
		fil<<"fullscreen="<<(fullscreen?1:0)<<endl;
		fil<<"low_textures="<<(low_textures?1:0)<<endl;
		fil<<"sound="<<(sound_on?1:0)<<endl;
		fil<<"sound_vol="<<sound_vol<<endl;
		fil<<"music="<<(music_on?1:0)<<endl;
		fil<<"music_vol="<<music_vol<<endl;
		fil<<"language="<<(spanish?"es":"en")<<endl;
		fil<<"extra_fx="<<(extra_fx?1:0)<<endl;
		fil<<"shaders="<<(shaders_on?1:0)<<endl;
		fil<<"particles_low="<<particles_low<<endl;
		fil<<"particles_hi="<<particles_hi<<endl;
		fil<<"screen_w="<<real_w<<endl;
		fil<<"screen_h="<<real_h<<endl;
		if (key_accel!=Key::Up) fil<<"key_accel="<<key_accel<<endl;
		if (key_brake!=Key::Down) fil<<"key_brake="<<key_brake<<endl;
		if (key_right!=Key::Right) fil<<"key_right="<<key_right<<endl;
		if (key_left!=Key::Left) fil<<"key_left="<<key_left<<endl;
		fil<<"joystick="<<joystick<<endl;
		fil<<"joy_accel_ib="<<(joy_accel_ib?1:0)<<endl;
		fil<<"joy_accel="<<joy_accel<<endl;
		fil<<"joy_brake_ib="<<(joy_brake_ib?1:0)<<endl;
		fil<<"joy_brake="<<joy_brake<<endl;
		fil<<"joy_right_ib="<<(joy_right_ib?1:0)<<endl;
		fil<<"joy_right="<<joy_right<<endl;
		fil<<"joy_left_ib="<<(joy_left_ib?1:0)<<endl;
		fil<<"joy_left="<<joy_left<<endl;
		fil.close();
	}
}

void Config::SetKeys(int ka, int kb, int kr, int kl) {
	key_accel=(Key::Code)ka;
	key_brake=(Key::Code)kb;
	key_right=(Key::Code)kr;
	key_left=(Key::Code)kl;
	changed=true;
}

void Config::ChangeJoystick(bool up) {
	if (up) {
		joystick++; if (joystick==5) joystick=0;
	} else {
		joystick--; if (joystick==-1) joystick=4;
	}
	changed=true;
}

void Config::SetJoys(bool bja, int ja, bool bjb, int jb, bool bjr, int jr, bool bjl, int jl) {
	joy_accel=ja; joy_accel_ib=bja;
	joy_brake=jb; joy_brake_ib=bjb;
	joy_right=jr; joy_right_ib=bjr;
	joy_left=jl; joy_left_ib=bjl;
	changed=true;
}

void Config::ChangeLanguage(bool up) {
	spanish=!spanish;
	changed=true;
}
