#include "ChampionshipData.h"
#include "Data.h"
#include "Profile.h"
#include "Moto.h"
#include "Experience.h"

ChampionshipData *championship_data;

ChampionshipData::ChampionshipData() {
	ResetData();
}

void ChampionshipData::ResetData() {
	CERR("ChampionshipData::ResetData()...");
	// moto del jugador
	obike=pbike=profile->bike;
	// carreras del campeonato
	num_races=profile->avail_tracks;
	races = new cRace[num_races];
	for (int i=0;i<num_races;i++) races[i].idx=i;
	for (int i=0;i<num_races-1;i++) {
		int j=i+rand()%(num_races-i);
		cRace aux=races[i];
		races[i]=races[j];
		races[j]=aux;
	}
	// motos de los oponentes
	num_bikes=data->bike_count;
	bikes = new cBike[num_bikes];
	for (int i=0;i<num_bikes;i++) bikes[i].idx=i;
	for (int i=0;i<num_bikes-1;i++) {
		int j=i+rand()%(num_bikes-i);
		cBike aux=bikes[i];
		bikes[i]=bikes[j];
		bikes[j]=aux;
	}
	races_done=next_race=0;
	
}

ChampionshipData::~ChampionshipData() {
	CERR("ChampionshipData::~ChampionshipData...");
	profile->bike=obike;
	for (int i=0;i<num_races;i++)
		delete races[i].results;
	delete [] races;
	delete [] bikes;
}

int ChampionshipData::cRace::GetPos(int idx) {
	int i=0; while (results[i].idx!=idx) i++;
	return i+1;
}
int ChampionshipData::cRace::GetPts(int idx) {
	int i=0; while (results[i].idx!=idx) i++;
	return results[i].pts;
}

void ChampionshipData::SortPositions() {
	for (int i=0;i<num_bikes-1;i++) {
		int imax=i;
		for (int j=i+1;j<num_bikes;j++) {
			if (bikes[j].pts>bikes[imax].pts) imax=j;
			// todo: else if == ver por carreras ganadas and so on
		}
		cBike baux=bikes[i];
		bikes[i]=bikes[imax];
		bikes[imax]=baux;
	}
}

void ChampionshipData::Save() {
	string fname=profile->file.substr(0,profile->file.size()-4)+".cps";
	CERR("ChampionshipData::Save("<<fname<<")...");
	ofstream fil(fname.c_str(),ios::trunc);
	fil<<"num_bikes="<<num_bikes<<endl;
	for (int i=0;i<num_bikes;i++) {
//		fil<<"bike="<<endl;
		fil<<"   "<<data->bikes[bikes[i].idx].id<<" "<<bikes[i].pts<<endl;
		fil<<"   "<<bikes[i].accel<<" "<<bikes[i].brake<<" "<<bikes[i].turn<<" "<<bikes[i].vel<<endl;
	}
	fil<<"num_races="<<num_races<<endl;
	for (int i=0;i<num_races;i++) {
//		fil<<"race="<<endl;
		fil<<"   "<<data->tracks[races[i].idx].id<<" "<<races[i].laps<<" "<<races[i].level<<endl;
		if (races[i].results) {
			for (int j=0;j<num_bikes;j++) {
				fil<<"   "<<data->bikes[races[i].results[j].idx].id<<" "<<races[i].results[j].pts<<endl;
			}
		}
	}
	fil<<"pbike="<<pbike<<endl;
	fil.close();
}

ChampionshipData::ChampionshipData(string afile) {
	CERR("ChampionshipData::ChampionshipData("<<afile<<")...");
	// moto del jugador
	obike=pbike=profile->bike;
	num_bikes=num_races=0;
	
	ifstream fil(afile.c_str());
	if (!fil.is_open()) {
		ResetData();
		return;
	}
	string s,k,v;
	size_t p;
	while (getline(fil,s)) {
		if (!s.size() || s[0]=='#') continue;
		p=s.find('=');
		if (p==string::npos) continue;
		k=s.substr(0,p);
		v=s.substr(p+1);
		if (k=="num_bikes") {
			num_bikes=atoi(v.c_str());
			bikes = new cBike[num_bikes];
			for (int i=0;i<num_bikes;i++) {
				fil>>v;	bikes[i].idx=data->FindBike(v);
				fil>>bikes[i].pts;
				fil>>bikes[i].accel;
				fil>>bikes[i].brake;
				fil>>bikes[i].turn;
				fil>>bikes[i].vel;
			}
		} else if (k=="num_races") {
			num_races=atoi(v.c_str());
			races=new cRace[num_races];
			for (int i=0;i<num_races;i++) {
				fil>>v; races[i].idx=data->FindTrack(v);
				fil>>races[i].laps; fil>>races[i].level;
				if (races[i].laps) {
					races[i].results=new cResult[num_bikes];
					for (int j=0;j<num_bikes;j++) {
						fil>>s; races[i].results[j].idx=data->FindBike(s);
						fil>>races[i].results[j].pts;
					}
				}
			}
		} else if (k=="pbike") profile->bike=pbike=atoi(v.c_str());
	}
	if (!num_bikes||!num_races) 
		ResetData();
	else
		FindNextRace();
}

void ChampionshipData::FindNextRace() {
	next_race=-1; races_done=0;
	for (int i=0;i<num_races;i++) {
		if (races[i].results) {
			races_done++;
		} else {
			if (next_race<0) next_race=i;
		}
	}
	
}
void ChampionshipData::ProcessPositions(int laps, int level) {
	races[next_race].laps=laps; races[next_race].level=level;
	cResult *results=new cResult[num_bikes];
	for (int i=0;i<num_bikes;i++) {
		results[i].idx=motos[i]->idx;
		if (i<10)
			results[i].pts=pts_champ[level-1][i];
		else
			results[i].pts=0;
		bikes[FindBike(results[i].idx)].pts+=results[i].pts;
	}
	races[next_race].results=results;
	if (++next_race==num_races) next_race=-1;
	races_done++;
	Save();
	if (!profile->on_championship) {
		profile->on_championship=true;
		profile->changed=true;
		profile->Save();
	}
	SortPositions();
}

int ChampionshipData::FindBike(int idx) {
	for (int i=0;i<num_bikes;i++)
		if (bikes[i].idx==idx) return i;
	return -1;
}

void ChampionshipData::Finish() {
	// buscar donde quedo y cuantos puntos hizo
	int pos=0; championship_data->SortPositions();
	while (championship_data->bikes[pos].idx!=championship_data->pbike) pos++;
	if (data->SetChampRecord(profile->name,championship_data->bikes[pos].pts)) {
		data->SaveRecords();
		Experience e(ET_RECORD);
		e.Run();
	}
	if (pos==0) {
		int old_avail_tracks=profile->avail_tracks;
		if (num_races==champ_avail_tracks[0] && profile->avail_tracks<champ_avail_tracks[1])
			profile->avail_tracks=champ_avail_tracks[1];
		if (num_races==champ_avail_tracks[1] && profile->avail_tracks<champ_avail_tracks[2])
			profile->avail_tracks=champ_avail_tracks[2];
		if (profile->avail_tracks!=old_avail_tracks) {
			Experience e(ET_TRACKS);
			e.Run();
		}
	}
}
