#include "Carrera.h"
#include <string>
#include "Confirm.h"
#include "RaceExtras.h"
#include "Circuito.h"
#include "Particulas.h"
#include "Moto.h"
#include "OSD.h"
#include "Loading.h"
#include "Data.h"
#include "Shader.h"
#include "Jukebox.h"
#include "Profile.h"
#include "Config.h"
#include "TextViewer.h"
#include "StyleOsd.h"
using namespace std;

Carrera *carrera;

#ifdef DEBUG
extern bool toggle_map;
#endif

void Carrera::CommonInit() {
	CERR(this<<" Carrera::Carrera");
	timer=0;
	humo->Reset(); marca->Reset(); tierra->Reset(); chispa->Reset(); lluvia->Reset();
	player_done=false;
	won=started=false;
}

Carrera::Carrera(int alaps, int anum_racers, bool aqualy_mode) {
	CommonInit(); own_data=false; laps=alaps; num_racers=anum_racers; qualy_mode=aqualy_mode;
	if (qualy_mode) { 
		moto_target=motos[0]=new Moto(racers[0]); 
	} else {
		for (int i=0;i<num_racers;i++) {
			motos[i]=new Moto(racers[i]);
			if (!motos[i]->controller) moto_target=motos[i];
		}
	}
}

Carrera::Carrera(Racer racer, int alaps) {
	CommonInit(); own_data=false; laps=alaps;
	num_racers=1; racer.start_pos=1;
	motos[0]=new Moto(racer); 
}

Carrera::Carrera(int track_index, int alaps) {
	circuito=new Circuito(track_index);
	CommonInit(); own_data=true; laps=alaps; num_racers=data->bike_count; qualy_mode=false;
	for (int i=0;i<data->bike_count;i++) {
		motos[i]=new Moto(racers[i]);
		if (!motos[i]->controller) moto_target=motos[i];
	}
	moto_target->ignore_time=100;
}

Carrera::~Carrera() {
	CERR(this<<" Carrera::~Carrera");
	if (profile) profile->Save();
	data->SaveRecords();
	for (int i=0;i<num_racers;i++) { delete motos[i]; motos[i]=NULL; }
	if (!own_data) return;
	if (circuito) { delete circuito; circuito=NULL; }
}

bool Carrera::Race() {
	
	music->StopMusic();
	
	if (config->sound_on && circuito->fans[0][0]) { 
		circuito->snd_fans1.Play();
		if (circuito->fans[1][0]) circuito->snd_fans2.Play();
	}

	if (rain_mode && config->sound_on) music->snd_rain.Play();
	
	int potential_w = int(real(config->real_w)*(real(screen_h)/real(config->real_h)));
	int  potential_h = int(real(config->real_h)*(real(screen_w)/real(config->real_w)));
	if (potential_w>screen_w) {
		race_screen_h=screen_h;
		race_screen_w=potential_w;
	} else {
		race_screen_w=screen_w;
		race_screen_h=potential_h;
	}
	
	samount=0;
	FloatRect rect(0,0,race_screen_w,race_screen_h);
	view->SetFromRect(rect);
	App->SetView(*view);
	real old_cam_x, old_cam_y, in_cam_x=0, in_cam_y=0;
	cam_x=moto_target->target_cam_x,cam_y=moto_target->target_cam_y, cam_z=15;
	osd->Reset();
	race_extras->Reset();
	while(App->IsOpened()) {
		sf::Event event;
		while(App->GetEvent(event)) {
			if(event.Type == event.Closed)
				App->Close();	
		}
		if(App->GetInput().IsKeyDown(sf::Key::F2)) { if( last_key!=sf::Key::F2) {
#ifdef DEBUG
			if (fixed_zoom>0) fixed_zoom=0; else fixed_zoom=60;
#else
			if (fixed_zoom>0) fixed_zoom=0; else fixed_zoom=30;
#endif
			last_key=sf::Key::F2;
		} } else if(App->GetInput().IsKeyDown(sf::Key::F12)) { if (fixed_zoom) {
			fixed_zoom+=2;
		} } else if(App->GetInput().IsKeyDown(sf::Key::F11)) { if (fixed_zoom) {
			fixed_zoom-=2;
		} } else if(App->GetInput().IsKeyDown(sf::Key::Pause)) { if (last_key!=sf::Key::P) {
			last_key=sf::Key::P;
#ifdef DEBUG
		} } else if(App->GetInput().IsKeyDown(sf::Key::U)) { if (last_key!=sf::Key::U) {
			if (moto_target->controller) moto_target->controller=0; else moto_target->controller=1;
			last_key=sf::Key::U;
		} } else if(App->GetInput().IsKeyDown(sf::Key::T)) { if (last_key!=sf::Key::T) {
			last_key=sf::Key::T; toggle_map=!toggle_map;
#endif
		} } else if(App->GetInput().IsKeyDown(sf::Key::F1)) { if (last_key!=sf::Key::F1) {
			last_key=sf::Key::F1;
			TextViewer t("data/misc/helpot.png"," ",
				qualy_mode?
				config->spanish?text_es_onqualy:text_en_onqualy:
				config->spanish?text_es_ontrack:text_en_ontrack
				,false);
			t.Show();
		} } else if(App->GetInput().IsKeyDown(sf::Key::F4)) { if (last_key!=sf::Key::F4) {
			if (osd_on && style_osd_on) style_osd_on=false;
			else if (osd_on) osd_on=false;
			else osd_on=style_osd_on=true;
			last_key=sf::Key::F4;
		} } else if(App->GetInput().IsKeyDown(sf::Key::F3)) { if (last_key!=sf::Key::F3) {
			show_map=!show_map;  last_key=sf::Key::F3;
		} } else if(App->GetInput().IsKeyDown(sf::Key::F5)) { if (last_key!=sf::Key::F5) {
			show_names=!show_names;  last_key=sf::Key::F5;
		} } else if(App->GetInput().IsKeyDown(sf::Key::F6)) { if (last_key!=sf::Key::F6) {
			head_label=!head_label;  last_key=sf::Key::F6;
		} } else if (!qualy_mode && App->GetInput().IsKeyDown(sf::Key::F8)) { if (last_key!=sf::Key::F8) {
			if (moto_target->pos>1) moto_target=motos[moto_target->pos-2];
			last_key=sf::Key::F8;
		} } else if(!qualy_mode && App->GetInput().IsKeyDown(sf::Key::F9)) { if (last_key!=sf::Key::F9) {
			for (int i=0;i<num_racers;i++) 
				if (motos[i]->controller==0)
					moto_target=motos[i];
			last_key=sf::Key::F9;
		} } else if(!qualy_mode && App->GetInput().IsKeyDown(sf::Key::F7)) { if (last_key!=sf::Key::F7) {
			last_key=sf::Key::F7;
			if (moto_target->pos<num_racers) moto_target=motos[moto_target->pos];
		} } else if(App->GetInput().IsKeyDown(sf::Key::Escape)) { if (last_key!=sf::Key::Escape) {
			last_key=sf::Key::Escape;
			if (player_done && !qualy_mode) FinishRace();
			if (player_done || confirm->Ask(this,config->spanish?"Abandor Carrera?":"Leave Race?")) {
				if (qualy_mode) motos[0]->Mute();
				else for (int i=0;i<num_racers;i++) motos[i]->Mute();
				circuito->snd_fans1.Stop(); circuito->snd_fans2.Stop(); music->snd_rain.Stop();
				music->PlayMusic(); return player_done;
				
			}
		} } else 
			last_key=sf::Key::Count;
		
		//Sprite events
		old_cam_x=cam_x; old_cam_y=cam_y;
		cam_x=(moto_target->target_cam_x+9*old_cam_x/*+9*in_cam_x*/)/10;
		cam_y=(moto_target->target_cam_y+9*old_cam_y/*+9*in_cam_y*/)/10;
//		real dz=sqrt((cam_x-moto_target->target_cam_x)*(cam_x-moto_target->target_cam_x)+(cam_y-moto_target->target_cam_y)*(cam_y-moto_target->target_cam_y));
//		Listener::SetPosition(cam_x,cam_y,0);
		in_cam_x=cam_x-old_cam_x;
		in_cam_y=cam_y-old_cam_y;
		view->SetFromRect(rect);
		view->SetCenter(cam_x,cam_y);
		if (fixed_zoom) cam_z=fixed_zoom/10.0;
		else cam_z+=(moto_target->target_cam_z-cam_z)/20;
//		else cam_z+=(1+dz/500-cam_z)/30;
		view->Zoom(1/cam_z);
		circuito->Draw(cam_x,cam_y);
		marca->Update();
		
		if (shaders && !moto_target->crash) {
			if (moto_target->velocidad>40) {
				shaders->shader_speed.SetParameter("direction", sin(moto_target->direccion)/race_screen_w,cos(moto_target->direccion)/race_screen_h);
				if (int(moto_target->velocidad-35)>samount) samount++; else if (samount) samount--;
			} else if (samount) samount--;
			if (samount) {
				shaders->shader_speed.SetParameter("amount", samount);
				App->Draw(shaders->shader_speed);
			}
		}
		
		chispa->Update();
		if (qualy_mode){
			moto_target->Update(); 
			if (night_mode && config->extra_fx) if (!moto_target->crash) App->Draw(moto_target->sprite_l);
		} else {
			for (int i=0;i<num_racers;i++) motos[i]->Update();
			if (night_mode && config->extra_fx) 
				for (int i=0;i<num_racers;i++) 
					if (!motos[i]->crash) App->Draw(motos[i]->sprite_l);
		}
		if (config->sound_on) circuito->DoSounds(int(moto_target->x), int(moto_target->y));
		if (rain_mode) {
			if (config->extra_fx) lluvia->Update(cam_x,cam_y,cam_z);
		} else {
			tierra->Update();
			humo->Update();
		}
		if (shaders && moto_target->crash && moto_target->crash_fase<30) {
			shaders->shader_crash.SetParameter("amount", real(moto_target->crash_fase)/10);
			App->Draw(shaders->shader_crash);
		}
		
//		App->Draw(shaders->shader_wonder);
		if (style_osd_on) style_osd->Update();
		if (osd_on) osd->Draw(cam_x,cam_y,cam_z);
		race_extras->Update(cam_x,cam_y,cam_z);
		
		App->TimedDisplay();
		
		timer++;
	}
	return true;
}

real Carrera::SimulateQualify() {
	CERR(this<<" Carrera::SimulateQualify "<<motos[0]->name);
	started=true;
	moto_target=motos[0];
	int max=laps*6000;
	real best_lap=-1;
	qualy_mode=true;
	while(!motos[0]->im_done && timer<max) {
		motos[0]->Update(false);
		if (motos[0]->time_last_lap>0 && (best_lap<0 || motos[0]->time_last_lap<best_lap))
			best_lap=motos[0]->time_last_lap;
		timer++;
	}
	return best_lap;
}

void Carrera::Sort() {
	int imin;
	Racer auxr;
	if (qualy_mode) {
		if (moto_target->time_last_lap>0&&(moto_target->time_last_lap<racers[moto_target->pos-1].best_lap||racers[moto_target->pos-1].best_lap<0))
			racers[moto_target->pos-1].best_lap=moto_target->time_last_lap;
		for (int i=1;i<num_racers;i++) {
			imin=i-1;
			for (int j=i;j<num_racers;j++) {
				if (racers[j].best_lap>0&&(racers[j].best_lap<racers[imin].best_lap||racers[imin].best_lap<0))
					imin=j;
			}
			auxr=racers[i-1];
			racers[i-1]=racers[imin];
			racers[imin]=auxr;
		}
		for (int i=0;i<num_racers;i++) { 
			if (!racers[i].controller)
				moto_target->pos=i+1;
			racers[i].start_pos=i+1;
		}
	} else {
		Moto *auxm;
		for (int i=1;i<num_racers;i++) {
			imin=i-1;
			for (int j=i;j<num_racers;j++) {
				if (motos[imin]->lap!=motos[j]->lap) {
					if (motos[j]->lap>motos[imin]->lap) imin=j;
				} else if (motos[imin]->im_done!=motos[j]->im_done) {
					if (!motos[j]->im_done) imin=j;
				} else if (motos[imin]->im_done) {
					if (motos[j]->time_total<motos[imin]->time_total) imin=j;
				} else {
					if (motos[j]->check_next<motos[imin]->check_next) continue;
					else if (motos[j]->check_next==motos[imin]->check_next)
						if (motos[j]->check_dist>motos[imin]->check_dist) continue;
					imin=j;
				}
			}
			motos[imin]->pos=i;
			auxm=motos[i-1];
			motos[i-1]=motos[imin];
			motos[imin]=auxm;
		}
		motos[num_racers-1]->pos=num_racers;
	}
}

// calcula el tiempo total de carrera, completando segun estadistica lo que les
// falta a los que no terminaron
void Carrera::FinishRace() {
	
	// marcar los tiempos hasta ahora de los que no terminaron
	for (int i=0;i<num_racers;i++) {
		if (!motos[i]->im_done) {
			if (motos[i]->lap==1) {
				motos[i]->time_total=-num_racers-1+i;
				motos[i]->im_done=true;
			} else
				motos[i]->time_total=(carrera->timer-motos[i]->clock_total)/TIMER_CTE;
		}
	}
	
	// calcular los promedios por pacial
	for (int i=0;i<num_racers;i++) {
		if (motos[i]->im_done) continue;
		int j=0, l=motos[i]->lap, d=motos[i]->check_next;
		while (circuito->checkpoints[j][0]!=0) {
			motos[i]->times_avg_partials[j]/=(j<d?l:l-1);
			j++;
		}
		motos[i]->times_avg_partials[j]/=(l-1);
	}
	
	// completar lo que falta de los que no terminaron
	for (int i=0;i<num_racers;i++) {
		if (motos[i]->im_done) continue;
		int px,py,nx,ny,cc=motos[i]->check_next;
		 
		// establecer de cual checkpoint a cual otro iban
		if (cc>0 && circuito->checkpoints[cc-1][0]==0) { // del ultimo a finish_line
			px=circuito->checkpoints[cc-2][0]; py=circuito->checkpoints[cc-2][1];
			nx=circuito->finish_line[0]; ny=circuito->finish_line[1]; cc--;
		} else {
			if (cc==0) { // de finish_line al primero
				px=circuito->finish_line[0]; py=circuito->finish_line[1];
			} else { // en medio
				px=circuito->checkpoints[cc-1][0]; py=circuito->checkpoints[cc-1][1];
			}
			nx=circuito->checkpoints[cc][0]; ny=circuito->checkpoints[cc][1];
		}
		
		real x=motos[i]->x, y=motos[i]->y, t=motos[i]->time_total;
		// completar el checkpoint que tenian a medias
		real totd = sqrt((px-nx)*(px-nx)+(py-ny)*(py-ny));
		real misd = sqrt((x-nx)*(x-nx)+(y-ny)*(y-ny));
		t+=motos[i]->times_avg_partials[cc]*misd/totd;
		// sumar los checkpoints que faltan
		while (circuito->checkpoints[cc][0]!=0) 
			t+=motos[i]->times_avg_partials[cc++];
		motos[i]->time_total=t;
		motos[i]->lap++; 
		motos[i]->im_done=true;
	}
	Sort();
}

void Carrera::DeleteSomething() {
	if (!own_data) return;
	CERR(this<<" Carrera::DeleteSomething");
	circuito->DeleteSomething();
}

void Carrera::Draw() {
	circuito->tsprite.SetPosition(screen_w/2,screen_h/2);
	circuito->tsprite.SetScale(1.4*global_scale,1.4*global_scale);
	App->Clear(Color(0,0,0));
	App->Draw(circuito->tsprite);
//	loading->Draw();
//	App->SetView(*view);
//	circuito->Draw(race_screen_w/race_2,screen_h/2);
}
