/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import mediathek.Funktionen;
import mediathek.daten.Daten;

public class Log {
    private Daten daten;
    private final String TRENNER = "  |###|  ";
    private LinkedList<String> logListeZdf = null;
    private LinkedList<String> logListePod = null;

    public Log(Daten d) {
        this.daten = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean zeileSchreiben(String titel, String url, String logdatei) {
        boolean ret = false;
        this.daten.log.clearLogList(logdatei);
        File f = new File(this.daten.getBasisVerzeichnis(true) + logdatei);
        if (f != null) {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter(new FileOutputStream(f, true));
                titel = titel.replace("\n", "");
                titel = titel.replace("|", "");
                titel = titel.replace("  |###|  ", "");
                titel = Funktionen.getHeute_dd_MM_yyyy() + "  |###|  " + titel;
                writer.write(titel + "  |###|  " + url + "\n");
                writer.close();
                ret = true;
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "Log.zeileSchreiben");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    this.daten.fehler.fehlerMeldung(ex, "Log.zeileSchreiben");
                }
            }
        }
        return ret;
    }

    public void clearLogList(String logdatei) {
        if (logdatei.equals(".mediathek_zdf_log")) {
            if (this.logListeZdf != null) {
                this.logListeZdf.clear();
                this.logListeZdf = null;
            }
        } else if (this.logListePod != null) {
            this.logListePod.clear();
            this.logListePod = null;
        }
    }

    public boolean urlPruefen(String urlFilm, String logdatei) {
        return this.listeBauen(logdatei).contains(urlFilm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<String> listeBauen(String logdatei) {
        BufferedReader in = null;
        File datei = null;
        LinkedList<String> liste = logdatei.equals(".mediathek_zdf_log") ? this.logListeZdf : this.logListePod;
        if (liste == null) {
            liste = new LinkedList();
            try {
                datei = new File(this.daten.getBasisVerzeichnis(false) + logdatei);
                if (datei.exists()) {
                    String zeile;
                    in = new LineNumberReader(new InputStreamReader(new FileInputStream(datei)));
                    while ((zeile = ((LineNumberReader)in).readLine()) != null) {
                        liste.add(this.getUrlAusZeile(zeile));
                    }
                }
            }
            catch (Exception ex) {
                System.err.println("Log.listeBauen-1: " + ex.getMessage());
            }
            finally {
                try {
                    if (datei.exists()) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    System.err.println("Log.listeBauen-2: " + ex.getMessage());
                }
            }
            if (logdatei.equals(".mediathek_zdf_log")) {
                this.logListeZdf = liste;
            } else {
                this.logListePod = liste;
            }
        }
        return liste;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean urlAusLogfileLoeschen(String urlFilm, String logdatei) {
        boolean gefunden = false;
        LinkedList<String> liste = new LinkedList<String>();
        BufferedReader in = null;
        try {
            String zeile;
            in = new LineNumberReader(new InputStreamReader(new FileInputStream(new File(this.daten.getBasisVerzeichnis(false) + logdatei))));
            while ((zeile = ((LineNumberReader)in).readLine()) != null) {
                if (this.getUrlAusZeile(zeile).equals(urlFilm)) {
                    gefunden = true;
                    continue;
                }
                liste.add(zeile);
            }
            in.close();
        }
        catch (Exception ex) {
            System.err.println("Log.urlAusLogfileLoeschen-1: " + ex.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {
                System.err.println("Log.urlAusLogfileLoeschen-2: " + ex.getMessage());
            }
        }
        if (gefunden) {
            File f = new File(this.daten.getBasisVerzeichnis(true) + logdatei);
            if (f != null) {
                OutputStreamWriter writer = null;
                try {
                    writer = new OutputStreamWriter(new FileOutputStream(f, false));
                    Iterator it = liste.iterator();
                    while (it.hasNext()) {
                        writer.write((String)it.next() + "\n");
                    }
                    writer.close();
                }
                catch (Exception ex) {
                    this.daten.fehler.fehlerMeldung(ex, "Log.urlAusLogfileLoeschen-3");
                }
                finally {
                    try {
                        writer.close();
                    }
                    catch (Exception ex) {
                        this.daten.fehler.fehlerMeldung(ex, "Log.urlAusLogfileLoeschen-4");
                    }
                }
            }
            this.daten.log.clearLogList(logdatei);
        }
        return gefunden;
    }

    private String getUrlAusZeile(String zeile) {
        String url = "";
        int a1 = 0;
        try {
            if (zeile.contains("  |###|  ")) {
                a1 = zeile.lastIndexOf("  |###|  ");
                url = zeile.substring(a1 += "  |###|  ".length());
            } else {
                url = zeile;
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "getUrlAusZeile, Zeile:  " + zeile);
        }
        return url;
    }
}

