/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;
import mediathek.daten.DatenProg;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXmlSchreiben {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;
    private Daten daten;
    EventListenerList listeners = new EventListenerList();
    public boolean stop = false;

    public IoXmlSchreiben(Daten d) {
        this.daten = d;
        this.stop = false;
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public synchronized void datenSchreiben() {
        this.stop = false;
        this.xmlDatenSchreiben();
        if (!this.daten.noGui) {
            this.xmlFilmeSchreiben();
            this.xmlPodcastlisteSchreiben();
            this.daten.history.speichern();
        }
    }

    public synchronized void filmeSchreiben() {
        this.stop = false;
        this.xmlFilmeSchreiben();
    }

    public synchronized void exportFilme(String datei) {
        this.stop = false;
        try {
            this.daten.fehler.systemMeldung("Filme exportieren nach: " + datei);
            this.xmlSchreibenStart(datei);
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde(datei);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "Filme exportieren nach: " + datei);
        }
    }

    public synchronized void exportPgruppe(DatenPgruppe pGruppe, String datei) {
        this.stop = false;
        try {
            this.daten.fehler.systemMeldung("Programmgruppe exportieren nach: " + datei);
            this.xmlSchreibenStart(datei);
            this.xmlSchreibenPGruppe(pGruppe);
            this.xmlSchreibenEnde(datei);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "Programmgruppe exportieren nach: " + datei);
        }
    }

    private void xmlDatenSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Daten schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".mediathek");
            this.xmlSchreibenDaten("System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
            this.xmlSchreibenDaten("Senderliste", this.daten.filmeLaden.getListeSender(), this.daten.filmeLaden.getSenderOn());
            this.xmlSchreibenProg();
            this.xmlSchreibenAbo();
            this.xmlSchreibenBlackList();
            this.xmlSchreibenPod();
            this.xmlSchreibenFilmUpdate();
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            System.err.println("IoXml.xmlDatenSchreiben: " + ex.getMessage());
        }
    }

    private void xmlFilmeSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Filme schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".filme");
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.xmlFilmeSchreiben");
        }
    }

    private void xmlPodcastlisteSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Podcastliste schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".podcaster");
            this.xmlSchreibenPodcastliste();
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            System.err.println("IoXml.xmlPodcastlisteSchreiben: " + ex.getMessage());
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        File file = new File(datei);
        System.out.println("Datei schreiben: " + file.getAbsolutePath());
        this.outFactory = XMLOutputFactory.newInstance();
        if (datei.endsWith(".bz2")) {
            this.bZip2CompressorOutputStream = new BZip2CompressorOutputStream(new FileOutputStream(file), 2);
            this.out = new OutputStreamWriter((OutputStream)this.bZip2CompressorOutputStream, "UTF-8");
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            ZipEntry entry = new ZipEntry(".filme");
            this.zipOutputStream.putNextEntry(entry);
            this.out = new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8");
        } else {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        this.writer = this.outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement("Mediathek");
        this.writer.writeCharacters("\n");
    }

    private void xmlSchreibenFilmliste() {
        this.xmlSchreibenDaten("Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmeLaden.filmlisteMetaDaten);
    }

    private void xmlSchreibenPodcastliste() {
        ListIterator iterator = this.daten.listePodster.listIterator();
        while (iterator.hasNext()) {
            DatenPodster datenPodster = (DatenPodster)iterator.next();
            this.xmlSchreibenDaten("Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr);
        }
    }

    private void xmlSchreibenFilm() {
        ListIterator iterator = this.daten.filmeLaden.listeFilmeSchattenliste.listIterator();
        while (iterator.hasNext()) {
            DatenFilm datenFilm = (DatenFilm)iterator.next();
            this.xmlSchreibenDaten("Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.getClean().arr);
        }
    }

    private void xmlSchreibenProg() {
        ListIterator it;
        DatenPgruppe datenPgruppe;
        ListIterator iterator = this.daten.listePgruppeAbo.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
        iterator = this.daten.listePgruppeButton.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
    }

    private void xmlSchreibenPGruppe(DatenPgruppe datenPgruppe) {
        this.xmlSchreibenDaten("Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
        ListIterator it = datenPgruppe.getListeProg().listIterator();
        while (it.hasNext()) {
            this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
        }
    }

    private void xmlSchreibenAbo() {
        ListIterator iterator = this.daten.listeAbo.listIterator();
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            this.xmlSchreibenDaten("Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr);
        }
    }

    private void xmlSchreibenBlackList() {
        for (DatenBlacklist blacklist : this.daten.listeBlacklist) {
            this.xmlSchreibenDaten("Blacklist", Konstanten.BLACKLIST_COLUMN_NAMES, blacklist.arr);
        }
    }

    private void xmlSchreibenPod() {
        ListIterator iterator = this.daten.listePod.listIterator();
        while (iterator.hasNext()) {
            DatenPod datenPod = (DatenPod)iterator.next();
            this.xmlSchreibenDaten("Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr);
        }
    }

    private void xmlSchreibenFilmUpdate() {
        ListIterator iterator = this.daten.listeFilmUpdate.alle.listIterator();
        while (iterator.hasNext()) {
            DatenFilmUpdate datenFilmUpdate = (DatenFilmUpdate)iterator.next();
            this.xmlSchreibenDaten("Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            this.writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                this.writer.writeStartElement(xmlSpalten[i]);
                this.writer.writeCharacters(datenArray[i]);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.xmlSchreibenDaten");
        }
    }

    private void xmlSchreibenEnde() throws Exception {
        this.xmlSchreibenEnde("");
    }

    private void xmlSchreibenEnde(String datei) throws Exception {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
        if (datei.endsWith(".bz2")) {
            this.writer.close();
            this.bZip2CompressorOutputStream.close();
        } else if (datei.endsWith(".zip")) {
            this.zipOutputStream.closeEntry();
            this.writer.close();
            this.zipOutputStream.close();
        } else {
            this.writer.close();
        }
        this.daten.fehler.systemMeldung("geschrieben!");
    }
}

