/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.menue;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;

public class PanelExportImportDateiUrl
extends PanelVorlage {
    public boolean ok = false;
    public String ziel;
    private boolean export = true;
    private boolean istDatei;
    private JButton jButtonExportPfad;
    private JButton jButtonExportieren;
    private JLabel jLabelDatei;
    private JPanel jPanel4;
    private JTextField jTextFieldPfad;

    public PanelExportImportDateiUrl(Daten d, boolean eexport, boolean ddatei) {
        super(d);
        this.initComponents();
        this.export = eexport;
        this.istDatei = ddatei;
        this.init();
    }

    private void init() {
        if (this.export) {
            this.jTextFieldPfad.setText(this.daten.system[25]);
            this.jTextFieldPfad.getDocument().addDocumentListener(new BeobTextFeld(25));
        } else {
            this.jButtonExportieren.setText("Importieren");
            if (this.istDatei) {
                this.jTextFieldPfad.setText(this.daten.system[22]);
                this.jTextFieldPfad.getDocument().addDocumentListener(new BeobTextFeld(22));
            } else {
                this.jLabelDatei.setText("URL: ");
                this.jButtonExportPfad.setVisible(false);
                this.jTextFieldPfad.setText(this.daten.system[23]);
                this.jTextFieldPfad.getDocument().addDocumentListener(new BeobTextFeld(23));
            }
        }
        this.jButtonExportieren.addActionListener(new BeobImportExport());
        this.jButtonExportPfad.addActionListener(new BeobPfad());
    }

    private void filmeImportieren() {
        if (this.jTextFieldPfad.getText().equals("")) {
            JOptionPane.showMessageDialog(null, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                if (this.istDatei) {
                    this.daten.filmeLaden.filmeImportDatei(this.daten.system[22], this.istDatei);
                } else {
                    this.daten.filmeLaden.filmeImportDatei(this.daten.system[23], this.istDatei);
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "DialogExportFilme.filmeImportieren: Filme wurden nicht Importiert!");
            }
        }
    }

    private void filmeExportieren() {
        int ret = -1;
        String d = this.daten.system[25];
        if (d.equals("")) {
            JOptionPane.showMessageDialog(null, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                ret = new File(d).exists() ? JOptionPane.showConfirmDialog(null, "Datei:  \"" + d + "\"" + "  existiert bereits", "\u00dcberschreiben?", 0) : 0;
                if (ret == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.daten.ioXmlSchreiben.exportFilme(d);
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "DialogExportFilme.filmeExportieren: Filme wurden nicht exportiert!");
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.jTextFieldPfad = new JTextField();
        this.jButtonExportPfad = new JButton();
        this.jButtonExportieren = new JButton();
        this.jLabelDatei = new JLabel();
        this.jPanel4.setBorder(new SoftBevelBorder(0));
        this.jButtonExportPfad.setText(":::");
        this.jButtonExportieren.setText("Exportieren");
        this.jLabelDatei.setText("Datei:");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDatei).addGap(18, 18, 18).addComponent(this.jTextFieldPfad, -1, 411, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportPfad).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExportieren).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jLabelDatei).addComponent(this.jButtonExportieren).addComponent(this.jButtonExportPfad)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonExportPfad, this.jButtonExportieren, this.jTextFieldPfad);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobImportExport
    implements ActionListener {
        private BeobImportExport() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PanelExportImportDateiUrl.this.export) {
                PanelExportImportDateiUrl.this.filmeExportieren();
            } else {
                PanelExportImportDateiUrl.this.filmeImportieren();
            }
        }
    }

    private class BeobPfad
    implements ActionListener {
        private BeobPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!PanelExportImportDateiUrl.this.jTextFieldPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(PanelExportImportDateiUrl.this.jTextFieldPfad.getText()));
            }
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    PanelExportImportDateiUrl.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    PanelExportImportDateiUrl.this.daten.fehler.fehlerMeldung(ex, "DialogImportFilme.BeobImport");
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        int nr;

        public BeobTextFeld(int n) {
            this.nr = n;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            PanelExportImportDateiUrl.this.daten.system[this.nr] = PanelExportImportDateiUrl.this.jTextFieldPfad.getText();
            PanelExportImportDateiUrl.this.daten.setGeaendert();
        }
    }
}

