/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme.sender;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipInputStream;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.filme.sender.MediathekReader;

public class MediathekBr
extends MediathekReader
implements Runnable {
    public MediathekBr(Daten ddaten) {
        super(ddaten);
        this.sender = "BR";
        this.text = "BR  (ca. 3 MB, 100 Filme)";
    }

    @Override
    void addToList() {
        new Thread(new ThemaLaden()).start();
    }

    void laden() {
        StringBuilder seite = new StringBuilder();
        int pos = 0;
        int posEnde = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        String link = "";
        String datum = "";
        String zeit = "";
        String titel = "";
        String tmp = "";
        String ITEM_1 = "<ausstrahlung";
        String ITEM_2 = "</ausstrahlung>";
        String MUSTER_URL = "<video ";
        String MUSTER_THEMA = "<titel>";
        String MUSTER_TITEL = "<nebentitel>";
        String MUSTER_DATUM = "<beginnPlan>";
        String ADRESSE = "http://rd.gl-systemhaus.de/br/b7/archive/archive.xml.zip.adler32";
        this.notifyProgress("http://rd.gl-systemhaus.de/br/b7/archive/archive.xml.zip.adler32");
        try {
            String user_agent = this.daten.system[3];
            InputStreamReader inReader = null;
            int timeout = 30000;
            char[] zeichen = new char[1];
            URLConnection conn = new URL("http://rd.gl-systemhaus.de/br/b7/archive/archive.xml.zip.adler32").openConnection();
            conn.setRequestProperty("User-Agent", user_agent);
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            ZipInputStream zipInputStream = new ZipInputStream(conn.getInputStream());
            zipInputStream.getNextEntry();
            inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
            seite.setLength(0);
            while (!this.stop && inReader.read(zeichen) != -1) {
                seite.append(zeichen);
            }
            while ((pos = seite.indexOf("<ausstrahlung", pos)) != -1 && (posEnde = seite.indexOf("</ausstrahlung>", pos += "<ausstrahlung".length())) != -1) {
                url = "";
                thema = "";
                link = "";
                datum = "";
                zeit = "";
                titel = "";
                tmp = "";
                pos1 = pos;
                while ((pos1 = seite.indexOf("<video ", pos1)) != -1 && ((pos2 = seite.indexOf("/>", pos1 += "<video ".length())) == -1 || pos1 <= posEnde && pos2 <= posEnde && !(url = seite.substring(pos1, pos2)).contains("xlarge"))) {
                }
                if (url.equals("")) continue;
                pos1 = seite.indexOf("<titel>", pos);
                if (pos1 != -1 && (pos2 = seite.indexOf("</", pos1 += "<titel>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                    thema = seite.substring(pos1, pos2);
                    thema = thema.replace("<!", "");
                    thema = thema.replace("[", "");
                    thema = thema.replace("CDATA", "");
                    thema = thema.replace("]", "");
                    thema = thema.replace(">", "");
                }
                if ((pos1 = seite.indexOf("<nebentitel>", pos)) != -1 && (pos2 = seite.indexOf("</", pos1 += "<nebentitel>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                    titel = seite.substring(pos1, pos2);
                    titel = titel.replace("<!", "");
                    titel = titel.replace("[", "");
                    titel = titel.replace("CDATA", "");
                    titel = titel.replace("]", "");
                    titel = titel.replace(">", "");
                }
                if (titel.equals("")) {
                    titel = thema;
                }
                if ((pos1 = seite.indexOf("<beginnPlan>", pos)) != -1 && (pos2 = seite.indexOf("<", pos1 += "<beginnPlan>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                    tmp = seite.substring(pos1, pos2);
                    datum = this.convertDatum(tmp);
                    zeit = this.convertTime(tmp);
                }
                int p = 0;
                String host = "";
                String app = "";
                String play = "";
                p = url.indexOf("host=\"");
                if (p != -1) {
                    host = url.substring(p += "host=\"".length(), url.indexOf("\"", p));
                }
                p = 0;
                p = url.indexOf("application=\"");
                if (p != -1) {
                    app = url.substring(p += "application=\"".length(), url.indexOf("\"", p));
                }
                p = 0;
                p = url.indexOf("stream=\"");
                if (p != -1) {
                    play = url.substring(p += "stream=\"".length(), url.indexOf("\"", p));
                }
                String urlRtmp = "--host " + host + " --app " + app + " --playpath mp4:" + play;
                String urlOrg = "rtmp://" + host + "/" + app + "/" + play;
                DatenFilm film = new DatenFilm(this.daten, this.sender, thema, link, titel, urlOrg, urlOrg, urlRtmp, datum, zeit, false);
                this.daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(film);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "MediathekBr.addToList");
        }
    }

    public String convertDatum(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "MediathekBr.convertDatum");
        }
        return datum;
    }

    public String convertTime(String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "MediatheBr.convertDatum");
        }
        return datum;
    }

    private class ThemaLaden
    implements Runnable {
        private ThemaLaden() {
        }

        @Override
        public synchronized void run() {
            MediathekBr.this.notifyStart(1);
            MediathekBr.this.addThread();
            try {
                MediathekBr.this.laden();
            }
            catch (Exception ex) {
                System.err.println("MediathekBr.ThemaLaden.run: " + ex.getMessage());
            }
            MediathekBr.this.threadUndFertig();
        }
    }
}

