/*
 * Decompiled with CFR 0.152.
 */
package mediathek;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.GermanStringSorter;
import mediathek.Hinweis;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.Datum;
import mediathek.daten.ListePgruppe;
import mediathek.filme.DatenFilm;
import mediathek.gui.dialoge.DialogHilfe;

public class Funktionen {
    private static final String PIPE = "| ";
    private static final String LEER = "      ";
    private static final String PFEIL = " -> ";

    public static boolean setLook(Daten daten, JFrame frame) {
        int look = 0;
        if (daten.system[1].equals("")) {
            daten.system[1] = "1";
        }
        if ((look = Integer.parseInt(daten.system[1])) != 0) {
            return Funktionen.setLook(daten, frame, look);
        }
        return true;
    }

    public static boolean setLook(Daten daten, JFrame frame, int look) {
        boolean ret = false;
        try {
            switch (look) {
                case 0: 
                case 1: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                default: {
                    UIManager.setLookAndFeel(Konstanten.THEME[look][1]);
                }
            }
            SwingUtilities.updateComponentTreeUI(frame);
            for (Frame f : Frame.getFrames()) {
                SwingUtilities.updateComponentTreeUI(f);
                for (Window w : f.getOwnedWindows()) {
                    SwingUtilities.updateComponentTreeUI(w);
                }
            }
            ret = true;
        }
        catch (Exception e) {
            daten.fehler.fehlerMeldung(e, "Kann das Look and Feel nicht \u00e4ndern!");
        }
        return ret;
    }

    public static void copyToClipboard(String s) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public static void setProxy(Daten daten) {
        if (Boolean.parseBoolean(daten.system[16])) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", daten.system[12]);
            System.setProperty("http.proxyPort", daten.system[13]);
            System.setProperty("http.proxyUser", daten.system[14]);
            System.setProperty("http.proxyPassword", daten.system[15]);
        } else {
            System.setProperty("proxySet", "false");
        }
    }

    public static String replaceLeerDateiname(String pfad, boolean pfadtrennerEntfernen) {
        String ret = pfad;
        if (pfadtrennerEntfernen) {
            ret = ret.replace("/", "-");
            ret = ret.replace("\\", "-");
        }
        ret = ret.replace("\n", "_");
        ret = ret.replace("\"", "_");
        ret = ret.replace(",", "_");
        ret = ret.replace(";", "_");
        ret = ret.replace("(", "_");
        ret = ret.replace(")", "_");
        ret = ret.replace(" ", "_");
        ret = ret.replace("*", "_");
        ret = ret.replace("?", "_");
        ret = ret.replace("<", "_");
        ret = ret.replace(">", "_");
        ret = ret.replace(":", "_");
        ret = ret.replace("'", "_");
        return ret;
    }

    public static String addsPfad(Daten daten, String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == File.separatorChar ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == File.separatorChar ? ret + pfad2 : ret + File.separator + pfad2;
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.addsPfad: " + pfad1 + " " + pfad2);
        }
        return ret;
    }

    public static String addsUrl(Daten daten, String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == '/' ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == '/' ? ret + pfad2 : ret + '/' + pfad2;
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.addsUrl: " + pfad1 + " " + pfad2);
        }
        return ret;
    }

    public static String getDateiName(Daten daten, String pfad) {
        String ret = "";
        if (pfad != null && !pfad.equals("")) {
            ret = pfad.substring(pfad.lastIndexOf("/") + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf("?"));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf("&"));
        }
        if (ret.equals("")) {
            daten.fehler.fehlerMeldung("Fehler!", "Funktionen.getDateiName: " + pfad);
        }
        return ret;
    }

    public static void listeSort(LinkedList<String> liste) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        Collections.sort(liste, sorter);
    }

    public static void listeSort(LinkedList<String[]> liste, int stelle) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (liste != null) {
            for (int i = 1; i < liste.size(); ++i) {
                String str2;
                String str1;
                for (int k = i; k > 0 && sorter.compare(str1 = liste.get(k - 1)[stelle], str2 = liste.get(k)[stelle]) > 0; --k) {
                    liste.add(k - 1, liste.remove(k));
                }
            }
        }
    }

    public static void addStandardprogrammeAbo(Daten daten) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            Funktionen.addStandardprogrammeAboWin(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            Funktionen.addStandardprogrammeAboLinux(daten);
        } else {
            Funktionen.addStandardprogrammeAboWin(daten);
            Funktionen.addStandardprogrammeAboLinux(daten);
        }
    }

    public static void addStandardPodcast(Daten daten) {
        daten.system[11] = Funktionen.getHomePath();
    }

    private static void addStandardprogrammeAboWin(Daten daten) {
        DatenPgruppe gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Programmgruppe Windows";
        gruppe.arr[6] = "%T-%N.mp4";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        DatenProg prog = new DatenProg();
        prog.arr[0] = "flvstreamer";
        prog.arr[1] = "flvstreamer_win32_latest.exe";
        prog.arr[2] = "%f -o \"**\" --resume";
        prog.arr[3] = "-";
        prog.arr[4] = "";
        prog.arr[5] = Boolean.TRUE.toString();
        gruppe.addProg(prog);
        prog = new DatenProg();
        prog.arr[0] = "vlc";
        prog.arr[1] = Funktionen.getWindowsVlcPath();
        prog.arr[2] = "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit";
        prog.arr[3] = "";
        prog.arr[4] = "";
        gruppe.addProg(prog);
        daten.listePgruppeAbo.add(gruppe);
    }

    private static void addStandardprogrammeAboLinux(Daten daten) {
        DatenPgruppe gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Programmgruppe Linux";
        gruppe.arr[6] = "%T-%N";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        DatenProg prog = new DatenProg();
        prog.arr[0] = "flvstreamer";
        prog.arr[1] = "flvstreamer";
        prog.arr[2] = "%f -o ** --resume";
        prog.arr[3] = "-";
        prog.arr[4] = "";
        prog.arr[5] = Boolean.TRUE.toString();
        gruppe.addProg(prog);
        prog = new DatenProg();
        prog.arr[0] = "Aufzeichnen Vlc";
        prog.arr[1] = "vlc";
        prog.arr[2] = "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=**}} -I dummy --play-and-exit";
        prog.arr[3] = "mms";
        prog.arr[4] = "";
        gruppe.addProg(prog);
        prog = new DatenProg();
        prog.arr[0] = "mplayer";
        prog.arr[1] = "mplayer";
        prog.arr[2] = "-cache 8192 -cache-min 50 -playlist %f -dumpstream -dumpfile **";
        prog.arr[3] = "";
        prog.arr[4] = "";
        gruppe.addProg(prog);
        daten.listePgruppeAbo.add(gruppe);
    }

    public static void addStandardprogrammeButton(Daten daten) {
        boolean is64bit = false;
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            Funktionen.addStandardprogrammeButtonWin(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            Funktionen.addStandardprogrammeButtonLinux(daten);
        } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            Funktionen.addStandardprogrammeButtonMac(daten);
        } else {
            Funktionen.addStandardprogrammeButtonWin(daten);
            Funktionen.addStandardprogrammeButtonLinux(daten);
            Funktionen.addStandardprogrammeButtonMac(daten);
        }
    }

    private static void addStandardprogrammeButtonMac(Daten daten) {
        DatenPgruppe gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Abspielen Vlc";
        gruppe.arr[6] = "";
        gruppe.arr[5] = "";
        gruppe.addProg(new DatenProg("Mac - Abspielen Vlc", "/Applications/VLC.app/Contents/MacOS/VLC", "%f", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
    }

    private static void addStandardprogrammeButtonLinux(Daten daten) {
        DatenPgruppe gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Abspielen Vlc";
        gruppe.arr[6] = "";
        gruppe.arr[5] = "";
        gruppe.addProg(new DatenProg("Linux - Abspielen Vlc", "/usr/bin/vlc", "%f", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen mplayer";
        gruppe.arr[6] = "%n";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("Linux - Aufzeichnen mplayer", "mplayer", "-cache 8192 -cache-min 50 -playlist %f -dumpstream -dumpfile **", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen mplayer mit Pfad";
        gruppe.arr[6] = "%p";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("Linux - Aufzeichnen mplayer mit Pfad", "/usr/bin/mplayer", "-cache 8192 -cache-min 50 -playlist %f -dumpstream -dumpfile **", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen VLC mit Pfad";
        gruppe.arr[6] = "%p";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("Linux - nicht transcodiertes Aufnehmen ohne Anschauen", "vlc", "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=**}} -I dummy --play-and-exit", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen flvstreamer";
        gruppe.arr[6] = "%n";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("flvstreamer", "flvstreamer", "%f -o ** --resume", Boolean.TRUE.toString()));
        daten.listePgruppeButton.add(gruppe);
        daten.listePgruppeButton.setDoppelklick(0);
    }

    private static void addStandardprogrammeButtonWin(Daten daten) {
        DatenPgruppe gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Abspielen Vlc";
        gruppe.arr[6] = "";
        gruppe.arr[5] = "";
        gruppe.addProg(new DatenProg("Win - Abspielen Vlc", Funktionen.getWindowsVlcPath(), "%f", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen Vlc";
        gruppe.arr[6] = "%p";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("Win - Aufzeichnen Vlc mit Pfad", Funktionen.getWindowsVlcPath(), "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit", Boolean.FALSE.toString()));
        daten.listePgruppeButton.add(gruppe);
        gruppe = new DatenPgruppe();
        gruppe.arr[0] = "Aufzeichnen flvstreamer";
        gruppe.arr[6] = "%p";
        gruppe.arr[5] = Funktionen.getHomePath();
        gruppe.arr[1] = "http";
        gruppe.arr[2] = "mp4,mp3,m4v,flv";
        gruppe.addProg(new DatenProg("flvstreamer", "flvstreamer_win32_latest.exe", "%f -o \"**\" --resume", Boolean.TRUE.toString()));
        daten.listePgruppeButton.add(gruppe);
        daten.listePgruppeButton.setDoppelklick(0);
    }

    public static void addProgVorlagen(Daten daten) {
        daten.listeProgVorlagen.clear();
        daten.listeProgVorlagen.addProg("Win - Abspielen Vlc", Funktionen.getWindowsVlcPath(), "%f");
        daten.listeProgVorlagen.addProg("Win - Aufzeichnen Vlc", Funktionen.getWindowsVlcPath(), "%f :sout=#transcode{acodec=mpga,ab=128,channels=2}:duplicate{dst=std{access=file,mux=ts,dst=\"**\"}} -I \"dummy\" --play-and-exit");
        daten.listeProgVorlagen.addProg("Win - nicht transcodiertes Aufnehmen ohne Anschauen", Funktionen.getWindowsVlcPath(), "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=\"**\"}} -I \"dummy\" --play-and-exit");
        daten.listeProgVorlagen.addProg("Win - nicht transcodiertes Aufnehmen und Anschauen", Funktionen.getWindowsVlcPath(), "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=\"**\"},dst=display} --play-and-exit");
        daten.listeProgVorlagen.addProg("Win - Itunes lauff\u00e4higes Video", Funktionen.getWindowsVlcPath(), "%f :sout=#transcode{vcodec=mp4v,vb=1024,scale=1,width=480,height=272,acodec=mp4a,ab=128,channels=2,samplerate=48000}:duplicate{dst=std{access=file,mux=mp4,dst=\"**\"}} --play-and-exit");
        DatenProg prog = new DatenProg("Windows - Aufzeichnen flvstreamer", "flvstreamer_win32_latest.exe", "%f -o \"**\" --resume", Boolean.TRUE.toString());
        prog.arr[3] = "-";
        daten.listeProgVorlagen.add(prog);
        daten.listeProgVorlagen.addProg("Linux - Abspielen Vlc", "/usr/bin/vlc", "%f");
        daten.listeProgVorlagen.addProg("Linux - Aufzeichnen mplayer", "/usr/bin/mplayer", "-cache 8192 -cache-min 50 -playlist %f -dumpstream -dumpfile **");
        daten.listeProgVorlagen.addProg("Linux - nicht transcodiertes Aufnehmen ohne Anschauen", "vlc", "%f :sout=#duplicate{dst=std{access=file,mux=asf,dst=**}} -I dummy --play-and-exit");
        prog = new DatenProg("Linux - Aufzeichnen flvstreamer", "/usr/bin/flvstreamer", "%f -o ** --resume", Boolean.TRUE.toString());
        prog.arr[3] = "-";
        daten.listeProgVorlagen.add(prog);
        daten.listeProgVorlagen.addProg("Mac - Abspielen Vlc", "/Applications/VLC.app/Contents/MacOS/VLC", "%f");
    }

    public static boolean programmePruefen(Daten daten, ListePgruppe listeProg) {
        boolean ret = true;
        String text = "";
        for (DatenPgruppe datenPgruppe : listeProg) {
            ret = true;
            if (datenPgruppe.isFreeLine() || datenPgruppe.isLable()) continue;
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n";
            text = text + "| Programmgruppe: " + datenPgruppe.arr[0] + "\n";
            String zielPfad = datenPgruppe.arr[5];
            if (zielPfad.equals("")) {
                if (datenPgruppe.needsPath()) {
                    ret = false;
                    text = text + "|       Zielpfad fehlt!\n";
                }
            } else {
                File pfad = new File(zielPfad);
                if (!pfad.isDirectory()) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" ist kein Verzeichnis!" + "\n";
                } else if (!Funktionen.checkPfadBeschreibbar(daten, false, zielPfad)) {
                    ret = false;
                    text = text + "|       Falscher Zielpfad!\n";
                    text = text + "|        -> Zielpfad \"" + zielPfad + "\" nicht beschreibbar!" + "\n";
                }
            }
            for (DatenProg datenProg : datenPgruppe.getListeProg()) {
                if (new File(datenProg.arr[1]).canExecute()) continue;
                ret = false;
                text = text + "|       Falscher Programmpfad!\n";
                text = text + "|        -> Programmname: " + datenProg.arr[0] + "\n";
                text = text + "|             Pfad: " + datenProg.arr[1] + "\n";
                if (datenProg.arr[1].contains(File.separator)) continue;
                text = text + "|        -> Wenn das Programm nicht im Systempfad liegt, \n";
                text = text + "|             wird der Start nicht klappen!\n";
            }
            if (ret) {
                text = text + "|  -> Ok!\n";
            }
            text = text + "++++++++++++++++++++++++++++++++++++++++++++\n\n\n";
        }
        new DialogHilfe(null, true, text).setVisible(true);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPfadBeschreibbar(Daten daten, boolean error, String pfad) {
        boolean ret = false;
        boolean beschreibbar = true;
        File testPfad = new File(pfad);
        try {
            if (pfad.equals("")) {
                if (error) {
                    daten.fehler.fehlerMeldung("Pfad ist fehlerhaft!", "Pfad ist leer");
                }
            } else if (!testPfad.isDirectory()) {
                if (error) {
                    daten.fehler.fehlerMeldung("Pfad ist fehlerhaft!", "\"Pfad\" ist kein Pfad");
                }
            } else {
                beschreibbar = false;
                if (testPfad.canWrite()) {
                    File tmpFile = File.createTempFile("mediathek", "tmp", testPfad);
                    tmpFile.delete();
                    ret = true;
                    beschreibbar = true;
                }
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (!beschreibbar && error) {
                daten.fehler.fehlerMeldung("Zielpfad ist fehlerhaft!", "Zielpfad ist  nicht beschreibbar");
            }
        }
        return ret;
    }

    private static String getWindowsVlcPath() {
        String PFAD_WIN_VLC_DEFAULT = "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
        String PFAD_WIN_VLC = "\\VideoLAN\\VLC\\vlc.exe";
        String vlcpath = "";
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows") && System.getenv("ProgramFiles") != null && new File(vlcpath = System.getenv("ProgramFiles") + "\\VideoLAN\\VLC\\vlc.exe").exists()) {
                return vlcpath;
            }
            if (System.getenv("ProgramFiles(x86)") != null && new File(vlcpath = System.getenv("ProgramFiles(x86)") + "\\VideoLAN\\VLC\\vlc.exe").exists()) {
                return vlcpath;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "C:\\Programme\\VideoLAN\\VLC\\vlc.exe";
    }

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String getJetzt_ddMMyyyy_HHmm() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HH_MM_SS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getJetzt_HHMMSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_yyyyMMdd() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getHeute_dd_MM_yyyy() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        Date today = new Date();
        String output = formatter.format(today);
        return output;
    }

    public static String getStandardUserAgent() {
        return "MediathekView 2.6.0";
    }

    public static String[] addLeerListe(String[] str) {
        int len = str.length + 1;
        String[] liste = new String[len];
        liste[0] = "";
        for (int i = 1; i < len; ++i) {
            liste[i] = str[i - 1];
        }
        return liste;
    }

    public static boolean praefixTesten(String str, String uurl, boolean praefix) {
        boolean ret = false;
        String url = uurl.toLowerCase();
        String s1 = "";
        if (str.equals("")) {
            ret = true;
        } else {
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ',') {
                    s1 = s1 + str.charAt(i);
                }
                if (str.charAt(i) != ',' && i < str.length() - 1) continue;
                if (praefix) {
                    if (url.startsWith(s1.toLowerCase())) {
                        ret = true;
                        break;
                    }
                } else if (url.endsWith(s1.toLowerCase())) {
                    ret = true;
                    break;
                }
                s1 = "";
            }
        }
        return ret;
    }

    public static void spaltenFilmLoeschen(JTable tabelle, Daten daten, boolean abo, boolean ziel, boolean prog, boolean zeit, boolean datei) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            if (daten.debug || !(!ziel && i == 13 || !ziel && i == 12 || !zeit && i == 5 || !datei && i == 11 || !prog && i == 15 || !abo && i == 17 || i == 14 || i == 7 || i == 8 || i == 9 || i == 16) && i != 10) continue;
            tabelle.getColumnModel().getColumn(i).setMinWidth(0);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(0);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(0);
        }
    }

    public static void spaltenFilmSetzen(JTable tabelle, Daten daten, boolean abo, boolean ziel, boolean prog) {
        for (int i = 0; i < tabelle.getColumnCount(); ++i) {
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(200);
            if (i == 0 || i == 4 || i == 5 || i == 1) {
                tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(100);
                continue;
            }
            if (i == 3) {
                tabelle.getColumnModel().getColumn(i).setMinWidth(10);
                tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
                tabelle.getColumnModel().getColumn(i).setPreferredWidth(300);
                continue;
            }
            if (i != 6) continue;
            tabelle.getColumnModel().getColumn(i).setMinWidth(10);
            tabelle.getColumnModel().getColumn(i).setMaxWidth(3000);
            tabelle.getColumnModel().getColumn(i).setPreferredWidth(500);
        }
        Funktionen.spaltenFilmLoeschen(tabelle, daten, abo, ziel, prog, true, true);
    }

    public static String getBefhelsString(String befehl, String zielDateiname, String url, DatenFilm datenFilm) {
        String befehlsString = befehl;
        befehlsString = befehlsString.replace("**", zielDateiname);
        befehlsString = befehlsString.replace("%f", url);
        if (datenFilm.arr[9].equals("")) {
            befehlsString = befehlsString.replace("%a", "");
            befehlsString = befehlsString.replace("%A", "");
        } else {
            befehlsString = befehlsString.replace("%a", datenFilm.arr[9]);
            befehlsString = befehlsString.replace("%A", "-W " + datenFilm.arr[9]);
        }
        return befehlsString;
    }

    public static String textLaenge(String text) {
        if (text.length() != 80) {
            return Funktionen.textLaenge(80, text);
        }
        return text;
    }

    public static String textLaenge(int max, String text) {
        int MAX = max;
        if (text.length() > MAX) {
            text = text.substring(0, 25) + " .... " + text.substring(text.length() - (MAX - 31));
        }
        while (text.length() < MAX) {
            text = text + " ";
        }
        return text;
    }

    public static int getUpdateFilme(Daten d) {
        int ret = 0;
        try {
            ret = Integer.parseInt(d.system[32]);
        }
        catch (Exception ex) {
            ret = 0;
        }
        return ret;
    }

    public static String convertDatum(Daten daten, String datum) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(datum);
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            datum = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Funktionen.convertDatum");
        }
        return datum;
    }

    public static String convertTime(Daten daten, String zeit) {
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            Date filmDate = sdfIn.parse(zeit);
            SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
            zeit = sdfOut.format(filmDate);
        }
        catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "Funktionen.convertTime");
        }
        return zeit;
    }

    public static String checkDatum(Daten daten, String datum, String fehlermeldung) {
        long MAX = 4320000000L;
        String ret = datum.trim();
        if (ret.equals("")) {
            return "";
        }
        if (!ret.contains(".")) {
            daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum: " + datum + " " + fehlermeldung);
            return "";
        }
        if (ret.length() != 10) {
            daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum: " + datum + " " + fehlermeldung);
            return "";
        }
        try {
            SimpleDateFormat sdfIn = new SimpleDateFormat("dd.MM.yyyy");
            Date filmDate = sdfIn.parse(ret);
            if (filmDate.getTime() < 0L) {
                daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum - Unsinniger Wert: " + datum + " " + fehlermeldung);
                ret = "";
            }
            if (new Date().getTime() + 4320000000L < filmDate.getTime()) {
                daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum - Unsinniger Wert: " + datum + " " + fehlermeldung);
                ret = "";
            }
        }
        catch (Exception ex) {
            ret = "";
            daten.fehler.fehlerMeldung(ex, "Funktionen.checkDatum");
            daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckDatum: " + datum + " " + fehlermeldung);
        }
        if (ret.equals("")) {
            // empty if block
        }
        return ret;
    }

    public static String checkZeit(Daten daten, String datum, String zeit, String text) {
        String ret = zeit.trim();
        if (datum.equals("")) {
            ret = "";
        } else if (!ret.equals("")) {
            if (!ret.contains(":")) {
                ret = "";
            }
            if (ret.length() != 8) {
                ret = "";
            }
            if (ret.equals("")) {
                daten.fehler.fehlerMeldung("Fehler: ", "DatenFilm.CheckZeit: " + zeit + " " + text);
            }
        }
        return ret;
    }

    public static String datumDrehen(String datum) {
        String ret = "";
        if (!datum.equals("")) {
            try {
                if (datum.length() == 10) {
                    String tmp = datum.substring(6);
                    tmp = tmp + "." + datum.substring(3, 5);
                    ret = tmp = tmp + "." + datum.substring(0, 2);
                }
            }
            catch (Exception ex) {
                System.err.println("Funktionen.datumDrehen: " + ex.getMessage());
            }
        }
        return ret;
    }

    public static String datumDatumZeitReinigen(String datum) {
        String ret = "";
        ret = datum;
        ret = ret.replace(":", "");
        ret = ret.replace(".", "");
        return ret;
    }

    public static Datum getDatumForObject(String datum) {
        Datum tmp = new Datum(0L);
        if (!datum.equals("")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                tmp.setTime(sdf.parse(datum).getTime());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return tmp;
    }

    public static void checkFlash(Daten daten, String url, String befehlsString) {
        if (!System.getProperty("os.name").toLowerCase().contains("linux") && (url.startsWith("-r") || url.startsWith("rtmp") || url.startsWith("--host")) && !befehlsString.contains("flvstreamer") && !befehlsString.contains("rtmpdump")) {
            new Hinweis(daten).hinweisFlash();
        }
    }
}

