/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.beobachter.BeobWeb;
import mediathek.daten.Daten;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiFilme;
import mediathek.gui.GuiPodder;
import mediathek.gui.OSXAdapter;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.gui.menue.DialogEinstellungen;
import mediathek.gui.menue.DialogExportImportDatei;
import mediathek.gui.menue.DialogInfo;
import mediathek.gui.menue.DialogSenderLaden;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.update.CheckUpdate;

public final class GuiMediathek
extends JFrame {
    private Daten daten;
    public GuiFilme guiFilme;
    private GuiDebug guiDebug;
    public GuiAbo guiAbo;
    public GuiPodder guiPodder;
    public static boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private boolean debug = false;
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private DialogSenderLaden dialogSenderLaden = null;
    private JButton jButtonStop;
    private JButton jButtonStopNachFilm;
    private JCheckBoxMenuItem jCheckBoxAboEinschalten;
    private JCheckBoxMenuItem jCheckBoxMenuItemPlayer;
    private JCheckBoxMenuItem jCheckBoxPodcastEinschalten;
    private JLabel jLabel2;
    private JLabel jLabelDownload;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu5;
    private JMenu jMenu6;
    private JMenu jMenuAboEinrichten;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItemAboEinrichten;
    private JMenuItem jMenuItemAnleitung;
    private JMenuItem jMenuItemBeenden;
    private JMenuItem jMenuItemButtonEinrichten;
    private JMenuItem jMenuItemEinstellungen;
    private JMenuItem jMenuItemFehler;
    private JMenuItem jMenuItemHistory;
    private JMenuItem jMenuItemImportDatei;
    private JMenuItem jMenuItemInfos;
    private JMenuItem jMenuItemLoeschen;
    private JMenuItem jMenuItemPodcastEinrichten;
    private JMenuItem jMenuItemSender;
    private JPanel jPanelExtra;
    private JProgressBar jProgressBar1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JTextField jTextFieldDownloads;
    private JPanel statusPanel;

    public GuiMediathek(String[] ar) {
        String pfad = "";
        boolean max = false;
        boolean alles = false;
        this.initComponents();
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (ar[i].equals("-D")) {
                    this.debug = true;
                }
                if (ar[i].equals("-M")) {
                    max = true;
                }
                if (!ar[i].equals("-alles")) continue;
                alles = true;
            }
        }
        this.jPanelExtra.setLayout(new BorderLayout());
        this.setStatusPanel(false);
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        this.daten = new Daten(pfad, this.debug, this, false);
        this.daten.allesLaden = alles;
        this.titelSetzen();
        Funktionen.setLook(this.daten, this);
        this.initTabs();
        this.init();
        this.setSize(max);
        if (this.debug && this.daten.dialogFehler != null) {
            this.daten.dialogFehler.setVisible(true);
        }
        this.registerForMacOSXEvents();
        new Thread(new CheckUpdate(this.daten)).start();
    }

    public void setSize(boolean max) {
        this.pack();
        if (max || Boolean.parseBoolean(this.daten.system[2])) {
            this.setExtendedState(6);
        } else {
            int x = 0;
            int y = 0;
            try {
                x = Integer.parseInt(this.daten.system[5]);
                y = Integer.parseInt(this.daten.system[6]);
            }
            catch (Exception ex) {
                x = 0;
                y = 0;
            }
            if (x > 0 && y > 0) {
                this.setSize(new Dimension(x, y));
            }
        }
    }

    public void setTabs() {
        this.jTabbedPane.removeAll();
        this.jPanelExtra.removeAll();
        if (!(this.daten.system[7].equals(Boolean.toString(true)) || this.daten.system[10].equals(Boolean.toString(true)) || this.debug)) {
            this.jPanelExtra.add((Component)this.guiFilme, "Center");
        } else {
            this.jPanelExtra.add((Component)this.jTabbedPane, "Center");
            this.jTabbedPane.addTab("Filme", this.guiFilme);
            if (this.daten.system[7].equals(Boolean.toString(true))) {
                this.jTabbedPane.addTab("Abonnements", this.guiAbo);
            }
            if (Boolean.parseBoolean(this.daten.system[10])) {
                this.jTabbedPane.addTab("Podcasts", this.guiPodder);
            }
            if (this.debug) {
                this.jTabbedPane.addTab("Debug", this.guiDebug);
            }
        }
        this.pack();
    }

    private void titelSetzen() {
        if (this.daten.debug) {
            this.setTitle("MediathekView 2.5.0  ** DEBUG **       [ " + this.daten.getBasisVerzeichnis() + " ]     Seiten: " + this.daten.filmeLaden.getSeitenZaehlerLauf());
        } else {
            this.setTitle("MediathekView 2.5.0");
        }
    }

    private void init() {
        this.initMenue();
        this.daten.starterClass.addListener(new BeobachterStart());
        this.jButtonStop.addActionListener(new AlleAbbrechen());
        this.jButtonStopNachFilm.addActionListener(new AlleAbbrechenNachFilm());
        this.jCheckBoxAboEinschalten.setSelected(Boolean.parseBoolean(this.daten.system[7]));
        this.jMenuItemAboEinrichten.setEnabled(Boolean.parseBoolean(this.daten.system[7]));
        this.jCheckBoxPodcastEinschalten.setSelected(Boolean.parseBoolean(this.daten.system[10]));
        this.jMenuItemPodcastEinrichten.setEnabled(Boolean.parseBoolean(this.daten.system[10]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GuiMediathek.this.beenden();
            }
        });
    }

    private void initMenue() {
        this.dialogSenderLaden = new DialogSenderLaden((Frame)this, false, this.daten);
        this.jMenuItemSender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiMediathek.this.dialogSenderLaden.setVisible(true);
            }
        });
        this.jMenuItemImportDatei.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogExportImportDatei(null, true, GuiMediathek.this.daten).setVisible(true);
            }
        });
        this.jMenuItemHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.history.loschen();
                GuiMediathek.this.guiFilme.neuLaden();
            }
        });
        this.jMenuItemLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.filmeLaden.alleFilmeLoeschen();
                GuiMediathek.this.guiFilme.neuLaden();
            }
        });
        this.jMenuItemBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiMediathek.this.beenden();
                GuiMediathek.this.undThschuess();
            }
        });
        this.jMenuItemEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogEinstellungen(null, true, GuiMediathek.this.daten).setVisible(true);
            }
        });
        this.jCheckBoxMenuItemPlayer.addActionListener(new BeobPlayer());
        this.jMenuItemButtonEinrichten.addActionListener(new BeobPgruppen());
        this.jCheckBoxPodcastEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.system[10] = Boolean.toString(GuiMediathek.this.jCheckBoxPodcastEinschalten.isSelected());
                GuiMediathek.this.jMenuItemPodcastEinrichten.setEnabled(Boolean.parseBoolean(((GuiMediathek)GuiMediathek.this).daten.system[10]));
                GuiMediathek.this.daten.setGeaendert();
                ((GuiMediathek)GuiMediathek.this).daten.guiMediathek.setTabs();
            }
        });
        this.jMenuItemPodcastEinrichten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiMediathek.this.guiPodder.basisziel();
            }
        });
        this.jCheckBoxAboEinschalten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GuiMediathek)GuiMediathek.this).daten.system[7] = Boolean.toString(GuiMediathek.this.jCheckBoxAboEinschalten.isSelected());
                GuiMediathek.this.jMenuItemAboEinrichten.setEnabled(Boolean.parseBoolean(((GuiMediathek)GuiMediathek.this).daten.system[7]));
                GuiMediathek.this.daten.setGeaendert();
                ((GuiMediathek)GuiMediathek.this).daten.guiMediathek.setTabs();
            }
        });
        this.jMenuItemAboEinrichten.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiMediathek.this.guiAbo.einstellungen();
            }
        });
        this.jMenuItemInfos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogInfo(null, false, GuiMediathek.this.daten).setVisible(true);
            }
        });
        this.jMenuItemAnleitung.addActionListener(new BeobWeb());
        this.jMenuItemFehler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GuiMediathek)GuiMediathek.this).daten.dialogFehler != null) {
                    ((GuiMediathek)GuiMediathek.this).daten.dialogFehler.setVisible(true);
                }
            }
        });
    }

    private void initTabs() {
        this.guiFilme = new GuiFilme(this.daten);
        this.guiAbo = new GuiAbo(this.daten);
        this.guiPodder = new GuiPodder(this.daten);
        this.guiDebug = new GuiDebug(this.daten);
        this.setTabs();
    }

    private void setProgressBar(StartEvent ev) {
        this.titelSetzen();
        if (ev.nixTun()) {
            this.setStatusPanel(false);
            this.jLabelDownload.setText("Filme:");
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
        } else {
            this.setStatusPanel(true);
            this.jLabelDownload.setText("Filme  (" + ev.getMax() + "):");
            this.jProgressBar1.setMaximum(ev.getMax());
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(ev.getProgress());
            this.jProgressBar1.setStringPainted(true);
        }
        if (ev.getDown() == 0) {
            this.jTextFieldDownloads.setText(String.valueOf(""));
            this.jTextFieldDownloads.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        } else {
            this.jTextFieldDownloads.setText(String.valueOf(" " + ev.getDown() + " "));
            this.jTextFieldDownloads.setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
        }
        this.statusPanel.repaint();
    }

    private void setStatusPanel(boolean bool) {
        for (int i = 0; i < this.statusPanel.getComponentCount(); ++i) {
            this.statusPanel.getComponent(i).setVisible(bool);
        }
    }

    private void beenden() {
        this.daten.allesAbbrechen();
        String x = String.valueOf(this.getSize().width);
        String y = String.valueOf(this.getSize().height);
        if (!x.equals(this.daten.system[5]) || !y.equals(this.daten.system[6])) {
            this.daten.system[5] = x;
            this.daten.system[6] = y;
            this.daten.setGeaendertOhnePanel();
        }
        if (this.daten.isGeaendert()) {
            this.daten.speichern();
        }
    }

    private void undThschuess() {
        this.daten.speichern();
        this.dispose();
        System.exit(0);
    }

    private void alleDownloadsAbbrechen() {
        this.daten.allesAbbrechen();
    }

    private void alleDownloadsAbbrechenNachFilm() {
        this.daten.allesAbbrechenNachFilm();
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jTextFieldDownloads = new JTextField();
        this.jLabelDownload = new JLabel();
        this.jButtonStop = new JButton();
        this.jButtonStopNachFilm = new JButton();
        this.jPanelExtra = new JPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItemSender = new JMenuItem();
        this.jMenuItemImportDatei = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItemLoeschen = new JMenuItem();
        this.jMenuItemHistory = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItemBeenden = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItemEinstellungen = new JMenuItem();
        this.jMenu5 = new JMenu();
        this.jCheckBoxMenuItemPlayer = new JCheckBoxMenuItem();
        this.jMenuItemButtonEinrichten = new JMenuItem();
        this.jMenuAboEinrichten = new JMenu();
        this.jCheckBoxAboEinschalten = new JCheckBoxMenuItem();
        this.jMenuItemAboEinrichten = new JMenuItem();
        this.jMenu6 = new JMenu();
        this.jCheckBoxPodcastEinschalten = new JCheckBoxMenuItem();
        this.jMenuItemPodcastEinrichten = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItemInfos = new JMenuItem();
        this.jMenuItemFehler = new JMenuItem();
        this.jMenuItemAnleitung = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.statusPanel.setBorder(new SoftBevelBorder(0));
        this.jLabel2.setText("laufende Filme:");
        this.jTextFieldDownloads.setEditable(false);
        this.jTextFieldDownloads.setHorizontalAlignment(0);
        this.jLabelDownload.setText("Filme:");
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/process-stop.png")));
        this.jButtonStop.setText("alle stoppen");
        this.jButtonStop.setToolTipText("Downloads sofort abbrechen");
        this.jButtonStopNachFilm.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/emblem-unreadable.png")));
        this.jButtonStopNachFilm.setText("wartende stoppen");
        this.jButtonStopNachFilm.setToolTipText("Downloads nach dem Film abbrechen");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelDownload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -1, 410, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStopNachFilm).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(6, 6, 6).addComponent(this.jTextFieldDownloads, -2, -1, -2).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelDownload).addComponent(this.jProgressBar1, -2, 23, -2).addComponent(this.jButtonStop).addComponent(this.jLabel2).addComponent(this.jTextFieldDownloads, -2, -1, -2).addComponent(this.jButtonStopNachFilm)));
        statusPanelLayout.linkSize(1, this.jButtonStop, this.jButtonStopNachFilm, this.jProgressBar1, this.jTextFieldDownloads);
        this.jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 950, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 321, Short.MAX_VALUE));
        this.jMenu1.setText("Filme");
        this.jMenuItemSender.setText("Einstellungen, Laden vom Sender");
        this.jMenuItemSender.setToolTipText("Filme direkt beim Sender laden und die Einstellungen dazu");
        this.jMenu1.add(this.jMenuItemSender);
        this.jMenuItemImportDatei.setText("Import/Export Filme aus Datei");
        this.jMenuItemImportDatei.setToolTipText("Die ganze Filmliste aus einer Datei importieren / in eine Datei exportieren");
        this.jMenu1.add(this.jMenuItemImportDatei);
        this.jMenu1.add(this.jSeparator1);
        this.jMenuItemLoeschen.setText("Filmliste l\u00f6schen");
        this.jMenu1.add(this.jMenuItemLoeschen);
        this.jMenuItemHistory.setText("History l\u00f6schen");
        this.jMenu1.add(this.jMenuItemHistory);
        this.jMenu1.add(this.jSeparator2);
        this.jMenuItemBeenden.setText("Beenden");
        this.jMenu1.add(this.jMenuItemBeenden);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Einstellungen");
        this.jMenuItemEinstellungen.setText("Allgemeine Einstellungen");
        this.jMenuItemEinstellungen.setToolTipText("allgemeine Programmeinstellungen");
        this.jMenu2.add(this.jMenuItemEinstellungen);
        this.jMenu5.setText("Button");
        this.jCheckBoxMenuItemPlayer.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.jCheckBoxMenuItemPlayer.setSelected(true);
        this.jCheckBoxMenuItemPlayer.setText("Playerbutton einblenden");
        this.jCheckBoxMenuItemPlayer.setToolTipText("Rahmen mit den Playerbutton ein- und ausblenden");
        this.jMenu5.add(this.jCheckBoxMenuItemPlayer);
        this.jMenuItemButtonEinrichten.setText("Einrichten");
        this.jMenu5.add(this.jMenuItemButtonEinrichten);
        this.jMenu2.add(this.jMenu5);
        this.jMenuAboEinrichten.setText("Abos");
        this.jCheckBoxAboEinschalten.setSelected(true);
        this.jCheckBoxAboEinschalten.setText("Einschalten");
        this.jMenuAboEinrichten.add(this.jCheckBoxAboEinschalten);
        this.jMenuItemAboEinrichten.setText("Einrichten");
        this.jMenuAboEinrichten.add(this.jMenuItemAboEinrichten);
        this.jMenu2.add(this.jMenuAboEinrichten);
        this.jMenu6.setText("Podcasts");
        this.jCheckBoxPodcastEinschalten.setSelected(true);
        this.jCheckBoxPodcastEinschalten.setText("Einschalten");
        this.jMenu6.add(this.jCheckBoxPodcastEinschalten);
        this.jMenuItemPodcastEinrichten.setText("Einrichten");
        this.jMenu6.add(this.jMenuItemPodcastEinrichten);
        this.jMenu2.add(this.jMenu6);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Infos");
        this.jMenuItemInfos.setText("Infos Anzeigen");
        this.jMenuItemInfos.setToolTipText("Programminfos, Speicherpfade");
        this.jMenu3.add(this.jMenuItemInfos);
        this.jMenuItemFehler.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.jMenuItemFehler.setText("Systemmeldungen anzeigen");
        this.jMenu3.add(this.jMenuItemFehler);
        this.jMenuItemAnleitung.setText("Anleitung im Web \u00f6ffnen");
        this.jMenu3.add(this.jMenuItemAnleitung);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitForMac", null));
            }
            catch (Exception e) {
                System.err.println("Error while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    public void quitForMac() {
        this.beenden();
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiMediathek.this.setProgressBar(ev);
        }
    }

    private class BeobPgruppen
    implements ActionListener {
        private BeobPgruppen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new DialogPgruppen(null, true, GuiMediathek.this.daten, true, GuiMediathek.this.guiFilme).setVisible(true);
            GuiMediathek.this.guiFilme.setExtraVisible(GuiMediathek.this.jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class BeobPlayer
    implements ActionListener {
        private BeobPlayer() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.guiFilme.setExtraVisible(GuiMediathek.this.jCheckBoxMenuItemPlayer.isSelected());
        }
    }

    private class AlleAbbrechenNachFilm
    implements ActionListener {
        private AlleAbbrechenNachFilm() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechenNachFilm();
        }
    }

    private class AlleAbbrechen
    implements ActionListener {
        private AlleAbbrechen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiMediathek.this.alleDownloadsAbbrechen();
        }
    }
}

