/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModelFilm;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.Datum;
import mediathek.daten.ListeAbo;
import mediathek.filme.BeobFilmeLaden;
import mediathek.filme.DatenFilm;
import mediathek.filme.TimerListener;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogDatenFilm;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.gui.menue.DialogImportFilme;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class GuiFilme
extends PanelVorlage {
    private TModelFilm tModel1;
    private JButton[] buttonArray;
    private DialogDatenFilm dialogDatenFilm;
    private JSpinner jSpinnerVerkuerzen = new JSpinner();
    private JSpinner jSpinnerTage = new JSpinner();
    private JCheckBox jCheckBoxVerkuerzen = new JCheckBox("Ansicht verk\u00fcrzen");
    private JCheckBox jCheckBoxNurAbo = new JCheckBox("Nur Abos anzeigen");
    private JCheckBox jCheckBoxKeineAbo = new JCheckBox("Keine Abos anzeigen");
    private JCheckBox jCheckBoxKeineGesehenen = new JCheckBox("Keine gesehenen Filme");
    private JCheckBox jCheckBox24Stunden = new JCheckBox("nur die letzten Tage");
    private JCheckBox jCheckBoxLive = new JCheckBox("nur Live-Streams anzeigen");
    private final String ABO_BUTTON_TEXT_NORMAL = "Abo";
    private final String ABO_BUTTON_TEXT_EINMAL = "Einmalabo";
    private JButton buttonProg;
    private JButton jButtonAboAnlegen;
    private JButton jButtonEinstellungen;
    private JButton jButtonFilterLoeschen;
    private JButton jButtonLaden;
    private JButton jButtonStop;
    private JComboBox jComboBoxFilterSender;
    private JComboBox jComboBoxFilterThema;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabelAlter;
    private JLabel jLabelGeladen;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuBar jMenuBar2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanelExtra;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldAlter;
    private JTextField jTextFieldFilterTitel;
    private JTextField jTextFieldGeladen;

    public GuiFilme(Daten d) {
        super(d);
        this.initComponents();
        this.dialogDatenFilm = new DialogDatenFilm(null, false, this.daten);
        this.init();
        this.extra();
        this.setInfo();
        this.filter();
        Funktionen.spaltenFilmSetzen(this.jTable1, this.daten, Boolean.parseBoolean(this.daten.system[7]), false, false);
    }

    @Override
    public void neuLaden() {
        this.jButtonAboAnlegen.setVisible(Boolean.parseBoolean(this.daten.system[7]));
        this.extra();
        this.filter();
    }

    public void bildProgs() {
        this.extra();
    }

    @Override
    public void neuLadenSofort() {
        this.setInfo();
    }

    public void setExtraVisible(boolean vis) {
        this.jPanelExtra.setVisible(vis);
        this.extra();
    }

    public void filmListeLaden() {
        this.jButtonLaden.setEnabled(false);
        this.jButtonEinstellungen.setEnabled(false);
        this.daten.filmeLaden.filmeImportServer();
    }

    private void init() {
        this.jProgressBar1.setVisible(false);
        this.jButtonStop.setVisible(false);
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        ActionMap am = this.jTable1.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = this.jTable1.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "film_starten");
        this.tModel1 = new TModelFilm(new Object[0][], Konstanten.FILME_COLUMN_NAMES);
        this.jTable1.setModel(this.tModel1);
        this.jTable1.addMouseListener(new BeobMausTabelle());
        this.jTable1.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setDefaultRenderer(Object.class, new DownloadCellRenderer(this.daten, true, true, 1, true));
        this.jTable1.setDefaultRenderer(Datum.class, new DownloadCellRenderer(this.daten, true, true, 1, true));
        this.jButtonFilterLoeschen.addActionListener(new BeobFilterLoeschen());
        this.jComboBoxFilterSender.addActionListener(new BeobFilterSender());
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(1, "", 0)));
        this.jComboBoxFilterThema.addActionListener(new BeobFilter());
        this.jComboBoxFilterThema.getEditor().getEditorComponent().addMouseListener(new BeobMausTextCombo());
        this.jComboBoxFilterThema.addMouseListener(new BeobMausTextCombo());
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(2, "", 0)));
        this.jTextFieldFilterTitel.addActionListener(new BeobFilter());
        this.jTextFieldFilterTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.jButtonLaden.addActionListener(new BeobachterNeuLaden());
        this.jButtonEinstellungen.addActionListener(new BeobImportDialog());
        this.jButtonStop.addActionListener(new BeobLoadStop());
        this.jButtonAboAnlegen.setVisible(Boolean.parseBoolean(this.daten.system[7]));
        this.jButtonAboAnlegen.addActionListener(new BeobAboAnlegen());
        this.jButtonAboAnlegen.addMouseListener(new BeobMausAboButton());
        this.jPanelExtra.addMouseListener(new BeobMausPgruppenDialog());
        this.jScrollPane1.addMouseListener(new BeobMausProgramme());
        this.daten.starterClass.addListener(new BeobachterStart());
        this.daten.filmeLaden.addAdListener(new BeobachterLaden());
        this.daten.timerLaden.addAdListener(new BeobTimerAlter());
        this.buttonProg = new JButton("Pfade");
        this.buttonProg.setToolTipText("Einstellungen der Buttons \u00e4ndern");
        this.buttonProg.addActionListener(new BeobPgruppen());
    }

    private void setInfo() {
        this.jTextFieldGeladen.setText(" " + this.daten.filmeLaden.filmlisteMetaDaten[0] + " ");
        this.jTextFieldAlter.setForeground(null);
        this.jTextFieldAlter.setFont(null);
        if (Funktionen.getUpdateFilme(this.daten) == 3) {
            this.jLabelAlter.setText("Neuladen in: ");
            String sek = String.valueOf(this.daten.neuLadenIn % 60);
            String min = String.valueOf(this.daten.neuLadenIn / 60);
            while (sek.length() < 2) {
                sek = "0" + sek;
            }
            while (min.length() < 2) {
                min = "0" + min;
            }
            this.jTextFieldAlter.setText(" " + min + ":" + sek + " ");
        } else {
            this.jLabelAlter.setText("Alter: ");
            this.jTextFieldAlter.setText(" ");
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
            date = this.daten.filmeLaden.filmlisteMetaDaten[0];
            Date jetzt = new Date(System.currentTimeMillis());
            Date filmDate = null;
            try {
                filmDate = sdf.parse(date);
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (jetzt != null && filmDate != null) {
                int sekunden = Math.round((jetzt.getTime() - filmDate.getTime()) / 1000L);
                boolean minus = sekunden < 0;
                sekunden = Math.abs(sekunden);
                int minuten = sekunden / 60;
                String sek = String.valueOf(sekunden % 60);
                String min = String.valueOf(minuten % 60);
                String stu = String.valueOf(minuten / 60);
                while (sek.length() < 2) {
                    sek = "0" + sek;
                }
                while (min.length() < 2) {
                    min = "0" + min;
                }
                while (stu.length() < 2) {
                    stu = "0" + stu;
                }
                this.jTextFieldAlter.setText(" " + (minus ? "-" : "") + stu + ":" + min + ":" + sek);
                if (sekunden >= 4500) {
                    this.jTextFieldAlter.setFont(new Font("Dialog", 1, 12));
                }
            }
        }
    }

    private void extra() {
        this.jPanelExtra.removeAll();
        this.jPanelExtra.updateUI();
        int maxSpalten = 4;
        int max = this.daten.listePgruppeButton.size();
        this.buttonArray = new JButton[max];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        this.jPanelExtra.setLayout(gridbag);
        int spalte = 0;
        int zeile = 0;
        for (int i = 0; i < max; ++i) {
            if (!this.daten.listePgruppeButton.freeLine(i)) {
                this.addExtraFeld(i, spalte, zeile, gridbag, c, this.jPanelExtra);
            }
            if (++spalte <= maxSpalten - 1) continue;
            spalte = 0;
            ++zeile;
        }
        c.weightx = 10.0;
        c.gridx = maxSpalten + 1;
        c.gridy = 0;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.jPanelExtra.add(label);
    }

    private Component addExtraFeld(int i, int spalte, int zeile, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        JComponent ret = null;
        c.gridx = spalte;
        c.gridy = zeile;
        if (((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getListeProg().isEmpty()) {
            JLabel label = new JLabel(((DatenPgruppe)this.daten.listePgruppeButton.get((int)i)).arr[0]);
            Color col = ((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getFarbe(this.daten);
            if (col != null) {
                label.setForeground(col);
            }
            gridbag.setConstraints(label, c);
            panel.add(label);
            ret = label;
        } else {
            JButton button = new JButton(((DatenPgruppe)this.daten.listePgruppeButton.get((int)i)).arr[0]);
            button.addActionListener(new BeobOpen(i));
            Color col = ((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getFarbe(this.daten);
            if (col != null) {
                button.setBackground(col);
            }
            this.buttonArray[i] = button;
            gridbag.setConstraints(button, c);
            panel.add(button);
            ret = button;
        }
        return ret;
    }

    private synchronized void filter() {
        try {
            boolean themaNichtDa = false;
            this.stopBeob = true;
            this.getSpalten(this.jTable1);
            if (this.daten.filmeLaden.listeFilme.isEmpty()) {
                this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(1, "", 0)));
                this.jComboBoxFilterSender.setSelectedIndex(0);
                this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(2, "", 0)));
                this.jComboBoxFilterThema.setSelectedIndex(0);
                this.tModel1.setRowCount(0);
            } else {
                this.setInfo();
                String thema = this.jComboBoxFilterThema.getSelectedItem().toString();
                String sender = this.jComboBoxFilterSender.getSelectedItem().toString();
                boolean themaOpen = this.jComboBoxFilterThema.isPopupVisible();
                boolean senderOpen = this.jComboBoxFilterSender.isPopupVisible();
                this.daten.filmeLaden.listeFilme.getModelTabFilme(this.tModel1, this.jComboBoxFilterSender.getSelectedItem().toString(), this.jComboBoxFilterThema.getSelectedItem().toString(), !this.jComboBoxFilterThema.isEditable(), this.jTextFieldFilterTitel.getText());
                Funktionen.spaltenFilmLoeschen(this.jTable1, this.daten, Boolean.parseBoolean(this.daten.system[7]), false, false, true, true);
                if (this.tModel1.getRowCount() > 0) {
                    if (this.jCheckBox24Stunden.isSelected() || this.jCheckBoxKeineGesehenen.isSelected() || this.jCheckBoxNurAbo.isSelected() || this.jCheckBoxKeineAbo.isSelected() || this.jCheckBoxLive.isSelected()) {
                        this.tModel1.filter(this.daten, this.jCheckBoxNurAbo.isSelected(), this.jCheckBoxKeineAbo.isSelected(), this.jCheckBoxKeineGesehenen.isSelected(), this.jCheckBox24Stunden.isSelected(), ((Number)this.jSpinnerTage.getModel().getValue()).intValue(), this.jCheckBoxLive.isSelected());
                    }
                    if (this.jCheckBoxVerkuerzen.isSelected() && !this.jCheckBoxLive.isSelected()) {
                        this.tModel1.verkuerzen(1, 2, ((Number)this.jSpinnerVerkuerzen.getModel().getValue()).intValue());
                    }
                }
                this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(1, "", 0)));
                this.jComboBoxFilterSender.setSelectedIndex(0);
                if (!sender.equals("")) {
                    this.jComboBoxFilterSender.setSelectedItem(sender);
                }
                if (sender.equals("")) {
                    this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(2, "", 0)));
                } else {
                    this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(2, sender, 1)));
                }
                for (ActionListener l : this.jComboBoxFilterThema.getActionListeners()) {
                    this.jComboBoxFilterThema.removeActionListener(l);
                }
                this.jComboBoxFilterThema.setSelectedItem(thema);
                if (!thema.equals("") && this.jComboBoxFilterThema.getSelectedIndex() == 0) {
                    themaNichtDa = true;
                }
                this.jComboBoxFilterThema.setPopupVisible(themaOpen);
                this.jComboBoxFilterThema.addActionListener(new BeobFilter());
                this.jComboBoxFilterSender.setPopupVisible(senderOpen);
            }
            this.zeilenZahl();
            this.setSpalten(this.jTable1);
            this.updateUI();
            this.stopBeob = false;
            if (themaNichtDa) {
                this.jComboBoxFilterThema.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "Filter");
        }
    }

    private void filterLoeschen() {
        this.stopBeob = true;
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(1, "", 0)));
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.filmeLaden.listeFilme.getModelOfField(2, "", 0)));
        this.jTextFieldFilterTitel.setText("");
        this.jCheckBoxVerkuerzen.setSelected(false);
        this.jCheckBoxNurAbo.setSelected(false);
        this.jCheckBoxKeineAbo.setSelected(false);
        this.jCheckBoxLive.setSelected(false);
        this.jCheckBoxKeineGesehenen.setSelected(false);
        this.jCheckBox24Stunden.setSelected(false);
        this.filter();
        this.stopBeob = false;
    }

    private void zeilenZahl() {
        String text = "";
        String leer = "   -   ";
        int runs = this.daten.starterClass.getStarts(1).size();
        text = this.tModel1 != null ? this.tModel1.getRowCount() + " Filme" : "0 Filme";
        if (runs == 1) {
            text = text + leer + runs + "    laufender Film";
        } else if (runs > 1) {
            text = text + leer + runs + "    laufende Filme";
        }
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, text, 0, 4));
    }

    private void table1Select() {
        DatenFilm aktFilm = new DatenFilm(this.daten);
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRow);
            for (int i = 0; i < 18; ++i) {
                aktFilm.arr[i] = this.tModel1.getValueAt(selectedModelRow, i).toString();
            }
            this.dialogDatenFilm.show(aktFilm);
        }
    }

    private void open(int open) {
        String url = "";
        DatenFilm ersterFilm = new DatenFilm(this.daten);
        int[] selectedTableRows = this.jTable1.getSelectedRows();
        for (int l = 0; l < selectedTableRows.length; ++l) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRows[l]);
            if (l == 0) {
                for (int i = 0; i < 18; ++i) {
                    ersterFilm.arr[i] = this.tModel1.getValueAt(selectedModelRow, i).toString();
                }
            }
            url = url.equals("") ? url + this.tModel1.getValueAt(selectedModelRow, 6).toString() : url + " " + this.tModel1.getValueAt(selectedModelRow, 6).toString();
        }
        this.daten.starterClass.urlStarten(url, open, ersterFilm);
        this.daten.history.add(url);
        this.daten.setGeaendertOhnePanel();
    }

    private void aboAnlegen() {
        if (this.jButtonAboAnlegen.getText().equals("Abo")) {
            boolean exakt;
            String sender = this.jComboBoxFilterSender.getSelectedItem().toString();
            String thema = this.jComboBoxFilterThema.getSelectedItem().toString();
            String titel = this.jTextFieldFilterTitel.getText();
            boolean bl = exakt = !this.jComboBoxFilterThema.isEditable();
            if (sender.equals("") && thema.equals("") & titel.equals("")) {
                JOptionPane.showMessageDialog(null, "der Filter darf nicht leer sein!", "Abo anlegen", 1);
            } else if (!this.daten.listeAbo.addAbo(sender, thema, exakt, titel)) {
                JOptionPane.showMessageDialog(null, "Abo existiert bereits!", "Abo anlegen", 1);
                this.daten.setGeaendertOhnePanel();
            }
        } else {
            int nr = this.jTable1.getSelectedRow();
            if (nr >= 0) {
                nr = this.jTable1.convertRowIndexToModel(nr);
                String thema = this.tModel1.getValueAt(nr, 2).toString();
                String sender = this.tModel1.getValueAt(nr, 1).toString();
                String titel = this.tModel1.getValueAt(nr, 3).toString();
                String url = this.tModel1.getValueAt(nr, 6).toString();
                this.daten.listeAbo.addEinmalAbo(sender, thema, titel, url);
                this.daten.setGeaendertOhnePanel();
                this.filter();
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private void loadStop() {
        this.daten.filmeLaden.setStop();
    }

    private void progressBar(int max, int progress, String text) {
        String was = "";
        was = "Filmen";
        if (max == 0) {
            this.jProgressBar1.setString(Funktionen.textLaenge(text));
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setVisible(false);
            this.jButtonStop.setVisible(false);
        } else if (max == 1) {
            this.jProgressBar1.setString(Funktionen.textLaenge(text));
            this.jProgressBar1.setIndeterminate(true);
            this.jProgressBar1.setMaximum(1);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setVisible(true);
            this.jButtonStop.setVisible(true);
        } else {
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setVisible(true);
            this.jButtonStop.setVisible(true);
            this.jProgressBar1.setMaximum(max);
            this.jProgressBar1.setMinimum(0);
            int proz = 0;
            if (progress != 0 && (proz = progress * 100 / max) >= 100) {
                proz = 99;
            }
            String seiten = "";
            if (this.daten.filmeLaden.getSeitenZaehlerLauf() != 0) {
                seiten = this.daten.filmeLaden.getSeitenZaehlerLauf() + " Seiten  /  ";
            }
            this.jProgressBar1.setString("( " + seiten + proz + "% von " + max + " " + was + " )  " + Funktionen.textLaenge(text));
            this.jProgressBar1.setStringPainted(true);
            this.jProgressBar1.setValue(progress);
        }
        this.jProgressBar1.setStringPainted(true);
    }

    private void senderLaden() {
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int sel = this.jTable1.convertRowIndexToModel(selectedTableRow);
            this.daten.filmeLaden.senderLaden(this.tModel1.getValueAt(sel, 1).toString());
        } else {
            JOptionPane.showMessageDialog(null, "Es ist keine Zeile (Thema) markiert!", "Fehler!", 0);
        }
    }

    private void importFilme() {
        new DialogImportFilme(null, true, this.daten).setVisible(true);
    }

    private void dialogPgruppen() {
        new DialogPgruppen(null, true, this.daten, true, this).setVisible(true);
        this.extra();
    }

    private void checkPattern(JTextField tf) {
        String text = tf.getText();
        if (ListeAbo.isPattern(text)) {
            if (ListeAbo.makePattern(text) == null) {
                tf.setBackground(Color.RED);
            } else {
                tf.setBackground(Color.PINK);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    private void setAboButton() {
        if (this.jButtonAboAnlegen.getText().equals("Abo")) {
            this.jButtonAboAnlegen.setText("Einmalabo");
            this.jButtonAboAnlegen.setToolTipText("Ausgew\u00e4hlten Film als Einmalabo anlegen");
        } else {
            this.jButtonAboAnlegen.setText("Abo");
            this.jButtonAboAnlegen.setToolTipText("Filter als Abo anlegen");
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenu4 = new JMenu();
        this.jPanelExtra = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jProgressBar1 = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxFilterSender = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxFilterThema = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldFilterTitel = new JTextField();
        this.jButtonFilterLoeschen = new JButton();
        this.jButtonAboAnlegen = new JButton();
        this.jButtonStop = new JButton();
        this.jPanel2 = new JPanel();
        this.jTextFieldGeladen = new JTextField();
        this.jLabelGeladen = new JLabel();
        this.jButtonLaden = new JButton();
        this.jButtonEinstellungen = new JButton();
        this.jLabelAlter = new JLabel();
        this.jTextFieldAlter = new JTextField();
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("File");
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu4.setText("Edit");
        this.jMenuBar2.add(this.jMenu4);
        this.jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 858, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, "0 Zeilen", 0, 4));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 834, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 267, Short.MAX_VALUE).addContainerGap()));
        this.jProgressBar1.setFont(new Font("Monospaced", 1, 12));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Filter"));
        this.jLabel2.setText("Sender:");
        this.jComboBoxFilterSender.setMaximumRowCount(25);
        this.jLabel3.setText("Thema:");
        this.jComboBoxFilterThema.setMaximumRowCount(25);
        this.jLabel5.setText("Titel:");
        this.jButtonFilterLoeschen.setText("x");
        this.jButtonFilterLoeschen.setToolTipText("Filter l\u00f6schen");
        this.jButtonAboAnlegen.setText("Abo");
        this.jButtonAboAnlegen.setToolTipText("Filter als Abo anlegen");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterSender, 0, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterThema, 0, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilterTitel, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAboAnlegen).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldFilterTitel, -2, -1, -2).addComponent(this.jComboBoxFilterThema, -2, -1, -2).addComponent(this.jComboBoxFilterSender, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jButtonFilterLoeschen, -2, 16, -2).addComponent(this.jButtonAboAnlegen)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButtonAboAnlegen, this.jButtonFilterLoeschen, this.jComboBoxFilterSender, this.jComboBoxFilterThema, this.jTextFieldFilterTitel);
        this.jButtonStop.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/process-stop.png")));
        this.jButtonStop.setText("Stop");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jTextFieldGeladen.setEditable(false);
        this.jLabelGeladen.setText("geladen am: ");
        this.jButtonLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh.png")));
        this.jButtonLaden.setText("alle Filme neu laden");
        this.jButtonLaden.setToolTipText("Neuladen aller Sender starten");
        this.jButtonEinstellungen.setText("::");
        this.jLabelAlter.setText("Alter: ");
        this.jTextFieldAlter.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEinstellungen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 486, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabelGeladen).addComponent(this.jTextFieldGeladen, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabelAlter).addComponent(this.jTextFieldAlter, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jTextFieldAlter, this.jTextFieldGeladen);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonLaden).addComponent(this.jButtonEinstellungen)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelGeladen).addComponent(this.jTextFieldGeladen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAlter).addComponent(this.jTextFieldAlter, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonEinstellungen, this.jButtonLaden);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelExtra, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jProgressBar1, -1, 763, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop)).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExtra, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jProgressBar1, -2, 14, -2).addComponent(this.jButtonStop)).addContainerGap()));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    private class BeobPgruppen
    implements ActionListener {
        private BeobPgruppen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.dialogPgruppen();
        }
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiFilme.this.zeilenZahl();
        }
    }

    private class BeobTimerAlter
    implements TimerListener {
        private BeobTimerAlter() {
        }

        @Override
        public void ping() {
            GuiFilme.this.setInfo();
        }

        @Override
        public void reset() {
        }
    }

    private class BeobFilterTitelDoc
    implements DocumentListener {
        private BeobFilterTitelDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int nr = GuiFilme.this.daten.listePgruppeButton.getDoppelklick();
            if (nr >= 0) {
                GuiFilme.this.open(nr);
            } else {
                JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
            }
        }
    }

    private class BeobMausPgruppenDialog
    extends MouseAdapter {
        private BeobMausPgruppenDialog() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                GuiFilme.this.dialogPgruppen();
            }
        }
    }

    private class BeobMausAboButton
    extends MouseAdapter {
        private BeobMausAboButton() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                GuiFilme.this.setAboButton();
            }
        }
    }

    private class BeobMausTextCombo
    extends MouseAdapter {
        private BeobMausTextCombo() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                boolean ed = GuiFilme.this.jComboBoxFilterThema.isEditable();
                GuiFilme.this.jComboBoxFilterThema.setEditable(!ed);
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobImportDialog
    implements ActionListener {
        private BeobImportDialog() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.importFilme();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private BeobUrl beobUrl = new BeobUrl();
        private BeobPrint beobPrint = new BeobPrint();
        private BeobInfo beobInfo = new BeobInfo();
        private BeobFilterLoeschen beobLoeschen = new BeobFilterLoeschen();
        private BeobAbo beobAbo = new BeobAbo(false);
        private BeobAbo beobAboMitTitel = new BeobAbo(true);
        private BeobAboEinmal beobAboEinmal = new BeobAboEinmal();
        private BeobFilterThema beobThema = new BeobFilterThema();
        private BeobFilterSender beobSender = new BeobFilterSender();
        private BeobFilterSenderThema beobSenderThema = new BeobFilterSenderThema();
        private BeobFilterSenderThemaTitel beobSenderThemaTitel = new BeobFilterSenderThemaTitel();
        private BeobSenderLaden beobSenderLaden = new BeobSenderLaden();
        private BeobBlacklist boeobBlacklistSender = new BeobBlacklist(true, false);
        private BeobBlacklist boeobBlacklistSenderThema = new BeobBlacklist(true, true);
        private Point p;
        JPanel panelVerkuerzen = new JPanel();
        JPanel panelNurAbo = new JPanel();
        JPanel panelKeineAbo = new JPanel();
        JPanel panelKeineGesehenen = new JPanel();
        JPanel panel24Stunden = new JPanel();
        JPanel panelLive = new JPanel();

        public BeobMausTabelle() {
            GuiFilme.this.jCheckBoxVerkuerzen.setSelected(false);
            GuiFilme.this.jSpinnerVerkuerzen.setModel(new SpinnerNumberModel(1, 1, 10, 1));
            GuiFilme.this.jSpinnerVerkuerzen.addChangeListener(new BeobSpinnerVerkuerzen());
            GuiFilme.this.jCheckBoxVerkuerzen.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBoxNurAbo.setSelected(false);
            GuiFilme.this.jCheckBoxNurAbo.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBoxKeineAbo.setSelected(false);
            GuiFilme.this.jCheckBoxKeineAbo.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBoxKeineGesehenen.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBoxKeineGesehenen.setSelected(false);
            GuiFilme.this.jCheckBoxLive.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBoxLive.setSelected(false);
            GuiFilme.this.jCheckBox24Stunden.addActionListener(new BeobVerkuerzen());
            GuiFilme.this.jCheckBox24Stunden.setSelected(false);
            GuiFilme.this.jSpinnerTage.setModel(new SpinnerNumberModel(1, 1, 10, 1));
            GuiFilme.this.jSpinnerTage.addChangeListener(new BeobSpinnerVerkuerzen());
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
            if (arg0.getButton() == 1 && arg0.getClickCount() > 1) {
                int nr = GuiFilme.this.daten.listePgruppeButton.getDoppelklick();
                if (nr >= 0) {
                    GuiFilme.this.open(nr);
                } else {
                    JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.jTable1.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.jTable1.setRowSelectionInterval(nr, nr);
            }
            String thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
            String sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
            String text = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3).toString();
            String url = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 6).toString();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Sender aktualisieren");
            item.addActionListener(this.beobSenderLaden);
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            item = new JMenuItem("URL kopieren");
            item.addActionListener(this.beobUrl);
            jPopupMenu.add(item);
            item = new JMenuItem("Tabelle Drucken");
            item.addActionListener(this.beobPrint);
            jPopupMenu.add(item);
            item = new JMenuItem("Infos anzeigen");
            item.addActionListener(this.beobInfo);
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            JMenu submenueFilter = new JMenu("Filter");
            jPopupMenu.add(submenueFilter);
            item = new JMenuItem("Filter l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender filtern");
            item.addActionListener(this.beobSender);
            submenueFilter.add(item);
            item = new JMenuItem("nach Thema filtern");
            item.addActionListener(this.beobThema);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender und Thema filtern");
            item.addActionListener(this.beobSenderThema);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender, Thema und Titel filtern");
            item.addActionListener(this.beobSenderThemaTitel);
            submenueFilter.add(item);
            submenueFilter.addSeparator();
            this.panelLive.setLayout(new BorderLayout());
            this.panelLive.add((Component)GuiFilme.this.jCheckBoxLive, "West");
            submenueFilter.add(this.panelLive);
            submenueFilter.addSeparator();
            this.panelNurAbo.setLayout(new BorderLayout());
            this.panelNurAbo.add((Component)GuiFilme.this.jCheckBoxNurAbo, "West");
            submenueFilter.add(this.panelNurAbo);
            this.panelKeineAbo.setLayout(new BorderLayout());
            this.panelKeineAbo.add((Component)GuiFilme.this.jCheckBoxKeineAbo, "West");
            submenueFilter.add(this.panelKeineAbo);
            this.panelKeineGesehenen.setLayout(new BorderLayout());
            this.panelKeineGesehenen.add((Component)GuiFilme.this.jCheckBoxKeineGesehenen, "West");
            submenueFilter.add(this.panelKeineGesehenen);
            this.panel24Stunden.setLayout(new BorderLayout());
            this.panel24Stunden.add((Component)GuiFilme.this.jCheckBox24Stunden, "Center");
            this.panel24Stunden.add((Component)GuiFilme.this.jSpinnerTage, "East");
            submenueFilter.add(this.panel24Stunden);
            this.panelVerkuerzen.setLayout(new BorderLayout());
            this.panelVerkuerzen.add((Component)GuiFilme.this.jCheckBoxVerkuerzen, "Center");
            this.panelVerkuerzen.add((Component)GuiFilme.this.jSpinnerVerkuerzen, "East");
            submenueFilter.add(this.panelVerkuerzen);
            if (Boolean.parseBoolean(GuiFilme.this.daten.system[7])) {
                JMenu submenueAbo = new JMenu("Abo");
                jPopupMenu.add(submenueAbo);
                JMenuItem itemAboLoeschen = new JMenuItem("Abo L\u00f6schen");
                JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
                JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
                JMenuItem itemAboEinmal = new JMenuItem("Film zum einmaligem Download eintragen");
                if (GuiFilme.this.daten.listeAbo.getAbo(sender, thema, text, url) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                    itemAboLoeschen.addActionListener(this.beobAbo);
                    itemAboEinmal.setEnabled(false);
                } else {
                    itemAboLoeschen.setEnabled(false);
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                    itemAboEinmal.addActionListener(this.beobAboEinmal);
                }
                submenueAbo.add(itemAboEinmal);
                submenueAbo.addSeparator();
                submenueAbo.add(itemAboLoeschen);
                submenueAbo.add(itemAbo);
                submenueAbo.add(itemAboMitTitel);
            }
            JMenu submenue = new JMenu("Film mit Programm starten:");
            jPopupMenu.add(submenue);
            for (int i = 0; i < GuiFilme.this.daten.listePgruppeButton.size(); ++i) {
                DatenPgruppe pgruppe = (DatenPgruppe)GuiFilme.this.daten.listePgruppeButton.get(i);
                Color col = pgruppe.getFarbe(GuiFilme.this.daten);
                item = new JMenuItem(pgruppe.arr[0]);
                if (pgruppe.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpen(i));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            submenueFilter.addSeparator();
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.boeobBlacklistSender);
            itemBlackSenderThema.addActionListener(this.boeobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackSenderThema);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobAboEinmal
        implements ActionListener {
            private BeobAboEinmal() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    String sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    String titel = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3).toString();
                    String url = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 6).toString();
                    GuiFilme.this.daten.listeAbo.addEinmalAbo(sender, thema, titel, url);
                }
                GuiFilme.this.daten.setGeaendertOhnePanel();
                GuiFilme.this.stopBeob = false;
                GuiFilme.this.filter();
            }
        }

        private class BeobBlacklist
        implements ActionListener {
            boolean sender;
            boolean thema;

            public BeobBlacklist(boolean ssender, boolean tthema) {
                this.sender = ssender;
                this.thema = tthema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    String th = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    String se = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    if (!this.sender) {
                        GuiFilme.this.daten.listeBlacklist.add(new DatenBlacklist("", th));
                    } else if (!this.thema) {
                        GuiFilme.this.daten.listeBlacklist.add(new DatenBlacklist(se, ""));
                    } else {
                        GuiFilme.this.daten.listeBlacklist.add(new DatenBlacklist(se, th));
                    }
                    GuiFilme.this.filter();
                    GuiFilme.this.daten.setGeaendertOhnePanel();
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            boolean mitTitel = false;

            public BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    String url;
                    String titel;
                    GuiFilme.this.stopBeob = true;
                    String thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    String sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    DatenAbo datenAbo = GuiFilme.this.daten.listeAbo.getAbo(sender, thema, titel = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3).toString(), url = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 6).toString());
                    if (datenAbo != null) {
                        GuiFilme.this.daten.listeAbo.aboLoeschen(datenAbo);
                    } else if (this.mitTitel) {
                        GuiFilme.this.daten.listeAbo.addAbo(sender, thema, true, titel);
                    } else {
                        GuiFilme.this.daten.listeAbo.addAbo(sender, thema, true, "");
                    }
                    GuiFilme.this.daten.setGeaendertOhnePanel();
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterLoeschen
        implements ActionListener {
            private BeobFilterLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.filterLoeschen();
            }
        }

        private class BeobFilterSenderThemaTitel
        implements ActionListener {
            private BeobFilterSenderThemaTitel() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    String titel = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3).toString();
                    GuiFilme.this.jTextFieldFilterTitel.setText(titel);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterSenderThema
        implements ActionListener {
            private BeobFilterSenderThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterSender
        implements ActionListener {
            private BeobFilterSender() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = "";
                    sender = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterThema
        implements ActionListener {
            private BeobFilterThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String thema = "";
                    thema = GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobVerkuerzen
        implements ActionListener {
            private BeobVerkuerzen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiFilme.this.stopBeob) {
                    GuiFilme.this.stopBeob = true;
                    if (e.getSource().equals(GuiFilme.this.jCheckBoxNurAbo) && GuiFilme.this.jCheckBoxNurAbo.isSelected()) {
                        GuiFilme.this.jCheckBoxKeineAbo.setSelected(false);
                    }
                    if (e.getSource().equals(GuiFilme.this.jCheckBoxKeineAbo) && GuiFilme.this.jCheckBoxKeineAbo.isSelected()) {
                        GuiFilme.this.jCheckBoxNurAbo.setSelected(false);
                    }
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobInfo
        implements ActionListener {
            private BeobInfo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.dialogDatenFilm.setVisible(true);
                GuiFilme.this.dialogDatenFilm.toFront();
            }
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.jTable1.print();
                }
                catch (PrinterException ex) {
                    GuiFilme.this.daten.fehler.fehlerMeldung(ex, "GuiFilme.BeobPrint - Fehler beim Drucken");
                }
            }
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(GuiFilme.this.jTable1.getModel().getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 6).toString());
                }
            }
        }

        private class BeobSenderLaden
        implements ActionListener {
            private BeobSenderLaden() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.senderLaden();
            }
        }
    }

    public class BeobMausProgramme
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            LinkedList<Starts> liste = GuiFilme.this.daten.starterClass.getStarts(1);
            if (liste.size() > 0) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (Starts s : liste) {
                    JMenuItem item = new JMenuItem("Beenden: [" + s.film.arr[1] + "]  " + s.film.arr[3]);
                    item.addActionListener(new BeobProgramm(s));
                    jPopupMenu.add(item);
                }
                jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        private class BeobProgramm
        implements ActionListener {
            Starts s;

            public BeobProgramm(Starts ss) {
                this.s = ss;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (this.s != null) {
                        this.s.stoppen = true;
                    }
                }
                catch (Exception ex) {
                    System.err.println("GuiFilme.BeobProgramm: " + ex.getMessage());
                }
            }
        }
    }

    private class BeobSpinnerVerkuerzen
    implements ChangeListener {
        private BeobSpinnerVerkuerzen() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            GuiFilme.this.filter();
        }
    }

    private class BeobLoadStop
    implements ActionListener {
        private BeobLoadStop() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFilme.this.loadStop();
        }
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                GuiFilme.this.table1Select();
            }
        }
    }

    private class BeobachterLaden
    extends BeobFilmeLaden {
        private BeobachterLaden() {
        }

        @Override
        public void starten() {
            GuiFilme.this.jButtonLaden.setEnabled(false);
            GuiFilme.this.jButtonEinstellungen.setEnabled(false);
        }

        @Override
        public void initProgressBar(String sender, int threads, int max, int progress, String text) {
            GuiFilme.this.progressBar(max, progress, text);
        }

        @Override
        public void beenden() {
            GuiFilme.this.filter();
            GuiFilme.this.jButtonLaden.setEnabled(true);
            GuiFilme.this.jButtonEinstellungen.setEnabled(true);
        }
    }

    private class BeobachterNeuLaden
    implements ActionListener {
        private BeobachterNeuLaden() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filmListeLaden();
        }
    }

    private class BeobFilterLoeschen
    implements ActionListener {
        private BeobFilterLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filterLoeschen();
        }
    }

    private class BeobFilter
    implements ActionListener {
        private BeobFilter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobFilterSender
    implements ActionListener {
        private BeobFilterSender() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobAboAnlegen
    implements ActionListener {
        private BeobAboAnlegen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.aboAnlegen();
        }
    }

    private class BeobOpen
    implements ActionListener {
        int open;

        public BeobOpen(int op) {
            this.open = op;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.open(this.open);
        }
    }
}

