/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import mediathek.daten.DatenFilmUpdate;

public class ListeFilmUpdate
extends LinkedList<DatenFilmUpdate> {
    public LinkedList<DatenFilmUpdate> alle = new LinkedList();
    private Random random = new Random();

    public void sort() {
        int nr = 0;
        Collections.sort(this);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            String str = String.valueOf(nr++);
            while (str.length() < 3) {
                str = "0" + str;
            }
            ((DatenFilmUpdate)it.next()).arr[0] = str;
        }
    }

    public boolean addAlle(DatenFilmUpdate film) {
        boolean ret = false;
        ListIterator it = this.alle.listIterator();
        while (it.hasNext()) {
            if (!((DatenFilmUpdate)it.next()).arr[1].equals(film.arr[1])) continue;
            return false;
        }
        return this.alle.add(film);
    }

    public void check20(boolean nur20) {
        this.clear();
        ListIterator it = this.alle.listIterator();
        while (it.hasNext()) {
            DatenFilmUpdate film = (DatenFilmUpdate)it.next();
            if (!this.check20_(nur20, film.arr[1])) continue;
            super.add(film);
        }
        this.sort();
    }

    private boolean check20_(boolean nur20, String url) {
        boolean ret = false;
        if (nur20) {
            String sub = url.substring(url.length() - 6);
            if (sub.compareTo("20.zip") >= 0 || sub.compareTo("04.zip") <= 0) {
                ret = true;
            }
            if (sub.compareTo("20.bz2") >= 0 || sub.compareTo("04.bz2") <= 0) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public String[][] getTableObjectData() {
        ListIterator iterator = this.listIterator();
        String[][] object = new String[this.size()][6];
        int i = 0;
        while (iterator.hasNext()) {
            DatenFilmUpdate filmUpdate = (DatenFilmUpdate)iterator.next();
            object[i] = filmUpdate.arr;
            ++i;
        }
        return object;
    }

    public int getNr(String url) {
        int nr = 0;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext() && !((DatenFilmUpdate)iterator.next()).arr[1].equals(url)) {
            ++nr;
        }
        if (nr >= this.size()) {
            nr = 0;
        }
        return nr;
    }

    public DatenFilmUpdate getNrUpdate(String url) {
        DatenFilmUpdate update = null;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            update = (DatenFilmUpdate)iterator.next();
            if (!update.arr[1].equals(url)) continue;
            return update;
        }
        return null;
    }

    public String getRand(int errcount) {
        int MAXMINUTEN = 50;
        int minCount = 2;
        if (errcount > 0) {
            minCount = 2 * errcount;
        }
        String ret = "";
        if (!this.isEmpty()) {
            DatenFilmUpdate filmUpdate2 = null;
            LinkedList<DatenFilmUpdate> listePrio = new LinkedList<DatenFilmUpdate>();
            LinkedList<DatenFilmUpdate> listeZeit = new LinkedList<DatenFilmUpdate>();
            Iterator it = this.iterator();
            Date today = new Date(System.currentTimeMillis());
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            int minuten = 200;
            int count = 0;
            while (it.hasNext()) {
                filmUpdate2 = (DatenFilmUpdate)it.next();
                date = filmUpdate2.arr[2] + " " + filmUpdate2.arr[3];
                try {
                    Date d = sdf.parse(date);
                    minuten = Math.round((today.getTime() - d.getTime()) / 60000L);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (minuten < 50) {
                    listeZeit.add(filmUpdate2);
                    ++count;
                    continue;
                }
                if (count >= minCount) continue;
                listeZeit.add(filmUpdate2);
                ++count;
            }
            for (DatenFilmUpdate filmUpdate2 : listeZeit) {
                if (filmUpdate2.arr[5].equals("1")) {
                    listePrio.add(filmUpdate2.getCopy());
                    continue;
                }
                listePrio.add(filmUpdate2.getCopy());
                listePrio.add(filmUpdate2.getCopy());
            }
            int nr = this.random.nextInt(listePrio.size());
            filmUpdate2 = (DatenFilmUpdate)listePrio.get(nr);
            ret = filmUpdate2.arr[1];
        }
        return ret;
    }

    public Date getAktuellster() {
        Date ret = null;
        if (!this.isEmpty()) {
            DatenFilmUpdate film = (DatenFilmUpdate)this.getFirst();
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            date = film.arr[2] + " " + film.arr[3];
            try {
                ret = sdf.parse(date);
            }
            catch (ParseException ex) {
                ret = null;
            }
        }
        return ret;
    }
}

