/*
 * Decompiled with CFR 0.152.
 */
package mediathek.beobachter;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.io.History;
import mediathek.io.starter.Starts;

public class DownloadCellRenderer
extends DefaultTableCellRenderer {
    private Daten daten;
    private boolean aboMalen;
    private boolean startMalen;
    private boolean gesehen = false;
    private int startQuelle = -1;
    private History history = null;

    public DownloadCellRenderer(Daten d, boolean sstartMalen, boolean aaboMalen, int sstartQuelle, boolean ggesehen) {
        this.daten = d;
        this.history = this.daten.history;
        this.startMalen = sstartMalen;
        this.aboMalen = aaboMalen;
        this.startQuelle = sstartQuelle;
        this.gesehen = ggesehen;
    }

    public DownloadCellRenderer(Daten d, boolean sstartMalen, boolean aaboMalen) {
        this.daten = d;
        this.history = this.daten.history;
        this.startMalen = sstartMalen;
        this.aboMalen = aaboMalen;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            String url;
            DatenAbo datenAbo;
            Starts s;
            this.setBackground(null);
            this.setForeground(null);
            this.setFont(null);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int r = table.convertRowIndexToModel(row);
            if (this.startMalen && (s = this.daten.starterClass.getStart(table.getModel().getValueAt(r, 6).toString())) != null && (this.startQuelle == -1 || this.startQuelle == s.quelle)) {
                switch (s.status) {
                    case 1: {
                        if (isSelected) {
                            this.setBackground(Konstanten.DOWNLOAD_FARBE_WAIT_SEL);
                            break;
                        }
                        this.setBackground(Konstanten.DOWNLOAD_FARBE_WAIT);
                        break;
                    }
                    case 2: {
                        if (isSelected) {
                            this.setBackground(Konstanten.DOWNLOAD_FARBE_RUN_SEL);
                            break;
                        }
                        this.setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
                        break;
                    }
                    case 3: {
                        if (isSelected) {
                            this.setBackground(Konstanten.DOWNLOAD_FARBE_FERTIG_SEL);
                            break;
                        }
                        this.setBackground(Konstanten.DOWNLOAD_FARBE_FERTIG);
                        break;
                    }
                    case 4: {
                        if (isSelected) {
                            this.setBackground(Konstanten.DOWNLOAD_FARBE_ERR_SEL);
                            break;
                        }
                        this.setBackground(Konstanten.DOWNLOAD_FARBE_ERR);
                    }
                }
            }
            if (this.aboMalen && (datenAbo = this.daten.listeAbo.getEinmalAbo(url = table.getModel().getValueAt(r, 6).toString())) != null) {
                this.setFont(new Font("Dialog", 3, 12));
                this.setForeground(Konstanten.DOWNLOAD_FARBE_ABO_EINMAL);
            }
            if (this.gesehen && this.history.contains(table.getModel().getValueAt(r, 6).toString())) {
                if (isSelected) {
                    this.setBackground(Konstanten.DOWNLOAD_FARBE_GESEHEN_SEL);
                } else {
                    this.setBackground(Konstanten.DOWNLOAD_FARBE_GESEHEN);
                }
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "DownloadCellRenderer.getTabeleCellRendererComponent");
        }
        return this;
    }
}

