/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.menue;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.daten.Daten;
import mediathek.filme.BeobFilmeLaden;
import mediathek.filme.sender.MediathekReader;
import mediathek.gui.PanelVorlage;

public class PanelSenderLaden
extends PanelVorlage {
    private BeobCheckboxSender[] beobCheck;
    private ButtonGroup buttonGroup1;
    private JButton jButtonStarten;
    private JCheckBox jCheckBoxNurAbos;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLayeredPane jLayeredPane1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JSpinner jSpinnerWarten;
    private JPanel panelSender;

    public PanelSenderLaden(Daten d) {
        super(d);
        this.initComponents();
        this.daten = d;
        this.beobCheck = new BeobCheckboxSender[this.daten.filmeLaden.mediathekListe.size()];
        for (int i = 0; i < this.daten.filmeLaden.mediathekListe.size(); ++i) {
            this.beobCheck[i] = new BeobCheckboxSender(i);
        }
        this.init();
        this.jSpinnerWarten.addChangeListener(new BeobSpinnerWarten());
        this.jCheckBoxNurAbos.addActionListener(new BeobCheckBox());
        this.jButtonStarten.addActionListener(new BeobStarten());
        this.daten.filmeLaden.addAdListener(new BeobachterLaden());
    }

    @Override
    public void neuLaden() {
        this.init();
    }

    private void init() {
        this.jCheckBoxNurAbos.setSelected(Boolean.parseBoolean(this.daten.system[8]));
        if (this.daten.system[42].equals("")) {
            this.jSpinnerWarten.setValue(1);
            this.daten.system[42] = "1";
        } else {
            this.jSpinnerWarten.setValue(Integer.parseInt(this.daten.system[42]));
        }
        this.addSender();
    }

    private void addSender() {
        this.panelSender.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        this.panelSender.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        int nr = 0;
        int y = 0;
        int halbe = this.daten.filmeLaden.mediathekListe.size() / 2;
        while (it.hasNext()) {
            c.gridy = y++;
            MediathekReader reader = (MediathekReader)it.next();
            this.addPanel(gridbag, c, reader, nr);
            ++nr;
            if (y <= halbe) continue;
            y = 0;
            c.gridx = 1;
        }
        JLabel label = new JLabel();
        c.gridx = 4;
        c.weightx = 2.0;
        gridbag.setConstraints(label, c);
        this.panelSender.add(label);
        this.panelSender.updateUI();
    }

    private void addPanel(GridBagLayout gridbag, GridBagConstraints c, MediathekReader reader, int nr) {
        JCheckBox box = new JCheckBox(reader.text);
        box.setSelected(reader.istSenderAn());
        box.addActionListener(this.beobCheck[nr]);
        c.insets = new Insets(2, 10, 2, 2);
        gridbag.setConstraints(box, c);
        this.panelSender.add(box);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLayeredPane1 = new JLayeredPane();
        this.panelSender = new JPanel();
        this.jPanel4 = new JPanel();
        this.jCheckBoxNurAbos = new JCheckBox();
        this.jSpinnerWarten = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButtonStarten = new JButton();
        this.panelSender.setBorder(BorderFactory.createTitledBorder("Sender"));
        GroupLayout panelSenderLayout = new GroupLayout(this.panelSender);
        this.panelSender.setLayout(panelSenderLayout);
        panelSenderLayout.setHorizontalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 652, Short.MAX_VALUE));
        panelSenderLayout.setVerticalGroup(panelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 28, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Beim direkten Laden vom Sender"));
        this.jCheckBoxNurAbos.setText("nur Abos laden");
        this.jSpinnerWarten.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jLabel7.setText("Laden um den Faktor bremsen");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxNurAbos).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jSpinnerWarten, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7))).addContainerGap(380, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxNurAbos).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jSpinnerWarten, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(new SoftBevelBorder(0));
        this.jLabel1.setText("Filme von den Websiten der Sender laden, kann etwas dauern!");
        this.jButtonStarten.setText("jetzt Laden");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 69, Short.MAX_VALUE).addComponent(this.jButtonStarten).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButtonStarten)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panelSender, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panelSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobachterLaden
    extends BeobFilmeLaden {
        private BeobachterLaden() {
        }

        @Override
        public void starten() {
            PanelSenderLaden.this.jButtonStarten.setEnabled(false);
        }

        @Override
        public void beenden() {
            PanelSenderLaden.this.jButtonStarten.setEnabled(true);
        }
    }

    private class BeobSpinnerWarten
    implements ChangeListener {
        private BeobSpinnerWarten() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            PanelSenderLaden.this.daten.system[42] = String.valueOf(((Number)PanelSenderLaden.this.jSpinnerWarten.getModel().getValue()).intValue());
            PanelSenderLaden.this.daten.setGeaendertOhnePanel();
        }
    }

    private class BeobStarten
    implements ActionListener {
        private BeobStarten() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelSenderLaden.this.daten.filmeLaden.filmeBeimSenderLaden();
            PanelSenderLaden.this.daten.setGeaendert();
        }
    }

    private class BeobCheckBox
    implements ActionListener {
        private BeobCheckBox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PanelSenderLaden.this.stopBeob) {
                PanelSenderLaden.this.daten.system[8] = Boolean.toString(PanelSenderLaden.this.jCheckBoxNurAbos.isSelected());
                PanelSenderLaden.this.daten.setGeaendert();
            }
        }
    }

    private class BeobCheckboxSender
    implements ActionListener {
        private int nr;

        public BeobCheckboxSender(int nnr) {
            this.nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PanelSenderLaden.this.daten.filmeLaden.mediathekListe.get(this.nr).setSenderAn(((JCheckBox)e.getSource()).isSelected());
            PanelSenderLaden.this.daten.setGeaendert();
        }
    }
}

