/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.beobachter.BeobachterTableSelect;
import mediathek.beobachter.DownloadCellRenderer;
import mediathek.beobachter.DownloadCellRendererAbo;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.filme.DatenFilm;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogEditAbo;
import mediathek.gui.dialoge.DialogExportAbos;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class GuiAbo
extends PanelVorlage {
    public TModel tModel1;
    public TModel tModel2;
    private BeobachterTableSelect beobachterTableSelect;
    private JButton jButtonAufraeumen;
    private JButton jButtonDauerhaft;
    private JButton jButtonDownloadLoeschen;
    private JButton jButtonDownloadStarten;
    private JButton jButtonDownloadsNeuLaden;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane2;
    private JTable jTable1;
    private JTable jTable2;

    public GuiAbo(Daten d) {
        super(d);
        this.initComponents();
        this.initBeobachter();
        this.tabelle2Laden();
        this.tabelle1Laden();
    }

    @Override
    public void neuLaden() {
    }

    public void einstellungen() {
        new DialogPgruppen(null, true, this.daten, false).setVisible(true);
        this.load();
    }

    private void initBeobachter() {
        this.jButtonDownloadStarten.addActionListener(new BeobachterDownloadAbos());
        this.jButtonDownloadLoeschen.addActionListener(new BeobDownloadLoeschen(false));
        this.jButtonDownloadsNeuLaden.addActionListener(new BeobachterNeuLaden());
        this.jButtonDauerhaft.addActionListener(new BeobDownloadLoeschen(true));
        this.jButtonAufraeumen.addActionListener(new BeobachterAufraeumen());
        this.beobachterTableSelect = new BeobachterTableSelect(this.daten, this.jTable1);
        this.jTable1.addMouseListener(new BeobMausTabelle1(this.jTable1));
        this.jTable1.getSelectionModel().addListSelectionListener(this.beobachterTableSelect);
        this.jTable2.addMouseListener(new BeobMausTabelle2(this.jTable2));
        ActionMap am = this.jTable2.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = this.jTable2.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "film_starten");
        this.daten.starterClass.addListener(new BeobachterStart());
    }

    private synchronized void tabelle1Laden() {
        this.jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.tModel1 = new TModel(this.daten.listeAbo.getObjectData(), Konstanten.ABO_COLUMN_NAMES);
        this.jTable1.setModel(this.tModel1);
        this.jTable1.setDefaultRenderer(Object.class, new DownloadCellRendererAbo(this.daten));
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(1000);
    }

    private synchronized void tabelle2Laden() {
        this.jTable2.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tModel2 = this.daten.filmeLaden.listeFilme.getAboModel();
        this.jTable2.setModel(this.tModel2);
        this.jTable2.setDefaultRenderer(Object.class, new DownloadCellRenderer(this.daten, true, true));
        Funktionen.spaltenFilmSetzen(this.jTable2, this.daten, false, true, true);
    }

    private void load() {
        super.getSpalten(this.jTable2);
        this.tabelle2Laden();
        super.setSpalten(this.jTable2);
        super.getSpalten(this.jTable1);
        this.tabelle1Laden();
        super.setSpalten(this.jTable1);
    }

    private void aboAendern() {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0) {
            int delRow = this.jTable1.convertRowIndexToModel(row);
            DatenAbo akt = this.daten.listeAbo.getAboNr(delRow);
            DatenAbo ret = akt.getCopy();
            DialogEditAbo dialog = new DialogEditAbo(null, true, this.daten, ret);
            dialog.setVisible(true);
            if (dialog.ok) {
                akt.aufMichKopieren(ret);
                this.load();
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aboLoeschen() {
        int[] rows = this.jTable1.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable1.convertRowIndexToModel(rows[i]);
                this.daten.listeAbo.remove(delRow);
            }
            this.daten.setGeaendert();
            this.load();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void downloadLoeschen(boolean dauerhaft) {
        int[] rows = this.jTable2.getSelectedRows();
        if (rows.length > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                int delRow = this.jTable2.convertRowIndexToModel(rows[i]);
                if (dauerhaft) {
                    DatenAbo abo = this.daten.listeAbo.getEinmalAbo(this.tModel2.getValueAt(delRow, 6).toString());
                    if (abo != null) {
                        abo.arr[10] = Boolean.toString(true);
                        this.daten.fehler.systemMeldung("StarterClass.einmalErledigen Abo: " + abo.arr[1]);
                    } else {
                        this.daten.log.zeileSchreiben(this.tModel2.getValueAt(delRow, 3).toString(), this.tModel2.getValueAt(delRow, 6).toString(), ".mediathek_zdf_log");
                    }
                }
                this.daten.starterClass.filmLoeschen(this.tModel2.getValueAt(delRow, 6).toString());
                this.tModel2.removeRow(delRow);
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void filmStartenWiederholen() {
        int row = this.jTable2.getSelectedRow();
        if (row >= 0) {
            int delRow = this.jTable2.convertRowIndexToModel(row);
            Starts s = this.daten.starterClass.getStart(this.tModel2.getValueAt(delRow, 6).toString());
            if (s != null && s.status > 2) {
                this.daten.starterClass.delStart(this.tModel2.getValueAt(delRow, 6).toString());
            }
            GuiAbo.downloadAll(this.daten, this.tModel2, this.tModel2.getValueAt(delRow, 6).toString());
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void aufraeumen() {
        for (int i = 0; i < this.tModel2.getRowCount(); ++i) {
            int s = this.daten.starterClass.getState(this.tModel2.getValueAt(i, 6).toString());
            if (s < 3) continue;
            this.tModel2.removeRow(i);
            --i;
        }
        this.daten.starterClass.aufraeumen(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        File f;
        OutputStreamWriter writer = null;
        DialogExportAbos dialog = new DialogExportAbos(null, true, this.daten, this.daten.system[33]);
        dialog.setVisible(true);
        if (dialog.ok && (!(f = new File(dialog.ziel)).exists() || JOptionPane.showConfirmDialog(null, "Trotzdem anlegen und \u00fcberschreiben?", "Datei existiert bereits!", 0) == 0)) {
            try {
                this.daten.system[33] = dialog.ziel;
                writer = new OutputStreamWriter(new FileOutputStream(f));
                for (int i = 0; i < this.tModel2.getRowCount(); ++i) {
                    writer.write(this.tModel2.getValueAt(i, 6).toString() + "\n");
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    this.daten.fehler.fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
                }
            }
        }
    }

    private void downloadAbos() {
        GuiAbo.downloadAll(this.daten, this.tModel2, "");
    }

    public static boolean downloadAll(Daten daten, TModel tMod, String uurl) {
        boolean ret = false;
        String befehlsString = "";
        String url = "";
        String zielPfad = "";
        String zielDateiname = "";
        int art = -1;
        if (daten.listePgruppeAbo.size() == 0) {
            JOptionPane.showMessageDialog(null, "Bitte ein Programm zum Downloaden einrichten.", "Kein Programm eingerichtet!", 1);
        } else if (tMod != null) {
            LinkedList<Starts> startsListe = new LinkedList<Starts>();
            for (int i = 0; i < tMod.getRowCount(); ++i) {
                url = tMod.getValueAt(i, 6).toString();
                if (!uurl.equals("") && !uurl.equals(url)) continue;
                zielPfad = tMod.getValueAt(i, 13).toString();
                DatenAbo abo = daten.listeAbo.getAbo(tMod.getValueAt(i, 1).toString(), tMod.getValueAt(i, 2).toString(), tMod.getValueAt(i, 3).toString(), tMod.getValueAt(i, 6).toString());
                DatenPgruppe gruppe = daten.listePgruppeAbo.getName(abo.arr[8]);
                DatenProg prog = gruppe.getProgUrl(url);
                befehlsString = prog.getBegehl();
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
                zielPfad = abo.aboPfadAnhaengen(daten, zielPfad);
                art = gruppe.checkDownloadDirekt(daten, url);
                if (prog.arr[2].contains("**")) {
                    DatenFilm datenFilm = daten.filmeLaden.listeFilme.getFilmByUrl(url);
                    zielDateiname = datenFilm.dateiNamenBauen(zielPfad, zielDateiname);
                    befehlsString = Funktionen.getBefhelsString(befehlsString, zielDateiname, url, datenFilm);
                    startsListe.add(new Starts(2, datenFilm, art, befehlsString, Boolean.parseBoolean(prog.arr[5])));
                    ret = true;
                    continue;
                }
                daten.fehler.fehlerMeldung("Fehler", new String[]{"Die Einstellungen zum Download der Abos sind Fehlerhaft", "es fehlen die Angaben zum Dateinamen in zB.: *%n*"});
            }
            daten.starterClass.addListe(startsListe);
        }
        return ret;
    }

    private void panelUpdate() {
        this.jTable2.repaint();
        this.validate();
    }

    private void open(int open) {
        DatenFilm ersterFilm = new DatenFilm(this.daten);
        int select = this.jTable2.convertRowIndexToModel(this.jTable2.getSelectedRow());
        for (int i = 0; i < 18; ++i) {
            ersterFilm.arr[i] = this.tModel2.getValueAt(select, i).toString();
        }
        this.daten.starterClass.urlStarten(ersterFilm.arr[6], open, ersterFilm);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jButtonDownloadsNeuLaden = new JButton();
        this.jButtonDownloadStarten = new JButton();
        this.jPanel3 = new JPanel();
        this.jSplitPane2 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jTable2 = new JTable();
        this.jButtonDownloadLoeschen = new JButton();
        this.jButtonDauerhaft = new JButton();
        this.jButtonAufraeumen = new JButton();
        this.jLabel1.setText("jLabel1");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonDownloadsNeuLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/view-refresh.png")));
        this.jButtonDownloadsNeuLaden.setText("Downloads aktualisieren");
        this.jButtonDownloadsNeuLaden.setToolTipText("Liste der anstehenden Downloads neu aufbauen");
        this.jButtonDownloadStarten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/go-next.png")));
        this.jButtonDownloadStarten.setText("alle Downloads starten");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonDownloadsNeuLaden).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonDownloadStarten).addContainerGap(347, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDownloadsNeuLaden).addComponent(this.jButtonDownloadStarten)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonDownloadStarten, this.jButtonDownloadsNeuLaden);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.jSplitPane2.setDividerLocation(150);
        this.jSplitPane2.setOrientation(0);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane2.setTopComponent(this.jScrollPane1);
        this.jTable2.setAutoCreateRowSorter(true);
        this.jTable2.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable2.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.jTable2);
        this.jSplitPane2.setRightComponent(this.jScrollPane2);
        this.jButtonDownloadLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-cut.png")));
        this.jButtonDownloadLoeschen.setText("Download l\u00f6schen");
        this.jButtonDownloadLoeschen.setToolTipText("markierten Download aus der Liste entfernen (beim n\u00e4chsten Laden wieder anzeigen)");
        this.jButtonDauerhaft.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/user-trash.png")));
        this.jButtonDauerhaft.setText("Download dauerhaft l\u00f6schen");
        this.jButtonDauerhaft.setToolTipText("markierten Download endg\u00fcltig aus der Liste l\u00f6schen");
        this.jButtonAufraeumen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/edit-clear.png")));
        this.jButtonAufraeumen.setText("Tabelle aufr\u00e4umen");
        this.jButtonAufraeumen.setToolTipText("abgeschlossene Downloads entfernen");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 810, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jButtonDownloadLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDauerhaft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAufraeumen))).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane2, -1, 328, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonDownloadLoeschen).addComponent(this.jButtonDauerhaft).addComponent(this.jButtonAufraeumen)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int nr = GuiAbo.this.daten.listePgruppeButton.getDoppelklick();
            if (nr >= 0) {
                GuiAbo.this.open(nr);
            } else {
                JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
            }
        }
    }

    public class BeobMausTabelle2
    extends MouseAdapter {
        private BeobUrl beobUrl = new BeobUrl();
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle2(JTable ttabelle) {
            this.tabelle = ttabelle;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    int nr = GuiAbo.this.daten.listePgruppeButton.getDoppelklick();
                    if (nr >= 0) {
                        GuiAbo.this.open(nr);
                    } else {
                        JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
                    }
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            int delRow;
            Starts s;
            this.p = evt.getPoint();
            int nr = this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            int row = GuiAbo.this.jTable2.getSelectedRow();
            boolean anzeigen = true;
            if (row >= 0 && (s = GuiAbo.this.daten.starterClass.getStart(GuiAbo.this.tModel2.getValueAt(delRow = GuiAbo.this.jTable2.convertRowIndexToModel(row), 6).toString())) != null && s.status <= 2) {
                anzeigen = false;
            }
            JMenuItem itemVorziehen = new JMenuItem("Film starten");
            menu.add(itemVorziehen);
            if (anzeigen) {
                itemVorziehen.addActionListener(new BeobFilmStartenWiederholen());
            } else {
                itemVorziehen.setEnabled(false);
            }
            JMenuItem itemVor = new JMenuItem("URL kopieren");
            itemVor.addActionListener(this.beobUrl);
            menu.add(itemVor);
            menu.addSeparator();
            JMenuItem itemLoeschen = new JMenuItem("Download l\u00f6schen");
            itemLoeschen.addActionListener(new BeobDownloadLoeschen(false));
            menu.add(itemLoeschen);
            JMenuItem itemDauerhaftLoeschen = new JMenuItem("Download dauerhaft l\u00f6schen");
            itemDauerhaftLoeschen.addActionListener(new BeobDownloadLoeschen(true));
            menu.add(itemDauerhaftLoeschen);
            menu.addSeparator();
            JMenuItem itemExport = new JMenuItem("Links in Datei exportieren");
            itemExport.addActionListener(new BeobachterExport());
            menu.add(itemExport);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = BeobMausTabelle2.this.tabelle.rowAtPoint(BeobMausTabelle2.this.p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard(BeobMausTabelle2.this.tabelle.getModel().getValueAt(BeobMausTabelle2.this.tabelle.convertRowIndexToModel(nr), 6).toString());
                }
            }
        }
    }

    public class BeobMausTabelle1
    extends MouseAdapter {
        private Point p;
        private JTable tabelle;

        public BeobMausTabelle1(JTable ttabelle) {
            this.tabelle = ttabelle;
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    GuiAbo.this.aboAendern();
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem itemLoeschen = new JMenuItem("Abo l\u00f6schen");
            itemLoeschen.addActionListener(new BeobachterAboLoeschen());
            menu.add(itemLoeschen);
            JMenuItem itemAendern = new JMenuItem("Abo \u00e4ndern");
            itemAendern.addActionListener(new BeobachterAboAendern());
            menu.add(itemAendern);
            menu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobachterStart
    implements StartListener {
        private BeobachterStart() {
        }

        @Override
        public void starter(StartEvent ev) {
            GuiAbo.this.panelUpdate();
            if (ev.allesStop()) {
                // empty if block
            }
        }
    }

    private class BeobachterAufraeumen
    implements ActionListener {
        private BeobachterAufraeumen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.aufraeumen();
        }
    }

    private class BeobachterExport
    implements ActionListener {
        private BeobachterExport() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.export();
        }
    }

    private class BeobachterNeuLaden
    implements ActionListener {
        private BeobachterNeuLaden() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.daten.log.clearLogList(".mediathek_zdf_log");
            GuiAbo.this.daten.listeAbo.erledigteEinmalAboLoeschen();
            GuiAbo.this.aufraeumen();
            GuiAbo.this.load();
        }
    }

    private class BeobachterDownloadAbos
    implements ActionListener {
        private BeobachterDownloadAbos() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.downloadAbos();
        }
    }

    private class BeobFilmStartenWiederholen
    implements ActionListener {
        private BeobFilmStartenWiederholen() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.filmStartenWiederholen();
        }
    }

    private class BeobDownloadLoeschen
    implements ActionListener {
        boolean dauerhaft = false;

        public BeobDownloadLoeschen(boolean d) {
            this.dauerhaft = d;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiAbo.this.downloadLoeschen(this.dauerhaft);
        }
    }

    private class BeobachterAboAendern
    implements ActionListener {
        private BeobachterAboAendern() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiAbo.this.aboAendern();
        }
    }

    private class BeobachterAboLoeschen
    implements ActionListener {
        private BeobachterAboLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiAbo.this.aboLoeschen();
        }
    }
}

