/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme.sender;

import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.Semaphore;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.filme.FilmListener;
import mediathek.io.GetUrl;

public class MediathekReader
implements Runnable {
    private int seitenSender = 0;
    private Date startZeit = null;
    private Date endZeit = null;
    public String text = "";
    public String sender = "";
    boolean senderOn = true;
    public boolean updateOn = false;
    public JDialog panelEinstellungen = null;
    int threads = 0;
    boolean stop = false;
    Daten daten;
    EventListenerList listeners = new EventListenerList();
    LinkedList<String[]> listeThemen = new LinkedList();
    GetUrl getUrlIo;
    Semaphore sem = new Semaphore(1);

    public MediathekReader(Daten ddaten) {
        this.daten = ddaten;
        this.getUrlIo = new GetUrl(this.daten);
    }

    public boolean istSenderAn() {
        return this.senderOn;
    }

    public void setSenderAn(boolean an) {
        this.senderOn = an;
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void stoppen() {
        this.stop = true;
    }

    @Override
    public void run() {
        this.startZeit = null;
        this.endZeit = null;
        try {
            if (this.daten.noGui || this.senderOn || this.updateOn) {
                this.updateOn = false;
                this.startZeit = new Date();
                this.stop = false;
                this.threads = 0;
                this.addToList();
            }
        }
        catch (Exception e) {
            this.daten.fehler.fehlerMeldung(e, "Exception im Thread Sender: " + this.sender);
        }
    }

    void getSem() {
        try {
            this.sem.acquire();
        }
        catch (InterruptedException e) {
            this.daten.fehler.fehlerMeldung(e, this.sender + " sem.acquire()");
        }
    }

    void relSem() {
        this.sem.release();
    }

    synchronized void addThread() {
        ++this.threads;
        this.notifyThread();
    }

    synchronized void threadUndFertig() {
        --this.threads;
        this.notifyThread();
        this.notifyFertig();
    }

    void addToList() {
    }

    void notifyMax(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.addMax(this.sender, max);
        }
    }

    void notifyStart(int max) {
        this.daten.fehler.systemMeldung("Starten " + this.sender + ": " + Funktionen.getJetzt_HH_MM_SS());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(this.sender, max);
        }
    }

    void notifyThread() {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.threads(this.sender, this.threads);
        }
    }

    void notifyFertig() {
        if (this.threads <= 0) {
            this.endZeit = new Date();
            this.daten.fehler.systemMeldung("Fertig " + this.sender + ": " + Funktionen.getJetzt_HH_MM_SS());
            this.seitenSenderSchreiben();
            for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
                l.fertig(this.sender, this.stop);
            }
        }
    }

    void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(this.sender, text);
        }
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String[])it.next())[nr].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    synchronized String[] getListeThemen() {
        return this.listeThemen.pollFirst();
    }

    private void seitenSenderSchreiben() {
        System.out.println("Sender " + this.sender + ": " + this.seitenSender + " Seiten");
    }

    public void incSeitenZaehler() {
        ++this.seitenSender;
    }

    public void seitenZaehlerLoeschen() {
        this.seitenSender = 0;
    }

    public int getSeitenZaehler() {
        return this.seitenSender;
    }

    public String getLaufzeitMinuten() {
        String ret = "";
        int sekunden = 0;
        try {
            if (this.startZeit != null && this.endZeit != null) {
                sekunden = Math.round((this.endZeit.getTime() - this.startZeit.getTime()) / 1000L);
                String min = String.valueOf(sekunden / 60);
                String sek = String.valueOf(sekunden % 60);
                if (sek.length() == 1) {
                    sek = "0" + sek;
                }
                ret = min + ":" + sek;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean nurAboLaden() {
        boolean ret = false;
        if (!this.daten.noGui && Boolean.parseBoolean(this.daten.system[7]) && Boolean.parseBoolean(this.daten.system[8])) {
            ret = true;
        }
        return ret;
    }
}

