/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filme;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.filme.FilmListener;
import mediathek.filme.ListeFilme;
import mediathek.filme.ListeFilmeSchattenliste;
import mediathek.filme.sender.Mediathek3Sat;
import mediathek.filme.sender.MediathekArd;
import mediathek.filme.sender.MediathekArdPodcast;
import mediathek.filme.sender.MediathekArte7;
import mediathek.filme.sender.MediathekMdr;
import mediathek.filme.sender.MediathekNdr;
import mediathek.filme.sender.MediathekOrf;
import mediathek.filme.sender.MediathekReader;
import mediathek.filme.sender.MediathekSf;
import mediathek.filme.sender.MediathekSfPod;
import mediathek.filme.sender.MediathekSwr;
import mediathek.filme.sender.MediathekWdr;
import mediathek.filme.sender.MediathekZdf;
import mediathek.io.GetUrl;
import mediathek.update.UpdateSuchen;

public class FilmeLaden {
    private int seitenZaehlerGesamt = 0;
    private int seitenZaehler = 0;
    public LinkedList<MediathekReader> mediathekListe = new LinkedList();
    private Daten daten;
    public ListeFilme listeFilme;
    public ListeFilmeSchattenliste listeFilmeOld;
    public ListeFilmeSchattenliste listeFilmeSchattenliste;
    public String[] filmlisteMetaDaten;
    public Date aktuellsterServer = null;
    EventListenerList listeners = new EventListenerList();
    private boolean ioxml = false;

    public FilmeLaden(Daten ddaten) {
        this.daten = ddaten;
        this.listeFilme = new ListeFilme(this.daten);
        this.listeFilmeSchattenliste = new ListeFilmeSchattenliste(this.daten);
        this.filmlisteMetaDaten = new String[4];
        for (int i = 0; i < this.filmlisteMetaDaten.length; ++i) {
            this.filmlisteMetaDaten[i] = "";
        }
        this.init();
    }

    public synchronized void checkBlacklist() {
        Iterator it = this.listeFilmeSchattenliste.iterator();
        this.listeFilme.clear();
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!this.daten.listeBlacklist.checkBlackOk(film)) continue;
            this.listeFilme.add(film);
        }
    }

    public synchronized void filmeImportServer() {
        new Thread(new filmeImportServerThread()).start();
    }

    private void filmeImportServer_() {
        new UpdateSuchen(this.daten).suchen(false);
        if (Funktionen.getUpdateFilme(this.daten) == 0) {
            this.urlLaden(this.daten.system[36]);
        } else {
            for (int i = 0; i < 10 && !this.urlLaden(this.daten.system[36]); ++i) {
                this.daten.system[36] = this.daten.listeFilmUpdate.getRand(i);
                this.daten.setGeaendertSofort();
            }
        }
        if (this.listeFilme.isEmpty()) {
            this.daten.fehler.fehlerMeldung("Filme laden", "Es konnten keine Filme geladen werden!");
        }
    }

    private boolean urlLaden(String pfad) {
        this.daten.timerLaden.reset();
        boolean ret = false;
        try {
            if (!this.ioxml) {
                this.ioxml = true;
                this.daten.ioXml.addAdListener(new BeobLaden(true));
            }
            if (pfad.equals("")) {
                JOptionPane.showMessageDialog(null, "Keine Datei/Url angegeben", "Pfad", 1);
            } else {
                this.alleFilmeLoeschen();
                ret = this.daten.ioXml.importDatenFilme(pfad, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void filmeImportDatei(String pfad, boolean istDatei) {
        new Thread(new filmeImportDateiThread(pfad, istDatei)).start();
    }

    private void filmeImportDatei_(String pfad, boolean istDatei) {
        try {
            if (pfad.equals("")) {
                JOptionPane.showMessageDialog(null, "Keine Datei/Url angegeben", "Pfad", 1);
            } else {
                if (!this.ioxml) {
                    this.ioxml = true;
                    this.daten.ioXml.addAdListener(new BeobLaden(true));
                }
                this.alleFilmeLoeschen();
                this.daten.ioXml.importDatenFilme(pfad, istDatei);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void filmeBeimSenderLaden() {
        new Thread(new filmebeimSenderLadenThread()).start();
    }

    private void filmeBeimSenderLaden_() {
        if (this.daten.noGui || this.wenigstensEinSenderAn()) {
            this.daten.setGeaendert();
            this.listeFilme.clear();
            if (this.daten.allesLaden) {
                this.listeFilmeSchattenliste.delOhneSender("SWR");
            } else {
                this.listeFilmeOld = this.listeFilmeSchattenliste;
                this.listeFilmeSchattenliste = new ListeFilmeSchattenliste(this.daten);
            }
            GetUrl.stop = false;
            this.seitenZaehlerLoeschen();
            Iterator it = this.mediathekListe.iterator();
            while (it.hasNext()) {
                new Thread((Runnable)it.next()).start();
            }
        } else if (!this.daten.noGui) {
            JOptionPane.showMessageDialog(null, "Kein Sender zum Laden ausgew\u00e4hlt!");
        }
    }

    public void senderLaden(String sender) {
        MediathekReader reader = this.getMediathekReader(sender);
        if (reader != null) {
            this.daten.setGeaendert();
            this.listeFilme.clear();
            if (this.daten.allesLaden && !sender.equalsIgnoreCase("SWR")) {
                this.listeFilmeSchattenliste.delSender(sender);
            }
            GetUrl.stop = false;
            this.seitenZaehlerLoeschen(sender);
            reader.updateOn = true;
            new Thread(reader).start();
        }
    }

    private void datumSchreiben(boolean loeschen) {
        if (!loeschen) {
            this.filmlisteMetaDaten[0] = Funktionen.getJetzt_ddMMyyyy_HHmm();
            this.filmlisteMetaDaten[1] = Funktionen.getJetzt_HH_MM_SS();
            this.filmlisteMetaDaten[2] = Funktionen.getHeute_dd_MM_yyyy();
        } else {
            this.filmlisteMetaDaten[0] = "";
            this.filmlisteMetaDaten[1] = "";
            this.filmlisteMetaDaten[2] = "";
        }
        this.filmlisteMetaDaten[3] = String.valueOf(this.listeFilmeSchattenliste.size());
    }

    public void alleFilmeLoeschen() {
        this.listeFilme.clear();
        this.listeFilmeSchattenliste.clear();
    }

    public int getSeitenZaehler(String sender) {
        int ret = 0;
        MediathekReader r = this.getMediathekReader(sender);
        if (r != null && r.sender.equalsIgnoreCase(sender)) {
            ret = r.getSeitenZaehler();
        }
        return ret;
    }

    public int getSeitenZaehlerGesamt() {
        return this.seitenZaehlerGesamt;
    }

    public int getSeitenZaehlerLauf() {
        return this.seitenZaehler;
    }

    public synchronized void incSeitenZaehler(String sender) {
        ++this.seitenZaehler;
        ++this.seitenZaehlerGesamt;
        MediathekReader r = this.getMediathekReader(sender);
        if (r != null) {
            r.incSeitenZaehler();
        }
    }

    public void seitenZaehlerLoeschen() {
        this.seitenZaehler = 0;
        Iterator it = this.mediathekListe.iterator();
        while (it.hasNext()) {
            ((MediathekReader)it.next()).seitenZaehlerLoeschen();
        }
    }

    public void seitenZaehlerLoeschen(String sender) {
        this.seitenZaehler = 0;
        MediathekReader r = this.getMediathekReader(sender);
        if (r != null) {
            r.seitenZaehlerLoeschen();
        }
    }

    public void laufzeitenSchreiben() {
        Iterator it = this.mediathekListe.iterator();
        int m = 0;
        String l = "";
        while (it.hasNext()) {
            MediathekReader r = (MediathekReader)it.next();
            if (!this.daten.noGui && !r.istSenderAn()) continue;
            this.daten.fehler.systemMeldung("##################################");
            this.daten.fehler.systemMeldung(r.sender);
            l = r.getLaufzeitMinuten();
            if (!l.equals("")) {
                this.daten.fehler.systemMeldung("    Laufzeit: " + l + " Minuten");
            }
            if ((m = r.getSeitenZaehler()) != 0) {
                this.daten.fehler.systemMeldung("    Seiten:   " + m);
            }
            this.daten.fehler.systemMeldung("    Filme:    " + this.listeFilmeSchattenliste.countSender(r.sender));
        }
    }

    public boolean wenigstensEinSenderAn() {
        boolean ret = false;
        Iterator it = this.mediathekListe.iterator();
        while (it.hasNext()) {
            if (!((MediathekReader)it.next()).istSenderAn()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public String[] getSenderNamen() {
        String[] ret = new String[this.daten.filmeLaden.mediathekListe.size()];
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = ((MediathekReader)it.next()).sender;
            ++i;
        }
        return ret;
    }

    public String[] getListeSender() {
        String[] ret = new String[this.daten.filmeLaden.mediathekListe.size()];
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = "xml" + ((MediathekReader)it.next()).sender;
            ++i;
        }
        return ret;
    }

    public String[] getSenderOn() {
        String[] ret = new String[this.daten.filmeLaden.mediathekListe.size()];
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = Boolean.toString(((MediathekReader)it.next()).istSenderAn());
            ++i;
        }
        return ret;
    }

    public void setSenderOn(String[] str) {
        String[] sender = this.getListeSender();
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        while (it.hasNext()) {
            for (int i = 0; i < str.length; ++i) {
                MediathekReader reader = (MediathekReader)it.next();
                if (!("xml" + reader.sender).equalsIgnoreCase(sender[i])) continue;
                if (str[i].equals("")) {
                    reader.setSenderAn(true);
                    continue;
                }
                reader.setSenderAn(Boolean.parseBoolean(str[i]));
            }
        }
    }

    public boolean senderAn(String sender) {
        MediathekReader r = this.getMediathekReader(sender);
        return r != null && r.istSenderAn();
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void setStop() {
        Iterator it = this.daten.filmeLaden.mediathekListe.iterator();
        while (it.hasNext()) {
            ((MediathekReader)it.next()).stoppen();
        }
        GetUrl.stop = true;
        this.daten.ioXml.stop = true;
    }

    private void init() {
        this.mediathekListe.add(new MediathekArd(this.daten));
        this.mediathekListe.add(new MediathekArdPodcast(this.daten));
        this.mediathekListe.add(new MediathekZdf(this.daten));
        this.mediathekListe.add(new MediathekArte7(this.daten, true));
        this.mediathekListe.add(new MediathekArte7(this.daten, false));
        this.mediathekListe.add(new Mediathek3Sat(this.daten));
        this.mediathekListe.add(new MediathekSwr(this.daten));
        this.mediathekListe.add(new MediathekNdr(this.daten));
        this.mediathekListe.add(new MediathekMdr(this.daten));
        this.mediathekListe.add(new MediathekWdr(this.daten));
        this.mediathekListe.add(new MediathekSf(this.daten));
        this.mediathekListe.add(new MediathekSfPod(this.daten));
        this.mediathekListe.add(new MediathekOrf(this.daten));
        BeobLaden beobLaden = new BeobLaden();
        for (MediathekReader r : this.mediathekListe) {
            r.addAdListener(beobLaden);
        }
    }

    private void notifyStart(String sender, int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(sender, max);
        }
    }

    private void notifyProgress(String sender, String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(sender, text);
        }
    }

    private void notifyFertig(String sender, boolean stop) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(sender, stop);
        }
    }

    private void notifyAddMax(String sender, int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.addMax(sender, max);
        }
    }

    private void notifyThreads(String sender, int threads) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.threads(sender, threads);
        }
    }

    private MediathekReader getMediathekReader(String sender) {
        MediathekReader ret2 = null;
        if (!sender.equals("")) {
            for (MediathekReader ret2 : this.mediathekListe) {
                if (!ret2.sender.equalsIgnoreCase(sender)) continue;
                break;
            }
        }
        return ret2;
    }

    private void addOld() {
        if (this.listeFilmeOld != null) {
            int nr = this.listeFilmeSchattenliste.size();
            Iterator it = this.listeFilmeOld.iterator();
            while (it.hasNext()) {
                this.listeFilmeSchattenliste.addOld((DatenFilm)it.next(), nr);
            }
            this.listeFilmeOld.clear();
        }
    }

    private class BeobLaden
    implements FilmListener {
        boolean listeImporieren = false;
        int count = 0;

        public BeobLaden() {
        }

        public BeobLaden(boolean iimporiteren) {
            this.listeImporieren = iimporiteren;
        }

        @Override
        public synchronized void start(String sender, int max) {
            ++this.count;
            if (this.count <= 1) {
                FilmeLaden.this.notifyStart(sender, max);
            } else {
                FilmeLaden.this.notifyAddMax(sender, max);
            }
        }

        @Override
        public synchronized void progress(String sender, String text) {
            FilmeLaden.this.notifyProgress(sender, text);
        }

        @Override
        public synchronized void fertig(String sender, boolean stop) {
            --this.count;
            if (this.count == 0) {
                FilmeLaden.this.addOld();
                FilmeLaden.this.listeFilmeSchattenliste.sort();
                if (!this.listeImporieren) {
                    FilmeLaden.this.checkBlacklist();
                    FilmeLaden.this.datumSchreiben(stop);
                }
                FilmeLaden.this.listeFilme.sort();
                if (!FilmeLaden.this.listeFilme.isEmpty()) {
                    FilmeLaden.this.laufzeitenSchreiben();
                    ((FilmeLaden)FilmeLaden.this).daten.ioXml.filmeSchreiben();
                }
                FilmeLaden.this.notifyFertig(sender, stop);
            } else {
                FilmeLaden.this.notifyProgress(sender, "fertig");
            }
        }

        @Override
        public synchronized void addMax(String sender, int max) {
            FilmeLaden.this.notifyAddMax(sender, max);
        }

        @Override
        public synchronized void threads(String sender, int threads) {
            FilmeLaden.this.notifyThreads(sender, threads);
        }
    }

    private class filmebeimSenderLadenThread
    implements Runnable {
        private filmebeimSenderLadenThread() {
        }

        @Override
        public synchronized void run() {
            FilmeLaden.this.filmeBeimSenderLaden_();
        }
    }

    private class filmeImportDateiThread
    implements Runnable {
        String pfad;
        boolean istDatei;

        public filmeImportDateiThread(String ppfad, boolean iistDatei) {
            this.pfad = ppfad;
            this.istDatei = iistDatei;
        }

        @Override
        public synchronized void run() {
            FilmeLaden.this.filmeImportDatei_(this.pfad, this.istDatei);
        }
    }

    private class filmeImportServerThread
    implements Runnable {
        private filmeImportServerThread() {
        }

        @Override
        public synchronized void run() {
            FilmeLaden.this.filmeImportServer_();
        }
    }
}

