/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.ListeFilmUpdate;
import mediathek.gui.dialoge.DialogHinweis;

public class UpdateSuchen {
    private ListeFilmUpdate listeFilme;
    private Daten daten;

    public UpdateSuchen(Daten ddaten) {
        this.daten = ddaten;
        this.listeFilme = new ListeFilmUpdate(this.daten);
    }

    public void suchen(boolean progUpdate, boolean filmUpdate) {
        String version = "";
        String release = "";
        String updateUrl = "";
        String parsername = "";
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader inReader = null;
            String user_agent = this.daten.system[3];
            int timeout = 10000;
            URLConnection conn = null;
            conn = new URL("http://zdfmediathk.sourceforge.net/update.xml").openConnection();
            conn.setRequestProperty("User-Agent", user_agent);
            conn.setReadTimeout(timeout);
            conn.setConnectTimeout(timeout);
            inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                parsername = parser.getLocalName();
                if (parser.getLocalName().equals("Program_Version")) {
                    version = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Program_Release_Info")) {
                    release = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Download_Programm")) {
                    updateUrl = parser.getElementText();
                    continue;
                }
                if (!parser.getLocalName().equals("Server")) continue;
                this.getServer(parser);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "UpdateSuchen.suchen:");
        }
        if (filmUpdate) {
            if (this.listeFilme.isEmpty()) {
                new DialogHinweis(null, true, this.daten, "Es ist ein Fehler aufgetreten!\n\nEs konnten keine Updateserver zum aktualisieren der Filme\ngefunden werden.\n\n", "http://zdfmediathk.sourceforge.net/update.html", "Online nach neuen Programmversionen suchen?", 45, "Update suchen").setVisible(true);
            } else {
                this.daten.listeFilmUpdate = this.listeFilme;
                this.daten.system[35] = this.daten.listeFilmUpdate.getRand(0);
                this.daten.setGeaendertSofort();
            }
        }
        if (progUpdate) {
            if (!version.equals("")) {
                this.daten.system[47] = Funktionen.getHeute_yyyyMMdd();
                if (!version.equals("2.3.0")) {
                    new DialogHinweis(null, false, this.daten, "   ==================================================\n   Neue Version:\n   " + version + "\n\n" + "   ==================================================\n" + "   \u00c4nderungen:\n" + "   " + release + "\n\n" + "   ==================================================\n" + "   URL:\n" + "   " + updateUrl + "\n\n", updateUrl, "Online nach neuen Programmversionen suchen?", 45, "Eine neue Version liegt vor").setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Alles aktuell!", "Update suchen", 1);
                }
            } else {
                new DialogHinweis(null, true, this.daten, "Es ist ein Fehler aufgetreten!\n\n", "http://sourceforge.net/projects/zdfmediathk/", "Online nach neuen Programmversionen suchen?", 45, "Update suchen").setVisible(true);
            }
        }
    }

    private void getServer(XMLStreamReader parser) {
        String anzahl = "";
        String zeit = "";
        String datum = "";
        String filmUrl = "";
        String parsername = "";
        String prio = "";
        try {
            while (parser.hasNext()) {
                prio = "1";
                int event = parser.next();
                if (event == 2) {
                    parsername = parser.getLocalName();
                    if (parser.getLocalName().equals("Server")) {
                        if (!filmUrl.equals("")) {
                            this.listeFilme.addAlle(new DatenFilmUpdate(filmUrl, prio, zeit, datum, anzahl));
                        }
                        break;
                    }
                }
                if (event != 1) continue;
                parsername = parser.getLocalName();
                if (parser.getLocalName().equals("Download_Filme_1")) {
                    filmUrl = parser.getElementText();
                    prio = "1";
                    continue;
                }
                if (parser.getLocalName().equals("Download_Filme_2")) {
                    filmUrl = parser.getElementText();
                    prio = "2";
                    continue;
                }
                if (parser.getLocalName().equals("Datum")) {
                    datum = parser.getElementText();
                    continue;
                }
                if (parser.getLocalName().equals("Zeit")) {
                    zeit = parser.getElementText();
                    continue;
                }
                if (!parser.getLocalName().equals("Anzahl")) continue;
                anzahl = parser.getElementText();
            }
        }
        catch (XMLStreamException ex) {
            // empty catch block
        }
    }
}

