/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.beobachter.BeobachterTableSelect;
import mediathek.daten.Daten;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;
import mediathek.gui.dialoge.DialogPod;

public class DialogPodster
extends JDialog {
    private Daten daten;
    private TModel tModel;
    private BeobachterTableSelect beobachterTableSelect;
    private boolean stopBeob = false;
    public boolean podGeaendert = false;
    private JButton jButtonBeenden;
    private JButton jButtonFilterLoeschen;
    private JButton jButtonHinzufuegen;
    private JButton jButtonLaden;
    private JComboBox jComboBoxFilterThema;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldFilter;

    public DialogPodster(Frame parent, boolean modal, Daten d) {
        super(parent, modal);
        this.initComponents();
        this.daten = d;
        this.init();
        this.setTitle("Podcast von Podster suchen");
        this.beobachterTableSelect = new BeobachterTableSelect(this.daten, this.jTable1){

            @Override
            public void fill() {
            }
        };
        this.jTable1.getSelectionModel().addListSelectionListener(this.beobachterTableSelect);
        this.jButtonHinzufuegen.addActionListener(new BeobHinzufuegen());
        this.jButtonLaden.addActionListener(new BeobListeLaden());
        this.jButtonBeenden.addActionListener(new BeobBeenden());
        this.jButtonFilterLoeschen.addActionListener(new BeobachterFilterLoeschen());
        this.jTextFieldFilter.getDocument().addDocumentListener(new BeobachterFilter());
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listePodster.getModelOfField(1)));
        this.jComboBoxFilterThema.addActionListener(new BeobFilterThema());
    }

    void init() {
        this.fillTable();
    }

    private void fillTable() {
        this.tModel = new TModel(this.daten.listePodster.getObjectData(), Konstanten.PODSTER_COLUMN_NAMES);
        this.jTable1.setModel(this.tModel);
        this.spaltenbreiteSetzen();
        this.zeilenZahl();
    }

    private void zeilenZahl() {
        String text = "";
        text = this.tModel != null ? this.tModel.getRowCount() + " Podcasts" : "0 Podcasts";
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, text, 0, 4));
    }

    private void spaltenbreiteSetzen() {
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            if (i == 0) {
                this.jTable1.getColumnModel().getColumn(i).setMinWidth(50);
                this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(50);
                this.jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
                continue;
            }
            if (i != 1) continue;
            this.jTable1.getColumnModel().getColumn(i).setMinWidth(150);
            this.jTable1.getColumnModel().getColumn(i).setPreferredWidth(150);
            this.jTable1.getColumnModel().getColumn(i).setMaxWidth(3000);
        }
    }

    private void listeLaden() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.daten.feedReaderPodster.starten();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.fillTable();
        this.stopBeob = true;
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listePodster.getModelOfField(1)));
        this.stopBeob = false;
    }

    private void podHinzuguegen() {
        String exist = null;
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRow);
            DatenPodster podster = this.daten.listePodster.getPodNr(Integer.parseInt((String)this.tModel.getValueAt(selectedModelRow, 0)));
            DatenPod datenPod = new DatenPod(podster.arr[2], podster.arr[3], podster.arr[2]);
            exist = this.daten.listePod.urlExists(podster.arr[3]);
            if (exist != null) {
                JOptionPane.showMessageDialog(null, "Podcast existiert bereits!\nName: " + exist, "Podcast anlegen", 1);
            } else {
                DialogPod dialogPod = new DialogPod(null, true, this.daten, datenPod);
                dialogPod.setVisible(true);
                this.daten.listePod.addPod(datenPod);
                this.podGeaendert = true;
            }
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void filterLoeschen() {
        this.stopBeob = true;
        this.jTextFieldFilter.setText("");
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listePodster.getModelOfField(1)));
        this.stopBeob = false;
        this.filter();
    }

    private void filter() {
        this.stopBeob = true;
        this.fillTable();
        if (this.tModel != null && this.tModel.getRowCount() > 0) {
            this.tModel.filterModel(this.jTextFieldFilter.getText(), 2, false);
            this.tModel.filterModel((String)this.jComboBoxFilterThema.getSelectedItem(), 1, true);
        }
        this.zeilenZahl();
        this.stopBeob = false;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldFilter = new JTextField();
        this.jButtonFilterLoeschen = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxFilterThema = new JComboBox();
        this.jButtonBeenden = new JButton();
        this.jButtonLaden = new JButton();
        this.jButtonHinzufuegen = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Titel:");
        this.jButtonFilterLoeschen.setText("X");
        this.jLabel2.setText("Thema:");
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterThema, -2, 138, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilter, -1, 290, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFilterLoeschen).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFilter, -2, -1, -2).addComponent(this.jButtonFilterLoeschen).addComponent(this.jComboBoxFilterThema, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel1)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonFilterLoeschen, this.jTextFieldFilter);
        this.jButtonBeenden.setText("Ok");
        this.jButtonBeenden.setToolTipText("diesen Dialog schlie\u00dfen");
        this.jButtonLaden.setText("Liste neu laden");
        this.jButtonHinzufuegen.setText("Podcast hinzuf\u00fcgen");
        this.jButtonHinzufuegen.setToolTipText("eine Auswahl an Programmen hinzuf\u00fcgen");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 628, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonHinzufuegen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBeenden))).addContainerGap()));
        layout.linkSize(0, this.jButtonBeenden, this.jButtonHinzufuegen, this.jButtonLaden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonLaden).addComponent(this.jButtonHinzufuegen)).addComponent(this.jButtonBeenden)).addContainerGap()));
        this.pack();
    }

    private class BeobFilterThema
    implements ActionListener {
        private BeobFilterThema() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DialogPodster.this.stopBeob) {
                DialogPodster.this.filter();
            }
        }
    }

    private class BeobachterFilter
    implements DocumentListener {
        private BeobachterFilter() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.filtern();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.filtern();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.filtern();
        }

        private void filtern() {
            if (!DialogPodster.this.stopBeob) {
                DialogPodster.this.filter();
            }
        }
    }

    private class BeobachterFilterLoeschen
    implements ActionListener {
        private BeobachterFilterLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPodster.this.filterLoeschen();
        }
    }

    private class BeobBeenden
    implements ActionListener {
        private BeobBeenden() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPodster.this.beenden();
        }
    }

    private class BeobListeLaden
    implements ActionListener {
        private BeobListeLaden() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPodster.this.listeLaden();
        }
    }

    private class BeobHinzufuegen
    implements ActionListener {
        private BeobHinzufuegen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPodster.this.podHinzuguegen();
        }
    }
}

