/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Fehler;
import mediathek.daten.Daten;

public class DialogExportFilme
extends JDialog {
    Daten daten;
    public boolean ok = false;
    public String ziel;
    private JButton jButtonBeenden;
    private JButton jButtonExportPfad;
    private JButton jButtonExportieren;
    private JCheckBox jCheckBoxExportZip;
    private JLabel jLabel2;
    private JPanel jPanel4;
    private JTextField jTextFieldPfadExportDatei;

    public DialogExportFilme(Frame parent, boolean modal, Daten d) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Filmliste in Datei exportieren");
        this.daten = d;
        this.init();
        this.jButtonExportieren.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExportFilme.this.filmeExportieren();
            }
        });
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogExportFilme.this.beenden();
            }
        });
        this.jTextFieldPfadExportDatei.getDocument().addDocumentListener(new BeobTextFeld(this.jTextFieldPfadExportDatei, 39));
        this.jCheckBoxExportZip.addActionListener(new BeobAction());
        this.jButtonExportPfad.addActionListener(new BeobPfad(this.jTextFieldPfadExportDatei));
    }

    private void init() {
        this.jCheckBoxExportZip.setSelected(Boolean.parseBoolean(this.daten.system[40]));
        this.jTextFieldPfadExportDatei.setText(this.daten.system[39]);
    }

    private void filmeExportieren() {
        int ret = -1;
        String datei = this.jTextFieldPfadExportDatei.getText();
        if (datei.equals("")) {
            JOptionPane.showMessageDialog(null, "Keine Datei angegeben", "Pfad", 1);
        } else {
            try {
                if (!(!this.jCheckBoxExportZip.isSelected() || datei.endsWith(".zip") && datei.endsWith(".Zip"))) {
                    datei = datei + ".zip";
                }
                if ((ret = new File(datei).exists() ? JOptionPane.showConfirmDialog(null, "Datei:  \"" + datei + "\"" + "  existiert bereits", "\u00dcberschreiben?", 0) : 0) == 0) {
                    this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                    this.daten.ioXml.exportFilme(datei, this.jCheckBoxExportZip.isSelected());
                }
            }
            catch (Exception ex) {
                this.daten.fehler.fehlerMeldung(ex, "DialogExportFilme.filmeExportieren: Filme wurden nicht exportiert!");
            }
        }
        this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jButtonBeenden = new JButton();
        this.jPanel4 = new JPanel();
        this.jTextFieldPfadExportDatei = new JTextField();
        this.jCheckBoxExportZip = new JCheckBox();
        this.jButtonExportPfad = new JButton();
        this.jButtonExportieren = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Beenden");
        this.jPanel4.setBorder(new SoftBevelBorder(0));
        this.jCheckBoxExportZip.setText("Datei mit Zip komprimieren");
        this.jButtonExportPfad.setText(":::");
        this.jButtonExportieren.setText("Exportieren");
        this.jLabel2.setText("Datei:");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxExportZip).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addComponent(this.jTextFieldPfadExportDatei, -1, 503, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExportPfad).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonExportieren))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldPfadExportDatei, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jButtonExportieren).addComponent(this.jButtonExportPfad)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxExportZip).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(1, this.jButtonExportPfad, this.jTextFieldPfadExportDatei);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonBeenden).addComponent(this.jPanel4, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBeenden).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class BeobPfad
    implements ActionListener {
        JTextField textFeld;

        public BeobPfad(JTextField ttextFeld) {
            this.textFeld = ttextFeld;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!this.textFeld.getText().equals("")) {
                chooser.setCurrentDirectory(new File(this.textFeld.getText()));
            }
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    this.textFeld.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    new Fehler(DialogExportFilme.this.daten).fehlerMeldung(ex, "DialogImportFilme.BeobImport");
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        JTextField textFeld;
        int nr;

        public BeobTextFeld(JTextField tFeld, int n) {
            this.textFeld = tFeld;
            this.nr = n;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            DialogExportFilme.this.daten.system[this.nr] = this.textFeld.getText();
            DialogExportFilme.this.daten.setGeaendert();
        }
    }

    private class BeobAction
    implements ActionListener {
        private BeobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogExportFilme.this.daten.system[40] = Boolean.toString(DialogExportFilme.this.jCheckBoxExportZip.isSelected());
        }
    }
}

