/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.io.File;
import java.util.Iterator;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.io.FilmListener;
import mediathek.io.MediathekReader;

public class MediathekNoGui {
    private Daten daten;
    private String startZeit = Funktionen.getJetzt_ddMMyyyy_HHmm();
    private String stopZeit = "";

    public MediathekNoGui(String[] ar) {
        boolean debug = false;
        String pfad = "";
        if (ar != null) {
            if (ar.length > 0 && !ar[0].startsWith("-")) {
                if (!ar[0].endsWith(File.separator)) {
                    ar[0] = ar[0] + File.separator;
                }
                pfad = ar[0];
            }
            for (int i = 0; i < ar.length; ++i) {
                if (!ar[i].equals("-D")) continue;
                debug = true;
            }
        }
        this.daten = new Daten(pfad, debug, null, true);
        this.daten.keinFehlerFenster = true;
        System.out.println("");
        System.out.println("========================================");
        System.out.println("Mediathek 2.3.0");
        System.out.println("========================================");
        System.out.println("");
        this.initListener();
        this.daten.listeFilme.filmeBeimSenderLaden();
    }

    private void initListener() {
        BeobachterLadenFilme beobachterLadenFilme = new BeobachterLadenFilme();
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            ((MediathekReader)it.next()).addAdListener(beobachterLadenFilme);
        }
    }

    private void undTschuess() {
        this.daten.speichern();
        this.stopZeit = Funktionen.getJetzt_ddMMyyyy_HHmm();
        System.out.println("");
        System.out.println("========================================");
        System.out.println("  " + this.daten.seitenZaehler + " Seiten geladen");
        System.out.println("  " + this.daten.listeFilme.size() + " Filme gefunden");
        System.out.println("  --> Beginn: " + this.startZeit);
        System.out.println("  --> Fertig: " + this.stopZeit);
        System.out.println("========================================");
        if (this.daten.listeFilme.isEmpty()) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    private synchronized void initProgressBar(int max, int progress, String text) {
        int proz = 0;
        if (max != 0) {
            int i;
            if (progress != 0) {
                proz = progress * 100 / max;
            }
            if (progress < max && proz == 100) {
                proz = 99;
            }
            System.out.print("  [ ");
            int a = proz / 10;
            for (i = 0; i < a; ++i) {
                System.out.print("#");
            }
            for (i = 0; i < 10 - a; ++i) {
                System.out.print("-");
            }
            System.out.print(" ] ");
            System.out.print("  " + this.daten.seitenZaehler + " Seiten  /  " + proz + "% von " + max + " Themen");
            System.out.print("\r");
        }
    }

    private class BeobachterLadenFilme
    implements FilmListener {
        int max = 0;
        int count = 0;
        int progress = 0;

        @Override
        public void start(String sender, int m) {
            ++this.count;
            this.max += m;
            if (this.max == 0) {
                MediathekNoGui.this.initProgressBar(1, 0, "");
            } else {
                MediathekNoGui.this.initProgressBar(this.max, 0, "");
            }
        }

        @Override
        public void progress(String text) {
            if (!text.contains("*")) {
                ++this.progress;
            } else {
                text = text.replace("*", "");
            }
            if (this.progress > this.max) {
                this.progress = this.max;
            }
            MediathekNoGui.this.initProgressBar(this.max, this.progress, text);
        }

        @Override
        public synchronized void fertig(String sender, boolean stop) {
            --this.count;
            if (this.count <= 0) {
                this.progress = 0;
                this.max = 0;
                MediathekNoGui.this.initProgressBar(0, 0, "");
                ((MediathekNoGui)MediathekNoGui.this).daten.listeFilme.datumSchreiben(stop);
                MediathekNoGui.this.undTschuess();
            }
        }

        @Override
        public void addMax(int m) {
            this.max += m;
        }

        @Override
        public void threads(int tthreads) {
        }
    }
}

