/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.Funktionen;
import mediathek.beobachter.Listener;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.io.FilmListener;
import mediathek.io.GetUrl;
import mediathek.io.MediathekReader;

public class GuiInfoLaden
extends PanelVorlage {
    private Listener seitenListener;
    private FilmListener[] filmListener;
    private JProgressBar[] jProgressBarThread;
    private JProgressBar[] jProgressBarErledigt;
    private JLabel[] jLabel;
    private String start = "";
    private int[] prozent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JPanel jPanelExtra;
    private JTextField jTextFieldEnde;
    private JTextField jTextFieldSeiten;
    private JTextField jTextFieldStart;

    public GuiInfoLaden(Daten d) {
        super(d);
        this.initComponents();
        this.daten = d;
        this.setText();
        this.init();
        this.seitenListener = new Listener(){

            @Override
            public void progress() {
                GuiInfoLaden.this.setText();
            }
        };
        GetUrl.addAdListener(this.seitenListener);
    }

    @Override
    public void neuLaden() {
        this.setText();
    }

    private void init() {
        int max = this.daten.mediathekListe.size() + 1;
        this.jProgressBarThread = new JProgressBar[max];
        this.jProgressBarErledigt = new JProgressBar[max];
        this.jLabel = new JLabel[max];
        this.filmeListener();
        this.jPanelExtra.removeAll();
        this.prozent = new int[max];
        for (int i = 0; i < max; ++i) {
            this.jProgressBarThread[i] = new JProgressBar();
            this.jProgressBarErledigt[i] = new JProgressBar();
            this.jProgressBarErledigt[i].setVisible(true);
            this.jProgressBarThread[i].setVisible(true);
            this.jProgressBarThread[i].setIndeterminate(false);
            this.jLabel[i] = new JLabel();
        }
        this.extra();
    }

    private void extra() {
        this.jPanelExtra.removeAll();
        this.jPanelExtra.updateUI();
        int maxX = this.daten.mediathekListe.size() + 1;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        this.jPanelExtra.setLayout(gridbag);
        this.addTitel(gridbag, c);
        for (int i = 0; i < maxX; ++i) {
            this.addExtraZeile(i, gridbag, c);
        }
        Iterator it = this.daten.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.jLabel[i].setText(((MediathekReader)it.next()).sender);
            ++i;
        }
        this.jLabel[i].setText("Podcast");
    }

    private void addTitel(GridBagLayout gridbag, GridBagConstraints c) {
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        JLabel label = new JLabel(" Sender ");
        gridbag.setConstraints(label, c);
        this.jPanelExtra.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        label = new JLabel(" Threads ");
        gridbag.setConstraints(label, c);
        this.jPanelExtra.add(label);
        c.gridx = 2;
        c.weightx = 100.0;
        label = new JLabel(" Erledigt ");
        gridbag.setConstraints(label, c);
        this.jPanelExtra.add(label);
    }

    private void addExtraZeile(int y, GridBagLayout gridbag, GridBagConstraints c) {
        c.gridy = y + 1;
        c.gridx = 0;
        c.weightx = 1.0;
        gridbag.setConstraints(this.jLabel[y], c);
        this.jPanelExtra.add(this.jLabel[y]);
        c.gridx = 1;
        c.weightx = 10.0;
        gridbag.setConstraints(this.jProgressBarThread[y], c);
        this.jPanelExtra.add(this.jProgressBarThread[y]);
        c.gridx = 2;
        c.weightx = 100.0;
        gridbag.setConstraints(this.jProgressBarErledigt[y], c);
        this.jPanelExtra.add(this.jProgressBarErledigt[y]);
    }

    public void filmeListener() {
        this.filmListener = new FilmListener[this.daten.mediathekListe.size() + 1];
        Iterator it = this.daten.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            MediathekReader reader = (MediathekReader)it.next();
            this.filmListener[i] = new BeobachterLaden(i);
            reader.addAdListener(this.filmListener[i]);
            ++i;
        }
        this.filmListener[i] = new BeobachterLaden(i);
        this.daten.feedReaderPods.addAdListener(this.filmListener[i]);
    }

    private void setText() {
        this.jTextFieldSeiten.setMargin(new Insets(1, 5, 1, 5));
        this.jTextFieldSeiten.setText(String.valueOf(this.daten.seitenZaehlerGesamt));
    }

    private void initProgressBar(int nr, String sender, int threads, int max, int progress, String text) {
        if (max == 0) {
            this.jProgressBarErledigt[nr].setIndeterminate(false);
            this.jProgressBarErledigt[nr].setMaximum(1);
            this.jProgressBarErledigt[nr].setMinimum(0);
            this.jProgressBarErledigt[nr].setValue(1);
            this.jProgressBarErledigt[nr].setStringPainted(true);
            this.jProgressBarErledigt[nr].setString("  " + this.daten.getSeitenZaehler(sender) + " Seiten  /  100% ");
            this.prozent[nr] = 0;
        } else if (max == 1) {
            this.jProgressBarErledigt[nr].setIndeterminate(true);
            this.jProgressBarErledigt[nr].setMaximum(1);
            this.jProgressBarErledigt[nr].setMinimum(0);
            this.jProgressBarErledigt[nr].setValue(0);
            this.jProgressBarErledigt[nr].setStringPainted(false);
        } else {
            this.jProgressBarErledigt[nr].setIndeterminate(false);
            this.jProgressBarErledigt[nr].setMaximum(max);
            this.jProgressBarErledigt[nr].setMinimum(0);
            int proz = 0;
            if (progress != 0 && (proz = progress * 100 / max) >= 100) {
                proz = 99;
            }
            this.prozent[nr] = proz;
            this.jProgressBarErledigt[nr].setString("  " + this.daten.getSeitenZaehler(sender) + " Seiten  /  " + proz + "% von " + max + " Themen  ");
            this.jProgressBarErledigt[nr].setStringPainted(true);
            this.jProgressBarErledigt[nr].setValue(progress);
        }
        if (threads == 0) {
            this.jProgressBarThread[nr].setMaximum(0);
            this.jProgressBarThread[nr].setMinimum(0);
            this.jProgressBarThread[nr].setValue(0);
            this.jProgressBarThread[nr].setStringPainted(false);
        } else {
            this.jProgressBarThread[nr].setMaximum(6);
            this.jProgressBarThread[nr].setMinimum(0);
            if (threads == 1) {
                this.jProgressBarThread[nr].setString(" " + threads + " Thread ");
            } else {
                this.jProgressBarThread[nr].setString(" " + threads + " Threads ");
            }
            this.jProgressBarThread[nr].setStringPainted(true);
            this.jProgressBarThread[nr].setValue(threads);
        }
    }

    private void progressLoeschen() {
        for (int i = 0; i < this.jProgressBarErledigt.length; ++i) {
            this.jProgressBarErledigt[i].setMaximum(0);
            this.jProgressBarErledigt[i].setMinimum(0);
            this.jProgressBarErledigt[i].setValue(0);
            this.jProgressBarErledigt[i].setString("");
            this.jProgressBarErledigt[i].setStringPainted(false);
        }
    }

    private synchronized void zeit() {
        try {
            Date today = new Date(System.currentTimeMillis());
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
            Date d = sdf.parse(this.start);
            long sekunden = Math.round((today.getTime() - d.getTime()) / 1000L);
            int proz = 100;
            for (int i = 0; i < this.prozent.length; ++i) {
                if (this.prozent[i] <= 0 || this.prozent[i] >= proz) continue;
                proz = this.prozent[i];
            }
            if (proz == 0 || proz == 100) {
                this.jTextFieldEnde.setText("");
            } else {
                sekunden = 100L * sekunden / (long)proz;
                Date ziel = new Date(today.getTime() + sekunden * 1000L);
                String output = sdf.format(ziel);
                this.jTextFieldEnde.setText(output);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private synchronized void zeitSetzen() {
        if (this.start.equals("")) {
            this.start = Funktionen.getJetzt_ddMMyyyy_HHmm();
            this.jTextFieldStart.setText(this.start);
            this.jTextFieldEnde.setText("");
        }
    }

    private synchronized void zeitLoeschen() {
        boolean alleFertig = true;
        for (int i = 0; i < this.prozent.length; ++i) {
            if (this.prozent[i] == 0) continue;
            alleFertig = false;
            break;
        }
        if (alleFertig) {
            this.progressLoeschen();
            this.start = "";
            this.jTextFieldStart.setText("");
            this.jTextFieldEnde.setText("");
        }
    }

    private void initComponents() {
        this.jLabel6 = new JLabel();
        this.jTextFieldSeiten = new JTextField();
        this.jPanelExtra = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldStart = new JTextField();
        this.jTextFieldEnde = new JTextField();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel6.setText("abgesuchte Webseiten:");
        this.jTextFieldSeiten.setEditable(false);
        this.jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 538, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jLabel1.setText("Startzeit:");
        this.jLabel2.setText("Endzeit:");
        this.jTextFieldStart.setEditable(false);
        this.jTextFieldEnde.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanelExtra, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldStart, -1, 360, Short.MAX_VALUE).addComponent(this.jTextFieldSeiten, -1, 360, Short.MAX_VALUE).addComponent(this.jTextFieldEnde, -1, 360, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldSeiten, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldStart, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldEnde, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanelExtra, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobachterLaden
    implements FilmListener {
        int max = 0;
        int count = 0;
        int progress = 0;
        int nr;
        String sender = "";
        int threads = 0;

        public BeobachterLaden(int i) {
            this.nr = i;
        }

        @Override
        public void start(String ssender, int m) {
            ++this.count;
            this.max += m;
            this.sender = ssender;
            if (this.max == 0) {
                GuiInfoLaden.this.initProgressBar(this.nr, this.sender, this.threads, 1, this.progress, "");
            } else {
                GuiInfoLaden.this.initProgressBar(this.nr, this.sender, this.threads, this.max, this.progress, "");
            }
            GuiInfoLaden.this.zeitSetzen();
        }

        @Override
        public void progress(String text) {
            if (!text.contains("*")) {
                ++this.progress;
            } else {
                text = text.replace("*", "");
            }
            if (this.progress > this.max) {
                this.progress = this.max;
            }
            GuiInfoLaden.this.initProgressBar(this.nr, this.sender, this.threads, this.max, this.progress, text);
            GuiInfoLaden.this.zeit();
        }

        @Override
        public synchronized void fertig(String ssender, boolean stop) {
            this.sender = ssender;
            --this.count;
            if (this.count <= 0) {
                this.progress = 0;
                this.threads = 0;
                this.max = 0;
                GuiInfoLaden.this.initProgressBar(this.nr, this.sender, 0, 0, 0, "");
                GuiInfoLaden.this.zeitLoeschen();
            }
        }

        @Override
        public void addMax(int m) {
            this.max += m;
        }

        @Override
        public void threads(int tthreads) {
            this.threads = tthreads;
        }
    }
}

