/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.ListeAbo;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogDatenFilm;
import mediathek.gui.dialoge.DialogExportFilme;
import mediathek.gui.dialoge.DialogImportFilme;
import mediathek.gui.dialoge.DialogPgruppen;
import mediathek.io.FilmListener;
import mediathek.io.GetUrl;
import mediathek.io.MediathekReader;
import mediathek.io.starter.RuntimeExecEvent;
import mediathek.io.starter.RuntimeListener;
import mediathek.wiz.WizButtonAnlegen;

public class GuiFilme
extends PanelVorlage {
    private TModel tModel1;
    private JButton[] buttonArray;
    private BeobachterLaden beobachterLaden;
    private DialogDatenFilm dialogDatenFilm;
    private int runtimes = 0;
    private JSpinner jSpinnerVerkuerzen = new JSpinner();
    private JCheckBox jCheckBoxVerkuerzen = new JCheckBox("Ansicht verk\u00fcrzen");
    private JButton jButtonAboAnlegen;
    private JButton jButtonFilterLoeschen;
    private JButton jButtonImport;
    private JButton jButtonLaden;
    private JButton jButtonStop;
    private JComboBox jComboBoxFilterSender;
    private JComboBox jComboBoxFilterThema;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabelGeladen;
    private JLabel jLabelServer;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenu jMenu4;
    private JMenuBar jMenuBar1;
    private JMenuBar jMenuBar2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanelExtra;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextField jTextFieldFilterTitel;
    private JTextField jTextFieldGeladen;

    public GuiFilme(Daten d) {
        super(d);
        this.initComponents();
        this.daten = d;
        this.dialogDatenFilm = new DialogDatenFilm(null, false, this.daten);
        this.jProgressBar1.setVisible(false);
        this.jButtonStop.setVisible(false);
        this.jProgressBar1.setForeground(new Color(102, 153, 255));
        this.jTable1.addMouseListener(new BeobMausTabelle());
        ActionMap am = this.jTable1.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = this.jTable1.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "film_starten");
        this.jTable1.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        this.jTable1.setAutoResizeMode(0);
        this.jButtonFilterLoeschen.addActionListener(new BeobFilterLoeschen());
        this.jComboBoxFilterSender.addActionListener(new BeobFilterSender());
        this.jComboBoxFilterThema.addActionListener(new BeobFilter());
        this.jComboBoxFilterThema.getEditor().getEditorComponent().addMouseListener(new BeobMausTextCombo());
        this.jComboBoxFilterThema.addMouseListener(new BeobMausTextCombo());
        this.jTextFieldFilterTitel.addActionListener(new BeobFilter());
        this.jTextFieldFilterTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.jButtonLaden.addActionListener(new BeobachterNeuLaden());
        this.jButtonImport.addActionListener(new BeobImportDialog());
        this.jButtonStop.addActionListener(new BeobLoadStop());
        this.beobachterLaden = new BeobachterLaden();
        this.jButtonAboAnlegen.setVisible(Boolean.parseBoolean(this.daten.system[7]));
        this.jButtonAboAnlegen.addActionListener(new BeobAboAnlegen());
        this.jPanelExtra.addMouseListener(new BeobMausPgruppenDialog());
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            ((MediathekReader)it.next()).addAdListener(this.beobachterLaden);
        }
        this.daten.listeFilme.addAdListener(this.beobachterLaden);
        this.extra();
        this.setInfo();
        this.setButtonLaden();
        if (this.daten.listeFilme.size() != 0) {
            this.filmeGeladen();
            Funktionen.spaltenFilmSetzen(this.jTable1, this.daten, Boolean.parseBoolean(this.daten.system[7]), false, false);
        } else {
            this.tabelleLoeschen();
        }
    }

    @Override
    public void neuLaden() {
        this.jButtonAboAnlegen.setVisible(Boolean.parseBoolean(this.daten.system[7]));
        this.extra();
        this.filter();
    }

    public void bildProgs() {
        this.extra();
    }

    @Override
    public void neuLadenSofort() {
        this.setButtonLaden();
    }

    public void setExtraVis(boolean vis) {
        this.jPanelExtra.setVisible(vis);
        this.extra();
    }

    public void filmListeLaden() {
        this.daten.guiMediathek.setCursor(Cursor.getPredefinedCursor(3));
        this.tabelleLoeschen();
        this.jButtonLaden.setEnabled(false);
        this.jButtonImport.setEnabled(false);
        new Thread(this.daten.listeFilme).start();
        this.daten.guiMediathek.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void setButtonLaden() {
        if (this.daten.system[38].equals("import-datei")) {
            this.jLabelServer.setText(this.daten.system[34]);
        } else if (this.daten.system[38].equals("import-url")) {
            this.jLabelServer.setText(this.daten.system[35]);
        } else {
            this.jLabelServer.setText("Direkt von den Sendern laden");
        }
    }

    private void setInfo() {
        this.jTextFieldGeladen.setText(" " + this.daten.filmliste[0] + " ");
    }

    private void filmeGeladen() {
        String setSender = "";
        String setThema = "";
        this.setInfo();
        this.stopBeob = true;
        setSender = (String)this.jComboBoxFilterSender.getSelectedItem();
        if (setSender == null) {
            setSender = "";
        }
        if ((setThema = (String)this.jComboBoxFilterThema.getSelectedItem()) == null) {
            setThema = "";
        }
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(1, "", 0)));
        this.jComboBoxFilterSender.setSelectedIndex(0);
        this.jComboBoxFilterSender.setSelectedItem(setSender);
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(2, "", 0)));
        this.jComboBoxFilterThema.setSelectedIndex(0);
        this.jComboBoxFilterThema.setSelectedItem(setThema);
        this.stopBeob = false;
        this.filter();
    }

    private void extra() {
        this.jPanelExtra.removeAll();
        this.jPanelExtra.updateUI();
        int maxSpalten = 4;
        int max = this.daten.listePgruppeButton.size();
        this.buttonArray = new JButton[max];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        this.jPanelExtra.setLayout(gridbag);
        int spalte = 0;
        int zeile = 0;
        for (int i = 0; i < max; ++i) {
            if (!this.daten.listePgruppeButton.freeLine(i)) {
                this.addExtraFeld(i, spalte, zeile, gridbag, c, this.jPanelExtra);
            }
            if (++spalte <= maxSpalten - 1) continue;
            spalte = 0;
            ++zeile;
        }
        c.weightx = 10.0;
        c.gridx = maxSpalten + 1;
        c.gridy = 0;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.jPanelExtra.add(label);
    }

    private Component addExtraFeld(int i, int spalte, int zeile, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        JComponent ret = null;
        c.gridx = spalte;
        c.gridy = zeile;
        if (((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getListeProg().isEmpty()) {
            JLabel label = new JLabel(((DatenPgruppe)this.daten.listePgruppeButton.get((int)i)).arr[0]);
            Color col = ((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getFarbe(this.daten);
            if (col != null) {
                label.setForeground(col);
            }
            gridbag.setConstraints(label, c);
            panel.add(label);
            ret = label;
        } else {
            JButton button = new JButton(((DatenPgruppe)this.daten.listePgruppeButton.get((int)i)).arr[0]);
            button.addActionListener(new BeobOpen(i));
            Color col = ((DatenPgruppe)this.daten.listePgruppeButton.get(i)).getFarbe(this.daten);
            if (col != null) {
                button.setBackground(col);
            }
            this.buttonArray[i] = button;
            gridbag.setConstraints(button, c);
            panel.add(button);
            ret = button;
        }
        return ret;
    }

    private void tabelleLoeschen() {
        this.stopBeob = true;
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(1, "", 0)));
        this.jComboBoxFilterSender.setSelectedIndex(0);
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(2, "", 0)));
        this.jComboBoxFilterThema.setSelectedIndex(0);
        this.stopBeob = false;
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], Konstanten.FILME_COLUMN_NAMES));
        this.tModel1 = null;
        Funktionen.spaltenFilmSetzen(this.jTable1, this.daten, Boolean.parseBoolean(this.daten.system[7]), false, false);
        this.zeilenZahl();
    }

    private synchronized void filter() {
        this.stopBeob = true;
        String thema = (String)this.jComboBoxFilterThema.getSelectedItem();
        String sender = (String)this.jComboBoxFilterSender.getSelectedItem();
        boolean themaOpen = this.jComboBoxFilterThema.isPopupVisible();
        this.getSpalten(this.jTable1);
        this.tabelleLadenFilter();
        if (this.tModel1 != null) {
            if (this.jCheckBoxVerkuerzen.isSelected()) {
                this.tModel1.verkuerzen(1, 2, ((Number)this.jSpinnerVerkuerzen.getModel().getValue()).intValue());
                this.zeilenZahl();
            }
            if (sender.equals("")) {
                this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(2, "", 0)));
            } else {
                this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(2, sender, 1)));
            }
            for (ActionListener l : this.jComboBoxFilterThema.getActionListeners()) {
                this.jComboBoxFilterThema.removeActionListener(l);
            }
            this.jComboBoxFilterThema.setSelectedItem(thema);
            this.jComboBoxFilterThema.setPopupVisible(themaOpen);
            this.jComboBoxFilterThema.addActionListener(new BeobFilter());
            this.setSpalten(this.jTable1);
        }
        this.updateUI();
        this.stopBeob = false;
    }

    private void filterLoeschen() {
        this.stopBeob = true;
        this.jCheckBoxVerkuerzen.setSelected(false);
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(1, "", 0)));
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilme.getModelOfField(2, "", 0)));
        this.jTextFieldFilterTitel.setText("");
        this.jComboBoxFilterSender.setSelectedIndex(0);
        this.jComboBoxFilterThema.setSelectedIndex(0);
        this.getSpalten(this.jTable1);
        this.tabelleLadenFilter();
        if (this.tModel1 != null) {
            this.setSpalten(this.jTable1);
        }
        this.stopBeob = false;
    }

    private void tabelleLadenFilter() {
        this.tModel1 = this.daten.listeFilme.getModel((String)this.jComboBoxFilterSender.getSelectedItem(), (String)this.jComboBoxFilterThema.getSelectedItem(), !this.jComboBoxFilterThema.isEditable(), this.jTextFieldFilterTitel.getText());
        if (this.tModel1 != null) {
            this.jTable1.setModel(this.tModel1);
            Funktionen.spaltenFilmSetzen(this.jTable1, this.daten, Boolean.parseBoolean(this.daten.system[7]), false, false);
        } else {
            this.tabelleLoeschen();
        }
        this.zeilenZahl();
    }

    private void zeilenZahl() {
        String text = "";
        String leer = "   -   ";
        text = this.tModel1 != null ? this.tModel1.getRowCount() + " Filme" : "0 Filme";
        if (this.runtimes == 1) {
            text = text + leer + this.runtimes + "    laufender Film";
        } else if (this.runtimes > 1) {
            text = text + leer + this.runtimes + "    laufende Filme";
        }
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, text, 0, 4));
    }

    private void table1Select() {
        DatenFilm aktFilm = new DatenFilm(this.daten);
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRow);
            for (int i = 0; i < 16; ++i) {
                aktFilm.arr[i] = (String)this.tModel1.getValueAt(selectedModelRow, i);
            }
            this.dialogDatenFilm.show(aktFilm);
        }
    }

    private void open(int open) {
        String url = "";
        DatenFilm ersterFilm = new DatenFilm(this.daten);
        int[] selectedTableRows = this.jTable1.getSelectedRows();
        for (int l = 0; l < selectedTableRows.length; ++l) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRows[l]);
            if (l == 0) {
                for (int i = 0; i < 16; ++i) {
                    ersterFilm.arr[i] = (String)this.tModel1.getValueAt(selectedModelRow, i);
                }
            }
            url = url.equals("") ? url + (String)this.tModel1.getValueAt(selectedModelRow, 4) : url + " " + (String)this.tModel1.getValueAt(selectedModelRow, 4);
        }
        this.setRuntimCounter(true);
        if (!this.daten.starterClass.urlStarten(url, open, ersterFilm, new BeobRuntimeExec())) {
            this.setRuntimCounter(false);
        }
    }

    private void aboAnlegen() {
        boolean exakt;
        String sender = (String)this.jComboBoxFilterSender.getSelectedItem();
        String thema = (String)this.jComboBoxFilterThema.getSelectedItem();
        String text = this.jTextFieldFilterTitel.getText();
        boolean bl = exakt = !this.jComboBoxFilterThema.isEditable();
        if (sender.equals("") && thema.equals("") & text.equals("")) {
            JOptionPane.showMessageDialog(null, "der Filter darf nicht leer sein!", "Abo anlegen", 1);
        } else if (!this.daten.listeAbo.addAbo(sender, thema, exakt, text)) {
            JOptionPane.showMessageDialog(null, "Abo existiert bereits!", "Abo anlegen", 1);
        }
    }

    private void loadStop() {
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            ((MediathekReader)it.next()).stoppen();
        }
        GetUrl.stop = true;
        this.initProgressBar(0, 0, "");
    }

    private void initProgressBar(int max, int progress, String text) {
        if (max == 0) {
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setMaximum(0);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
            this.jProgressBar1.setVisible(false);
            this.jButtonStop.setVisible(false);
        } else if (max == 1) {
            this.jProgressBar1.setIndeterminate(true);
            this.jProgressBar1.setMaximum(1);
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setValue(0);
            this.jProgressBar1.setStringPainted(false);
            this.jProgressBar1.setVisible(true);
            this.jButtonStop.setVisible(true);
        } else {
            this.jProgressBar1.setIndeterminate(false);
            this.jProgressBar1.setVisible(true);
            this.jButtonStop.setVisible(true);
            this.jProgressBar1.setMaximum(max);
            this.jProgressBar1.setMinimum(0);
            int proz = 0;
            if (progress != 0 && (proz = progress * 100 / max) >= 100) {
                proz = 99;
            }
            this.jProgressBar1.setString("( " + this.daten.seitenZaehler + " Seiten  /  " + proz + "% von " + max + " Themen )  " + Funktionen.textLaenge(text));
            this.jProgressBar1.setStringPainted(true);
            this.jProgressBar1.setValue(progress);
        }
    }

    private void themaLaden() {
        DatenFilm aktFilm = new DatenFilm(this.daten);
        String themaUrl = "";
        String thema = "";
        String sender = "";
        int selectedTableRow = this.jTable1.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.jTable1.convertRowIndexToModel(selectedTableRow);
            for (int i = 0; i < 16; ++i) {
                aktFilm.arr[i] = (String)this.tModel1.getValueAt(selectedModelRow, i);
            }
            themaUrl = aktFilm.arr[9];
            thema = aktFilm.arr[2];
            sender = aktFilm.arr[1];
            MediathekReader reader = this.daten.getMedReader(sender);
            if (reader != null) {
                this.daten.seitenZaehler = 0;
                reader.addThema(themaUrl, thema);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Es ist keine Zeile (Thema) markiert!", "Fehler!", 0);
        }
    }

    private void importFilme() {
        DialogImportFilme dialog = new DialogImportFilme(null, true, this.daten);
        dialog.setVisible(true);
        this.setButtonLaden();
    }

    private void exportFilme() {
        DialogExportFilme dialog = new DialogExportFilme(null, true, this.daten);
        dialog.setVisible(true);
    }

    private synchronized void setRuntimCounter(boolean up) {
        if (this.runtimes <= 0) {
            this.runtimes = 0;
        }
        this.runtimes = up ? ++this.runtimes : --this.runtimes;
        this.zeilenZahl();
    }

    private void dialogPgruppen() {
        new DialogPgruppen(null, true, this.daten, true, this).setVisible(true);
        this.extra();
    }

    private void dialogWizard() {
        new WizButtonAnlegen(this.daten);
        this.extra();
    }

    private void checkPattern(JTextField tf) {
        String text = tf.getText();
        if (ListeAbo.isPattern(text)) {
            if (ListeAbo.makePattern(text) == null) {
                tf.setBackground(Color.RED);
            } else {
                tf.setBackground(Color.PINK);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu3 = new JMenu();
        this.jMenu4 = new JMenu();
        this.jPanelExtra = new JPanel();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jProgressBar1 = new JProgressBar();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxFilterSender = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxFilterThema = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldFilterTitel = new JTextField();
        this.jButtonFilterLoeschen = new JButton();
        this.jButtonAboAnlegen = new JButton();
        this.jButtonStop = new JButton();
        this.jPanel2 = new JPanel();
        this.jTextFieldGeladen = new JTextField();
        this.jLabelGeladen = new JLabel();
        this.jButtonLaden = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jLabelServer = new JLabel();
        this.jButtonImport = new JButton();
        this.jMenu1.setText("File");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("File");
        this.jMenuBar2.add(this.jMenu3);
        this.jMenu4.setText("Edit");
        this.jMenuBar2.add(this.jMenu4);
        this.jPanelExtra.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 858, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jScrollPane1.setBorder(BorderFactory.createTitledBorder(null, "0 Zeilen", 0, 4));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jTable1.setCursor(new Cursor(0));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 834, Short.MAX_VALUE).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 282, Short.MAX_VALUE).addContainerGap()));
        this.jProgressBar1.setFont(new Font("Monospaced", 1, 12));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Filter"));
        this.jLabel2.setText("Sender:");
        this.jComboBoxFilterSender.setMaximumRowCount(25);
        this.jLabel3.setText("Thema:");
        this.jComboBoxFilterThema.setMaximumRowCount(25);
        this.jLabel5.setText("Titel:");
        this.jButtonFilterLoeschen.setText("x");
        this.jButtonFilterLoeschen.setToolTipText("Filter l\u00f6schen");
        this.jButtonAboAnlegen.setText("Abo");
        this.jButtonAboAnlegen.setToolTipText("Filter als Abo anlegen");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterSender, 0, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterThema, 0, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilterTitel, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAboAnlegen).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldFilterTitel, -2, -1, -2).addComponent(this.jComboBoxFilterThema, -2, -1, -2).addComponent(this.jComboBoxFilterSender, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jButtonFilterLoeschen, -2, 16, -2).addComponent(this.jButtonAboAnlegen)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.jButtonAboAnlegen, this.jButtonFilterLoeschen, this.jComboBoxFilterSender, this.jComboBoxFilterThema, this.jTextFieldFilterTitel);
        this.jButtonStop.setText("Stop");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jTextFieldGeladen.setEditable(false);
        this.jLabelGeladen.setText("geladen am:");
        this.jButtonLaden.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/start.gif")));
        this.jButtonLaden.setText("alle Filme neu laden");
        this.jButtonLaden.setToolTipText("Neuladen aller Sender starten");
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setVerticalScrollBarPolicy(21);
        this.jLabelServer.setText("jLabel1");
        this.jScrollPane2.setViewportView(this.jLabelServer);
        this.jButtonImport.setText("::");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImport).addGap(12, 12, 12).addComponent(this.jScrollPane2, -1, 450, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelGeladen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGeladen, -2, -1, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonLaden).addComponent(this.jScrollPane2, -2, 26, -2).addComponent(this.jLabelGeladen).addComponent(this.jTextFieldGeladen, -2, -1, -2).addComponent(this.jButtonImport)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonImport, this.jButtonLaden);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelExtra, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jProgressBar1, -1, 789, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStop)).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExtra, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jProgressBar1, -2, 14, -2).addComponent(this.jButtonStop)).addContainerGap()));
        layout.linkSize(1, this.jButtonStop, this.jProgressBar1);
    }

    private class BeobFilterTitelDoc
    implements DocumentListener {
        private BeobFilterTitelDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
        }
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int nr = GuiFilme.this.daten.listePgruppeButton.getDoppelklick();
            if (nr >= 0) {
                GuiFilme.this.open(nr);
            } else {
                JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
            }
        }
    }

    private class BeobMausPgruppenDialog
    extends MouseAdapter {
        private BeobMausPgruppenDialog() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                GuiFilme.this.dialogPgruppen();
            }
        }
    }

    private class BeobMausTextCombo
    extends MouseAdapter {
        private BeobMausTextCombo() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                boolean ed = GuiFilme.this.jComboBoxFilterThema.isEditable();
                GuiFilme.this.jComboBoxFilterThema.setEditable(!ed);
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobImportDialog
    implements ActionListener {
        private BeobImportDialog() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.importFilme();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        private BeobUrl beobUrl = new BeobUrl();
        private BeobPrint beobPrint = new BeobPrint();
        private BeobInfo beobInfo = new BeobInfo();
        private BeobFilterLoeschen beobLoeschen = new BeobFilterLoeschen();
        private BeobAbo beobAbo = new BeobAbo();
        private BeobFilterThema beobThema = new BeobFilterThema();
        private BeobFilterSender beobSender = new BeobFilterSender();
        private BeobFilterSenderThema beobSenderThema = new BeobFilterSenderThema();
        private BeobThemaLaden beobThemaLaden = new BeobThemaLaden();
        private Point p;
        JPanel panel = new JPanel();

        public BeobMausTabelle() {
            GuiFilme.this.jCheckBoxVerkuerzen.setSelected(false);
            GuiFilme.this.jSpinnerVerkuerzen.setModel(new SpinnerNumberModel(1, 1, 10, 1));
            GuiFilme.this.jSpinnerVerkuerzen.addChangeListener(new BeobSpinnerVerkuerzen());
            GuiFilme.this.jCheckBoxVerkuerzen.addActionListener(new BeobVerkuerzen());
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
            if (arg0.getButton() == 1 && arg0.getClickCount() > 1) {
                int nr = GuiFilme.this.daten.listePgruppeButton.getDoppelklick();
                if (nr >= 0) {
                    GuiFilme.this.open(nr);
                } else {
                    JOptionPane.showMessageDialog(null, "unter \"Pfade\" einen Standardbutton festlegen.", "keine Standardbutton!", 1);
                }
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.jTable1.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.jTable1.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Thema neu laden");
            item.addActionListener(this.beobThemaLaden);
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            item = new JMenuItem("URL kopieren");
            item.addActionListener(this.beobUrl);
            jPopupMenu.add(item);
            item = new JMenuItem("Tabelle Drucken");
            item.addActionListener(this.beobPrint);
            jPopupMenu.add(item);
            item = new JMenuItem("Infos anzeigen");
            item.addActionListener(this.beobInfo);
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            item = new JMenuItem("Filter l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            jPopupMenu.add(item);
            item = new JMenuItem("nach Sender filtern");
            item.addActionListener(this.beobSender);
            jPopupMenu.add(item);
            item = new JMenuItem("nach Thema filtern");
            item.addActionListener(this.beobThema);
            jPopupMenu.add(item);
            item = new JMenuItem("nach Sender und Thema filtern");
            item.addActionListener(this.beobSenderThema);
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)GuiFilme.this.jCheckBoxVerkuerzen, "Center");
            this.panel.add((Component)GuiFilme.this.jSpinnerVerkuerzen, "East");
            jPopupMenu.add(this.panel);
            if (Boolean.parseBoolean(GuiFilme.this.daten.system[7])) {
                jPopupMenu.addSeparator();
                String thema = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2);
                String sender = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1);
                String text = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3);
                JMenuItem itemAbo = GuiFilme.this.daten.listeAbo.getAbo(sender, thema, text) != null ? new JMenuItem("Abo L\u00f6schen") : new JMenuItem("Abo mit Sender und Thema anlegen");
                itemAbo.addActionListener(this.beobAbo);
                jPopupMenu.add(itemAbo);
            }
            jPopupMenu.addSeparator();
            JMenu submenue = new JMenu("Film mit Programm starten:");
            jPopupMenu.add(submenue);
            for (int i = 0; i < GuiFilme.this.daten.listePgruppeButton.size(); ++i) {
                DatenPgruppe pgruppe = (DatenPgruppe)GuiFilme.this.daten.listePgruppeButton.get(i);
                Color col = pgruppe.getFarbe(GuiFilme.this.daten);
                item = new JMenuItem(pgruppe.arr[0]);
                if (pgruppe.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpen(i));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobAbo
        implements ActionListener {
            private BeobAbo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    String text;
                    GuiFilme.this.stopBeob = true;
                    String thema = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2);
                    String sender = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1);
                    DatenAbo datenAbo = GuiFilme.this.daten.listeAbo.getAbo(sender, thema, text = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 3));
                    if (datenAbo != null) {
                        GuiFilme.this.daten.listeAbo.aboLoeschen(datenAbo);
                    } else {
                        GuiFilme.this.daten.listeAbo.addAbo(sender, thema, true, "");
                    }
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterLoeschen
        implements ActionListener {
            private BeobFilterLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.filterLoeschen();
            }
        }

        private class BeobFilterSenderThema
        implements ActionListener {
            private BeobFilterSenderThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterSender
        implements ActionListener {
            private BeobFilterSender() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = "";
                    sender = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 1);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobFilterThema
        implements ActionListener {
            private BeobFilterThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String thema = "";
                    thema = (String)GuiFilme.this.tModel1.getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 2);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobVerkuerzen
        implements ActionListener {
            private BeobVerkuerzen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiFilme.this.stopBeob) {
                    GuiFilme.this.filter();
                }
            }
        }

        private class BeobInfo
        implements ActionListener {
            private BeobInfo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.dialogDatenFilm.setVisible(true);
                GuiFilme.this.dialogDatenFilm.toFront();
            }
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.jTable1.print();
                }
                catch (PrinterException ex) {
                    GuiFilme.this.daten.fehler.fehlerMeldung(ex, "GuiFilme.BeobPrint - Fehler beim Drucken");
                }
            }
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.jTable1.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    Funktionen.copyToClipboard((String)GuiFilme.this.jTable1.getModel().getValueAt(GuiFilme.this.jTable1.convertRowIndexToModel(nr), 4));
                }
            }
        }

        private class BeobThemaLaden
        implements ActionListener {
            private BeobThemaLaden() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.themaLaden();
            }
        }
    }

    private class BeobSpinnerVerkuerzen
    implements ChangeListener {
        private BeobSpinnerVerkuerzen() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            GuiFilme.this.filter();
        }
    }

    private class BeobRuntimeExec
    implements RuntimeListener {
        private BeobRuntimeExec() {
        }

        @Override
        public void starter(RuntimeExecEvent e) {
            GuiFilme.this.setRuntimCounter(false);
        }
    }

    private class BeobLoadStop
    implements ActionListener {
        private BeobLoadStop() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            GuiFilme.this.loadStop();
            GuiFilme.this.filmeGeladen();
            GuiFilme.this.jButtonLaden.setEnabled(true);
            GuiFilme.this.jButtonImport.setEnabled(true);
            GuiFilme.this.setInfo();
        }
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                GuiFilme.this.table1Select();
            }
        }
    }

    private class BeobachterLaden
    implements FilmListener {
        int max = 0;
        int count = 0;
        int progress = 0;

        @Override
        public void start(String sender, int m) {
            ++this.count;
            this.max += m;
            if (this.max == 0) {
                GuiFilme.this.initProgressBar(1, 0, "");
            } else {
                GuiFilme.this.initProgressBar(this.max, 0, "");
            }
        }

        @Override
        public void progress(String text) {
            if (!text.contains("*")) {
                ++this.progress;
            } else {
                text = text.replace("*", "");
            }
            if (this.progress > this.max) {
                this.progress = this.max;
            }
            GuiFilme.this.initProgressBar(this.max, this.progress, text);
        }

        @Override
        public synchronized void fertig(String sender, boolean stop) {
            --this.count;
            if (this.count <= 0) {
                this.progress = 0;
                this.max = 0;
                GuiFilme.this.filmeGeladen();
                Funktionen.spaltenFilmSetzen(GuiFilme.this.jTable1, GuiFilme.this.daten, Boolean.parseBoolean(GuiFilme.this.daten.system[7]), false, false);
                GuiFilme.this.initProgressBar(0, 0, "");
                GuiFilme.this.jButtonLaden.setEnabled(true);
                GuiFilme.this.jButtonImport.setEnabled(true);
                GuiFilme.this.daten.ioXml.filmeSchreiben();
            }
        }

        @Override
        public void addMax(int m) {
            this.max += m;
        }

        @Override
        public void threads(int tthreads) {
        }
    }

    private class BeobachterNeuLaden
    implements ActionListener {
        private BeobachterNeuLaden() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filmListeLaden();
        }
    }

    private class BeobFilterLoeschen
    implements ActionListener {
        private BeobFilterLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filterLoeschen();
        }
    }

    private class BeobFilter
    implements ActionListener {
        private BeobFilter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobFilterSender
    implements ActionListener {
        private BeobFilterSender() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.filter();
            }
        }
    }

    private class BeobAboAnlegen
    implements ActionListener {
        private BeobAboAnlegen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.aboAnlegen();
        }
    }

    private class BeobPgruppen
    implements ActionListener {
        private BeobPgruppen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.dialogPgruppen();
        }
    }

    private class BeobInfo
    implements ActionListener {
        private BeobInfo() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GuiFilme.this.daten.debug) {
                GuiFilme.this.dialogWizard();
            } else {
                GuiFilme.this.dialogDatenFilm.setVisible(true);
                GuiFilme.this.dialogDatenFilm.toFront();
            }
        }
    }

    private class BeobOpen
    implements ActionListener {
        int open;

        public BeobOpen(int op) {
            this.open = op;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.open(this.open);
        }
    }
}

