/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialoge.DialogHilfe;

public class GuiEinstellungen
extends PanelVorlage {
    private BeobCheckboxSender[] beobCheck;
    private JButton jButtonHilfe;
    private JButton jButtonStandard;
    private JCheckBox jCheckBoxAbo;
    private JCheckBox jCheckBoxFehler;
    private JCheckBox jCheckBoxHinweise;
    private JCheckBox jCheckBoxMax;
    private JCheckBox jCheckBoxPodcast;
    private JCheckBox jCheckBoxSimmulieren;
    private JComboBox jComboBoxLook;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel6;
    private JSeparator jSeparator2;
    private JTextField jTextFieldUserAgent;

    public GuiEinstellungen(Daten d) {
        super(d);
        this.initComponents();
        this.daten = d;
        this.beobCheck = new BeobCheckboxSender[this.daten.mediathekListe.size()];
        for (int i = 0; i < this.daten.mediathekListe.size(); ++i) {
            this.beobCheck[i] = new BeobCheckboxSender(i);
        }
        this.init();
        this.jCheckBoxPodcast.setSelected(Boolean.parseBoolean(this.daten.system[10]));
        this.jCheckBoxPodcast.addActionListener(new BeobachterCheckbox());
        this.jCheckBoxAbo.addActionListener(new BeobachterCheckbox());
        this.jCheckBoxFehler.addActionListener(new BeobCheckboxFehler());
        this.jCheckBoxHinweise.addActionListener(new BeobHinweise());
        this.jCheckBoxMax.addActionListener(new BeobCheckboxMax());
        this.jCheckBoxSimmulieren.addActionListener(new BeobachterSimmulieren());
        String[] theme = new String[Konstanten.THEME.length];
        for (int i = 0; i < Konstanten.THEME.length; ++i) {
            theme[i] = Konstanten.THEME[i][0];
        }
        this.jComboBoxLook.setModel(new DefaultComboBoxModel<String>(theme));
        if (this.daten.system[1].equals("")) {
            this.daten.system[1] = "1";
        }
        this.jComboBoxLook.setSelectedIndex(Integer.parseInt(this.daten.system[1]));
        this.jComboBoxLook.addActionListener(new BeobLook());
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, false, "\nDieser Text wird als User-Agent\nan den Webserver \u00fcbertragen. Das enstpricht\nder Kennung die auch die Browser senden.").setVisible(true);
            }
        });
        this.jButtonStandard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiEinstellungen.this.jTextFieldUserAgent.setText(Funktionen.getStandardUserAgent());
                GuiEinstellungen.this.daten.setGeaendertOhnePanel();
            }
        });
        this.jTextFieldUserAgent.getDocument().addDocumentListener(new BeobUserAgent());
    }

    @Override
    public void neuLaden() {
        this.init();
    }

    @Override
    public void neuLadenSofort() {
        this.jCheckBoxFehler.setSelected(Boolean.parseBoolean(this.daten.system[0]));
        this.jCheckBoxHinweise.setSelected(Boolean.parseBoolean(this.daten.system[41]));
    }

    private void init() {
        this.jCheckBoxPodcast.setSelected(Boolean.parseBoolean(this.daten.system[10]));
        this.jCheckBoxAbo.setSelected(Boolean.parseBoolean(this.daten.system[7]));
        this.jCheckBoxFehler.setSelected(Boolean.parseBoolean(this.daten.system[0]));
        this.jCheckBoxHinweise.setSelected(Boolean.parseBoolean(this.daten.system[41]));
        this.jCheckBoxMax.setSelected(Boolean.parseBoolean(this.daten.system[2]));
        this.jTextFieldUserAgent.setText(this.daten.system[3]);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jCheckBoxPodcast = new JCheckBox();
        this.jCheckBoxAbo = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jCheckBoxFehler = new JCheckBox();
        this.jCheckBoxSimmulieren = new JCheckBox();
        this.jCheckBoxMax = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBoxLook = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldUserAgent = new JTextField();
        this.jButtonStandard = new JButton();
        this.jButtonHilfe = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jCheckBoxHinweise = new JCheckBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jCheckBoxPodcast.setText("Podcasts aktivieren");
        this.jCheckBoxAbo.setText("Abos aktivieren");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAbo).addGap(18, 18, 18).addComponent(this.jCheckBoxPodcast).addContainerGap(480, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxAbo).addComponent(this.jCheckBoxPodcast)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(""));
        this.jCheckBoxFehler.setText("Fehlermeldungen anzeigen");
        this.jCheckBoxSimmulieren.setText("Zum Testen: Das Starten externer Programme nur simulieren");
        this.jCheckBoxMax.setText("Programmfenster maximiert starten");
        this.jLabel1.setText("Look and Feel:");
        this.jComboBoxLook.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel5.setText("User-Agent:");
        this.jButtonStandard.setText("R\u00fccksetzen");
        this.jButtonHilfe.setText("Hilfe");
        this.jSeparator2.setOpaque(true);
        this.jCheckBoxHinweise.setText("Hinweise anzeigen");
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 782, Short.MAX_VALUE).addComponent(this.jCheckBoxMax).addComponent(this.jCheckBoxSimmulieren).addComponent(this.jCheckBoxHinweise).addComponent(this.jCheckBoxFehler).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addComponent(this.jTextFieldUserAgent, -1, 422, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStandard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe)).addComponent(this.jComboBoxLook, 0, 666, Short.MAX_VALUE)))).addContainerGap()));
        jPanel6Layout.linkSize(0, this.jButtonHilfe, this.jButtonStandard);
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jCheckBoxFehler).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxHinweise).addGap(18, 18, 18).addComponent(this.jCheckBoxSimmulieren).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxMax).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxLook, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jTextFieldUserAgent, -2, -1, -2).addComponent(this.jButtonHilfe).addComponent(this.jButtonStandard)).addContainerGap(177, Short.MAX_VALUE)));
        jPanel6Layout.linkSize(1, this.jButtonHilfe, this.jTextFieldUserAgent);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
    }

    private class BeobLook
    implements ActionListener {
        private BeobLook() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Funktionen.setLook(GuiEinstellungen.this.daten, GuiEinstellungen.this.daten.guiMediathek, Integer.parseInt(String.valueOf(GuiEinstellungen.this.jComboBoxLook.getSelectedIndex())))) {
                GuiEinstellungen.this.daten.system[1] = String.valueOf(GuiEinstellungen.this.jComboBoxLook.getSelectedIndex());
                GuiEinstellungen.this.daten.setGeaendert();
            } else {
                GuiEinstellungen.this.daten.system[1] = "1";
                GuiEinstellungen.this.jComboBoxLook.setSelectedIndex(1);
                Funktionen.setLook(GuiEinstellungen.this.daten, GuiEinstellungen.this.daten.guiMediathek, 1);
            }
        }
    }

    private class BeobUserAgent
    implements DocumentListener {
        private BeobUserAgent() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            GuiEinstellungen.this.daten.system[3] = GuiEinstellungen.this.jTextFieldUserAgent.getText();
            GuiEinstellungen.this.daten.setGeaendert();
        }
    }

    private class BeobachterSimmulieren
    implements ActionListener {
        private BeobachterSimmulieren() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.simmulieren = GuiEinstellungen.this.jCheckBoxSimmulieren.isSelected();
        }
    }

    private class BeobCheckboxSender
    implements ActionListener {
        private int nr;

        public BeobCheckboxSender(int nnr) {
            this.nr = nnr;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.mediathekListe.get((int)this.nr).senderOn = ((JCheckBox)e.getSource()).isSelected();
            GuiEinstellungen.this.daten.setGeaendert();
        }
    }

    private class BeobCheckboxMax
    implements ActionListener {
        private BeobCheckboxMax() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.system[2] = Boolean.toString(GuiEinstellungen.this.jCheckBoxMax.isSelected());
            GuiEinstellungen.this.daten.setGeaendert();
        }
    }

    private class BeobHinweise
    implements ActionListener {
        private BeobHinweise() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.system[41] = Boolean.toString(GuiEinstellungen.this.jCheckBoxHinweise.isSelected());
            GuiEinstellungen.this.daten.setGeaendert();
        }
    }

    private class BeobCheckboxFehler
    implements ActionListener {
        private BeobCheckboxFehler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.system[0] = Boolean.toString(GuiEinstellungen.this.jCheckBoxFehler.isSelected());
            GuiEinstellungen.this.daten.setGeaendert();
        }
    }

    private class BeobachterCheckbox
    implements ActionListener {
        private BeobachterCheckbox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiEinstellungen.this.daten.system[10] = Boolean.toString(GuiEinstellungen.this.jCheckBoxPodcast.isSelected());
            GuiEinstellungen.this.daten.system[7] = Boolean.toString(GuiEinstellungen.this.jCheckBoxAbo.isSelected());
            GuiEinstellungen.this.daten.system[5] = String.valueOf(GuiEinstellungen.this.daten.guiMediathek.getSize().width);
            GuiEinstellungen.this.daten.system[6] = String.valueOf(GuiEinstellungen.this.daten.guiMediathek.getSize().height);
            GuiEinstellungen.this.daten.setGeaendert();
            GuiEinstellungen.this.daten.guiMediathek.setTabs();
        }
    }
}

