/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.ListeAbo;
import mediathek.gui.dialoge.DialogExport;
import mediathek.io.FilmListener;
import mediathek.io.GetUrl;
import mediathek.io.Mediathek3Sat;
import mediathek.io.MediathekArd;
import mediathek.io.MediathekReader;
import mediathek.io.MediathekZdf;
import org.apache.commons.lang.StringEscapeUtils;

public class ListeFilme
extends LinkedList<DatenFilm>
implements Runnable {
    private Daten daten;
    private TModel model = null;
    private int nr = 0;
    EventListenerList listeners = new EventListenerList();

    public ListeFilme(Daten ddaten) {
        this.daten = ddaten;
    }

    @Override
    public synchronized void clear() {
        this.nr = 0;
        super.clear();
    }

    public void datumSchreiben(boolean loeschen) {
        if (!loeschen) {
            this.daten.filmliste[0] = Funktionen.getJetzt_ddMMyyyy_HHmm();
            this.daten.filmliste[1] = Funktionen.getJetzt_HHMMSS();
            this.daten.filmliste[2] = Funktionen.getHeute_ddMMyyyy();
        } else {
            this.daten.filmliste[0] = "";
            this.daten.filmliste[1] = "";
            this.daten.filmliste[2] = "";
        }
        this.daten.filmliste[3] = String.valueOf(this.daten.listeFilme.size());
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    @Override
    public synchronized boolean add(DatenFilm film) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 4) {
            str = "0" + str;
        }
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2]);
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3]);
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2]);
        film.arr[0] = str;
        return super.add(film);
    }

    public synchronized boolean addOhneEscapeOhneNummer(DatenFilm film) {
        return super.add(film);
    }

    public synchronized boolean addRtmp(DatenFilm film) {
        if (Boolean.parseBoolean(this.daten.system[20]) && film.arr[4].startsWith("rtmp")) {
            film.arr[4] = "-r " + film.arr[4];
        }
        String str = String.valueOf(this.nr++);
        while (str.length() < 4) {
            str = "0" + str;
        }
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2]);
        film.arr[3] = StringEscapeUtils.unescapeHtml(film.arr[3]);
        film.arr[2] = StringEscapeUtils.unescapeHtml(film.arr[2]);
        film.arr[0] = str;
        return super.add(film);
    }

    public synchronized void delThema(String sender, String thema) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (!film.arr[1].equals(sender) || !film.arr[2].equals(thema)) continue;
            it.remove();
        }
    }

    public synchronized void delSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (!film.arr[1].equals(sender)) continue;
            it.remove();
        }
    }

    public synchronized void delOhneSender(String sender) {
        DatenFilm film = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            film = (DatenFilm)it.next();
            if (film.arr[1].equals(sender)) continue;
            it.remove();
        }
    }

    public synchronized TModel getModel(String filterSender, String filterThema, boolean filterExakt, String filterText) {
        if (this.size() == 0) {
            return null;
        }
        ListeFilme liste = new ListeFilme(this.daten);
        for (DatenFilm film : this) {
            if (!ListeAbo.aboPruefen(filterSender, filterThema, filterExakt, filterText, film.arr[1], film.arr[2], film.arr[3])) continue;
            liste.addOhneEscapeOhneNummer(film);
        }
        int max = 17;
        Object[] titel = new String[max];
        for (int i = 0; i < max; ++i) {
            titel[i] = i < 16 ? Konstanten.FILME_COLUMN_NAMES[i] : "Abo";
        }
        this.model = new TModel(liste.getObjectData(), titel);
        return this.model;
    }

    public synchronized TModel getAboModel() {
        this.model = new TModel(this.getAboObjectData(), Konstanten.FILME_COLUMN_NAMES);
        return this.model;
    }

    public synchronized TModel getPodModel() {
        this.model = new TModel(this.getPodObjectData(), Konstanten.FILME_COLUMN_NAMES_POD);
        return this.model;
    }

    @Override
    public void run() {
        this.filmeLaden();
    }

    public void filmeLaden() {
        if (this.daten.system[38].equals("import-datei")) {
            this.notifyStart(1);
            this.pfadLaden(this.daten.system[34], true);
            this.notifyFertig();
        } else if (this.daten.system[38].equals("import-url")) {
            this.notifyStart(1);
            for (int i = 0; i < 10 && !this.pfadLaden(this.daten.system[35], false); ++i) {
                this.daten.system[35] = this.daten.listeFilmUpdate.getRand(i);
                this.daten.setGeaendertSofort();
            }
            if (this.daten.listeFilme.isEmpty()) {
                this.daten.fehler.fehlerMeldung("Filme laden", "Es konnten keine Filme geladen werden!");
            }
            this.notifyFertig();
        } else if (this.daten.listeFilme.isOneSenderOn()) {
            this.daten.listeFilme.filmeBeimSenderLaden();
        } else {
            this.notifyFertig();
            JOptionPane.showMessageDialog(null, "Kein Sender zum Laden ausgew\u00e4hlt!");
        }
    }

    private boolean pfadLaden(String pfad, boolean boolDatei) {
        boolean ret = false;
        try {
            if (pfad.equals("")) {
                JOptionPane.showMessageDialog(null, "Keine Datei/Url angegeben", "Pfad", 1);
            } else {
                this.daten.listeFilme.clear();
                ret = this.daten.ioXml.importDatenFilme(pfad, pfad.endsWith(".zip") || pfad.endsWith(".Zip") || pfad.endsWith(".ZIP"), boolDatei);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return ret;
    }

    public synchronized boolean filmeBeimSenderLaden() {
        boolean ret = this.isOneSenderOn();
        this.daten.setGeaendert();
        this.clear();
        this.nr = 0;
        GetUrl.stop = false;
        this.daten.seitenZaehlerLoeschen();
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            new Thread((Runnable)it.next()).start();
        }
        return ret;
    }

    public boolean isOneSenderOn() {
        boolean ret = false;
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            if (!((MediathekReader)it.next()).senderOn) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public synchronized String[] getModelOfField(int feld, String filterString, int filterFeld) {
        LinkedList<String> list = new LinkedList<String>();
        String str = "";
        list.add("");
        Iterator it = this.iterator();
        if (filterString.equals("")) {
            while (it.hasNext()) {
                str = ((DatenFilm)it.next()).arr[feld];
                if (list.contains(str)) continue;
                list.add(str);
            }
        } else {
            while (it.hasNext()) {
                DatenFilm film = (DatenFilm)it.next();
                str = film.arr[feld];
                if (!film.arr[filterFeld].equals(filterString) || list.contains(str)) continue;
                list.add(str);
            }
        }
        Funktionen.listeSort(list);
        String[] ret = new String[]{};
        ret = list.toArray(ret);
        return ret;
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (!f.arr[4].equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    public synchronized void leitungAendern() {
        for (DatenFilm film : this.daten.listeFilme) {
            if (film.arr[1].equals("3Sat")) {
                film.arr[4] = Mediathek3Sat.leitungAendern(this.daten, film);
                continue;
            }
            if (!film.arr[1].equals("Zdf")) continue;
            film.arr[4] = MediathekZdf.leitungAendern(this.daten, film);
        }
    }

    public synchronized void rtmpAendern() {
        String RTMP = "-r ";
        String RTMP_PRTOKOLL = "rtmp";
        for (DatenFilm film : this.daten.listeFilme) {
            if (film.arr[1].equals("Ard")) {
                film.arr[4] = MediathekArd.rtmpAendern(this.daten, film.arr[5], film.arr[7]);
                continue;
            }
            if (Boolean.parseBoolean(this.daten.system[20])) {
                if (!film.arr[4].startsWith("rtmp")) continue;
                film.arr[4] = "-r " + film.arr[4];
                continue;
            }
            if (!film.arr[4].startsWith("-r ")) continue;
            film.arr[4] = film.arr[4].substring("-r ".length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void listeSpeichern() {
        File f;
        OutputStreamWriter writer = null;
        DialogExport dialog = new DialogExport(null, true, this.daten, this.daten.system[33]);
        dialog.setVisible(true);
        if (dialog.ok && (!(f = new File(dialog.ziel)).exists() || JOptionPane.showConfirmDialog(null, "Trotzdem anlegen und \u00fcberschreiben?", "Datei existiert bereits!", 0) == 0)) {
            try {
                this.daten.system[33] = dialog.ziel;
                writer = new OutputStreamWriter(new FileOutputStream(f));
                for (DatenFilm film : this) {
                    writer.write("Sender: " + film.arr[1] + "\n" + "    Thema: " + film.arr[2] + "\n" + "    Titel: " + film.arr[3] + "\n" + "    Url: " + film.arr[4] + "\n");
                }
            }
            catch (Exception ex) {
                new Fehler(this.daten).fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    new Fehler(this.daten).fehlerMeldung(ex, "GuiAbo.zeileSchreiben");
                }
            }
        }
    }

    private Object[][] getObjectData() {
        Object[][] object = null;
        int i = 0;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            int objLen = 17;
            object = new Object[this.size()][objLen];
            while (iterator.hasNext()) {
                DatenFilm film = (DatenFilm)iterator.next();
                for (int k = 0; k < objLen; ++k) {
                    DatenAbo datenAbo;
                    object[i][k] = k < 16 ? film.arr[k] : ((datenAbo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3])) != null ? datenAbo.arr[1] : "");
                }
                ++i;
            }
        }
        return object;
    }

    private Object[][] getAboObjectData() {
        DatenFilm film;
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        String zielPfad = "";
        String zielDateiname = "";
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            DatenAbo abo;
            film = (DatenFilm)itFilm.next();
            if (this.daten.log.zeilePruefen(film.arr[4], ".mediathek_zdf_log") || (abo = this.daten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3])) == null) continue;
            abo.arr[7] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            this.daten.setGeaendert();
            if (this.checkListe(liste, film.arr[4])) continue;
            DatenPgruppe gruppe = this.daten.listePgruppeAbo.getName(abo.arr[8]);
            if (gruppe != null) {
                DatenProg datenProg = gruppe.getProgUrl(film.arr[4]);
                if (datenProg != null) {
                    film.arr[14] = gruppe.checkDownloadDirekt(this.daten, film.arr[4]) == 3 ? "direkter Download" : datenProg.arr[0];
                }
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
            }
            zielPfad = abo.aboPfadAnhaengen(this.daten, zielPfad);
            zielDateiname = film.dateiNamenBauen(zielPfad, zielDateiname);
            liste.add(film);
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][16];
            itFilm = liste.listIterator();
            int i = 0;
            while (itFilm.hasNext()) {
                film = (DatenFilm)itFilm.next();
                object[i] = film.arr;
                ++i;
            }
        }
        return object;
    }

    private Object[][] getPodObjectData() {
        LinkedList<DatenFilm> liste = new LinkedList<DatenFilm>();
        Object[][] object = null;
        int i = 0;
        ListIterator itFilm = this.listIterator(0);
        while (itFilm.hasNext()) {
            DatenFilm film = (DatenFilm)itFilm.next();
            String zielpfad = this.daten.listePod.getZiel(film.arr[2]);
            if (zielpfad == null || this.daten.log.zeilePruefen(film.arr[4], ".mediathek_podder_log") || this.checkListe(liste, film.arr[4])) continue;
            zielpfad = Funktionen.addsPfad(this.daten, this.daten.system[11], zielpfad);
            film.dateiNamenBauen(zielpfad, film.arr[10]);
            liste.add(film);
        }
        if (liste.size() > 0) {
            object = new Object[liste.size()][16];
            itFilm = liste.listIterator();
            while (itFilm.hasNext()) {
                object[i] = ((DatenFilm)itFilm.next()).arr;
                ++i;
            }
        }
        return object;
    }

    private boolean checkListe(LinkedList<DatenFilm> liste, String url) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!url.equals(film.arr[4])) continue;
            ret = true;
            break;
        }
        return ret;
    }

    void notifyStart(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start("", max);
        }
    }

    void notifyFertig() {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig("", false);
        }
    }
}

