/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;

public class ListeFilmUpdate
extends LinkedList<DatenFilmUpdate> {
    public LinkedList<DatenFilmUpdate> alle = new LinkedList();
    private Daten daten;
    private Random random = new Random();

    public ListeFilmUpdate(Daten ddaten) {
        this.daten = ddaten;
    }

    public void sort() {
        Collections.sort(this);
    }

    public boolean addAlle(DatenFilmUpdate film) {
        boolean ret = true;
        Object tmp = null;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            if (!((DatenFilmUpdate)it.next()).arr[0].equals(film.arr[0])) continue;
            return false;
        }
        ret = this.alle.add(film);
        if (this.check20_(film.arr[0])) {
            this.addCheckSort(film);
        }
        return ret;
    }

    public void addCheckSort(DatenFilmUpdate film) {
        DatenFilmUpdate tmp = null;
        ListIterator it = this.listIterator();
        boolean found = false;
        while (it.hasNext()) {
            tmp = (DatenFilmUpdate)it.next();
            boolean r = tmp.arr[1].equals(film.arr[1]);
            r = tmp.arr[2].equals(film.arr[2]);
            if (tmp.arr[1].compareTo(film.arr[1]) < 0) {
                super.add(it.previousIndex(), film);
                found = true;
                break;
            }
            if (tmp.arr[1].compareTo(film.arr[1]) != 0 || tmp.arr[2].compareTo(film.arr[2]) >= 0) continue;
            super.add(it.previousIndex(), film);
            found = true;
            break;
        }
        if (!found) {
            super.add(film);
        }
    }

    public void check20() {
        DatenFilmUpdate tmp = null;
        this.clear();
        ListIterator it = this.alle.listIterator();
        while (it.hasNext()) {
            tmp = (DatenFilmUpdate)it.next();
            if (!this.check20_(tmp.arr[0])) continue;
            this.addCheckSort(tmp);
        }
    }

    private boolean check20_(String url) {
        boolean ret = false;
        if (Boolean.parseBoolean(this.daten.system[49])) {
            String sub = url.substring(url.length() - 6);
            if (sub.compareTo("20.zip") >= 0 || sub.compareTo("04.zip") <= 0) {
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public String[][] getTableObjectData() {
        ListIterator iterator = this.listIterator();
        String[][] object = new String[this.size()][5];
        int i = 0;
        while (iterator.hasNext()) {
            DatenFilmUpdate filmUpdate = (DatenFilmUpdate)iterator.next();
            object[i] = filmUpdate.arr;
            ++i;
        }
        return object;
    }

    public int getNr(String url) {
        int nr = 0;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext() && !((DatenFilmUpdate)iterator.next()).arr[0].equals(url)) {
            ++nr;
        }
        if (nr >= this.size()) {
            nr = 0;
        }
        return nr;
    }

    public DatenFilmUpdate getNrUpdate(String url) {
        DatenFilmUpdate update = null;
        ListIterator iterator = this.listIterator();
        while (iterator.hasNext()) {
            update = (DatenFilmUpdate)iterator.next();
            if (!update.arr[0].equals(url)) continue;
            return update;
        }
        return null;
    }

    public String getRand(int errcount) {
        int MAXMINUTEN = 130;
        int minCount = 1;
        if (errcount > 0) {
            minCount = 2 * errcount;
        }
        String ret = "";
        if (!this.isEmpty()) {
            DatenFilmUpdate film2 = null;
            ListeFilmUpdate listePrio = new ListeFilmUpdate(this.daten);
            ListeFilmUpdate listeZeit = new ListeFilmUpdate(this.daten);
            Iterator it = this.iterator();
            Date today = new Date(System.currentTimeMillis());
            String date = "";
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            int minuten = 200;
            int count = 0;
            while (it.hasNext()) {
                film2 = (DatenFilmUpdate)it.next();
                date = film2.arr[1] + " " + film2.arr[2];
                try {
                    Date d = sdf.parse(date);
                    minuten = Math.round((today.getTime() - d.getTime()) / 60000L);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                if (minuten < 130) {
                    listeZeit.add(film2);
                    ++count;
                    continue;
                }
                if (count >= minCount) continue;
                listeZeit.add(film2);
                ++count;
            }
            for (DatenFilmUpdate film2 : listeZeit) {
                if (film2.arr[4].equals("1")) {
                    listePrio.add(film2.getCopy());
                    listePrio.add(film2.getCopy());
                    continue;
                }
                listePrio.add(film2.getCopy());
            }
            int nr = this.random.nextInt(listePrio.size());
            film2 = (DatenFilmUpdate)listePrio.get(nr);
            ret = film2.arr[0];
        }
        return ret;
    }
}

