/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.io.File;
import java.util.LinkedList;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.ListeAbo;
import mediathek.daten.ListeFilmUpdate;
import mediathek.daten.ListeFilme;
import mediathek.daten.ListePgruppe;
import mediathek.daten.ListePod;
import mediathek.daten.ListePodster;
import mediathek.daten.ListeProg;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiMediathek;
import mediathek.gui.GuiPodder;
import mediathek.gui.PanelListe;
import mediathek.gui.dialoge.DialogFehler;
import mediathek.gui.dialoge.DialogLog;
import mediathek.io.FeedReaderPods;
import mediathek.io.FeedReaderPodster;
import mediathek.io.IoXml;
import mediathek.io.Log;
import mediathek.io.Mediathek3Sat;
import mediathek.io.MediathekArd;
import mediathek.io.MediathekArdPodcast;
import mediathek.io.MediathekArte7;
import mediathek.io.MediathekMdr;
import mediathek.io.MediathekNdr;
import mediathek.io.MediathekOrf;
import mediathek.io.MediathekReader;
import mediathek.io.MediathekSf;
import mediathek.io.MediathekWdr;
import mediathek.io.MediathekZdf;
import mediathek.io.starter.StarterClass;

public class Daten {
    public ListeFilme listeFilme;
    public ListePgruppe listePgruppeButton;
    public ListePgruppe listePgruppeAbo;
    public ListeProg listeProgVorlagen;
    public ListeAbo listeAbo;
    public ListePod listePod;
    public ListePodster listePodster;
    public ListeFilmUpdate listeFilmUpdate;
    public Log log;
    public IoXml ioXml;
    public String[] system;
    public String[] filmliste;
    public GuiMediathek guiMediathek;
    public GuiPodder guiPodder;
    public GuiAbo guiAbo;
    public StarterClass starterClass;
    private boolean geaendert;
    private String basisverzeichnis;
    public PanelListe panelListe;
    public Boolean simmulieren = false;
    public DialogLog dialogLog = null;
    public DialogFehler dialogFehler = null;
    public boolean debug = false;
    public boolean progAusgabe = false;
    public boolean auto = false;
    public boolean noGui = false;
    public LinkedList<MediathekReader> mediathekListe = new LinkedList();
    public FeedReaderPods feedReaderPods;
    public boolean keinFehlerFenster = false;
    public Fehler fehler;
    public FeedReaderPodster feedReaderPodster = null;
    public int seitenZaehler = 0;
    public int seitenZaehlerGesamt = 0;
    public int[] seitenSender = null;

    public Daten(String basis, boolean ddebug, GuiMediathek gguiMediathek, boolean nnoGui) {
        int i;
        this.basisverzeichnis = basis;
        this.debug = ddebug;
        this.noGui = nnoGui;
        this.fehler = new Fehler(this);
        this.guiMediathek = gguiMediathek;
        this.panelListe = new PanelListe(this);
        this.listeFilme = new ListeFilme(this);
        this.listePgruppeButton = new ListePgruppe();
        this.listePgruppeAbo = new ListePgruppe();
        this.listeProgVorlagen = new ListeProg();
        this.listeAbo = new ListeAbo(this);
        this.listePod = new ListePod();
        this.listePodster = new ListePodster();
        this.listeFilmUpdate = new ListeFilmUpdate(this);
        this.seitenSender = new int[Konstanten.SENDER_LISTE.length];
        this.geaendert = false;
        this.system = new String[50];
        for (i = 0; i < this.system.length; ++i) {
            this.system[i] = "";
        }
        this.filmliste = new String[4];
        for (i = 0; i < this.filmliste.length; ++i) {
            this.filmliste[i] = "";
        }
        this.feedReaderPodster = new FeedReaderPodster(this);
        this.feedReaderPods = new FeedReaderPods(this);
        this.mediathekListe.add(new MediathekArdPodcast(this));
        this.mediathekListe.add(new MediathekNdr(this));
        this.mediathekListe.add(new MediathekArd(this));
        this.mediathekListe.add(new MediathekMdr(this));
        this.mediathekListe.add(new MediathekZdf(this));
        this.mediathekListe.add(new MediathekWdr(this));
        this.mediathekListe.add(new MediathekArte7(this));
        this.mediathekListe.add(new MediathekOrf(this));
        this.mediathekListe.add(new Mediathek3Sat(this));
        this.mediathekListe.add(new MediathekSf(this));
        this.system[24] = "20";
        this.system[25] = "dsl2000";
        this.system[26] = Boolean.toString(false);
        this.system[19] = "dsl2000";
        this.system[17] = "2";
        this.system[42] = "1";
        this.system[3] = Funktionen.getStandardUserAgent();
        this.log = new Log(this);
        this.ioXml = new IoXml(this);
        this.ioXml.datenLesen();
        if (!this.noGui) {
            this.dialogFehler = new DialogFehler(this);
        }
        this.starterClass = new StarterClass(this);
        Funktionen.addProgVorlagen(this);
        if (this.system[42].equals("")) {
            this.system[42] = "1";
        }
        if (this.system[27].equals("")) {
            this.system[27] = Boolean.toString(true);
        }
        if (this.system[41].equals("")) {
            this.system[41] = Boolean.toString(true);
        }
        if (this.system[1].equals("")) {
            this.system[1] = "1";
        }
        if (this.system[20].equals("")) {
            this.system[20] = Boolean.toString(true);
        }
        if (this.system[48].equals("")) {
            this.system[48] = Boolean.toString(true);
        }
        if (this.system[46].equals("")) {
            this.system[46] = Boolean.toString(true);
        }
        if (!this.system[4].equals("2.3.0")) {
            this.system[3] = Funktionen.getStandardUserAgent();
            this.system[4] = "2.3.0";
            this.system[38] = "import-url";
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathek.perfectz.info/Mediathek_22.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.xml.in/mediathek-00_00.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://usrmed.netfast.org/mediathek-00_00.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.xml.in/mediathek-00_02.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.mezoka.com/mediathek-00_04.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.spaceydu.de/mediathek-00_06.zip\t", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathek.000a.de/Mediathek_10.zip", "1"));
            this.listeFilmUpdate.add(new DatenFilmUpdate("http://mediathekview.heim.at/mediathek-00_14.zip", "1"));
            this.system[35] = this.listeFilmUpdate.getRand(0);
            this.setGeaendertSofort();
        }
    }

    public MediathekReader getMedReader(String sender) {
        MediathekReader ret2 = null;
        if (!sender.equals("")) {
            for (MediathekReader ret2 : this.mediathekListe) {
                if (!ret2.sender.equals(sender)) continue;
                break;
            }
        }
        return ret2;
    }

    public void incSeitenZaehler(String sender) {
        ++this.seitenZaehler;
        ++this.seitenZaehlerGesamt;
        for (int i = 0; i < Konstanten.SENDER_LISTE.length; ++i) {
            if (!Konstanten.SENDER_LISTE[i].equals(sender)) continue;
            int n = i;
            this.seitenSender[n] = this.seitenSender[n] + 1;
            break;
        }
    }

    public void seitenZaehlerLoeschen() {
        this.seitenZaehler = 0;
        int i = 0;
        if (i < Konstanten.SENDER_LISTE.length) {
            this.seitenSender[i] = 0;
        }
    }

    public int getSeitenZaehler(String sender) {
        for (int i = 0; i < Konstanten.SENDER_LISTE.length; ++i) {
            if (!Konstanten.SENDER_LISTE[i].equals(sender)) continue;
            return this.seitenSender[i];
        }
        return 0;
    }

    public void seitenSenderSchreiben(String sender) {
        for (int i = 0; i < Konstanten.SENDER_LISTE.length; ++i) {
            if (!Konstanten.SENDER_LISTE[i].equals(sender)) continue;
            System.out.println("Sender " + sender + ": " + this.seitenSender[i] + " Seiten");
            break;
        }
    }

    public void setGeaendert() {
        this.panelListe.aendern();
        this.geaendert = true;
    }

    public void setGeaendertSofort() {
        this.panelListe.aendern();
        this.panelListe.aendernSofort();
        this.geaendert = true;
    }

    public void setGeaendertOhnePanel() {
        this.geaendert = true;
    }

    public boolean isGeaendert() {
        return this.geaendert;
    }

    public void speichern() {
        this.ioXml.datenSchreiben();
    }

    public void allesAbbrechen() {
        if (this.starterClass != null) {
            this.starterClass.abbrechen();
        }
    }

    public void allesAbbrechenNachFilm() {
        if (this.starterClass != null) {
            this.starterClass.abbrechenNachFilm();
        }
    }

    public String getBasisVerzeichnis() {
        return this.getBasisVerzeichnis(false);
    }

    public String getBasisVerzeichnis(boolean anlegen) {
        File basis;
        String ret = this.basisverzeichnis.equals("") ? System.getProperty("user.home") + File.separator + ".mediathek" + File.separator : this.basisverzeichnis;
        if (anlegen && !(basis = new File(ret)).exists() && !basis.mkdir()) {
            new Fehler(this).fehlerMeldung("Fehler!", new String[]{"Kann den Ordner zum Speichern der Daten nicht anlegen!", "Daten.getBasisVerzeichnis"});
        }
        return ret;
    }
}

