/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io.starter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.Hinweis;
import mediathek.HinweisKeineAuswahl;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.gui.dialoge.DialogZiel;
import mediathek.io.starter.ListeStarts;
import mediathek.io.starter.RuntimeExec;
import mediathek.io.starter.RuntimeExecEvent;
import mediathek.io.starter.RuntimeListener;
import mediathek.io.starter.StartEvent;
import mediathek.io.starter.StartListener;
import mediathek.io.starter.Starts;

public class StarterClass {
    private Daten daten;
    private boolean allesStop = false;
    private ListeStarts listeStarts;
    private Starten starten = null;
    private EventListenerList listeners = new EventListenerList();

    public StarterClass(Daten d) {
        this.daten = d;
        this.listeners = new EventListenerList();
        this.listeStarts = new ListeStarts(this.daten);
        this.starten = new Starten();
        Thread startenThread = new Thread(this.starten);
        startenThread.setDaemon(true);
        startenThread.start();
    }

    public boolean urlStarten(String url, int open, DatenFilm ersterFilm, RuntimeListener listener) {
        boolean ret = false;
        String befehlsString = "";
        String zielDateiname = "";
        String zielPfad = "";
        String zielPfadDatei = "";
        int art = 0;
        if (!url.equals("")) {
            DatenPgruppe gruppe = (DatenPgruppe)this.daten.listePgruppeButton.get(open);
            DatenProg prog = gruppe.getProgUrl(url);
            if (prog != null) {
                befehlsString = prog.getBegehl();
                if ((url.startsWith("-r") || url.startsWith("rtmp") || url.startsWith("--host")) && !befehlsString.contains("flvstreamer") && !befehlsString.contains("rtmpdump")) {
                    new Hinweis(this.daten).hinweisFlash();
                }
                zielDateiname = gruppe.getZielDateiname();
                zielPfad = gruppe.getZielPfad();
                art = gruppe.checkDownloadDirekt(this.daten, url);
                if (!zielDateiname.equals("")) {
                    if (zielDateiname.contains("%p")) {
                        DialogZiel dialog = new DialogZiel(null, true, this.daten, befehlsString.contains("%p") ? "" : null, Funktionen.getDateiName(this.daten, ersterFilm.arr[4]));
                        dialog.setVisible(true);
                        if (!dialog.ok) {
                            return false;
                        }
                        zielDateiname = zielDateiname.replace("%p", dialog.zielDateiname);
                        zielPfad = dialog.zielPfad;
                    } else if (zielDateiname.contains("%n")) {
                        String str = JOptionPane.showInputDialog("Dateiname eingeben", (Object)Funktionen.getDateiName(this.daten, ersterFilm.arr[4]));
                        if (str == null) {
                            return false;
                        }
                        zielDateiname = zielDateiname.replace("%n", Funktionen.replaceLeerDateiname(str, true));
                    }
                    if (zielPfad.equals("")) {
                        JOptionPane.showMessageDialog(null, "Zielpfad angeben!", "Pfad leer", 1);
                    }
                    zielPfadDatei = ersterFilm.dateiNamenBauen(zielPfad, zielDateiname);
                    befehlsString = Funktionen.getBefhelsString(befehlsString, zielPfadDatei, url, ersterFilm);
                } else {
                    befehlsString = befehlsString.replace("%f", url);
                }
                ret = true;
                this.daten.starterClass.startDirekt(new Starts(ersterFilm, art, befehlsString, Boolean.parseBoolean(prog.arr[5])), listener);
            }
        } else {
            new HinweisKeineAuswahl();
        }
        return ret;
    }

    public TModel getStarterModell() {
        return this.listeStarts.getModel();
    }

    public void addListener(StartListener listener) {
        this.listeners.add(StartListener.class, listener);
    }

    public void startDirekt(Starts starts, RuntimeListener listener) {
        if (starts.art == 2) {
            ZdfStarten zdfStarten = new ZdfStarten(starts, true);
            if (listener != null) {
                this.listeners.add(RuntimeListener.class, listener);
            }
            new Thread(zdfStarten).start();
        } else {
            PodderStart podderStart = new PodderStart(starts, true);
            if (listener != null) {
                this.listeners.add(RuntimeListener.class, listener);
            }
            new Thread(podderStart).start();
        }
    }

    public synchronized void addListe(LinkedList<Starts> starts) {
        this.allesStop = false;
        if (starts != null) {
            ListIterator<Starts> it = starts.listIterator(0);
            while (it.hasNext()) {
                Starts s = it.next();
                if (this.listeStarts.contain(s)) continue;
                this.listeStarts.add(s);
            }
            this.notifyStartEvent();
        }
    }

    public int getState(String url) {
        int ret = 0;
        ListIterator it = this.listeStarts.listIterator(0);
        while (it.hasNext()) {
            Starts s = (Starts)it.next();
            if (!s.film.arr[4].equals(url)) continue;
            ret = s.status;
            break;
        }
        return ret;
    }

    public synchronized void aufraeumen(int startArt) {
        ListIterator it = this.listeStarts.listIterator(0);
        while (it.hasNext()) {
            Starts start = (Starts)it.next();
            if (start.status < 3 || start.art != startArt) continue;
            it.remove();
        }
        this.notifyStartEvent();
    }

    public void abbrechen() {
        this.allesStop = true;
        this.notifyStartEvent();
    }

    public void abbrechenNachFilm() {
        this.listeStarts.delRest();
        this.notifyStartEvent();
    }

    public void filmLoeschen(String url) {
        this.listeStarts.delStart(url);
        this.notifyStartEvent();
    }

    private void notifyStartEvent() {
        int down = 0;
        int progr = 0;
        int max = this.listeStarts.getmax();
        for (int i = 0; i < this.listeStarts.size(); ++i) {
            Starts s = this.listeStarts.get(i);
            if (s.status == 2) {
                ++down;
            }
            if (s.status < 3) continue;
            ++progr;
        }
        StartEvent event = new StartEvent(this, down, progr, max, this.allesStop);
        for (StartListener l : (StartListener[])this.listeners.getListeners(StartListener.class)) {
            l.starter(event);
        }
    }

    private void notifyRuntimeEvent() {
        RuntimeExecEvent eventr = new RuntimeExecEvent(this);
        for (RuntimeListener l : (RuntimeListener[])this.listeners.getListeners(RuntimeListener.class)) {
            l.starter(eventr);
        }
    }

    private synchronized Starts getListe() {
        Starts s;
        Starts ret = null;
        if (this.allesStop) {
            ListIterator it = this.listeStarts.listIterator(0);
            while (it.hasNext()) {
                Starts s2 = (Starts)it.next();
                if (s2.status >= 3) continue;
                it.remove();
            }
        } else if (this.listeStarts.size() >= 0 && this.listeStarts.getDown() < Integer.parseInt(this.daten.system[17]) && (s = this.naechsterStart()) != null && s.status == 1) {
            ret = s;
            ret.status = 2;
        }
        return ret;
    }

    private Starts naechsterStart() {
        Starts s = null;
        ListIterator it = this.listeStarts.listIterator(0);
        while (it.hasNext()) {
            s = (Starts)it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 1)) continue;
            return s;
        }
        it = this.listeStarts.listIterator(0);
        while (it.hasNext()) {
            s = (Starts)it.next();
            if (s.status != 1 || this.maxSenderLaufen(s, 2)) continue;
            return s;
        }
        return null;
    }

    private boolean maxSenderLaufen(Starts s, int max) {
        int counter = 0;
        Starts start = null;
        String sender = s.film.arr[1];
        ListIterator it = this.listeStarts.listIterator(0);
        while (it.hasNext()) {
            start = (Starts)it.next();
            if (start.status != 2 || !start.film.arr[1].equals(sender) || ++counter < max) continue;
            return true;
        }
        return false;
    }

    private boolean pruefen(Starts starts) {
        boolean ret = false;
        String logfile = "";
        logfile = starts.art == 2 || starts.art == 3 ? ".mediathek_zdf_log" : ".mediathek_podder_log";
        File file = new File(starts.film.arr[13]);
        if (!file.exists()) {
            new Fehler(this.daten).fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[13]);
        } else if (file.length() < 2048L) {
            new Fehler(this.daten).fehlerMeldung("Fehler!", "Download fehlgeschlagen: " + starts.film.arr[13]);
        } else {
            this.daten.log.zeileSchreiben(starts.film.arr[4], logfile);
            ret = true;
        }
        return ret;
    }

    private class PodderStart
    implements Runnable {
        Starts starts;
        Boolean filmDownload = false;

        public PodderStart(Starts s) {
            this.starts = s;
        }

        public PodderStart(Starts s, boolean ffilmDownload) {
            this.starts = s;
            this.filmDownload = ffilmDownload;
        }

        @Override
        public void run() {
            InputStream input = null;
            FileOutputStream destStream = null;
            try {
                int len;
                new File(this.starts.film.arr[12]).mkdirs();
                URL feedUrl = new URL(this.starts.film.arr[4]);
                input = feedUrl.openStream();
                byte[] buffer = new byte[1024];
                destStream = new FileOutputStream(this.starts.film.arr[13]);
                while ((len = input.read(buffer)) != -1) {
                    ((OutputStream)destStream).write(buffer, 0, len);
                    if (!StarterClass.this.allesStop) continue;
                }
                input.close();
                ((OutputStream)destStream).close();
            }
            catch (Exception e) {
                new Fehler(StarterClass.this.daten).fehlerMeldung(e, "StarterClass.PodderStart-1");
            }
            try {
                if (StarterClass.this.allesStop) {
                    new File(this.starts.film.arr[13]).delete();
                } else {
                    this.starts.status = StarterClass.this.pruefen(this.starts) ? 3 : 4;
                }
            }
            catch (Exception e) {
                new Fehler(StarterClass.this.daten).fehlerMeldung(e, "StarterClass.PodderStart-2");
            }
            if (this.filmDownload.booleanValue()) {
                StarterClass.this.notifyRuntimeEvent();
            } else {
                StarterClass.this.notifyStartEvent();
            }
        }
    }

    private class ZdfStarten
    implements Runnable {
        Starts starts;
        RuntimeExec runtimeExec;
        boolean button = false;

        public ZdfStarten(Starts s, boolean bbutton) {
            this.starts = s;
            this.button = bbutton;
            try {
                new File(this.starts.film.arr[12]).mkdirs();
            }
            catch (Exception ex) {
                new Fehler(StarterClass.this.daten).fehlerMeldung(ex, "StarterClass.ZdfStarten.run");
            }
        }

        @Override
        public synchronized void run() {
            int k = 0;
            long filesize = -1L;
            boolean restart = false;
            boolean startOk = false;
            if (this.starten()) {
                restart = true;
            }
            while (restart) {
                startOk = false;
                restart = false;
                while (!StarterClass.this.allesStop) {
                    try {
                        k = this.starts.process.exitValue();
                        break;
                    }
                    catch (Exception ex) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                if (StarterClass.this.allesStop) {
                    if (this.starts.process == null) continue;
                    this.starts.process.destroy();
                    this.starts.status = 1;
                    new File(this.starts.film.arr[13]).delete();
                    continue;
                }
                if (k != 0) {
                    if (this.starts.restart) {
                        File file;
                        if (filesize == -1L) {
                            file = new File(this.starts.film.arr[13]);
                            if (file.exists()) {
                                filesize = file.length();
                                startOk = true;
                            } else if (this.starts.startcounter < 3) {
                                startOk = true;
                            }
                        } else {
                            file = new File(this.starts.film.arr[13]);
                            if (file.exists() && file.length() > filesize) {
                                startOk = true;
                                filesize = file.length();
                            }
                        }
                        if (startOk && this.starten()) {
                            restart = true;
                            continue;
                        }
                        this.starts.status = 4;
                        continue;
                    }
                    this.starts.status = 4;
                    continue;
                }
                if (this.button) {
                    this.starts.status = 3;
                    continue;
                }
                if (StarterClass.this.pruefen(this.starts)) {
                    this.starts.status = 3;
                    continue;
                }
                this.starts.status = 4;
            }
            if (this.button) {
                StarterClass.this.notifyRuntimeEvent();
            } else {
                StarterClass.this.notifyStartEvent();
            }
        }

        private boolean starten() {
            boolean ret = true;
            this.runtimeExec = new RuntimeExec(StarterClass.this.daten, this.starts);
            this.starts.process = this.runtimeExec.exec();
            if (this.starts.process == null) {
                this.starts.status = 4;
                ret = false;
            } else {
                ++this.starts.startcounter;
            }
            return ret;
        }
    }

    private class Starten
    implements Runnable {
        Starts starts;

        private Starten() {
        }

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        StarterClass.this.notifyStartEvent();
                        block8: while ((this.starts = StarterClass.this.getListe()) != null) {
                            StarterClass.this.notifyStartEvent();
                            switch (this.starts.art) {
                                case 2: {
                                    ZdfStarten zdfStarten = new ZdfStarten(this.starts, false);
                                    new Thread(zdfStarten).start();
                                    this.wait(10000L);
                                    continue block8;
                                }
                                case 1: 
                                case 3: {
                                    PodderStart podderStart = new PodderStart(this.starts);
                                    new Thread(podderStart).start();
                                    this.wait(2000L);
                                    continue block8;
                                }
                            }
                            new Fehler(StarterClass.this.daten).fehlerMeldung("Fehler!", "StarterClass.Starten - Switch-default");
                        }
                        this.wait(3000L);
                    }
                }
                catch (Exception ex) {
                    new Fehler(StarterClass.this.daten).fehlerMeldung(ex, "StarterClass.Starten.run");
                    continue;
                }
                break;
            }
        }
    }
}

