/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import mediathek.Funktionen;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.io.FilmListener;
import mediathek.io.GetUrl;

public class MediathekReader
implements Runnable {
    public String text = "";
    public String sender = "";
    public boolean senderOn = true;
    public JDialog panelEinstellungen = null;
    public int pageCounter = 0;
    int threads = 0;
    boolean stop = false;
    boolean nurAbos = false;
    Daten daten;
    EventListenerList listeners = new EventListenerList();
    LinkedList<String[]> listeThemen = new LinkedList();
    GetUrl getUrlIo;

    public MediathekReader(Daten ddaten) {
        this.daten = ddaten;
        this.getUrlIo = new GetUrl(this.daten);
    }

    public static String leitungAendern(Daten daten, DatenFilm film) {
        return film.arr[5];
    }

    public static String rtmpAendern(Daten daten, String urlorg, String urlRtmp) {
        return urlorg;
    }

    public void addAdListener(FilmListener listener) {
        this.listeners.add(FilmListener.class, listener);
    }

    public void stoppen() {
        this.stop = true;
    }

    @Override
    public void run() {
        this.pageCounter = 0;
        if (this.senderOn) {
            this.stop = false;
            this.threads = 0;
            this.notifyAnfang(1);
            this.addToList();
            this.notifyFertigSofort();
        }
    }

    void addToList() {
    }

    public void setNurAbosLaden() {
        this.nurAbos = true;
    }

    public void addThema(String uurl, String tthema) {
        this.stop = false;
        if (!uurl.equals("") && !tthema.equals("")) {
            this.daten.listeFilme.delThema(this.sender, tthema);
            this.listeThemen.clear();
            String[] add = new String[]{uurl, tthema};
            this.listeThemen.add(add);
            if (this.listeThemen.size() > 0) {
                this.notifyStart(this.listeThemen.size());
                ++this.threads;
                this.themaLaden();
            }
        }
    }

    void themaLaden() {
    }

    void addMax(int max) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.addMax(max);
        }
    }

    void notifyStart(int max) {
        this.daten.fehler.systemMeldung("Starten " + this.sender + ": " + Funktionen.getJetzt_HHMMSS());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(max);
        }
    }

    void notifyAnfang(int max) {
        this.daten.fehler.systemMeldung("Anfang " + this.sender + ": " + Funktionen.getJetzt_HHMMSS());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.start(max);
        }
    }

    void notifyFertig() {
        if (this.threads <= 0) {
            this.daten.fehler.systemMeldung("Fertig " + this.sender + ": " + Funktionen.getJetzt_HHMMSS());
            this.daten.seitenSenderSchreiben(this.sender);
            this.daten.filmliste[0] = !this.stop ? Funktionen.getJetzt_HHMMSS() : "";
            this.daten.filmliste[1] = String.valueOf(this.daten.listeFilme.size());
            for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
                l.fertig(this.stop);
            }
        }
    }

    void notifyFertigSofort() {
        this.daten.filmliste[0] = !this.stop ? Funktionen.getJetzt_HHMMSS() : "";
        this.daten.filmliste[1] = String.valueOf(this.daten.listeFilme.size());
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.fertig(this.stop);
        }
    }

    void notifyProgress(String text) {
        for (FilmListener l : (FilmListener[])this.listeners.getListeners(FilmListener.class)) {
            l.progress(text);
        }
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String[])it.next())[nr].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    synchronized String[] getListeThemen() {
        return this.listeThemen.pollFirst();
    }
}

