/*
 * Decompiled with CFR 0.152.
 */
package mediathek.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import mediathek.Fehler;
import mediathek.Funktionen;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenFilmUpdate;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenPod;
import mediathek.daten.DatenPodster;
import mediathek.daten.DatenProg;
import mediathek.io.MediathekReader;

public class IoXml {
    private XMLOutputFactory outFactory;
    private XMLStreamWriter writer;
    private OutputStreamWriter out = null;
    ZipOutputStream zipOutputStream = null;
    private Daten daten;

    public IoXml(Daten d) {
        this.daten = d;
    }

    public void datenLesen() {
        this.xmlDatenLesen();
        this.xmlDatenLesenFilme();
        this.xmlDatenLesenPodster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importDatenFilme(String datei, boolean zip, boolean istDatei) {
        boolean ret = true;
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        XMLStreamReader parser = null;
        InputStreamReader inReader = null;
        String user_agent = this.daten.system[3];
        int timeout = 30000;
        URLConnection conn = null;
        try {
            if (istDatei) {
                if (zip) {
                    ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(datei));
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                }
            } else {
                conn = new URL(datei).openConnection();
                conn.setRequestProperty("User-Agent", user_agent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                if (zip) {
                    ZipInputStream zipInputStream = new ZipInputStream(conn.getInputStream());
                    zipInputStream.getNextEntry();
                    inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                } else {
                    inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                }
            }
            parser = inFactory.createXMLStreamReader(inReader);
            ret = this.datenLesenFilme(parser, Boolean.parseBoolean(this.daten.system[43]));
        }
        catch (Exception ex) {
            ret = false;
            this.daten.fehler.fehlerMeldung(ex, "Filme importieren von: " + datei);
        }
        finally {
            try {
                if (inReader != null) {
                    inReader.close();
                }
            }
            catch (Exception ex) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean xmlDatenLesen() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".mediathek";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            DatenPgruppe datenPgruppe = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                String t = parser.getLocalName();
                if (parser.getLocalName().equals("System")) {
                    this.get(parser, event, "System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
                    continue;
                }
                if (parser.getLocalName().equals("Senderliste")) {
                    String[] str = new String[this.daten.mediathekListe.size()];
                    this.get(parser, event, "Senderliste", this.getListeSender(), str);
                    this.setSenderOn(str);
                    continue;
                }
                if (parser.getLocalName().equals("Programmgruppe-Abo")) {
                    datenPgruppe = new DatenPgruppe();
                    if (!this.get(parser, event, "Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                    this.daten.listePgruppeAbo.add(datenPgruppe);
                    continue;
                }
                if (parser.getLocalName().equals("Programmgruppe-Button")) {
                    datenPgruppe = new DatenPgruppe();
                    if (!this.get(parser, event, "Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr)) continue;
                    this.daten.listePgruppeButton.add(datenPgruppe);
                    continue;
                }
                if (parser.getLocalName().equals("Programm")) {
                    DatenProg datenProg = new DatenProg();
                    if (!this.get(parser, event, "Programm", Konstanten.PROGRAMM_COLUMN_NAMES, datenProg.arr) || datenPgruppe == null) continue;
                    datenPgruppe.addProg(datenProg);
                    continue;
                }
                if (parser.getLocalName().equals("Abonnement")) {
                    DatenAbo datenAbo = new DatenAbo();
                    if (!this.get(parser, event, "Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr)) continue;
                    this.daten.listeAbo.addAbo(datenAbo);
                    continue;
                }
                if (parser.getLocalName().equals("Pod")) {
                    DatenPod datenPod = new DatenPod();
                    if (!this.get(parser, event, "Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr)) continue;
                    this.daten.listePod.addPod(datenPod);
                    continue;
                }
                if (!parser.getLocalName().equals("Film-Update")) continue;
                DatenFilmUpdate datenFilmUpdate = new DatenFilmUpdate();
                if (!this.get(parser, event, "Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr)) continue;
                this.daten.listeFilmUpdate.add(datenFilmUpdate);
            }
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.datenLesen");
            Funktionen.addStandardprogrammeButton(this.daten);
            Funktionen.addStandardprogrammeAbo(this.daten);
            ret = false;
        }
        finally {
            if (this.daten.listePgruppeAbo.size() == 0) {
                Funktionen.addStandardprogrammeAbo(this.daten);
            }
            if (this.daten.listePgruppeButton.size() == 0) {
                Funktionen.addStandardprogrammeButton(this.daten);
            }
            ret = false;
        }
        return ret;
    }

    private boolean xmlDatenLesenFilme() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".filme";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            ret = this.datenLesenFilme(parser, true);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean xmlDatenLesenPodster() {
        boolean ret = true;
        try {
            String datei = "";
            datei = this.daten.getBasisVerzeichnis(false) + ".podcaster";
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            XMLStreamReader parser = null;
            InputStreamReader in = null;
            in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
            parser = inFactory.createXMLStreamReader(in);
            ret = this.datenLesenPodster(parser);
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenFilme(XMLStreamReader parser, boolean auchAlte) {
        boolean ret = true;
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1 && parser.getLocalName().equals("Filmliste")) {
                    this.get(parser, event, "Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmliste);
                }
                if (event != 1 || !parser.getLocalName().equals("Filme")) continue;
                DatenFilm datenFilm = new DatenFilm(this.daten);
                if (!this.get(parser, event, "Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.arr) || !auchAlte && Boolean.parseBoolean(datenFilm.arr[15])) continue;
                this.daten.listeFilme.add(datenFilm);
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean datenLesenPodster(XMLStreamReader parser) {
        boolean ret = true;
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("Podster")) continue;
                DatenPodster datenPodster = new DatenPodster();
                if (!this.get(parser, event, "Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr)) continue;
                this.daten.listePodster.add(datenPodster);
            }
        }
        catch (Exception ex) {
            ret = false;
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        int i;
        boolean ret = true;
        int maxElem = strRet.length;
        for (i = 0; i < maxElem; ++i) {
            strRet[i] = "";
        }
        try {
            block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (i = 0; i < maxElem; ++i) {
                    if (!parser.getLocalName().equals(xmlNames[i])) continue;
                    strRet[i] = parser.getElementText();
                    continue block3;
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            new Fehler(this.daten).fehlerMeldung(ex, "IoXml.get");
        }
        return ret;
    }

    public synchronized void datenSchreiben() {
        this.xmlDatenSchreiben();
        this.xmlFilmeSchreiben();
        this.xmlPodcastlisteSchreiben();
    }

    public synchronized void filmeSchreiben() {
        this.xmlFilmeSchreiben();
    }

    public synchronized void exportFilme(String datei, boolean zip) {
        try {
            this.daten.fehler.systemMeldung("Filme exportieren nach: " + datei);
            this.xmlSchreibenStart(datei, zip);
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde(zip);
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "Filme exportieren nach: " + datei);
        }
    }

    private void xmlDatenSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Daten schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".mediathek");
            this.xmlSchreibenSystem();
            this.xmlSchreibenProg();
            this.xmlSchreibenAbo();
            this.xmlSchreibenPod();
            this.xmlSchreibenFilmUpdate();
            this.xmlSchreibenEnde();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xmlFilmeSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Filme schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".filme");
            this.xmlSchreibenFilmliste();
            this.xmlSchreibenFilm();
            this.xmlSchreibenEnde();
        }
        catch (Exception ex) {
            this.daten.fehler.fehlerMeldung(ex, "IoXml.xmlFilmeSchreiben");
        }
    }

    private void xmlPodcastlisteSchreiben() {
        try {
            this.daten.fehler.systemMeldung("Podcastliste schreiben!");
            this.xmlSchreibenStart(this.daten.getBasisVerzeichnis(true) + ".podcaster");
            this.xmlSchreibenPodcastliste();
            this.xmlSchreibenEnde();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void xmlSchreibenStart(String datei) throws Exception {
        this.xmlSchreibenStart(datei, false);
    }

    private void xmlSchreibenStart(String datei, boolean zip) throws Exception {
        this.outFactory = XMLOutputFactory.newInstance();
        if (zip) {
            this.zipOutputStream = new ZipOutputStream(new FileOutputStream(datei));
            ZipEntry entry = new ZipEntry(".filme");
            this.zipOutputStream.putNextEntry(entry);
            this.out = new OutputStreamWriter((OutputStream)this.zipOutputStream, "UTF-8");
        } else {
            this.out = new OutputStreamWriter((OutputStream)new FileOutputStream(datei), "UTF-8");
        }
        this.writer = this.outFactory.createXMLStreamWriter(this.out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement("Mediathek");
        this.writer.writeCharacters("\n");
    }

    private void xmlSchreibenSystem() {
        this.xmlSchreibenDaten("System", Konstanten.SYSTEM_COLUMN_NAMES, this.daten.system);
        this.xmlSchreibenDaten("Senderliste", this.getListeSender(), this.getSenderOn());
    }

    private void xmlSchreibenFilmliste() {
        this.xmlSchreibenDaten("Filmliste", Konstanten.FILMLISTE_COLUMN_NAMES, this.daten.filmliste);
    }

    private void xmlSchreibenPodcastliste() {
        ListIterator iterator = this.daten.listePodster.listIterator();
        while (iterator.hasNext()) {
            DatenPodster datenPodster = (DatenPodster)iterator.next();
            this.xmlSchreibenDaten("Podster", Konstanten.PODSTER_COLUMN_NAMES, datenPodster.arr);
        }
    }

    private void xmlSchreibenFilm() {
        ListIterator iterator = this.daten.listeFilme.listIterator();
        while (iterator.hasNext()) {
            DatenFilm datenFilm = (DatenFilm)iterator.next();
            this.xmlSchreibenDaten("Filme", Konstanten.FILME_COLUMN_NAMES, datenFilm.arr);
        }
    }

    private void xmlSchreibenProg() {
        ListIterator it;
        DatenPgruppe datenPgruppe;
        ListIterator iterator = this.daten.listePgruppeAbo.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Abo", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
        iterator = this.daten.listePgruppeButton.listIterator();
        while (iterator.hasNext()) {
            datenPgruppe = (DatenPgruppe)iterator.next();
            this.xmlSchreibenDaten("Programmgruppe-Button", Konstanten.PROGRAMMGRUPPE_COLUMN_NAMES, datenPgruppe.arr);
            it = datenPgruppe.getListeProg().listIterator();
            while (it.hasNext()) {
                this.xmlSchreibenDaten("Programm", Konstanten.PROGRAMM_COLUMN_NAMES, ((DatenProg)it.next()).arr);
            }
        }
    }

    private void xmlSchreibenAbo() {
        ListIterator iterator = this.daten.listeAbo.listIterator();
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            this.xmlSchreibenDaten("Abonnement", Konstanten.ABO_COLUMN_NAMES, datenAbo.arr);
        }
    }

    private void xmlSchreibenPod() {
        ListIterator iterator = this.daten.listePod.listIterator();
        while (iterator.hasNext()) {
            DatenPod datenPod = (DatenPod)iterator.next();
            this.xmlSchreibenDaten("Pod", Konstanten.POD_COLUMN_NAMES, datenPod.arr);
        }
    }

    private void xmlSchreibenFilmUpdate() {
        ListIterator iterator = this.daten.listeFilmUpdate.listIterator();
        while (iterator.hasNext()) {
            DatenFilmUpdate datenFilmUpdate = (DatenFilmUpdate)iterator.next();
            this.xmlSchreibenDaten("Film-Update", Konstanten.FILM_UPDATE_COLUMN_NAMES, datenFilmUpdate.arr);
        }
    }

    private void xmlSchreibenDaten(String xmlName, String[] xmlSpalten, String[] datenArray) {
        int xmlMax = datenArray.length;
        try {
            this.writer.writeStartElement(xmlName);
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].equals("")) continue;
                this.writer.writeStartElement(xmlSpalten[i]);
                this.writer.writeCharacters(datenArray[i]);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (Exception ex) {
            new Fehler(this.daten).fehlerMeldung(ex, "IoXml.xmlSchreibenDaten");
        }
    }

    private void xmlSchreibenEnde() throws Exception {
        this.xmlSchreibenEnde(false);
    }

    private void xmlSchreibenEnde(boolean zip) throws Exception {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
        if (zip) {
            this.zipOutputStream.closeEntry();
            this.writer.close();
            this.zipOutputStream.close();
        } else {
            this.writer.close();
        }
        this.daten.fehler.systemMeldung("geschrieben!");
    }

    private String[] getListeSender() {
        String[] ret = new String[this.daten.mediathekListe.size()];
        Iterator it = this.daten.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = "xml" + ((MediathekReader)it.next()).sender;
            ++i;
        }
        return ret;
    }

    private String[] getSenderOn() {
        String[] ret = new String[this.daten.mediathekListe.size()];
        Iterator it = this.daten.mediathekListe.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = Boolean.toString(((MediathekReader)it.next()).senderOn);
            ++i;
        }
        return ret;
    }

    private void setSenderOn(String[] str) {
        String[] sender = this.getListeSender();
        Iterator it = this.daten.mediathekListe.iterator();
        while (it.hasNext()) {
            for (int i = 0; i < str.length; ++i) {
                MediathekReader reader = (MediathekReader)it.next();
                if (!("xml" + reader.sender).equals(sender[i])) continue;
                reader.senderOn = str[i].equals("") ? true : Boolean.parseBoolean(str[i]);
            }
        }
    }
}

