/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.Fehler;
import mediathek.daten.Daten;

public class DialogZiel
extends JDialog {
    Daten daten;
    public boolean ok = false;
    public String zielPfad = "";
    public String zielDateiname = "";
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JTextField jTextFieldName;
    private JTextField jTextFieldPfad;

    public DialogZiel(Frame parent, boolean modal, Daten d, String pfad, String name) {
        super(parent, modal);
        this.initComponents();
        this.daten = d;
        this.jButtonOk.addActionListener(new OkBeobachter());
        this.jButtonAbbrechen.addActionListener(new AbbrechenBeobachter());
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        if (pfad != null) {
            this.jTextFieldPfad.setText(pfad);
        } else {
            this.jTextFieldPfad.setEnabled(false);
        }
        this.jTextFieldName.setText(name);
    }

    void check() {
        boolean ret = false;
        String pfad = this.jTextFieldPfad.getText();
        String name = this.jTextFieldName.getText();
        if (!pfad.equals("") && !name.equals("")) {
            if (!pfad.substring(pfad.length() - 1).equals(File.separator)) {
                pfad = pfad + File.separator;
            }
            this.zielPfad = pfad;
            this.zielDateiname = name;
            if (new File(this.zielPfad).isDirectory()) {
                ret = true;
            }
        }
        this.ok = ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jTextFieldName = new JTextField();
        this.jButtonZiel = new JButton();
        this.jTextFieldPfad = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonZiel.setText(":::");
        this.jLabel1.setText("Zielpfad:");
        this.jLabel2.setText("Dateiname:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldPfad, -1, 224, Short.MAX_VALUE).addComponent(this.jTextFieldName, -1, 224, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel1).addComponent(this.jTextFieldPfad, -2, -1, -2).addComponent(this.jButtonZiel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldName, this.jTextFieldPfad);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonOk.setText("Ok");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonOk)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!DialogZiel.this.jTextFieldPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(DialogZiel.this.jTextFieldPfad.getText()));
            }
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    DialogZiel.this.jTextFieldPfad.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    new Fehler(DialogZiel.this.daten).fehlerMeldung(ex, "DialogZiel.ZielBeobachter");
                }
            }
        }
    }

    private class AbbrechenBeobachter
    implements ActionListener {
        private AbbrechenBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogZiel.this.ok = false;
            DialogZiel.this.beenden();
        }
    }

    private class OkBeobachter
    implements ActionListener {
        private OkBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogZiel.this.check();
            DialogZiel.this.beenden();
        }
    }
}

