/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mediathek.Funktionen;
import mediathek.HinweisKeineAuswahl;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenPgruppe;
import mediathek.daten.DatenProg;
import mediathek.daten.ListePgruppe;
import mediathek.gui.GuiFilme;
import mediathek.gui.dialoge.DialogFarbe;
import mediathek.gui.dialoge.DialogHilfeProgramme;

public class DialogPgruppen
extends JDialog {
    private Daten daten;
    public boolean ok = false;
    private TModel tModel;
    private ListePgruppe listePgruppe;
    private boolean stopBeob = false;
    private boolean button;
    private GuiFilme guiFilme = null;
    private JButton jButtonGruppeAb;
    private JButton jButtonGruppeAuf;
    private JButton jButtonGruppeDoppelklick;
    private JButton jButtonGruppeDuplizieren;
    private JButton jButtonGruppeFarbe;
    private JButton jButtonGruppeLoeschen;
    private JButton jButtonGruppeNeu;
    private JButton jButtonGruppePfad;
    private JButton jButtonGruppeStandardfarbe;
    private JButton jButtonHilfe;
    private JButton jButtonOk;
    private JButton jButtonProgAb;
    private JButton jButtonProgAuf;
    private JButton jButtonProgDuplizieren;
    private JButton jButtonProgMinus;
    private JButton jButtonProgPfad;
    private JButton jButtonProgPlus;
    private JButton jButtonProgVorlageHinzufuegen;
    private JButton jButtonPruefen;
    private JCheckBox jCheckBoxRestart;
    private JComboBox jComboBoxProgVorlagen;
    private JLabel jLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelTitel;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JTextField jTextFieldGruppeDirektPraefix;
    private JTextField jTextFieldGruppeDirektSuffix;
    private JTextField jTextFieldGruppeName;
    private JTextField jTextFieldGruppeZielName;
    private JTextField jTextFieldGruppeZielPfad;
    private JTextField jTextFieldProgName;
    private JTextField jTextFieldProgPfad;
    private JTextField jTextFieldProgPraefix;
    private JTextField jTextFieldProgSchalter;
    private JTextField jTextFieldProgSuffix;

    public DialogPgruppen(Frame parent, boolean modal, Daten d, boolean bbutton, GuiFilme gguiFilme) {
        super(parent, modal);
        this.initComponents();
        this.guiFilme = gguiFilme;
        this.daten = d;
        this.button = bbutton;
        this.starten();
    }

    public DialogPgruppen(Frame parent, boolean modal, Daten d, boolean bbutton) {
        super(parent, modal);
        this.initComponents();
        this.daten = d;
        this.button = bbutton;
        this.starten();
    }

    private void starten() {
        BeobProgDoc beobDoc = new BeobProgDoc();
        this.jTable1.getSelectionModel().addListSelectionListener(new BeobTableSelect());
        this.jTextFieldProgPfad.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgSchalter.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgName.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgPraefix.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgSuffix.getDocument().addDocumentListener(beobDoc);
        this.jTextFieldProgPfad.setEnabled(false);
        this.jTextFieldProgSchalter.setEnabled(false);
        this.jTextFieldProgName.setEnabled(false);
        this.jTextFieldProgPraefix.setEnabled(false);
        this.jTextFieldProgSuffix.setEnabled(false);
        this.jButtonProgPfad.addActionListener(new BeobDateiDialogProg());
        this.jButtonProgPlus.addActionListener(new BeobProgNeueZeile());
        this.jButtonProgMinus.addActionListener(new BeobProgLoeschen());
        this.jButtonProgDuplizieren.addActionListener(new BeobProgDuplizieren());
        this.jButtonProgAuf.addActionListener(new BeobProgAufAb(true));
        this.jButtonProgAb.addActionListener(new BeobProgAufAb(false));
        this.jButtonProgPfad.setEnabled(false);
        this.jButtonProgVorlageHinzufuegen.addActionListener(new BeobVorlageProgHinzufuegen());
        this.jComboBoxProgVorlagen.setModel(new DefaultComboBoxModel<String>(this.daten.listeProgVorlagen.getObjectDataCombo()));
        this.jCheckBoxRestart.addActionListener(new BeobProgAction());
        this.jList1.addListSelectionListener(new BeobSelectGruppe());
        this.jList1.setCellRenderer(new ComboBoxRenderer());
        this.jList1.addMouseListener(new BeobMaus());
        this.jButtonGruppeNeu.addActionListener(new BeobGruppeNeu());
        this.jButtonGruppeLoeschen.addActionListener(new BeobGruppeLoeschen());
        this.jButtonGruppeFarbe.addActionListener(new BeobachterFarbe());
        this.jButtonGruppeStandardfarbe.addActionListener(new BeobStandardfarbe());
        this.jButtonGruppeAuf.addActionListener(new BeobGruppeAufAb(true));
        this.jButtonGruppeAb.addActionListener(new BeobGruppeAufAb(false));
        this.jButtonGruppeDuplizieren.addActionListener(new BeobGruppeDuplizieren());
        this.jButtonGruppeDoppelklick.addActionListener(new BeobGruppeDoppelklick());
        this.jButtonGruppePfad.addActionListener(new BeobDateiDialogPfad());
        this.jTextFieldGruppeName.getDocument().addDocumentListener(new BeobGruppenDoc(this.jTextFieldGruppeName, 0));
        this.jTextFieldGruppeDirektSuffix.getDocument().addDocumentListener(new BeobGruppenDoc(this.jTextFieldGruppeDirektSuffix, 2));
        this.jTextFieldGruppeDirektPraefix.getDocument().addDocumentListener(new BeobGruppenDoc(this.jTextFieldGruppeDirektPraefix, 1));
        this.jTextFieldGruppeZielName.getDocument().addDocumentListener(new BeobGruppenDoc(this.jTextFieldGruppeZielName, 6));
        this.jTextFieldGruppeZielPfad.getDocument().addDocumentListener(new BeobGruppenDoc(this.jTextFieldGruppeZielPfad, 5));
        this.jButtonHilfe.addActionListener(new BeobHilfeTabelle());
        this.jButtonOk.addActionListener(new BeobOk());
        this.jButtonPruefen.addActionListener(new BeobPuefen());
        if (this.button) {
            this.setTitle("Einstellungen Programme Button");
            this.jLabelTitel.setText("Button anlegen");
            this.listePgruppe = this.daten.listePgruppeButton;
        } else {
            this.setTitle("Einstellungen Programme Abo");
            this.jLabelTitel.setText("Abo einrichten");
            this.listePgruppe = this.daten.listePgruppeAbo;
        }
        this.init();
        this.pack();
    }

    private void init() {
        if (this.listePgruppe.size() > 0) {
            this.fillList(0);
        } else {
            this.fillList();
        }
    }

    private void fillList() {
        this.fillList(-1);
    }

    private void fillList(int count) {
        this.stopBeob = true;
        int sel = this.jList1.getSelectedIndex();
        this.jList1.setModel(new DefaultComboBoxModel<String>(this.listePgruppe.getObjectDataCombo()));
        if (count < 0) {
            this.jList1.setSelectedIndex(sel);
        } else {
            this.jList1.setSelectedIndex(count);
            this.jList1.setSelectionInterval(count, count);
        }
        this.stopBeob = false;
        this.fillTable();
        this.guiFilmeAendern();
    }

    private void guiFilmeAendern() {
        if (this.guiFilme != null) {
            this.guiFilme.bildProgs();
        }
    }

    private void fillTable() {
        DatenPgruppe pgruppe = this.getPgruppe();
        this.stopBeob = true;
        this.jTextFieldGruppeName.setEnabled(pgruppe != null);
        this.jTextFieldGruppeDirektSuffix.setEnabled(pgruppe != null);
        this.jTextFieldGruppeDirektPraefix.setEnabled(pgruppe != null);
        this.jTextFieldGruppeZielName.setEnabled(pgruppe != null);
        this.jTextFieldGruppeZielPfad.setEnabled(pgruppe != null);
        this.jButtonGruppePfad.setEnabled(pgruppe != null);
        if (pgruppe != null) {
            this.jTextFieldGruppeName.setText(pgruppe.arr[0]);
            this.jTextFieldGruppeDirektSuffix.setText(pgruppe.arr[2]);
            this.jTextFieldGruppeDirektPraefix.setText(pgruppe.arr[1]);
            this.jTextFieldGruppeZielName.setText(pgruppe.arr[6]);
            this.jTextFieldGruppeZielPfad.setText(pgruppe.arr[5]);
        } else {
            this.jTextFieldGruppeName.setText("");
            this.jTextFieldGruppeDirektSuffix.setText("");
            this.jTextFieldGruppeDirektPraefix.setText("");
            this.jTextFieldGruppeZielName.setText("");
            this.jTextFieldGruppeZielPfad.setText("");
        }
        if (pgruppe != null) {
            this.tModel = this.getPgruppe().getListeProg().getModel();
            this.jTable1.setModel(this.tModel);
            if (this.tModel.getRowCount() > 0) {
                this.jTable1.setRowSelectionInterval(0, 0);
                this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(0, 0, true));
            }
        } else {
            this.jTable1.setModel(new TModel(new Object[0][6], Konstanten.PROGRAMM_COLUMN_NAMES));
        }
        this.stopBeob = false;
        this.fillText();
    }

    private void fillText() {
        this.stopBeob = true;
        int rows = this.jTable1.getSelectedRow();
        this.jTextFieldProgPfad.setEnabled(rows != -1);
        this.jTextFieldProgSchalter.setEnabled(rows != -1);
        this.jTextFieldProgName.setEnabled(rows != -1);
        this.jTextFieldProgPraefix.setEnabled(rows != -1);
        this.jTextFieldProgSuffix.setEnabled(rows != -1);
        this.jButtonProgPfad.setEnabled(rows != -1);
        this.jCheckBoxRestart.setEnabled(rows != -1);
        if (rows != -1) {
            int row = this.jTable1.convertRowIndexToModel(rows);
            DatenProg prog = this.getPgruppe().getProg(row);
            this.jTextFieldProgPfad.setText(prog.arr[1]);
            this.jTextFieldProgSchalter.setText(prog.arr[2]);
            this.jTextFieldProgName.setText(prog.arr[0]);
            this.jTextFieldProgPraefix.setText(prog.arr[3]);
            this.jTextFieldProgSuffix.setText(prog.arr[4]);
            this.jCheckBoxRestart.setSelected(Boolean.parseBoolean(prog.arr[5]));
        } else {
            this.jTextFieldProgPfad.setText("");
            this.jTextFieldProgSchalter.setText("");
            this.jTextFieldProgName.setText("");
            this.jTextFieldProgName.setBackground(Color.WHITE);
            this.jTextFieldProgPraefix.setText("");
            this.jTextFieldProgSuffix.setText("");
        }
        this.stopBeob = false;
    }

    private DatenPgruppe getPgruppe() {
        DatenPgruppe ret = null;
        int i = this.jList1.getSelectedIndex();
        if (i != -1) {
            ret = (DatenPgruppe)this.listePgruppe.get(i);
        }
        return ret;
    }

    private void setDoppelklick() {
        int i = this.jList1.getSelectedIndex();
        if (((DatenPgruppe)this.listePgruppe.get(i)).getListeProg().size() <= 0) {
            JOptionPane.showMessageDialog(null, "Die Programmgruppe muss mind. ein Programm enthalten!", "kein Programm", 1);
        } else if (i != -1) {
            this.listePgruppe.setDoppelklick(i);
            this.daten.setGeaendert();
            this.fillList();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void gruppenNamePruefen() {
        int rows;
        if (!this.button && (rows = this.jList1.getSelectedIndex()) != -1) {
            int foundgruppe = 0;
            for (DatenPgruppe gruppe : this.listePgruppe) {
                if (!this.jTextFieldGruppeName.getText().equals(gruppe.arr[0])) continue;
                ++foundgruppe;
            }
            if (foundgruppe > 1) {
                this.jTextFieldGruppeName.setBackground(Color.ORANGE);
            } else {
                this.jTextFieldGruppeName.setBackground(Color.WHITE);
            }
        }
    }

    private void gruppeAufAb(boolean auf) {
        int rows = this.jList1.getSelectedIndex();
        if (rows != -1) {
            this.fillList(this.listePgruppe.auf(rows, auf));
            this.daten.setGeaendert();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void gruppeNeu() {
        this.listePgruppe.add(new DatenPgruppe("", "", "", "", ""));
        this.fillList(this.listePgruppe.size() - 1);
    }

    private void gruppeLoeschen() {
        int row = this.jList1.getSelectedIndex();
        if (row >= 0) {
            int ret = -1;
            ret = JOptionPane.showConfirmDialog(null, "L\u00f6schen?", " ", 0);
            if (ret == 0) {
                this.listePgruppe.remove(row);
            }
            this.fillList();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void progNeueZeile(DatenProg prog) {
        DatenPgruppe gruppe = null;
        int i = this.jList1.getSelectedIndex();
        if (i != -1) {
            gruppe = (DatenPgruppe)this.listePgruppe.get(i);
            gruppe.addProg(prog);
            this.fillTable();
            int neu = this.tModel.getRowCount();
            this.jTable1.setRowSelectionInterval(this.jTable1.convertRowIndexToView(neu - 1), this.jTable1.convertRowIndexToView(neu - 1));
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(neu - 1, 0, true));
            this.daten.setGeaendert();
            this.guiFilmeAendern();
        }
    }

    private void progAufAb(boolean auf) {
        int rows = this.jTable1.getSelectedRow();
        if (rows != -1) {
            int row = this.jTable1.convertRowIndexToModel(rows);
            int neu = this.getPgruppe().getListeProg().auf(row, auf);
            this.fillTable();
            this.jTable1.setRowSelectionInterval(neu, neu);
            this.jTable1.scrollRectToVisible(this.jTable1.getCellRect(neu, 0, true));
            this.daten.setGeaendert();
        } else {
            new HinweisKeineAuswahl();
        }
    }

    private void vorlageProgHinzufuegen() {
        int i = this.jComboBoxProgVorlagen.getSelectedIndex();
        DatenProg prog = ((DatenProg)this.daten.listeProgVorlagen.get(i)).copy();
        this.progNeueZeile(prog);
    }

    private void dialogHilfe() {
        new DialogHilfeProgramme(null, true, this.daten, this.button).setVisible(true);
        this.fillList();
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jButtonGruppeNeu = new JButton();
        this.jButtonGruppeLoeschen = new JButton();
        this.jButtonGruppeDuplizieren = new JButton();
        this.jButtonGruppeAuf = new JButton();
        this.jButtonGruppeAb = new JButton();
        this.jLabelTitel = new JLabel();
        this.jButtonGruppeDoppelklick = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jTextFieldGruppeDirektSuffix = new JTextField();
        this.jLabel5 = new JLabel();
        this.jButtonGruppeFarbe = new JButton();
        this.jButtonGruppeStandardfarbe = new JButton();
        this.jTextFieldGruppeName = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jTextFieldGruppeZielPfad = new JTextField();
        this.jLabel8 = new JLabel();
        this.jTextFieldGruppeZielName = new JTextField();
        this.jButtonGruppePfad = new JButton();
        this.jTextFieldGruppeDirektPraefix = new JTextField();
        this.jLabel10 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel2 = new JPanel();
        this.jButtonProgPlus = new JButton();
        this.jButtonProgMinus = new JButton();
        this.jButtonProgDuplizieren = new JButton();
        this.jComboBoxProgVorlagen = new JComboBox();
        this.jButtonProgVorlageHinzufuegen = new JButton();
        this.jButtonProgAuf = new JButton();
        this.jButtonProgAb = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel = new JLabel();
        this.jTextFieldProgPfad = new JTextField();
        this.jButtonProgPfad = new JButton();
        this.jTextFieldProgSchalter = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldProgName = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldProgPraefix = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldProgSuffix = new JTextField();
        this.jCheckBoxRestart = new JCheckBox();
        this.jButtonHilfe = new JButton();
        this.jButtonPruefen = new JButton();
        this.jButtonOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.jSplitPane1.setDividerLocation(300);
        this.jPanel4.setBorder(new SoftBevelBorder(0));
        this.jList1.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jList1);
        this.jButtonGruppeNeu.setText("Neu");
        this.jButtonGruppeNeu.setToolTipText("neue Programmgruppe anlegen");
        this.jButtonGruppeLoeschen.setText("L\u00f6schen");
        this.jButtonGruppeLoeschen.setToolTipText("Programmgruppe l\u00f6schen");
        this.jButtonGruppeDuplizieren.setText("Duplizieren");
        this.jButtonGruppeDuplizieren.setToolTipText("Programmgruppe kopieren");
        this.jButtonGruppeAuf.setText("Auf");
        this.jButtonGruppeAuf.setToolTipText("Programmgruppe nach oben schieben");
        this.jButtonGruppeAb.setText("Ab");
        this.jButtonGruppeAb.setToolTipText("Programmgruppe nach unten schieben");
        this.jLabelTitel.setText("  ");
        this.jButtonGruppeDoppelklick.setText("Doppelklick");
        this.jButtonGruppeDoppelklick.setToolTipText("Bei einem Doppelklick wird dieser Button bet\u00e4tigt");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonGruppeDoppelklick, -1, 269, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 269, Short.MAX_VALUE).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonGruppeAuf).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGruppeNeu, -1, 136, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonGruppeAb)).addComponent(this.jLabelTitel).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.jButtonGruppeDuplizieren).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.jButtonGruppeLoeschen, -2, 125, -2))).addContainerGap()));
        jPanel4Layout.linkSize(0, this.jButtonGruppeDuplizieren, this.jButtonGruppeLoeschen);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelTitel).addGap(12, 12, 12).addComponent(this.jScrollPane2, -1, 542, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jButtonGruppeAuf).addComponent(this.jButtonGruppeNeu).addComponent(this.jButtonGruppeAb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonGruppeDuplizieren).addComponent(this.jButtonGruppeLoeschen)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGruppeDoppelklick).addContainerGap()));
        jPanel4Layout.linkSize(1, this.jButtonGruppeLoeschen, this.jButtonGruppeNeu);
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.jPanel5.setBorder(new SoftBevelBorder(0));
        this.jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(102, 102, 255), 2), "Programmgruppe"));
        this.jLabel5.setText("Suffix:");
        this.jButtonGruppeFarbe.setText("Farbe");
        this.jButtonGruppeFarbe.setToolTipText("Farbauswahldialog anzeigen");
        this.jButtonGruppeStandardfarbe.setText("Standardfarbe");
        this.jButtonGruppeStandardfarbe.setToolTipText("Farbe zur\u00fccksetzen");
        this.jLabel6.setText("Name:");
        this.jLabel7.setText("Zielpfad:");
        this.jLabel8.setText("Zieldateiname:");
        this.jButtonGruppePfad.setText(":::");
        this.jButtonGruppePfad.setToolTipText("Pfad ausw\u00e4hlen");
        this.jLabel10.setText("direkter Downloads, Pr\u00e4fix:");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jButtonGruppeFarbe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGruppeStandardfarbe)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGruppeDirektPraefix, -2, 127, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGruppeDirektSuffix, -1, 97, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldGruppeName, -1, 441, Short.MAX_VALUE)).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jTextFieldGruppeZielPfad, -1, 323, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonGruppePfad)).addComponent(this.jTextFieldGruppeZielName, -1, 378, Short.MAX_VALUE)))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGruppeName, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGruppeZielPfad, -2, -1, -2).addComponent(this.jButtonGruppePfad).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jTextFieldGruppeZielName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldGruppeDirektSuffix, -2, -1, -2).addComponent(this.jLabel10).addComponent(this.jTextFieldGruppeDirektPraefix, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonGruppeFarbe).addComponent(this.jButtonGruppeStandardfarbe)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(102, 102, 255)), "Programme"));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonProgPlus.setText("+");
        this.jButtonProgPlus.setToolTipText("neues Programm anlegen");
        this.jButtonProgMinus.setText("-");
        this.jButtonProgMinus.setToolTipText("markiertes Programm l\u00f6schen");
        this.jButtonProgDuplizieren.setText("Duplizieren");
        this.jButtonProgDuplizieren.setToolTipText("markierte Zeile duplizieren");
        this.jComboBoxProgVorlagen.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonProgVorlageHinzufuegen.setText("Hinzuf\u00fcgen");
        this.jButtonProgVorlageHinzufuegen.setToolTipText("eine Auswahl an Programmen hinzuf\u00fcgen");
        this.jButtonProgAuf.setText("auf");
        this.jButtonProgAuf.setToolTipText("markierte Zeile eins nach oben");
        this.jButtonProgAb.setText("ab");
        this.jButtonProgAb.setToolTipText("markierte Zeile eins nach unten");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButtonProgPlus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgMinus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgDuplizieren).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgAuf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgAb)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jComboBoxProgVorlagen, 0, 351, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgVorlageHinzufuegen))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonProgPlus).addComponent(this.jButtonProgMinus).addComponent(this.jButtonProgDuplizieren).addComponent(this.jButtonProgAuf).addComponent(this.jButtonProgAb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProgVorlagen, -2, -1, -2).addComponent(this.jButtonProgVorlageHinzufuegen)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel.setText("Programm:");
        this.jButtonProgPfad.setText(":::");
        this.jButtonProgPfad.setToolTipText("Pfad ausw\u00e4hlen");
        this.jLabel1.setText("Schalter:");
        this.jLabel2.setText("Name:");
        this.jLabel3.setText("Pr\u00e4fix ( zB. http ):");
        this.jLabel4.setText("Suffix ( zB. mp4):");
        this.jCheckBoxRestart.setText("fehlgeschlagene Downloads wieder Starten");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxRestart).addComponent(this.jTextFieldProgSchalter, -1, 337, Short.MAX_VALUE).addComponent(this.jTextFieldProgName, -1, 337, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldProgPfad, -1, 282, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonProgPfad)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldProgPraefix, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgSuffix, -1, 50, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldProgName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel).addComponent(this.jButtonProgPfad).addComponent(this.jTextFieldProgPfad, -2, 12, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldProgSchalter, -2, 15, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.jTextFieldProgPraefix, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jTextFieldProgSuffix, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxRestart).addContainerGap(18, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jTextFieldProgName, this.jTextFieldProgPfad, this.jTextFieldProgPraefix, this.jTextFieldProgSchalter, this.jTextFieldProgSuffix);
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 500, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 139, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 165, -2).addContainerGap()));
        this.jButtonHilfe.setText("Hilfe");
        this.jButtonHilfe.setToolTipText("Hilfedialog anzeigen");
        this.jButtonPruefen.setText("Pr\u00fcfen");
        this.jButtonPruefen.setToolTipText("Programmpfade pr\u00fcfen");
        this.jButtonOk.setText("Ok");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addComponent(this.jButtonPruefen, -2, 84, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonOk)).addComponent(this.jPanel7, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel5Layout.linkSize(0, this.jButtonHilfe, this.jButtonOk, this.jButtonPruefen);
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonHilfe).addComponent(this.jButtonPruefen).addComponent(this.jButtonOk)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel5);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 875, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 694, Short.MAX_VALUE).addContainerGap()));
    }

    public class BeobMaus
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1 && arg0.getClickCount() > 1) {
                DialogPgruppen.this.setDoppelklick();
            }
        }
    }

    public class BeobTableSelect
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting() && !DialogPgruppen.this.stopBeob) {
                DialogPgruppen.this.fillText();
            }
        }
    }

    private class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private ComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value.toString().equals("")) {
                this.setMinimumSize(new Dimension(19, 19));
                this.setPreferredSize(new Dimension(19, 19));
            }
            this.setText(value.toString());
            this.setBackground(null);
            this.setBorder(null);
            Color col = null;
            col = ((DatenPgruppe)DialogPgruppen.this.listePgruppe.get(index)).getFarbe(DialogPgruppen.this.daten);
            boolean doppelklick = ((DatenPgruppe)((DialogPgruppen)DialogPgruppen.this).listePgruppe.get((int)index)).arr[4].equals(Boolean.toString(true));
            if (isSelected) {
                if (doppelklick) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(list.getSelectionForeground());
                }
                this.setBackground(list.getSelectionBackground());
            } else {
                if (doppelklick) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(list.getForeground());
                }
                this.setBackground(list.getBackground());
            }
            if (col != null) {
                this.setBorder(BorderFactory.createLineBorder(col, 2));
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class BeobStandardfarbe
    implements ActionListener {
        private BeobStandardfarbe() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenPgruppe pgruppe = DialogPgruppen.this.getPgruppe();
            if (pgruppe != null) {
                pgruppe.arr[3] = "";
                DialogPgruppen.this.fillList();
                DialogPgruppen.this.daten.setGeaendert();
            }
        }
    }

    private class BeobachterFarbe
    implements ActionListener {
        private BeobachterFarbe() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenPgruppe pgruppe = DialogPgruppen.this.getPgruppe();
            if (pgruppe != null) {
                DialogFarbe dialog = new DialogFarbe(null, true);
                dialog.setVisible(true);
                if (dialog.farbe != null) {
                    pgruppe.setFarbe(dialog.farbe);
                    DialogPgruppen.this.fillList();
                    DialogPgruppen.this.daten.setGeaendert();
                }
            }
        }
    }

    private class BeobGruppeLoeschen
    implements ActionListener {
        private BeobGruppeLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.gruppeLoeschen();
        }
    }

    private class BeobGruppeNeu
    implements ActionListener {
        private BeobGruppeNeu() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.gruppeNeu();
        }
    }

    private class BeobGruppeAufAb
    implements ActionListener {
        boolean auf;

        public BeobGruppeAufAb(boolean a) {
            this.auf = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.gruppeAufAb(this.auf);
        }
    }

    private class BeobProgAufAb
    implements ActionListener {
        boolean auf;

        public BeobProgAufAb(boolean a) {
            this.auf = a;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.progAufAb(this.auf);
        }
    }

    private class BeobVorlageProgHinzufuegen
    implements ActionListener {
        private BeobVorlageProgHinzufuegen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.vorlageProgHinzufuegen();
        }
    }

    private class BeobPuefen
    implements ActionListener {
        private BeobPuefen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Funktionen.programmePruefen(DialogPgruppen.this.daten, DialogPgruppen.this.listePgruppe);
        }
    }

    private class BeobProgLoeschen
    implements ActionListener {
        private BeobProgLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = DialogPgruppen.this.jTable1.getSelectedRows();
            if (rows.length > 0) {
                int ret = -1;
                ret = JOptionPane.showConfirmDialog(null, "L\u00f6schen?", " ", 0);
                if (ret == 0) {
                    for (int i = rows.length - 1; i >= 0; --i) {
                        int delRow = DialogPgruppen.this.jTable1.convertRowIndexToModel(rows[i]);
                        DialogPgruppen.this.getPgruppe().getListeProg().remove(delRow);
                    }
                    DialogPgruppen.this.fillTable();
                    DialogPgruppen.this.daten.setGeaendert();
                    DialogPgruppen.this.guiFilmeAendern();
                }
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private class BeobHilfeTabelle
    implements ActionListener {
        private BeobHilfeTabelle() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.dialogHilfe();
        }
    }

    private class BeobOk
    implements ActionListener {
        private BeobOk() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.beenden();
        }
    }

    private class BeobGruppeDoppelklick
    implements ActionListener {
        private BeobGruppeDoppelklick() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogPgruppen.this.setDoppelklick();
        }
    }

    private class BeobGruppeDuplizieren
    implements ActionListener {
        private BeobGruppeDuplizieren() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = DialogPgruppen.this.jList1.getSelectedIndex();
            if (row >= 0) {
                DialogPgruppen.this.listePgruppe.duplicate(DialogPgruppen.this.getPgruppe());
                DialogPgruppen.this.fillList();
                DialogPgruppen.this.daten.setGeaendert();
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private class BeobGruppenDoc
    implements DocumentListener {
        JTextField textfeld;
        int nr;

        public BeobGruppenDoc(JTextField ttextfeld, int nnr) {
            this.textfeld = ttextfeld;
            this.nr = nnr;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            if (!DialogPgruppen.this.stopBeob) {
                int row = DialogPgruppen.this.jList1.getSelectedIndex();
                if (row >= 0) {
                    DialogPgruppen.this.stopBeob = true;
                    DatenPgruppe gruppe = (DatenPgruppe)DialogPgruppen.this.listePgruppe.get(row);
                    gruppe.arr[this.nr] = this.textfeld.getText();
                    if (this.nr == 0) {
                        DialogPgruppen.this.jList1.setModel(new DefaultComboBoxModel<String>(DialogPgruppen.this.listePgruppe.getObjectDataCombo()));
                        DialogPgruppen.this.jList1.setSelectedIndex(row);
                    }
                    DialogPgruppen.this.daten.setGeaendert();
                    DialogPgruppen.this.stopBeob = false;
                } else {
                    new HinweisKeineAuswahl();
                }
            }
            DialogPgruppen.this.gruppenNamePruefen();
            DialogPgruppen.this.guiFilmeAendern();
        }
    }

    private class BeobProgDuplizieren
    implements ActionListener {
        private BeobProgDuplizieren() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rows = DialogPgruppen.this.jTable1.getSelectedRow();
            if (rows != -1) {
                int row = DialogPgruppen.this.jTable1.convertRowIndexToModel(rows);
                DatenProg prog = (DatenProg)DialogPgruppen.this.getPgruppe().getListeProg().get(row);
                DialogPgruppen.this.progNeueZeile(prog.copy());
            } else {
                new HinweisKeineAuswahl();
            }
        }
    }

    private class BeobProgNeueZeile
    implements ActionListener {
        private BeobProgNeueZeile() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DatenProg prog = new DatenProg();
            DialogPgruppen.this.progNeueZeile(prog);
        }
    }

    private class BeobDateiDialogPfad
    implements ActionListener {
        private BeobDateiDialogPfad() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            if (!DialogPgruppen.this.jTextFieldGruppeZielPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(DialogPgruppen.this.jTextFieldGruppeZielPfad.getText()));
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                try {
                    String str = chooser.getSelectedFile().getPath();
                    DialogPgruppen.this.jTextFieldGruppeZielPfad.setText(str);
                }
                catch (Exception ex) {
                    ((DialogPgruppen)DialogPgruppen.this).daten.fehler.fehlerMeldung(ex, "DialogPgruppe.BeobDateiDialogPfad");
                }
            }
        }
    }

    private class BeobDateiDialogProg
    implements ActionListener {
        private BeobDateiDialogProg() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            if (!DialogPgruppen.this.jTextFieldProgPfad.getText().equals("")) {
                chooser.setCurrentDirectory(new File(DialogPgruppen.this.jTextFieldProgPfad.getText()));
            }
            if ((returnVal = chooser.showOpenDialog(null)) == 0) {
                try {
                    String str = chooser.getSelectedFile().getPath();
                    DialogPgruppen.this.jTextFieldProgPfad.setText(str);
                }
                catch (Exception ex) {
                    ((DialogPgruppen)DialogPgruppen.this).daten.fehler.fehlerMeldung(ex, "DialogPgruppe.BeobDateiDialogProg");
                }
            }
        }
    }

    private class BeobSelectGruppe
    implements ListSelectionListener {
        private BeobSelectGruppe() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!DialogPgruppen.this.stopBeob && !event.getValueIsAdjusting()) {
                DialogPgruppen.this.fillTable();
            }
        }
    }

    private class BeobProgDoc
    implements DocumentListener {
        private BeobProgDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            if (!DialogPgruppen.this.stopBeob) {
                DialogPgruppen.this.daten.setGeaendert();
                int rows = DialogPgruppen.this.jTable1.getSelectedRow();
                if (rows != -1) {
                    int row = DialogPgruppen.this.jTable1.convertRowIndexToModel(rows);
                    DatenProg prog = (DatenProg)DialogPgruppen.this.getPgruppe().getListeProg().get(row);
                    prog.arr[1] = DialogPgruppen.this.jTextFieldProgPfad.getText();
                    prog.arr[2] = DialogPgruppen.this.jTextFieldProgSchalter.getText();
                    prog.arr[0] = DialogPgruppen.this.jTextFieldProgName.getText();
                    prog.arr[4] = DialogPgruppen.this.jTextFieldProgSuffix.getText();
                    prog.arr[3] = DialogPgruppen.this.jTextFieldProgPraefix.getText();
                    DialogPgruppen.this.tModel.setValueAt(DialogPgruppen.this.jTextFieldProgPfad.getText(), row, 1);
                    DialogPgruppen.this.tModel.setValueAt(DialogPgruppen.this.jTextFieldProgSchalter.getText(), row, 2);
                    DialogPgruppen.this.tModel.setValueAt(DialogPgruppen.this.jTextFieldProgName.getText(), row, 0);
                    DialogPgruppen.this.tModel.setValueAt(DialogPgruppen.this.jTextFieldProgSuffix.getText(), row, 4);
                    DialogPgruppen.this.tModel.setValueAt(DialogPgruppen.this.jTextFieldProgPraefix.getText(), row, 3);
                }
            }
        }
    }

    private class BeobProgAction
    implements ActionListener {
        private BeobProgAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DialogPgruppen.this.stopBeob) {
                DialogPgruppen.this.daten.setGeaendert();
                int rows = DialogPgruppen.this.jTable1.getSelectedRow();
                if (rows != -1) {
                    int row = DialogPgruppen.this.jTable1.convertRowIndexToModel(rows);
                    DatenProg prog = (DatenProg)DialogPgruppen.this.getPgruppe().getListeProg().get(row);
                    prog.arr[5] = Boolean.toString(DialogPgruppen.this.jCheckBoxRestart.isSelected());
                    DialogPgruppen.this.tModel.setValueAt(Boolean.toString(DialogPgruppen.this.jCheckBoxRestart.isSelected()), row, 5);
                }
            }
        }
    }
}

