/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialoge;

import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.Fehler;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilmUpdate;
import mediathek.io.UpdateSuchen;

public class DialogImportFilme
extends JDialog {
    Daten daten;
    public boolean ok = false;
    public String ziel;
    private boolean stopBeob = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonBeenden;
    private JButton jButtonImportPfad;
    private JButton jButtonUpdate;
    private JCheckBox jCheckBoxAlt;
    private JCheckBox jCheckBoxImport;
    private JComboBox jComboBoxImportUrl;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonImportDatei;
    private JRadioButton jRadioButtonImportUrl;
    private JRadioButton jRadioButtonImportWebsite;
    private JTextField jTextFieldPfadImportDatei;

    public DialogImportFilme(Frame parent, boolean modal, Daten d) {
        super(parent, modal);
        this.initComponents();
        this.daten = d;
        this.init();
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogImportFilme.this.beenden();
            }
        });
        this.jTextFieldPfadImportDatei.getDocument().addDocumentListener(new BeobTextFeld(this.jTextFieldPfadImportDatei, 34));
        this.jComboBoxImportUrl.addActionListener(new BeobImportUrl());
        this.jRadioButtonImportWebsite.addActionListener(new BeobAction());
        this.jRadioButtonImportDatei.addActionListener(new BeobAction());
        this.jRadioButtonImportUrl.addActionListener(new BeobAction());
        this.jButtonImportPfad.addActionListener(new BeobPfad(this.jTextFieldPfadImportDatei));
        this.jButtonUpdate.addActionListener(new BeobSuchen());
        this.jCheckBoxImport.addActionListener(new BeobCheckBox());
        this.jCheckBoxAlt.addActionListener(new BeobCheckBox());
    }

    private void init() {
        if (this.daten.system[38].equals("import-datei")) {
            this.jRadioButtonImportDatei.setSelected(true);
        } else if (this.daten.system[38].equals("import-url")) {
            this.jRadioButtonImportUrl.setSelected(true);
        } else {
            this.jRadioButtonImportWebsite.setSelected(true);
        }
        this.jTextFieldPfadImportDatei.setText(this.daten.system[34]);
        this.jComboBoxImportUrl.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilmUpdate.getObjectData()));
        this.jComboBoxImportUrl.setSelectedIndex(this.daten.listeFilmUpdate.getNr(this.daten.system[35]));
        this.jCheckBoxImport.setSelected(Boolean.parseBoolean(this.daten.system[47]));
        this.jCheckBoxAlt.setSelected(Boolean.parseBoolean(this.daten.system[43]));
        this.textfeldSetzen();
    }

    private void textfeldSetzen() {
        this.jTextFieldPfadImportDatei.setEnabled(this.daten.system[38].equals("import-datei"));
        this.jComboBoxImportUrl.setEnabled(this.daten.system[38].equals("import-url"));
        this.jButtonUpdate.setEnabled(this.daten.system[38].equals("import-url"));
    }

    private void beenden() {
        this.dispose();
    }

    private void updateSuchen() {
        new UpdateSuchen(this.daten).suchen(false, true);
        this.stopBeob = true;
        this.jComboBoxImportUrl.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilmUpdate.getObjectData()));
        this.jComboBoxImportUrl.setSelectedIndex(this.daten.listeFilmUpdate.getNr(this.daten.system[35]));
        this.stopBeob = false;
    }

    private void importUrlSetzen() {
        String url = (String)this.jComboBoxImportUrl.getSelectedItem();
        DatenFilmUpdate datenFilmUpdate = new DatenFilmUpdate(url, "1");
        this.daten.system[35] = url;
        if (!this.daten.listeFilmUpdate.addCheck(datenFilmUpdate)) {
            this.jComboBoxImportUrl.setModel(new DefaultComboBoxModel<String>(this.daten.listeFilmUpdate.getObjectData()));
            this.jComboBoxImportUrl.setSelectedItem(url);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonBeenden = new JButton();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonImportUrl = new JRadioButton();
        this.jComboBoxImportUrl = new JComboBox();
        this.jButtonUpdate = new JButton();
        this.jCheckBoxImport = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonImportDatei = new JRadioButton();
        this.jTextFieldPfadImportDatei = new JTextField();
        this.jButtonImportPfad = new JButton();
        this.jCheckBoxAlt = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jRadioButtonImportWebsite = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jButtonBeenden.setText("Ok");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(51, 51, 255)), "Filmliste aus Datei importieren"));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButtonImportUrl);
        this.jRadioButtonImportUrl.setSelected(true);
        this.jRadioButtonImportUrl.setText("Url:");
        this.jComboBoxImportUrl.setEditable(true);
        this.jComboBoxImportUrl.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButtonUpdate.setText("Liste online aktualisieren");
        this.jCheckBoxImport.setText("Importliste beim Update-Suchen aktualisieren");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportUrl).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxImportUrl, 0, 574, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxImport))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonImportUrl).addComponent(this.jComboBoxImportUrl, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonUpdate).addComponent(this.jCheckBoxImport)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.buttonGroup1.add(this.jRadioButtonImportDatei);
        this.jRadioButtonImportDatei.setText("Datei:");
        this.jButtonImportPfad.setText(":::");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportDatei).addGap(8, 8, 8).addComponent(this.jTextFieldPfadImportDatei, -1, 501, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImportPfad).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldPfadImportDatei, -2, -1, -2).addComponent(this.jRadioButtonImportDatei).addComponent(this.jButtonImportPfad)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonImportPfad, this.jTextFieldPfadImportDatei);
        this.jCheckBoxAlt.setText("Auch \u00e4ltere Filme importieren");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAlt).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxAlt).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(51, 51, 255)));
        this.buttonGroup1.add(this.jRadioButtonImportWebsite);
        this.jRadioButtonImportWebsite.setText("Filme von den Websiten der Sender laden (dauert mehrere Stunden!)");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportWebsite).addContainerGap(164, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonImportWebsite).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonBeenden, GroupLayout.Alignment.TRAILING, -2, 94, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel3, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel4, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButtonBeenden).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private class BeobCheckBox
    implements ActionListener {
        private BeobCheckBox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogImportFilme.this.daten.system[47] = Boolean.toString(DialogImportFilme.this.jCheckBoxImport.isSelected());
            DialogImportFilme.this.daten.system[43] = Boolean.toString(DialogImportFilme.this.jCheckBoxAlt.isSelected());
            DialogImportFilme.this.daten.setGeaendert();
        }
    }

    private class BeobImportUrl
    implements ActionListener {
        private BeobImportUrl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DialogImportFilme.this.stopBeob) {
                DialogImportFilme.this.importUrlSetzen();
            }
        }
    }

    private class BeobSuchen
    implements ActionListener {
        private BeobSuchen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogImportFilme.this.updateSuchen();
        }
    }

    private class BeobPfad
    implements ActionListener {
        JTextField textFeld;

        public BeobPfad(JTextField ttextFeld) {
            this.textFeld = ttextFeld;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            if (!this.textFeld.getText().equals("")) {
                chooser.setCurrentDirectory(new File(this.textFeld.getText()));
            }
            chooser.setFileSelectionMode(0);
            chooser.setFileHidingEnabled(false);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal == 0) {
                try {
                    this.textFeld.setText(chooser.getSelectedFile().getAbsolutePath());
                }
                catch (Exception ex) {
                    new Fehler(DialogImportFilme.this.daten).fehlerMeldung(ex, "DialogImportFilme.BeobImport");
                }
            }
        }
    }

    private class BeobTextFeld
    implements DocumentListener {
        JTextField textFeld;
        int nr;

        public BeobTextFeld(JTextField tFeld, int n) {
            this.textFeld = tFeld;
            this.nr = n;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tusEinfach(e);
        }

        void tusEinfach(DocumentEvent e) {
            DialogImportFilme.this.daten.system[this.nr] = this.textFeld.getText();
            DialogImportFilme.this.daten.setGeaendert();
        }
    }

    private class BeobAction
    implements ActionListener {
        private BeobAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogImportFilme.this.daten.system[38] = DialogImportFilme.this.jRadioButtonImportUrl.isSelected() ? "import-url" : (DialogImportFilme.this.jRadioButtonImportDatei.isSelected() ? "import-datei" : "import-website");
            DialogImportFilme.this.textfeldSetzen();
        }
    }
}

