/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.Konstanten;
import mediathek.TModel;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenProg;

public class ListeProg
extends LinkedList<DatenProg> {
    public void addProg(String name, String pfad, String schalter) {
        this.add(new DatenProg(name, pfad, schalter));
    }

    public DatenProg remove(String name) {
        DatenProg ret = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenProg prog = (DatenProg)it.next();
            if (!prog.arr[0].equals(name)) continue;
            it.remove();
            ret = prog;
            break;
        }
        return ret;
    }

    public DatenProg getProgAbo(Daten daten, int art, String thema) {
        DatenProg ret2 = null;
        String name = null;
        boolean gefunden = true;
        try {
            for (DatenAbo abo : daten.listeAbo) {
                if (!abo.arr[3].equals(thema)) continue;
                name = abo.arr[8];
                break;
            }
            if (name != null) {
                for (DatenProg ret2 : this) {
                    if (!ret2.arr[0].equals(name)) continue;
                    gefunden = true;
                    break;
                }
            }
            if (!gefunden) {
                ret2 = (DatenProg)this.getFirst();
                daten.fehler.fehlerMeldung("Fehler", new String[]{"Es wurde kein passendes Programm f\u00fcr ein Abo gefunden.", "Thema: " + thema});
            }
        }
        catch (Exception ex) {
            daten.fehler.fehlerMeldung("Fehler", new String[]{"ListeProg.getProgAbo", ex.getMessage(), "Es wurde kein passendes Programm f\u00fcr ein Abo gefunden.", "Thema: " + thema});
        }
        return ret2;
    }

    public int auf(int idx, boolean auf) {
        DatenProg prog = (DatenProg)this.remove(idx);
        int neu = idx;
        if (auf) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, prog);
        return neu;
    }

    public TModel getModel() {
        TModel model = null;
        int i = 0;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            Object[][] object = new Object[this.size()][6];
            while (iterator.hasNext()) {
                DatenProg daten = (DatenProg)iterator.next();
                object[i] = daten.arr;
                ++i;
            }
            model = new TModel(object, Konstanten.PROGRAMM_COLUMN_NAMES);
        } else {
            model = new TModel(new Object[0][6], Konstanten.PROGRAMM_COLUMN_NAMES);
        }
        return model;
    }

    public String[] getObjectDataCombo() {
        int i = 0;
        ListIterator iterator = this.listIterator(0);
        String[] object = new String[this.size()];
        while (iterator.hasNext()) {
            DatenProg daten = (DatenProg)iterator.next();
            object[i] = daten.arr[0];
            ++i;
        }
        return object;
    }
}

