/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.gui.dialoge.DialogEditAbo;

public class ListeAbo
extends LinkedList<DatenAbo> {
    Daten daten;
    private int nr = 0;

    public ListeAbo(Daten ddaten) {
        this.daten = ddaten;
    }

    public boolean addAbo(String sender, String thema, boolean exakt, String text) {
        boolean ret = false;
        DatenAbo datenAbo = new DatenAbo(thema, sender, thema, exakt, text, thema, "");
        DialogEditAbo dialogEditAbo = new DialogEditAbo(null, true, this.daten, datenAbo);
        dialogEditAbo.setVisible(true);
        if (dialogEditAbo.ok && !this.aboSuchen(sender, thema, exakt, text)) {
            this.addAbo(datenAbo);
            this.sort();
            ret = true;
        }
        return ret;
    }

    public void aboLoeschen(DatenAbo abo) {
        if (abo != null) {
            this.remove(abo);
        }
    }

    public void addAbo(DatenAbo datenAbo) {
        String str = String.valueOf(this.nr++);
        while (str.length() < 3) {
            str = "0" + str;
        }
        datenAbo.arr[0] = str;
        if (datenAbo.arr[4].equals("")) {
            datenAbo.arr[4] = Boolean.toString(true);
        }
        super.add(datenAbo);
    }

    public DatenAbo getAboNr(int i) {
        return (DatenAbo)this.get(i);
    }

    public String getName(String sender, String thema, String text) {
        String ret = "";
        DatenAbo datenAbo = this.getAbo(sender, thema, text);
        if (datenAbo != null) {
            ret = datenAbo.arr[1];
        }
        return ret;
    }

    public void sort() {
        Collections.sort(this);
    }

    public Object[][] getObjectData() {
        int i = 0;
        ListIterator iterator = this.listIterator();
        Object[][] object = new Object[this.size()][9];
        while (iterator.hasNext()) {
            DatenAbo datenAbo = (DatenAbo)iterator.next();
            object[i] = datenAbo.arr;
            ++i;
        }
        return object;
    }

    public boolean aboSuchen(String sender, String thema, boolean exakt, String text) {
        boolean ret = false;
        DatenAbo abo2 = null;
        for (DatenAbo abo2 : this) {
            if (!abo2.arr[2].equals(sender) || !abo2.arr[3].equals(thema) || !abo2.arr[5].equals(text) || !Boolean.parseBoolean(abo2.arr[4]) || !exakt) continue;
            ret = true;
        }
        return ret;
    }

    public boolean aboExists(String sender, String thema, String text) {
        boolean ret = false;
        if (this.getAbo(sender, thema, text) != null) {
            ret = true;
        }
        return ret;
    }

    public static boolean isPattern(String textSuchen) {
        return textSuchen.startsWith("#:");
    }

    public static Pattern makePattern(String textSuchen) {
        Pattern p = null;
        try {
            if (ListeAbo.isPattern(textSuchen)) {
                p = Pattern.compile(textSuchen.substring(2));
            }
        }
        catch (Exception ex) {
            p = null;
        }
        return p;
    }

    public static boolean aboPruefen(String senderSuchen, String themaSuchen, boolean themaExakt, String textSuchen, String imSender, String imThema, String imText) {
        Pattern p1 = ListeAbo.makePattern(themaSuchen);
        boolean ret = false;
        if (senderSuchen.equals("") || imSender.equals(senderSuchen)) {
            if (p1 != null) {
                if (p1.matcher(imThema).matches()) {
                    ret = ListeAbo.textPruefen(textSuchen, imText);
                }
            } else if (themaSuchen.equals("") || themaExakt && imThema.toLowerCase().equals(themaSuchen.toLowerCase()) || !themaExakt && imThema.toLowerCase().contains(themaSuchen.toLowerCase())) {
                ret = ListeAbo.textPruefen(textSuchen, imText);
            }
        }
        return ret;
    }

    private static boolean textPruefen(String textSuchen, String imText) {
        Pattern p = ListeAbo.makePattern(textSuchen);
        boolean ret = false;
        if (p != null) {
            ret = p.matcher(imText).matches();
        } else if (textSuchen.equals("") || imText.toLowerCase().contains(textSuchen.toLowerCase())) {
            ret = true;
        }
        return ret;
    }

    public DatenAbo getAbo(String sender, String thema, String text) {
        DatenAbo datenAbo = null;
        ListIterator iterator = this.listIterator();
        if (sender.equals("") && thema.equals("") && text.equals("")) {
            this.daten.fehler.fehlerMeldung("Abo", "Leeres Abo!");
        } else {
            while (iterator.hasNext()) {
                datenAbo = (DatenAbo)iterator.next();
                if (!ListeAbo.aboPruefen(datenAbo.arr[2], datenAbo.arr[3], Boolean.parseBoolean(datenAbo.arr[4]), datenAbo.arr[5], sender, thema, text)) continue;
                return datenAbo;
            }
        }
        return null;
    }
}

