/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.Log;

public class CellRendererAbo
extends DefaultTableCellRenderer {
    DDaten daten;

    public CellRendererAbo(DDaten d) {
        this.daten = d;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        this.setIcon(null);
        this.setHorizontalAlignment(10);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            int r = table.convertRowIndexToModel(row);
            int c = table.convertColumnIndexToModel(column);
            DatenAbo abo = this.daten.listeAbo.getAboNr(r);
            boolean eingeschaltet = abo.aboIstEingeschaltet();
            if (!eingeschaltet) {
                this.setFont(new Font("Dialog", 2, 12));
                if (isSelected) {
                    this.setBackground(GuiKonstanten.FARBE_GRAU_SEL);
                } else {
                    this.setBackground(GuiKonstanten.FARBE_GRAU);
                }
            }
            if (c == 1) {
                this.setHorizontalAlignment(0);
                if (eingeschaltet) {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
                } else {
                    this.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_12.png")));
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(630365892, 0, this.getClass().getName(), ex);
        }
        return this;
    }
}

