/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenPset;
import mediathek.tool.EscBeenden;
import mediathek.tool.GuiFunktionen;

public class DialogEditAbo
extends JDialog {
    private DDaten ddaten;
    private DatenAbo aktAbo;
    private JTextField[] textfeldListe;
    private JComboBox comboboxProgramm = new JComboBox();
    private JComboBox comboboxSender = new JComboBox();
    private JCheckBox checkBoxEingeschaltet = new JCheckBox();
    public boolean ok = false;
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogEditAbo(Frame parent, boolean modal, DDaten d, DatenAbo aktA) {
        super(parent, modal);
        this.initComponents();
        this.ddaten = d;
        this.aktAbo = aktA;
        this.comboboxProgramm.setModel(new DefaultComboBoxModel<String>(this.ddaten.listePset.getListeAbo().getObjectDataCombo()));
        this.comboboxSender.setModel(new DefaultComboBoxModel<String>(GuiFunktionen.addLeerListe(DDaten.filmeLaden.getSenderNamen())));
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditAbo.this.check();
                DialogEditAbo.this.beenden();
            }
        });
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditAbo.this.beenden();
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonBeenden);
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogEditAbo.this.beenden();
            }
        };
        this.setExtra();
    }

    private void setExtra() {
        this.textfeldListe = new JTextField[10];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < 10; ++i) {
            this.addExtraFeld(i, gridbag, c, this.jPanelExtra, this.aktAbo.arr);
            c.gridy = ++zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel, String[] item) {
        JLabel label;
        c.gridx = 0;
        c.weightx = 0.0;
        if (i == 3 || i == 4 || i == 5 || i == 6) {
            label = new JLabel("  " + DatenAbo.ABO_COLUMN_NAMES[i] + ": ");
            label.setForeground(Color.BLUE);
        } else {
            label = new JLabel(DatenAbo.ABO_COLUMN_NAMES[i] + ": ");
        }
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        if (i == 9) {
            if (this.ddaten.listePset.getListeAbo().size() <= 1) {
                JTextField textfeld;
                DatenPset gruppe = (DatenPset)this.ddaten.listePset.getListeAbo().getFirst();
                this.textfeldListe[i] = textfeld = new JTextField();
                if (item[i].equals("") && gruppe != null) {
                    this.aktAbo.arr[9] = gruppe.arr[0];
                }
                textfeld.setText(item[i]);
                textfeld.setEditable(false);
                gridbag.setConstraints(textfeld, c);
                panel.add(textfeld);
            } else {
                this.comboboxProgramm.setSelectedItem(item[i]);
                this.aktAbo.arr[9] = this.comboboxProgramm.getSelectedItem().toString();
                this.comboboxProgramm.addActionListener(new BeobComboProgramm());
                gridbag.setConstraints(this.comboboxProgramm, c);
                panel.add(this.comboboxProgramm);
            }
        } else if (i == 3) {
            this.comboboxSender.setSelectedItem(item[i]);
            this.aktAbo.arr[3] = this.comboboxSender.getSelectedItem().toString();
            this.comboboxSender.addActionListener(new BeobComboSender());
            gridbag.setConstraints(this.comboboxSender, c);
            panel.add(this.comboboxSender);
        } else if (i == 1) {
            this.checkBoxEingeschaltet.setSelected(Boolean.parseBoolean(item[i]));
            this.checkBoxEingeschaltet.addActionListener(new BeobCheckbox());
            gridbag.setConstraints(this.checkBoxEingeschaltet, c);
            panel.add(this.checkBoxEingeschaltet);
        } else {
            JTextField textfeld;
            this.textfeldListe[i] = textfeld = new JTextField();
            if (i == 0 || i == 8) {
                textfeld.setEditable(false);
            } else {
                textfeld.getDocument().addDocumentListener(new BeobachterDocumentTextfeld(i));
            }
            textfeld.setText(item[i]);
            gridbag.setConstraints(textfeld, c);
            panel.add(textfeld);
        }
    }

    private void check() {
        this.aktAbo.arr[7] = GuiFunktionen.replaceLeerDateiname(this.aktAbo.arr[7], true, true);
        this.ok = true;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonBeenden = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanelExtra.setBorder(new SoftBevelBorder(1));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 463, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 457, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonBeenden.setText("Ok");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 472, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 466, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen)).addContainerGap()));
        this.pack();
    }

    private class BeobCheckbox
    implements ActionListener {
        private BeobCheckbox() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[1] = Boolean.toString(DialogEditAbo.this.checkBoxEingeschaltet.isSelected());
        }
    }

    private class BeobComboSender
    implements ActionListener {
        private BeobComboSender() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[3] = DialogEditAbo.this.comboboxSender.getSelectedItem().toString();
        }
    }

    private class BeobComboProgramm
    implements ActionListener {
        private BeobComboProgramm() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[9] = DialogEditAbo.this.comboboxProgramm.getSelectedItem().toString();
        }
    }

    private class BeobachterDocumentTextfeld
    implements DocumentListener {
        int nr;

        public BeobachterDocumentTextfeld(int n) {
            this.nr = n;
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.eingabe();
        }

        private void eingabe() {
            ((DialogEditAbo)DialogEditAbo.this).aktAbo.arr[this.nr] = DialogEditAbo.this.textfeldListe[this.nr].getText().trim();
        }
    }
}

