/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mediathek.controller.filmeLaden.ListenerFilmeLaden;
import mediathek.controller.filmeLaden.ListenerFilmeLadenEvent;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeAbo;
import mediathek.daten.ListePset;
import mediathek.file.GetFile;
import mediathek.gui.GuiDownloads;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogDatenFilm;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.BeobMpanel;
import mediathek.tool.CellRendererFilme;
import mediathek.tool.Datum;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiKonstanten;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.JTableMed;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;
import mediathek.tool.TModelFilm;

public class GuiFilme
extends PanelVorlage {
    private JButton[] buttonArray;
    private final String[] COMBO_ZEIT = new String[]{"alles", "1 Tag", "2 Tage", "3 Tage", "4 Tage", "5 Tage", "10 Tage", "15 Tage", "20 Tage", "30 Tage"};
    public static final int[] COMBO_ZEIT_INT = new int[]{0, 1, 2, 3, 4, 5, 10, 15, 20, 30};
    private BeobMausTabelle beobMausTabelle;
    private DialogDatenFilm dialogDatenFilm = null;
    private String[] sender;
    private String[][] themenPerSender;
    private JButton jButtonFilterLoeschen;
    private JButton jButtonHilfe;
    private JCheckBox jCheckBoxFilter;
    private JCheckBox jCheckBoxKeineAbos;
    private JCheckBox jCheckBoxKeineGesehenen;
    private JCheckBox jCheckBoxProgamme;
    private JComboBox jComboBoxFilterSender;
    private JComboBox jComboBoxFilterThema;
    private JComboBox jComboBoxZeitraum;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelExtra;
    private JPanel jPanelExtraInnen;
    private JPanel jPanelFilter;
    private JPanel jPanelFilterInnen;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JTextField jTextFieldFilterThemaTitel;
    private JTextField jTextFieldFilterTitel;
    private JToggleButton jToggleButtonLivestram;

    public GuiFilme(DDaten d) {
        super(d);
        this.initComponents();
        this.tabelle = new JTableMed(0);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.dialogDatenFilm = new DialogDatenFilm(null, false, this.ddaten);
        this.init();
        this.panelVideoplayer();
        this.tabelleLaden();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void isShown() {
        super.isShown();
        this.ddaten.mediathekGui.setToolbar(1);
        this.ddaten.infoPanel.setIdx(1);
    }

    public void filmAbspielen() {
        this.filmAbspielen_();
    }

    public void filmSpeichern() {
        this.filmSpeichern_();
    }

    private void init() {
        this.checkBlacklist();
        this.jComboBoxZeitraum.setModel(new DefaultComboBoxModel<String>(this.COMBO_ZEIT));
        try {
            this.jCheckBoxKeineAbos.setSelected(Boolean.parseBoolean(Daten.system[31]));
            this.jCheckBoxKeineGesehenen.setSelected(Boolean.parseBoolean(Daten.system[32]));
            this.jComboBoxZeitraum.setSelectedIndex(Integer.parseInt(Daten.system[30]));
        }
        catch (Exception ex) {
            this.jComboBoxZeitraum.setSelectedIndex(6);
            Daten.system[30] = "6";
        }
        this.jComboBoxZeitraum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.system[30] = String.valueOf(GuiFilme.this.jComboBoxZeitraum.getSelectedIndex());
                GuiFilme.this.checkBlacklist();
                GuiFilme.this.tabelleLaden();
            }
        });
        DDaten.filmeLaden.addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start_(ListenerFilmeLadenEvent event) {
                ((GuiFilme)GuiFilme.this).beobMausTabelle.itemSenderLaden.setEnabled(false);
            }

            @Override
            public void fertig_(ListenerFilmeLadenEvent event) {
                GuiFilme.this.checkBlacklist();
                GuiFilme.this.tabelleLaden();
                ((GuiFilme)GuiFilme.this).beobMausTabelle.itemSenderLaden.setEnabled(true);
            }
        });
        this.jButtonHilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(null, false, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_SUCHEN)).setVisible(true);
            }
        });
        ActionMap am = this.tabelle.getActionMap();
        am.put("film_starten", new BeobAbstractAction());
        InputMap im = this.tabelle.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "film_starten");
        this.tabelle.setModel(new TModelFilm(new Object[0][], DatenFilm.FILME_COLUMN_NAMES));
        this.beobMausTabelle = new BeobMausTabelle();
        this.tabelle.addMouseListener(this.beobMausTabelle);
        this.tabelle.getSelectionModel().addListSelectionListener(new BeobachterTableSelect1());
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererFilme(this.ddaten));
        this.tabelle.setDefaultRenderer(Datum.class, new CellRendererFilme(this.ddaten));
        this.jToggleButtonLivestram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GuiFilme.this.stopBeob) {
                    GuiFilme.this.stopBeob = true;
                    GuiFilme.this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(GuiFilme.this.sender));
                    GuiFilme.this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(GuiFilme.this.getThemen("")));
                    GuiFilme.this.jTextFieldFilterTitel.setText("");
                }
                GuiFilme.this.tabelleLaden();
            }
        });
        this.jButtonFilterLoeschen.addActionListener(new BeobFilterLoeschen());
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.sender));
        this.jComboBoxFilterSender.addActionListener(new BeobFilterSender());
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
        this.jComboBoxFilterThema.addActionListener(new BeobFilter());
        this.jTextFieldFilterTitel.addActionListener(new BeobFilter());
        this.jTextFieldFilterTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.jTextFieldFilterThemaTitel.addActionListener(new BeobFilter());
        this.jTextFieldFilterThemaTitel.getDocument().addDocumentListener(new BeobFilterTitelDoc());
        this.jCheckBoxKeineAbos.addActionListener(new BeobFilter());
        this.jCheckBoxKeineGesehenen.addActionListener(new BeobFilter());
        this.jScrollPane1.addMouseListener(new BeobMausLaufendeProgramme());
        this.ddaten.infoPanel.addMouseListener(new BeobMausLaufendeProgramme());
        this.jCheckBoxFilter.addActionListener(new BeobMpanel(this.jCheckBoxFilter, this.jPanelFilter, "Filter"));
        this.jCheckBoxProgamme.addActionListener(new BeobMpanel(this.jCheckBoxProgamme, this.jPanelExtra, "weitere Videoplayer"));
        ListenerMediathekView.addListener(new ListenerMediathekView(3, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.panelVideoplayer();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(2, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.tabelleLaden();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(1, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.checkBlacklist();
                GuiFilme.this.tabelleLaden();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(5, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.checkBlacklist();
                GuiFilme.this.tabelleLaden();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(14, GuiFilme.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.tabelle.fireTableDataChanged(true);
                GuiFilme.this.setInfo();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(10, GuiDownloads.class.getSimpleName()){

            @Override
            public void ping() {
                GuiFilme.this.checkBlacklist();
                GuiFilme.this.tabelleLaden();
            }
        });
    }

    private void themenLaden() {
        this.sender = DDaten.listeFilmeNachBlackList.getModelOfFieldSender();
        this.themenPerSender = new String[this.sender.length][];
        for (int i = 0; i < this.sender.length; ++i) {
            this.themenPerSender[i] = DDaten.listeFilmeNachBlackList.getModelOfFieldThema(this.sender[i]);
        }
    }

    private String[] getThemen(String ssender) {
        for (int i = 1; i < this.themenPerSender.length; ++i) {
            if (!this.sender[i].equals(ssender)) continue;
            return this.themenPerSender[i];
        }
        return this.themenPerSender[0];
    }

    private synchronized void filmAbspielen_() {
        DatenPset gruppe = this.ddaten.listePset.getPsetAbspielen();
        if (gruppe != null) {
            this.open(gruppe);
        } else {
            JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Abspielen festlegen.", "kein Videoplayer!", 1);
        }
    }

    private synchronized void filmSpeichern_() {
        if (this.ddaten.listePset.getListeSpeichern().size() == 0) {
            JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
        } else {
            int[] selRows = this.tabelle.getSelectedRows();
            if (selRows.length == 0) {
                new HinweisKeineAuswahl().zeigen();
            } else {
                for (int i = 0; i < selRows.length; ++i) {
                    int selRow = selRows[i];
                    selRow = this.tabelle.convertRowIndexToModel(selRow);
                    DatenFilm film = DDaten.listeFilme.getFilmByUrl(this.tabelle.getModel().getValueAt(selRow, 6).toString());
                    DialogAddDownload dialog = new DialogAddDownload(null, this.ddaten, film);
                    dialog.setVisible(true);
                }
            }
        }
    }

    private void panelVideoplayer() {
        this.jPanelExtraInnen.removeAll();
        this.jPanelExtraInnen.updateUI();
        ListePset listeButton = this.ddaten.listePset.getListeButton();
        int maxSpalten = 4;
        this.buttonArray = new JButton[listeButton.size()];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(4, 10, 4, 10);
        this.jPanelExtraInnen.setLayout(gridbag);
        int spalte = 0;
        int zeile = 0;
        for (int i = 0; i < listeButton.size(); ++i) {
            if (!((DatenPset)listeButton.get(i)).isFreeLine()) {
                this.addExtraFeld(i, spalte, zeile, gridbag, c, this.jPanelExtraInnen, listeButton);
            }
            if (++spalte <= maxSpalten - 1) continue;
            spalte = 0;
            ++zeile;
        }
        c.weightx = 10.0;
        c.gridx = maxSpalten + 1;
        c.gridy = 0;
        JLabel label = new JLabel();
        gridbag.setConstraints(label, c);
        this.jPanelExtraInnen.add(label);
        this.jPanelExtra.setVisible(Boolean.parseBoolean(DDaten.system[11]));
    }

    private Component addExtraFeld(int i, int spalte, int zeile, GridBagLayout gridbag, GridBagConstraints c, JPanel panel, ListePset liste) {
        JComponent ret;
        c.gridx = spalte;
        c.gridy = zeile;
        if (((DatenPset)liste.get(i)).isLable()) {
            JLabel label = new JLabel(((DatenPset)liste.get((int)i)).arr[0]);
            Color col = ((DatenPset)liste.get(i)).getFarbe(this.ddaten);
            if (col != null) {
                label.setForeground(col);
            }
            gridbag.setConstraints(label, c);
            panel.add(label);
            ret = label;
        } else {
            JButton button = new JButton(((DatenPset)liste.get((int)i)).arr[0]);
            button.addActionListener(new BeobOpen((DatenPset)liste.get(i)));
            Color col = ((DatenPset)liste.get(i)).getFarbe(this.ddaten);
            if (col != null) {
                button.setBackground(col);
            }
            this.buttonArray[i] = button;
            gridbag.setConstraints(button, c);
            panel.add(button);
            ret = button;
        }
        return ret;
    }

    private synchronized void tabelleLaden() {
        try {
            boolean themaNichtDa = false;
            this.stopBeob = true;
            this.tabelle.getSpalten();
            String filterThema = this.jComboBoxFilterThema.getSelectedItem().toString();
            String filterSender = this.jComboBoxFilterSender.getSelectedItem().toString();
            boolean themaOpen = this.jComboBoxFilterThema.isPopupVisible();
            boolean senderOpen = this.jComboBoxFilterSender.isPopupVisible();
            if (DDaten.listeFilmeNachBlackList.isEmpty()) {
                this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.sender));
                this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
                this.jComboBoxFilterSender.setSelectedIndex(0);
                this.jComboBoxFilterThema.setSelectedIndex(0);
                this.listeInModellLaden();
            } else {
                this.listeInModellLaden();
                this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.sender));
                this.jComboBoxFilterSender.setSelectedIndex(0);
                if (!filterSender.equals("")) {
                    this.jComboBoxFilterSender.setEditable(true);
                    this.jComboBoxFilterSender.setSelectedItem(filterSender);
                    this.jComboBoxFilterSender.setEditable(false);
                    if (this.jComboBoxFilterSender.getSelectedIndex() == 0) {
                        filterSender = "";
                        this.listeInModellLaden();
                    }
                }
                this.jComboBoxFilterSender.setPopupVisible(senderOpen);
                if (filterSender.equals("")) {
                    this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
                } else {
                    this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.getThemen(filterSender)));
                }
                this.jComboBoxFilterThema.setEditable(true);
                this.jComboBoxFilterThema.setSelectedItem(filterThema);
                this.jComboBoxFilterThema.setEditable(false);
                if (!filterThema.equals("") && this.jComboBoxFilterThema.getSelectedIndex() == 0) {
                    themaNichtDa = true;
                }
                this.jComboBoxFilterThema.setPopupVisible(themaOpen);
            }
            this.setInfo();
            this.tabelle.setSpalten();
            this.stopBeob = false;
            if (themaNichtDa) {
                this.tabelleLaden();
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(558965421, 0, "GuiFilme.tabelleBauen", ex);
        }
    }

    private synchronized void listeInModellLaden() {
        TModelFilm m = DDaten.listeFilmeNachBlackList.getModelTabFilme(this.ddaten, (TModelFilm)this.tabelle.getModel(), this.jComboBoxFilterSender.getSelectedItem().toString(), this.jComboBoxFilterThema.getSelectedItem().toString(), this.jTextFieldFilterTitel.getText(), this.jTextFieldFilterThemaTitel.getText());
        if (m.getRowCount() > 0 && (this.jCheckBoxKeineGesehenen.isSelected() || this.jCheckBoxKeineAbos.isSelected() || this.jToggleButtonLivestram.isSelected())) {
            m.filter(this.ddaten, this.jCheckBoxKeineAbos.isSelected(), this.jCheckBoxKeineGesehenen.isSelected(), this.jToggleButtonLivestram.isSelected());
        }
        this.tabelle.setModel(m);
    }

    private void filterLoeschen() {
        this.stopBeob = true;
        this.jComboBoxFilterSender.setModel(new DefaultComboBoxModel<String>(this.sender));
        this.jComboBoxFilterThema.setModel(new DefaultComboBoxModel<String>(this.getThemen("")));
        this.jTextFieldFilterTitel.setText("");
        this.jTextFieldFilterThemaTitel.setText("");
        this.tabelleLaden();
        this.stopBeob = false;
    }

    private void table1Select() {
        DatenFilm aktFilm = new DatenFilm();
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow >= 0) {
            int selectedModelRow = this.tabelle.convertRowIndexToModel(selectedTableRow);
            DatenFilm film = Daten.listeFilme.getFilmByUrl(this.tabelle.getModel().getValueAt(selectedModelRow, 6).toString());
            if (film != null) {
                aktFilm = film;
            }
        }
        this.dialogDatenFilm.setAktFilm(aktFilm);
    }

    private void open(DatenPset gruppe) {
        if (this.tabelle.getSelectedRow() == -1) {
            new HinweisKeineAuswahl().zeigen();
        } else {
            String url = "";
            DatenFilm ersterFilm = new DatenFilm();
            int[] selectedTableRows = this.tabelle.getSelectedRows();
            for (int l = selectedTableRows.length - 1; l >= 0; --l) {
                int selectedModelRow = this.tabelle.convertRowIndexToModel(selectedTableRows[l]);
                ersterFilm = DDaten.listeFilmeNachBlackList.getFilmByUrl(this.tabelle.getModel().getValueAt(selectedModelRow, 6).toString());
                url = ersterFilm.arr[6] + " " + url;
                this.ddaten.history.add(ersterFilm.getUrlOrg());
            }
            ersterFilm.arr[6] = url.trim();
            this.ddaten.starterClass.urlStarten(gruppe, ersterFilm);
        }
    }

    private void senderLaden() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow >= 0) {
            int sel = this.tabelle.convertRowIndexToModel(selectedTableRow);
            Daten.filmeLaden.updateSender(new String[]{this.tabelle.getModel().getValueAt(sel, 1).toString()}, Daten.listeFilme);
        }
    }

    private void checkPattern(JTextField tf) {
        String text = tf.getText();
        if (ListeAbo.isPattern(text)) {
            if (ListeAbo.makePattern(text) == null) {
                tf.setBackground(GuiKonstanten.FILTER_REGEX_FEHLER);
            } else {
                tf.setBackground(GuiKonstanten.FILTER_REGEX);
            }
        } else {
            tf.setBackground(Color.WHITE);
        }
    }

    private void setInfo() {
        String textLinks;
        String leer = "   -   ";
        int gesamt = Daten.listeFilme.size();
        int anzListe = this.tabelle.getModel().getRowCount();
        int runs = this.ddaten.starterClass.getStarts(1).size();
        if (gesamt == anzListe) {
            textLinks = anzListe == 1 ? "1 Film" : anzListe + " Filme";
        } else {
            textLinks = anzListe == 1 ? "1 Film" : anzListe + " Filme";
            textLinks = textLinks + ", (insgesamt: " + gesamt + " Filme)";
        }
        if (runs == 1) {
            textLinks = textLinks + leer + runs + "    laufender Film";
        } else if (runs > 1) {
            textLinks = textLinks + leer + runs + "    laufende Filme";
        }
        this.ddaten.infoPanel.setTextLinks(1, textLinks);
    }

    private void checkBlacklist() {
        DDaten.listeFilmeNachBlackList = this.ddaten.listeBlacklist.filterListe(Daten.listeFilme);
        this.themenLaden();
        DDaten.listeFilmeNachBlackList.abosEintragen(this.ddaten);
    }

    private void initComponents() {
        this.jPanelFilter = new JPanel();
        this.jCheckBoxFilter = new JCheckBox();
        this.jPanelFilterInnen = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxZeitraum = new JComboBox();
        this.jCheckBoxKeineGesehenen = new JCheckBox();
        this.jCheckBoxKeineAbos = new JCheckBox();
        this.jToggleButtonLivestram = new JToggleButton();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxFilterSender = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jComboBoxFilterThema = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jTextFieldFilterTitel = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldFilterThemaTitel = new JTextField();
        this.jButtonFilterLoeschen = new JButton();
        this.jButtonHilfe = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanelExtra = new JPanel();
        this.jCheckBoxProgamme = new JCheckBox();
        this.jPanelExtraInnen = new JPanel();
        this.jPanelFilter.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxFilter.setBackground(new Color(217, 217, 217));
        this.jCheckBoxFilter.setFont(new Font("Dialog", 1, 10));
        this.jCheckBoxFilter.setText("Filter");
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel1.setText("Zeitraum:");
        this.jComboBoxZeitraum.setMaximumRowCount(10);
        this.jComboBoxZeitraum.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBoxKeineGesehenen.setText("keine gesehenen");
        this.jCheckBoxKeineAbos.setText("keine Abos");
        this.jToggleButtonLivestram.setText("nur Livestreams");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxZeitraum, -2, 131, -2).addGap(18, 18, 18).addComponent(this.jCheckBoxKeineGesehenen).addGap(18, 18, 18).addComponent(this.jCheckBoxKeineAbos).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 109, Short.MAX_VALUE).addComponent(this.jToggleButtonLivestram).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxZeitraum, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jCheckBoxKeineGesehenen).addComponent(this.jCheckBoxKeineAbos).addComponent(this.jToggleButtonLivestram)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jLabel2.setText("Sender:");
        this.jComboBoxFilterSender.setMaximumRowCount(25);
        this.jLabel3.setText("Thema:");
        this.jComboBoxFilterThema.setMaximumRowCount(25);
        this.jLabel5.setText("Titel:");
        this.jLabel6.setText("Thema oder Titel:");
        this.jButtonFilterLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
        this.jButtonFilterLoeschen.setToolTipText("Filter l\u00f6schen");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/help_16.png")));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterSender, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFilterThema, -2, 215, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilterTitel, -1, 207, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFilterThemaTitel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilterLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jButtonFilterLoeschen, this.jButtonHilfe);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.jComboBoxFilterSender, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.jComboBoxFilterThema, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jTextFieldFilterTitel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldFilterThemaTitel, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jButtonHilfe)).addComponent(this.jButtonFilterLoeschen, -2, 16, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jButtonFilterLoeschen, this.jButtonHilfe, this.jComboBoxFilterSender, this.jComboBoxFilterThema, this.jTextFieldFilterThemaTitel, this.jTextFieldFilterTitel);
        GroupLayout jPanelFilterInnenLayout = new GroupLayout(this.jPanelFilterInnen);
        this.jPanelFilterInnen.setLayout(jPanelFilterInnenLayout);
        jPanelFilterInnenLayout.setHorizontalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelFilterInnenLayout.setVerticalGroup(jPanelFilterInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterInnenLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelFilterLayout = new GroupLayout(this.jPanelFilter);
        this.jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFilterInnen, -1, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxFilter, -1, -1, Short.MAX_VALUE));
        jPanelFilterLayout.setVerticalGroup(jPanelFilterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFilterLayout.createSequentialGroup().addComponent(this.jCheckBoxFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFilterInnen, -1, -1, Short.MAX_VALUE)));
        this.jTable1.setAutoCreateRowSorter(true);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanelExtra.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jCheckBoxProgamme.setBackground(new Color(204, 204, 204));
        this.jCheckBoxProgamme.setFont(new Font("Dialog", 1, 10));
        this.jCheckBoxProgamme.setText("weitere Videoplayer");
        GroupLayout jPanelExtraInnenLayout = new GroupLayout(this.jPanelExtraInnen);
        this.jPanelExtraInnen.setLayout(jPanelExtraInnenLayout);
        jPanelExtraInnenLayout.setHorizontalGroup(jPanelExtraInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraInnenLayout.setVerticalGroup(jPanelExtraInnenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 106, Short.MAX_VALUE));
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxProgamme, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelExtraInnen, -1, -1, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jCheckBoxProgamme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExtraInnen, -1, -1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelFilter, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addComponent(this.jPanelExtra, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelFilter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 280, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExtra, -2, -1, -2).addContainerGap()));
    }

    private class BeobFilterTitelDoc
    implements DocumentListener {
        private BeobFilterTitelDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tus();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.tus();
        }

        private void tus() {
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterThemaTitel);
            GuiFilme.this.checkPattern(GuiFilme.this.jTextFieldFilterTitel);
            if (Boolean.parseBoolean(Daten.system[0])) {
                GuiFilme.this.tabelleLaden();
            }
        }
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filmAbspielen_();
        }
    }

    public class BeobMausTabelle
    extends MouseAdapter {
        JMenuItem itemSenderLaden = new JMenuItem("Sender aktualisieren");
        private BeobUrl beobUrl = new BeobUrl();
        private BeobPrint beobPrint = new BeobPrint();
        private BeobInfo beobInfo = new BeobInfo();
        private BeobFilterLoeschen beobLoeschen = new BeobFilterLoeschen();
        private BeobAbo beobAbo = new BeobAbo(false);
        private BeobAbo beobAboMitTitel = new BeobAbo(true);
        private BeobAboFilter beobAboFilter = new BeobAboFilter();
        private BeobFilterThema beobThema = new BeobFilterThema();
        private BeobFilterSender beobSender = new BeobFilterSender();
        private BeobFilterSenderThema beobSenderThema = new BeobFilterSenderThema();
        private BeobFilterSenderThemaTitel beobSenderThemaTitel = new BeobFilterSenderThemaTitel();
        private BeobSenderLaden beobSenderLaden = new BeobSenderLaden();
        private BeobBlacklist boeobBlacklistSender = new BeobBlacklist(true, false);
        private BeobBlacklist boeobBlacklistSenderThema = new BeobBlacklist(true, true);
        private Point p;
        JPanel panelNurAbo = new JPanel();
        JPanel panelKeineAbo = new JPanel();
        JPanel panelKeineGesehenen = new JPanel();
        JPanel panel24Stunden = new JPanel();
        JPanel panelLive = new JPanel();

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
            if (arg0.getButton() == 1 && arg0.getClickCount() > 1) {
                GuiFilme.this.filmAbspielen_();
            }
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            String filmThema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
            String filmSender = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
            String filmTitel = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 3).toString();
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem item = new JMenuItem("Film starten");
            item.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_play_16.png")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiFilme.this.filmAbspielen_();
                }
            });
            jPopupMenu.add(item);
            item = new JMenuItem("Film speichern");
            item.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/player_rec_16.png")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiFilme.this.filmSpeichern_();
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.addSeparator();
            JMenu submenueFilter = new JMenu("Filter");
            jPopupMenu.add(submenueFilter);
            item = new JMenuItem("Filter l\u00f6schen");
            item.addActionListener(this.beobLoeschen);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender filtern");
            item.addActionListener(this.beobSender);
            submenueFilter.add(item);
            item = new JMenuItem("nach Thema filtern");
            item.addActionListener(this.beobThema);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender und Thema filtern");
            item.addActionListener(this.beobSenderThema);
            submenueFilter.add(item);
            item = new JMenuItem("nach Sender, Thema und Titel filtern");
            item.addActionListener(this.beobSenderThemaTitel);
            submenueFilter.add(item);
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAboLoeschen = new JMenuItem("Abo L\u00f6schen");
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            JMenuItem itemAboFilter = new JMenuItem("Abo aus Filter anlegen");
            if (GuiFilme.this.ddaten.listeAbo.getAbo(filmSender, filmThema, filmTitel) != null) {
                itemAbo.setEnabled(false);
                itemAboMitTitel.setEnabled(false);
                itemAboFilter.setEnabled(false);
                itemAboLoeschen.addActionListener(this.beobAbo);
            } else {
                itemAboLoeschen.setEnabled(false);
                itemAbo.addActionListener(this.beobAbo);
                itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                itemAboFilter.addActionListener(this.beobAboFilter);
            }
            submenueAbo.add(itemAboLoeschen);
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            submenueAbo.add(itemAboFilter);
            JMenu submenue = new JMenu("Film mit Programm starten:");
            jPopupMenu.add(submenue);
            ListePset liste = GuiFilme.this.ddaten.listePset.getListeButton();
            for (int i = 0; i < liste.size(); ++i) {
                DatenPset pset = (DatenPset)liste.get(i);
                if (pset.getListeProg().isEmpty() && pset.arr[0].equals("")) continue;
                Color col = pset.getFarbe(GuiFilme.this.ddaten);
                item = new JMenuItem(pset.arr[0]);
                if (pset.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(new BeobOpen(pset));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.boeobBlacklistSender);
            itemBlackSenderThema.addActionListener(this.boeobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackSenderThema);
            jPopupMenu.addSeparator();
            this.itemSenderLaden.addActionListener(this.beobSenderLaden);
            jPopupMenu.add(this.itemSenderLaden);
            item = new JMenuItem("URL kopieren");
            item.addActionListener(this.beobUrl);
            jPopupMenu.add(item);
            item = new JMenuItem("Tabelle Drucken");
            item.addActionListener(this.beobPrint);
            jPopupMenu.add(item);
            item = new JMenuItem("Infos anzeigen");
            item.addActionListener(this.beobInfo);
            jPopupMenu.add(item);
            item = new JMenuItem("Spalten zur\u00fccksetzen");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiFilme.this.tabelle.resetTabelle();
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private class BeobBlacklist
        implements ActionListener {
            boolean sender;
            boolean thema;

            public BeobBlacklist(boolean ssender, boolean tthema) {
                this.sender = ssender;
                this.thema = tthema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    String th = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
                    String se = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
                    if (!this.sender) {
                        GuiFilme.this.ddaten.listeBlacklist.add(new DatenBlacklist("", th));
                    } else if (!this.thema) {
                        GuiFilme.this.ddaten.listeBlacklist.add(new DatenBlacklist(se, ""));
                    } else {
                        GuiFilme.this.ddaten.listeBlacklist.add(new DatenBlacklist(se, th));
                    }
                }
            }
        }

        private class BeobAboFilter
        implements ActionListener {
            private BeobAboFilter() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GuiFilme.this.ddaten.listePset.getListeAbo().size() == 0) {
                    JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        String filmThema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
                        GuiFilme.this.ddaten.listeAbo.addAbo(GuiFilme.this.jComboBoxFilterSender.getSelectedItem().toString(), GuiFilme.this.jComboBoxFilterThema.getSelectedItem().toString(), GuiFilme.this.jTextFieldFilterTitel.getText(), GuiFilme.this.jTextFieldFilterThemaTitel.getText(), filmThema);
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            boolean mitTitel = false;

            public BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GuiFilme.this.ddaten.listePset.getListeAbo().size() == 0) {
                    JOptionPane.showMessageDialog(null, "Im Men\u00fc unter \"Datei->Optionen->Videoplayer\" ein Programm zum Aufzeichnen festlegen.", "kein Videoplayer!", 1);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                    if (nr >= 0) {
                        String filmTitel;
                        String filmThema;
                        GuiFilme.this.stopBeob = true;
                        String filmSender = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
                        DatenAbo datenAbo = GuiFilme.this.ddaten.listeAbo.getAbo(filmSender, filmThema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString(), filmTitel = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 3).toString());
                        if (datenAbo != null) {
                            GuiFilme.this.ddaten.listeAbo.aboLoeschen(datenAbo);
                        } else if (this.mitTitel) {
                            GuiFilme.this.ddaten.listeAbo.addAbo(filmSender, filmThema, filmTitel);
                        } else {
                            GuiFilme.this.ddaten.listeAbo.addAbo(filmSender, filmThema, "");
                        }
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private class BeobFilterLoeschen
        implements ActionListener {
            private BeobFilterLoeschen() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.filterLoeschen();
            }
        }

        private class BeobFilterSenderThemaTitel
        implements ActionListener {
            private BeobFilterSenderThemaTitel() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    String titel = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 3).toString();
                    GuiFilme.this.jTextFieldFilterTitel.setText(titel);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelleLaden();
                }
            }
        }

        private class BeobFilterSenderThema
        implements ActionListener {
            private BeobFilterSenderThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    String thema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelleLaden();
                }
            }
        }

        private class BeobFilterSender
        implements ActionListener {
            private BeobFilterSender() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String sender = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 1).toString();
                    GuiFilme.this.jComboBoxFilterSender.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterSender.setSelectedItem(sender);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelleLaden();
                }
            }
        }

        private class BeobFilterThema
        implements ActionListener {
            private BeobFilterThema() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFilme.this.stopBeob = true;
                    String thema = "";
                    thema = GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 2).toString();
                    GuiFilme.this.jComboBoxFilterThema.setSelectedIndex(0);
                    GuiFilme.this.jComboBoxFilterThema.setSelectedItem(thema);
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelleLaden();
                }
            }
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.tabelle.print();
                }
                catch (PrinterException ex) {
                    Log.fehlerMeldung(688542239, 0, "GuiFilme.BeobPrint", ex);
                }
            }
        }

        private class BeobUrl
        implements ActionListener {
            private BeobUrl() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(BeobMausTabelle.this.p);
                if (nr >= 0) {
                    GuiFunktionen.copyToClipboard(GuiFilme.this.tabelle.getModel().getValueAt(GuiFilme.this.tabelle.convertRowIndexToModel(nr), 6).toString());
                }
            }
        }

        private class BeobSenderLaden
        implements ActionListener {
            private BeobSenderLaden() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.senderLaden();
            }
        }

        private class BeobInfo
        implements ActionListener {
            private BeobInfo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiFilme.this.dialogDatenFilm.setVis();
            }
        }
    }

    public class BeobMausLaufendeProgramme
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            LinkedList<Start> liste = GuiFilme.this.ddaten.starterClass.getStarts(1);
            if (liste.size() > 0) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                for (Start s : liste) {
                    JMenuItem item = new JMenuItem("Beenden: [" + s.datenDownload.arr[3] + "]  " + s.datenDownload.arr[5]);
                    item.addActionListener(new BeobProgramm(s));
                    jPopupMenu.add(item);
                }
                jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        private class BeobProgramm
        implements ActionListener {
            Start start;

            public BeobProgramm(Start sstart) {
                this.start = sstart;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (this.start != null) {
                        GuiFilme.this.ddaten.starterClass.filmLoeschen(this.start.datenDownload.arr[9]);
                    }
                }
                catch (Exception ex) {
                    System.err.println("GuiFilme.BeobProgramm: " + ex);
                }
            }
        }
    }

    private class BeobachterTableSelect1
    implements ListSelectionListener {
        public int selectedModelRow = -1;

        private BeobachterTableSelect1() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting()) {
                GuiFilme.this.table1Select();
            }
        }
    }

    private class BeobFilterLoeschen
    implements ActionListener {
        private BeobFilterLoeschen() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.filterLoeschen();
        }
    }

    private class BeobFilter
    implements ActionListener {
        private BeobFilter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                Daten.system[31] = String.valueOf(GuiFilme.this.jCheckBoxKeineAbos.isSelected());
                Daten.system[32] = String.valueOf(GuiFilme.this.jCheckBoxKeineGesehenen.isSelected());
                GuiFilme.this.tabelleLaden();
            }
        }
    }

    private class BeobFilterSender
    implements ActionListener {
        private BeobFilterSender() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!GuiFilme.this.stopBeob) {
                GuiFilme.this.tabelleLaden();
            }
        }
    }

    private class BeobOpen
    implements ActionListener {
        DatenPset gruppe;

        public BeobOpen(DatenPset p) {
            this.gruppe = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.open(this.gruppe);
        }
    }
}

