/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import mediathek.MediathekGui;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialogEinstellungen.PanelListeFilmlistenServer;
import mediathek.gui.dialogEinstellungen.PanelSenderLaden;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;

public class GuiDebug
extends PanelVorlage {
    private JButton[] buttonSender;
    private String[] sender;
    private JButton jButtonAllesSpeichern;
    private JButton jButtonFehler;
    private JButton jButtonFilmlisteLoeschen;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelListen;
    private JPanel jPanelSender;
    private JPanel jPanelSenderLaden;
    private JTabbedPane jTabbedPane1;
    private JToggleButton jToggleButtonAllesLaden;

    public GuiDebug(DDaten d) {
        super(d);
        this.initComponents();
        this.ddaten = d;
        this.sender = Daten.filmeLaden.getSenderNamen();
        this.buttonSender = new JButton[this.sender.length];
        for (int i = 0; i < Daten.filmeLaden.getSenderNamen().length; ++i) {
            this.buttonSender[i] = new JButton(this.sender[i]);
            this.buttonSender[i].addActionListener(new BeobSenderLoeschen(this.sender[i]));
        }
        this.addSender();
        this.jToggleButtonAllesLaden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.filmeLaden.setAllesLaden(GuiDebug.this.jToggleButtonAllesLaden.isSelected());
            }
        });
        this.jButtonAllesSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiDebug.this.ddaten.allesSpeichern();
            }
        });
        this.jButtonFilmlisteLoeschen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDaten.listeFilme.clear();
                ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
            }
        });
        this.jButtonFehler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.printEndeMeldung();
            }
        });
        this.jPanelSenderLaden.setLayout(new BorderLayout());
        this.jPanelSenderLaden.add(new PanelSenderLaden(this.ddaten));
        this.jPanelListen.setLayout(new BorderLayout());
        this.jPanelListen.add(new PanelListeFilmlistenServer(d));
    }

    private void addSender() {
        this.jPanelSender.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        this.jPanelSender.setLayout(gridbag);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 1;
        int nr = 0;
        int y = 0;
        int halbe = this.sender.length / 2;
        halbe += this.sender.length % 2;
        for (int i = 0; i < this.sender.length; ++i) {
            c.gridy = y++;
            this.addPanel(gridbag, c, this.sender[i], nr);
            ++nr;
            if (y < halbe) continue;
            y = 0;
            c.gridx = 1;
        }
        JLabel label = new JLabel();
        c.gridx = 4;
        c.weightx = 2.0;
        gridbag.setConstraints(label, c);
        this.jPanelSender.add(label);
        this.jPanelSender.updateUI();
    }

    private void addPanel(GridBagLayout gridbag, GridBagConstraints c, String sender, int nr) {
        c.insets = new Insets(2, 10, 2, 2);
        gridbag.setConstraints(this.buttonSender[nr], c);
        this.jPanelSender.add(this.buttonSender[nr]);
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.jPanelSenderLaden = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanelSender = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanelListen = new JPanel();
        this.jPanel4 = new JPanel();
        this.jToggleButtonAllesLaden = new JToggleButton();
        this.jButtonFilmlisteLoeschen = new JButton();
        this.jButtonAllesSpeichern = new JButton();
        this.jButtonFehler = new JButton();
        this.jPanelSenderLaden.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Sender starten"));
        GroupLayout jPanelSenderLadenLayout = new GroupLayout(this.jPanelSenderLaden);
        this.jPanelSenderLaden.setLayout(jPanelSenderLadenLayout);
        jPanelSenderLadenLayout.setHorizontalGroup(jPanelSenderLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 878, Short.MAX_VALUE));
        jPanelSenderLadenLayout.setVerticalGroup(jPanelSenderLadenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 503, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSenderLaden, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSenderLaden, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("tab2", this.jPanel2);
        this.jPanelSender.setBorder(BorderFactory.createTitledBorder(new SoftBevelBorder(1), "Sender l\u00f6schen"));
        GroupLayout jPanelSenderLayout = new GroupLayout(this.jPanelSender);
        this.jPanelSender.setLayout(jPanelSenderLayout);
        jPanelSenderLayout.setHorizontalGroup(jPanelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 878, Short.MAX_VALUE));
        jPanelSenderLayout.setVerticalGroup(jPanelSenderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 503, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSender, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelSender, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("tab1", this.jPanel1);
        GroupLayout jPanelListenLayout = new GroupLayout(this.jPanelListen);
        this.jPanelListen.setLayout(jPanelListenLayout);
        jPanelListenLayout.setHorizontalGroup(jPanelListenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 892, Short.MAX_VALUE));
        jPanelListenLayout.setVerticalGroup(jPanelListenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 532, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelListen, -1, -1, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelListen, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab("tab3", this.jPanel3);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jToggleButtonAllesLaden.setText("[-alles] setzen");
        this.jButtonFilmlisteLoeschen.setText("Filmliste l\u00f6schen");
        this.jButtonAllesSpeichern.setText("alles speichern");
        this.jButtonFehler.setText("Fehler ausgeben");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.jToggleButtonAllesLaden).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFilmlisteLoeschen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAllesSpeichern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFehler).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel4Layout.linkSize(0, this.jButtonAllesSpeichern, this.jButtonFilmlisteLoeschen, this.jToggleButtonAllesLaden);
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButtonAllesLaden).addComponent(this.jButtonFilmlisteLoeschen).addComponent(this.jButtonAllesSpeichern).addComponent(this.jButtonFehler)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private class BeobSenderLoeschen
    implements ActionListener {
        private String sender;

        public BeobSenderLoeschen(String ssender) {
            this.sender = ssender;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DDaten.listeFilme.delSender(this.sender);
            ListenerMediathekView.notify(5, MediathekGui.class.getSimpleName());
        }
    }
}

