/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import mediathek.daten.DDaten;
import mediathek.daten.DatenAbo;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.tool.CellRendererAbo;
import mediathek.tool.Datum;
import mediathek.tool.HinweisKeineAuswahl;
import mediathek.tool.JTableMed;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModelAbo;

public class GuiAbo
extends PanelVorlage {
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public GuiAbo(DDaten d) {
        super(d);
        this.initComponents();
        this.tabelle = new JTableMed(2);
        this.jScrollPane1.setViewportView(this.tabelle);
        this.initBeobachter();
        this.tabelleLaden();
        this.tabelle.initTabelle();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public void isShown() {
        super.isShown();
        this.ddaten.mediathekGui.setToolbar(3);
        this.ddaten.infoPanel.setIdx(3);
    }

    public void aendern() {
        this.aboAendern();
    }

    public void einAus(boolean ein) {
        this.aboEinAus(ein);
    }

    public void loeschen() {
        this.aboLoeschen();
    }

    private void initBeobachter() {
        ListenerMediathekView.addListener(new ListenerMediathekView(10, GuiAbo.class.getSimpleName()){

            @Override
            public void ping() {
                GuiAbo.this.tabelleLaden();
            }
        });
        this.tabelle.addMouseListener(new BeobMausTabelle1());
        this.tabelle.setDefaultRenderer(Object.class, new CellRendererAbo(this.ddaten));
        this.tabelle.setDefaultRenderer(Datum.class, new CellRendererAbo(this.ddaten));
        this.tabelle.setModel(new TModelAbo(new Object[0][], DatenAbo.ABO_COLUMN_NAMES));
        ActionMap am = this.tabelle.getActionMap();
        am.put("aendern", new BeobAbstractAction());
        InputMap im = this.tabelle.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, "aendern");
    }

    private void tabelleLaden() {
        this.tabelle.getSpalten();
        this.ddaten.listeAbo.addObjectData((TModelAbo)this.tabelle.getModel());
        this.tabelle.setSpalten();
        this.setInfo();
    }

    private void aboLoeschen() {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            String text;
            if (rows.length == 1) {
                int delRow = this.tabelle.convertRowIndexToModel(rows[0]);
                text = "\"" + this.tabelle.getModel().getValueAt(delRow, 2).toString() + "\" l\u00f6schen?";
            } else {
                text = rows.length + " Abos l\u00f6schen?";
            }
            int ret = JOptionPane.showConfirmDialog(null, text, "L\u00f6schen?", 0);
            if (ret == 0) {
                for (int i = rows.length - 1; i >= 0; --i) {
                    int delRow = this.tabelle.convertRowIndexToModel(rows[i]);
                    ((TModelAbo)this.tabelle.getModel()).removeRow(delRow);
                    this.ddaten.listeAbo.remove(delRow);
                }
            }
            this.tabelleLaden();
            ListenerMediathekView.notify(10, GuiAbo.class.getSimpleName());
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void aboAendern() {
        int row = this.tabelle.getSelectedRow();
        if (row >= 0) {
            int delRow = this.tabelle.convertRowIndexToModel(row);
            DatenAbo akt = this.ddaten.listeAbo.getAboNr(delRow);
            DatenAbo ret = akt.getCopy();
            DialogEditAbo dialog = new DialogEditAbo(null, true, this.ddaten, ret);
            dialog.setVisible(true);
            if (dialog.ok) {
                akt.aufMichKopieren(ret);
                this.tabelleLaden();
                ListenerMediathekView.notify(10, GuiAbo.class.getSimpleName());
            }
            this.setInfo();
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void aboEinAus(boolean ein) {
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            int i;
            for (i = 0; i < rows.length; ++i) {
                int modelRow = this.tabelle.convertRowIndexToModel(rows[i]);
                DatenAbo akt = this.ddaten.listeAbo.getAboNr(modelRow);
                akt.arr[1] = String.valueOf(ein);
            }
            this.tabelleLaden();
            this.tabelle.clearSelection();
            for (i = 0; i < rows.length; ++i) {
                this.tabelle.addRowSelectionInterval(rows[i], rows[i]);
            }
            this.setInfo();
            ListenerMediathekView.notify(10, GuiAbo.class.getSimpleName());
        } else {
            new HinweisKeineAuswahl().zeigen();
        }
    }

    private void setInfo() {
        int ein = 0;
        int aus = 0;
        int gesamt = this.tabelle.getModel().getRowCount();
        for (int i = 0; i < this.tabelle.getModel().getRowCount(); ++i) {
            int modelRow = this.tabelle.convertRowIndexToModel(i);
            DatenAbo akt = this.ddaten.listeAbo.getAboNr(modelRow);
            if (akt.aboIstEingeschaltet()) {
                ++ein;
                continue;
            }
            ++aus;
        }
        String textLinks = gesamt == 1 ? "1 Abo, " : gesamt + " Abos, ";
        textLinks = textLinks + "(" + ein + " eingeschaltet, " + aus + " ausgeschaltet)";
        this.ddaten.infoPanel.setTextLinks(3, textLinks);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jLabel1.setText("jLabel1");
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 576, Short.MAX_VALUE).addGap(14, 14, 14)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 247, Short.MAX_VALUE).addContainerGap()));
    }

    private class BeobMausTabelle1
    extends MouseAdapter {
        private Point p;

        private BeobMausTabelle1() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                if (arg0.getClickCount() > 1) {
                    GuiAbo.this.aboAendern();
                }
            } else if (arg0.getButton() == 3) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            boolean ein = true;
            this.p = evt.getPoint();
            int nr = GuiAbo.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiAbo.this.tabelle.setRowSelectionInterval(nr, nr);
                int modelRow = GuiAbo.this.tabelle.convertRowIndexToModel(nr);
                DatenAbo akt = GuiAbo.this.ddaten.listeAbo.getAboNr(modelRow);
                ein = Boolean.parseBoolean(akt.arr[1]);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenuItem itemEinschalten = new JMenuItem("Abo einschalten");
            itemEinschalten.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/ja_16.png")));
            itemEinschalten.setEnabled(!ein);
            itemEinschalten.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboEinAus(true);
                }
            });
            jPopupMenu.add(itemEinschalten);
            JMenuItem itemDeaktivieren = new JMenuItem("Abo deaktivieren");
            itemDeaktivieren.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/nein_16.png")));
            itemDeaktivieren.setEnabled(ein);
            itemDeaktivieren.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboEinAus(false);
                }
            });
            jPopupMenu.add(itemDeaktivieren);
            JMenuItem itemLoeschen = new JMenuItem("Abo l\u00f6schen");
            itemLoeschen.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/del_16.png")));
            itemLoeschen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboLoeschen();
                }
            });
            jPopupMenu.add(itemLoeschen);
            JMenuItem itemAendern = new JMenuItem("Abo \u00e4ndern");
            itemAendern.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/configure_16.png")));
            itemAendern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.aboAendern();
                }
            });
            jPopupMenu.add(itemAendern);
            jPopupMenu.addSeparator();
            JMenuItem item = new JMenuItem("Spalten zur\u00fccksetzen");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiAbo.this.tabelle.resetTabelle();
                }
            });
            jPopupMenu.add(item);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private class BeobAbstractAction
    extends AbstractAction {
        private BeobAbstractAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiAbo.this.aendern();
        }
    }
}

