/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.SimpleTimeZone;
import java.util.TreeSet;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeAbo;
import mediathek.tool.Funktionen;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log;
import mediathek.tool.TModelFilm;
import org.apache.commons.lang3.StringEscapeUtils;

public class ListeFilme
extends LinkedList<DatenFilm> {
    public static final String THEMA_LIVE = "Livestream";
    public static final String FILMLISTE = "Filmliste";
    public static final int FILMLISTE_MAX_ELEM = 4;
    public static final String FILMLISTE_DATUM = "Filmliste-Datum";
    public static final int FILMLISTE_DATUM_NR = 0;
    public static final String FILMLISTE_DATUM_GMT = "Filmliste-Datum-GMT";
    public static final int FILMLISTE_DATUM_GMT_NR = 1;
    public static final String FILMLISTE_VERSION = "Filmliste-Version";
    public static final int FILMLISTE_VERSION_NR = 2;
    public static final String FILMLISTE_PROGRAMM = "Filmliste-Programm";
    public static final int FILMLISTE_PRGRAMM_NR = 3;
    public static final String[] FILMLISTE_COLUMN_NAMES = new String[]{"Filmliste-Datum", "Filmliste-Datum-GMT", "Filmliste-Version", "Filmliste-Programm"};
    private int nr = 0;
    public String[] metaDaten;
    private HashSet<String> hashSetModelOfField = new HashSet();
    private LinkedList<String> listGetModelOfField = new LinkedList();
    private TreeSet<String> ts = new TreeSet<String>(GermanStringSorter.getInstance());
    private final String DATUM_ZEIT_FORMAT = "dd.MM.yyyy, HH:mm";

    public ListeFilme() {
        this.metaDaten = ListeFilme.newMetaDaten();
    }

    public static String[] newMetaDaten() {
        String[] ret = new String[4];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = "";
        }
        return ret;
    }

    @Override
    public synchronized void clear() {
        this.nr = 0;
        super.clear();
    }

    public void sort() {
        Collections.sort(this);
        Iterator it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            ((DatenFilm)it.next()).arr[0] = this.getNr(i++);
        }
    }

    public synchronized void setMeta(String[] mmeta) {
        for (int i = 0; i < 4; ++i) {
            this.metaDaten[i] = mmeta[i].toString();
        }
    }

    public synchronized boolean addFilmVomSender(DatenFilm film) {
        film.arr[2] = StringEscapeUtils.unescapeXml(film.arr[2].trim());
        film.arr[2] = StringEscapeUtils.unescapeHtml4(film.arr[2].trim());
        film.arr[3] = StringEscapeUtils.unescapeXml(film.arr[3].trim());
        film.arr[3] = StringEscapeUtils.unescapeHtml4(film.arr[3].trim());
        for (DatenFilm f : this) {
            if (!f.getIndex().equals(film.getIndex())) continue;
            return false;
        }
        return this.add(film);
    }

    public synchronized void updateListe(ListeFilme liste, boolean index) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (index) {
                hashSet.add(((DatenFilm)it.next()).getIndex());
                continue;
            }
            hashSet.add(((DatenFilm)it.next()).arr[6]);
        }
        for (DatenFilm film : liste) {
            if (index) {
                if (hashSet.contains(film.getIndex())) continue;
                this.add(film);
                continue;
            }
            if (hashSet.contains(film.arr[6])) continue;
            this.add(film);
        }
    }

    public synchronized boolean addWithNr(DatenFilm film) {
        film.arr[0] = this.getNr(this.nr++);
        film.arr[6] = film.getUrlOrg();
        film.setDatum();
        return this.add(film);
    }

    private String getNr(int nr) {
        int MAX_STELLEN = 5;
        String FUELL_ZEICHEN = "0";
        String str = String.valueOf(nr);
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str;
    }

    public synchronized int countSender(String sender) {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenFilm)it.next()).arr[1].equalsIgnoreCase(sender)) continue;
            ++ret;
        }
        return ret;
    }

    public synchronized void delSender(String sender) {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm film = (DatenFilm)it.next();
            if (!film.arr[1].equalsIgnoreCase(sender)) continue;
            it.remove();
        }
    }

    public void liveStreamEintragen() {
        this.addFilmVomSender(new DatenFilm("ZDF", THEMA_LIVE, "", "ZDF Livestream", "http://wstreaming.zdf.de/encoder/livestream2_vh.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("3Sat", THEMA_LIVE, "", "3Sat Livestream", "http://wstreaming.zdf.de/encoder/3sat_vh.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("ARD", THEMA_LIVE, "", "ARD Tagesschau Livestream", "mmsh://tagesschau-live1-webm-wmv.wm.llnwd.net/tagesschau_live1_webm_wmv?MSWMExt=.asf", "", ""));
        this.addFilmVomSender(new DatenFilm("NDR", THEMA_LIVE, "", "NDR Livestream", "http://www.ndr.de/resources/metadaten/ndr_fs_nds_hi_wmv.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("WDR", THEMA_LIVE, "", "WDR Livestream", "http://www.wdr.de/wdrlive/media/wdr-fernsehen_web-l.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR SACHSEN Livestream", "http://avw.mdr.de/livestreams/mdr_tv_sachsen.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR SACHSEN-ANHALT Livestream", "http://avw.mdr.de/livestreams/mdr_tv_sachsen-anhalt.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("MDR", THEMA_LIVE, "", "MDR TH\u00dcRINGEN Livestream", "http://avw.mdr.de/livestreams/mdr_tv_thueringen.asx", "", ""));
        this.addFilmVomSender(new DatenFilm("ARD", THEMA_LIVE, "", "ARD Phoenix Livestream", "http://hstreaming.zdf.de/encoder/phoenix_vh.mov", "", ""));
    }

    public synchronized void getModelTabFilme___(DDaten ddaten, TModelFilm modelFilm, String filterSender, String filterThema, String filterTitel, String filterThemaTitel) {
        modelFilm.setRowCount(0);
        if (this.size() != 0) {
            if (filterSender.equals("") && filterThema.equals("") && filterTitel.equals("") && filterThemaTitel.equals("")) {
                this.addObjectDataTabFilme(ddaten, modelFilm);
            } else {
                ListeFilme liste = new ListeFilme();
                for (DatenFilm film : this) {
                    if (!ListeAbo.filterAufAboPruefen(filterSender, filterThema, filterTitel, filterThemaTitel, film.arr[1], film.arr[2], film.arr[3])) continue;
                    liste.add(film);
                }
                liste.addObjectDataTabFilme(ddaten, modelFilm);
            }
        }
    }

    public synchronized TModelFilm getModelTabFilme(DDaten ddaten, TModelFilm modelFilm__, String filterSender, String filterThema, String filterTitel, String filterThemaTitel) {
        TModelFilm modelFilm = new TModelFilm(new Object[0][], DatenFilm.FILME_COLUMN_NAMES);
        if (this.size() != 0) {
            if (filterSender.equals("") && filterThema.equals("") && filterTitel.equals("") && filterThemaTitel.equals("")) {
                this.addObjectDataTabFilme(ddaten, modelFilm);
            } else {
                ListeFilme liste = new ListeFilme();
                for (DatenFilm film : this) {
                    if (!ListeAbo.filterAufAboPruefen(filterSender, filterThema, filterTitel, filterThemaTitel, film.arr[1], film.arr[2], film.arr[3])) continue;
                    liste.add(film);
                }
                liste.addObjectDataTabFilme(ddaten, modelFilm);
            }
        }
        return modelFilm;
    }

    public synchronized String[] getModelOfField_(int feld, String filterString, int filterFeld) {
        this.listGetModelOfField.add("");
        Iterator it = this.iterator();
        if (filterString.equals("")) {
            while (it.hasNext()) {
                String str = ((DatenFilm)it.next()).arr[feld];
                String s = str.toLowerCase();
                if (this.hashSetModelOfField.contains(s)) continue;
                this.hashSetModelOfField.add(s);
                this.listGetModelOfField.add(str);
            }
        } else {
            while (it.hasNext()) {
                String s;
                DatenFilm film = (DatenFilm)it.next();
                String str = film.arr[feld];
                if (!film.arr[filterFeld].equalsIgnoreCase(filterString) || this.hashSetModelOfField.contains(s = str.toLowerCase())) continue;
                this.hashSetModelOfField.add(s);
                this.listGetModelOfField.add(str);
            }
        }
        this.hashSetModelOfField.clear();
        GuiFunktionen.listeSort(this.listGetModelOfField);
        String[] ret = new String[]{};
        ret = this.listGetModelOfField.toArray(ret);
        this.listGetModelOfField.clear();
        return ret;
    }

    public synchronized String[] getModelOfFieldThema(String sender) {
        this.ts.add("");
        Iterator it = this.iterator();
        if (sender.equals("")) {
            while (it.hasNext()) {
                String str = ((DatenFilm)it.next()).arr[2];
                String s = str.toLowerCase();
                if (this.hashSetModelOfField.contains(s)) continue;
                this.hashSetModelOfField.add(s);
                this.ts.add(str);
            }
        } else {
            while (it.hasNext()) {
                String str;
                String s;
                DatenFilm film = (DatenFilm)it.next();
                if (!film.arr[1].equals(sender) || this.hashSetModelOfField.contains(s = (str = film.arr[2]).toLowerCase())) continue;
                this.hashSetModelOfField.add(s);
                this.ts.add(str);
            }
        }
        this.hashSetModelOfField.clear();
        String[] a = this.ts.toArray(new String[0]);
        this.ts.clear();
        return a;
    }

    public synchronized String[] getModelOfFieldSender() {
        this.ts.add("");
        Iterator it = this.iterator();
        int max = DDaten.filmeLaden.getSenderNamen().length;
        while (it.hasNext()) {
            String str = ((DatenFilm)it.next()).arr[1];
            if (this.ts.contains(str)) continue;
            this.ts.add(str);
            if (this.ts.size() <= max) continue;
        }
        String[] a = this.ts.toArray(new String[0]);
        this.ts.clear();
        return a;
    }

    public synchronized DatenFilm getFilmByUrl(String url) {
        DatenFilm ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenFilm f = (DatenFilm)it.next();
            if (!f.arr[6].equals(url)) continue;
            ret = f;
            break;
        }
        return ret;
    }

    private void addObjectDataTabFilme(DDaten ddaten, TModelFilm model) {
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            while (iterator.hasNext()) {
                DatenFilm film = (DatenFilm)iterator.next();
                Object[] object = new Object[11];
                for (int m = 0; m < 11; ++m) {
                    object[m] = m == 4 ? film.datumFilm : film.arr[m];
                }
                model.addRow(object);
            }
        }
    }

    public void abosEintragen(DDaten ddaten) {
        ListIterator iterator = this.listIterator(0);
        while (iterator.hasNext()) {
            DatenFilm film = (DatenFilm)iterator.next();
            DatenAbo datenAbo = ddaten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3]);
            if (datenAbo != null) {
                film.arr[10] = datenAbo.arr[2];
                continue;
            }
            film.arr[10] = "";
        }
    }

    public String erstellt() {
        String ret;
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        if (this.metaDaten[1].equals("")) {
            ret = this.metaDaten[0];
        } else {
            String date = this.metaDaten[1];
            sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
            Date filmDate = null;
            try {
                filmDate = sdf.parse(date);
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (filmDate == null) {
                ret = this.metaDaten[1];
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
                ret = formatter.format(filmDate);
            }
        }
        return ret;
    }

    public int alterFilmlisteSek() {
        String date;
        int ret = 0;
        Date jetzt = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        if (!this.metaDaten[1].equals("")) {
            date = this.metaDaten[1];
            sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        } else {
            date = this.metaDaten[0];
        }
        Date filmDate = null;
        try {
            filmDate = sdf.parse(date);
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (jetzt != null && filmDate != null && (ret = Math.round((jetzt.getTime() - filmDate.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    public boolean filmlisteZuAlt() {
        if (this.size() == 0) {
            return true;
        }
        return this.filmlisteIstAelter(10800);
    }

    public boolean filmlisteIstAelter(int sekunden) {
        int ret = this.alterFilmlisteSek();
        if (ret != 0) {
            Log.systemMeldung("Die Filmliste ist " + ret / 60 + " Minuten alt");
        }
        return ret > sekunden;
    }

    public void metaDatenSchreiben(boolean stop) {
        this.metaDaten = ListeFilme.newMetaDaten();
        if (!Daten.filmeLaden.getStop()) {
            this.metaDaten[0] = this.getJetzt_ddMMyyyy_HHmm();
            this.metaDaten[1] = this.getJetzt_ddMMyyyy_HHmm_gmt();
        } else {
            this.metaDaten[0] = "";
            this.metaDaten[1] = "";
        }
        this.metaDaten[2] = "3.1.0";
        this.metaDaten[3] = Funktionen.getProgVersionString() + " - Compiled: " + Funktionen.getCompileDate();
    }

    private String getJetzt_ddMMyyyy_HHmm() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        return formatter.format(new Date());
    }

    private String getJetzt_ddMMyyyy_HHmm_gmt() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
        formatter.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return formatter.format(new Date());
    }
}

