/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.tool.DatumZeit;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModelDownload;

public class ListeDownloads
extends LinkedList<DatenDownload> {
    private DDaten ddaten;

    public ListeDownloads(DDaten ddaten) {
        this.ddaten = ddaten;
    }

    public void sort() {
        Collections.sort(this);
    }

    public boolean addMitNummer(DatenDownload e) {
        boolean ret = super.add(e);
        this.listeNummerieren();
        return ret;
    }

    public synchronized void zurueckgestellteWiederAktivieren() {
        Object d = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            ((DatenDownload)it.next()).arr[21] = Boolean.FALSE.toString();
        }
    }

    public synchronized void listePutzen() {
        boolean gefunden = false;
        LinkedList<Start> s = this.ddaten.starterClass.getStarts(-1);
        for (Start start : s) {
            if (start.status < 3) continue;
            gefunden = true;
            this.delDownloadByUrl(start.datenDownload.arr[9]);
        }
        if (gefunden) {
            ListenerMediathekView.notify(9, this.getClass().getSimpleName());
        }
        this.ddaten.starterClass.aufraeumen();
    }

    public synchronized DatenDownload downloadVorziehen(String url) {
        DatenDownload d = null;
        Start s = this.ddaten.starterClass.urlVorziehen(url);
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            d = (DatenDownload)it.next();
            if (!d.arr[9].equals(url)) continue;
            it.remove();
            this.addFirst(d);
            break;
        }
        this.listeNummerieren();
        return d;
    }

    public synchronized DatenDownload getDownloadByUrl(String url) {
        DatenDownload ret = null;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (!d.arr[9].equals(url)) continue;
            ret = d;
            break;
        }
        return ret;
    }

    public synchronized boolean delDownloadByUrl(String url) {
        boolean ret = false;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (!((DatenDownload)it.next()).arr[9].equals(url)) continue;
            it.remove();
            ret = true;
            break;
        }
        if (ret) {
            this.listeNummerieren();
        }
        return ret;
    }

    public synchronized void getModel(TModelDownload tModel, boolean abos, boolean downloads) {
        tModel.setRowCount(0);
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            while (iterator.hasNext()) {
                DatenDownload download = (DatenDownload)iterator.next();
                if (download.istZurueckgestellt()) continue;
                boolean istAbo = download.istAbo();
                if ((!abos || !istAbo) && (!downloads || istAbo)) continue;
                DatenDownload datenDownload = download.getCopy();
                Object[] object = new Object[22];
                for (int i = 0; i < 22; ++i) {
                    object[i] = i == 15 ? "" : (i == 7 ? DatumZeit.getDatumForObject(datenDownload) : datenDownload.arr[i]);
                }
                tModel.addRow(object);
            }
        }
    }

    public synchronized void abosSuchen() {
        boolean gefunden = false;
        ListIterator itFilm = Daten.listeFilme.listIterator();
        while (itFilm.hasNext()) {
            DatenFilm film = (DatenFilm)itFilm.next();
            DatenAbo abo = this.ddaten.listeAbo.getAbo(film.arr[1], film.arr[2], film.arr[3]);
            if (abo == null || !abo.aboIstEingeschaltet() || this.ddaten.erledigteAbos.urlPruefen(film.arr[6]) || this.checkListe(film.arr[6])) continue;
            abo.arr[8] = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            DatenPset pSet = this.ddaten.listePset.getPsetAbo(abo.arr[9]);
            if (!abo.arr[9].equals(pSet.arr[0])) {
                abo.arr[9] = pSet.arr[0];
            }
            if (pSet == null) continue;
            this.add(new DatenDownload(pSet, film, 3, abo, "", ""));
            gefunden = true;
        }
        if (gefunden) {
            this.listeNummerieren();
        }
    }

    public synchronized void abosLoschenWennNochNichtGestartet() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Start s;
            DatenDownload d = (DatenDownload)it.next();
            if (!d.istAbo() || (s = this.ddaten.starterClass.getStart(d.arr[9])) != null) continue;
            it.remove();
            gefunden = true;
        }
        if (gefunden) {
            this.listeNummerieren();
        }
    }

    public void listeNummerieren() {
        int i = 0;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            String str = String.valueOf(i++);
            while (str.length() < 3) {
                str = "0" + str;
            }
            ((DatenDownload)it.next()).arr[0] = str;
        }
    }

    private boolean checkListe(String url) {
        boolean ret = false;
        ListIterator it = this.listIterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (!url.equals(d.arr[9])) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

