/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io.starter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import mediathek.controller.io.starter.ListeStarts;
import mediathek.controller.io.starter.RuntimeExec;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.Log;
import mediathek.tool.TModel;

public class StarterClass {
    private DDaten ddaten;
    private ListeStarts listeStarts;
    private Starten starten = null;

    public StarterClass(DDaten d) {
        this.ddaten = d;
        this.init();
    }

    private void init() {
        this.listeStarts = new ListeStarts(this.ddaten);
        this.starten = new Starten();
        Thread startenThread = new Thread(this.starten);
        startenThread.setDaemon(true);
        startenThread.start();
    }

    public synchronized Start urlStarten(DatenPset pSet, DatenFilm ersterFilm) {
        Start s = null;
        String url = ersterFilm.arr[6];
        if (!url.equals("")) {
            s = new Start(new DatenDownload(pSet, ersterFilm, 1, null, "", ""));
            this.starten.startStarten(s);
            this.addStarts(s);
        }
        return s;
    }

    public Start urlVorziehen(String url) {
        return this.listeStarts.urlVorziehen(url);
    }

    public synchronized LinkedList<Start> getStarts(int quelle) {
        return this.listeStarts.getStarts(quelle);
    }

    public synchronized int getDownloadsWarten() {
        return this.listeStarts.getDownloadsWarten();
    }

    public synchronized int getDownloadsLaufen() {
        return this.listeStarts.getDownloadsLaufen();
    }

    public synchronized int getStartsWaiting() {
        return this.listeStarts.getmax();
    }

    public synchronized TModel getModellStarts(TModel model) {
        return this.listeStarts.getModelStarts(model);
    }

    public synchronized void addStarts(Start start) {
        this.listeStarts.addStarts(start);
    }

    public synchronized Start getStart(String url) {
        return this.listeStarts.getStart(url);
    }

    public synchronized void aufraeumen() {
        this.listeStarts.aufraeumen();
    }

    public synchronized void delAllStart() {
        this.listeStarts.delAllStart();
    }

    public synchronized void filmLoeschen(String url) {
        this.listeStarts.delStart(url);
    }

    private void notifyStartEvent() {
        ListenerMediathekView.notify(14, StarterClass.class.getSimpleName());
    }

    private void buttonStartsPutzen() {
        this.listeStarts.buttonStartsPutzen();
    }

    private Start getListe() {
        return this.listeStarts.getListe();
    }

    private int laenge(String url) {
        int ret;
        try {
            URL u = new URL(url);
            ret = u.openConnection().getContentLength();
        }
        catch (Exception ex) {
            ret = -1;
            Log.fehlerMeldung(643298301, 0, "StarterClass.StartenDonwnload.laenge", ex);
        }
        if (ret < 100) {
            ret = -1;
        }
        return ret;
    }

    private boolean pruefen(Start start) {
        boolean ret = false;
        File file = new File(start.datenDownload.arr[18]);
        if (!file.exists()) {
            Log.fehlerMeldung(550236231, 0, "StartetClass.pruefen-1", "Download fehlgeschlagen: Datei existiert nicht" + start.datenDownload.arr[18]);
        } else if (file.length() < 2048L) {
            Log.fehlerMeldung(795632500, 0, "StartetClass.pruefen-2", "Download fehlgeschlagen: Datei zu klein" + start.datenDownload.arr[18]);
        } else {
            if (start.datenDownload.istAbo()) {
                this.ddaten.erledigteAbos.zeileSchreiben(start.datenDownload.arr[4], start.datenDownload.arr[5], start.datenDownload.arr[9]);
            }
            ret = true;
        }
        return ret;
    }

    private void leeresFileLoeschen(File file) {
        try {
            if (file.exists()) {
                if (file.length() == 0L) {
                    Log.systemMeldung(new String[]{"Restart/Aufr\u00e4umen: leere Datei l\u00f6schen", file.getAbsolutePath()});
                    file.delete();
                } else if (file.length() < 2048L) {
                    Log.systemMeldung(new String[]{"Restart/Aufr\u00e4umen: Zu kleine Datei l\u00f6schen", file.getAbsolutePath()});
                    file.delete();
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(795632500, 0, "StartetClass.leeresFileLoeschen", "Fehler beim l\u00f6schen" + file.getAbsolutePath());
        }
    }

    private void startmeldung(Start start) {
        boolean abspielen;
        ArrayList<String> text = new ArrayList<String>();
        boolean bl = abspielen = start.datenDownload.getQuelle() == 1;
        if (abspielen) {
            text.add("Film starten");
        } else {
            if (start.startcounter > 1) {
                text.add("Download starten - Restart (Summe Starts: " + start.startcounter + ")");
            } else {
                text.add("Download starten");
            }
            text.add("Programmset: " + start.datenDownload.arr[12]);
            text.add("Ziel: " + start.datenDownload.arr[18]);
        }
        text.add("URL: " + start.datenDownload.arr[9]);
        if (start.datenDownload.getArt() == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + start.datenDownload.arr[14]);
        }
        Log.systemMeldung(text.toArray(new String[0]));
    }

    private void fertigmeldung(Start start) {
        boolean abspielen;
        ArrayList<String> text = new ArrayList<String>();
        boolean bl = abspielen = start.datenDownload.getQuelle() == 1;
        if (abspielen) {
            text.add("Film fertig");
        } else {
            if (start.stoppen) {
                text.add("Download abgebrochen");
            } else if (start.status != 4) {
                text.add("Download ist fertig und hat geklappt");
            } else {
                text.add("Download ist fertig und war fehlerhaft");
            }
            text.add("Programmset: " + start.datenDownload.arr[12]);
            text.add("Ziel: " + start.datenDownload.arr[18]);
        }
        text.add("URL: " + start.datenDownload.arr[9]);
        if (start.datenDownload.getArt() == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + start.datenDownload.arr[14]);
        }
        Log.systemMeldung(text.toArray(new String[0]));
    }

    private class StartenDonwnload
    implements Runnable {
        Start start;

        public StartenDonwnload(Start s) {
            this.start = s;
            this.start.status = 2;
            StarterClass.this.notifyStartEvent();
        }

        @Override
        public void run() {
            StarterClass.this.startmeldung(this.start);
            try {
                int len;
                new File(this.start.datenDownload.arr[17]).mkdirs();
                URL feedUrl = new URL(this.start.datenDownload.arr[9]);
                int maxLen = StarterClass.this.laenge(this.start.datenDownload.arr[9]);
                int downLen = 0;
                InputStream input = feedUrl.openStream();
                byte[] buffer = new byte[1024];
                long pp = 0L;
                FileOutputStream destStream = new FileOutputStream(this.start.datenDownload.arr[18]);
                while ((len = input.read(buffer)) != -1 && !this.start.stoppen) {
                    downLen += len;
                    if (maxLen > 0) {
                        long p = (long)downLen * 1000L / (long)maxLen;
                        if (p == 0L) {
                            p = 1L;
                        }
                        if (p >= 1000L) {
                            p = 999L;
                        }
                        if (p != pp) {
                            this.start.datenDownload.startMelden((int)p);
                            pp = p;
                        }
                    }
                    ((OutputStream)destStream).write(buffer, 0, len);
                }
                input.close();
                ((OutputStream)destStream).close();
            }
            catch (Exception ex) {
                Log.fehlerMeldung(502039078, 0, "StarterClass.StartenDonwnload-1", ex);
            }
            if (!this.start.stoppen) {
                this.start.status = this.start.datenDownload.getQuelle() == 1 ? 3 : (StarterClass.this.pruefen(this.start) ? 3 : 4);
            }
            StarterClass.this.leeresFileLoeschen(new File(this.start.datenDownload.arr[18]));
            StarterClass.this.fertigmeldung(this.start);
            this.start.datenDownload.startMelden(1000);
            StarterClass.this.notifyStartEvent();
        }
    }

    private class StartenProgramm
    implements Runnable {
        Start start;
        RuntimeExec runtimeExec;
        File file;

        public StartenProgramm(Start s) {
            this.start = s;
            this.start.status = 2;
            this.file = new File(this.start.datenDownload.arr[18]);
            StarterClass.this.notifyStartEvent();
            try {
                new File(this.start.datenDownload.arr[17]).mkdirs();
            }
            catch (Exception ex) {
                Log.fehlerMeldung(469365281, 0, "StarterClass.StartenProgramm-1", ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            long filesize = -1L;
            boolean stat_start = false;
            boolean stat_laufen = true;
            int stat_restart = 3;
            int stat_pruefen = 4;
            int stat_fertig_ok = 10;
            int stat_fertig_fehler = 11;
            int stat_ende = 99;
            int stat = 0;
            try {
                block14: while (stat < 99) {
                    switch (stat) {
                        case 0: {
                            if (this.starten()) {
                                stat = 1;
                                break;
                            }
                            stat = 3;
                            break;
                        }
                        case 1: {
                            try {
                                if (this.start.stoppen) {
                                    stat = 10;
                                    if (this.start.process == null) continue block14;
                                    this.start.process.destroy();
                                    break;
                                }
                                int exitV = this.start.process.exitValue();
                                if (exitV != 0) {
                                    stat = 3;
                                    break;
                                }
                                stat = 4;
                            }
                            catch (Exception ex) {
                                try {
                                    this.wait(2000L);
                                    break;
                                }
                                catch (InterruptedException e) {}
                            }
                            continue block14;
                        }
                        case 3: {
                            if (!this.start.datenDownload.isRestart()) {
                                stat = 11;
                                break;
                            }
                            if (filesize == -1L) {
                                StarterClass.this.leeresFileLoeschen(this.file);
                                if (this.file.exists()) {
                                    filesize = this.file.length();
                                    stat = 0;
                                    break;
                                }
                                if (this.start.startcounter < 3) {
                                    stat = 0;
                                    break;
                                }
                                stat = 11;
                                break;
                            }
                            if (!this.file.exists()) {
                                stat = 11;
                                break;
                            }
                            if (this.file.length() > filesize) {
                                filesize = this.file.length();
                                stat = 0;
                                break;
                            }
                            stat = 11;
                            break;
                        }
                        case 4: {
                            if (this.start.datenDownload.getQuelle() == 1) {
                                stat = 10;
                                break;
                            }
                            if (StarterClass.this.pruefen(this.start)) {
                                stat = 10;
                                break;
                            }
                            stat = 11;
                            break;
                        }
                        case 11: {
                            this.start.status = 4;
                            stat = 99;
                            break;
                        }
                        case 10: {
                            this.start.status = 3;
                            stat = 99;
                            continue block14;
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(395623710, 0, "StarterClass.StartenProgramm-2", ex);
            }
            StarterClass.this.leeresFileLoeschen(this.file);
            StarterClass.this.fertigmeldung(this.start);
            this.start.datenDownload.startMelden(1000);
            StarterClass.this.notifyStartEvent();
        }

        private boolean starten() {
            boolean ret = false;
            ++this.start.startcounter;
            StarterClass.this.startmeldung(this.start);
            this.runtimeExec = new RuntimeExec(this.start);
            this.start.process = this.runtimeExec.exec();
            if (this.start.process != null) {
                ret = true;
            }
            return ret;
        }
    }

    private class Starten
    implements Runnable {
        Start start;

        private Starten() {
        }

        @Override
        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        if ((this.start = StarterClass.this.getListe()) != null) {
                            this.startStarten(this.start);
                            this.wait(5000L);
                            continue;
                        }
                        StarterClass.this.buttonStartsPutzen();
                        this.wait(3000L);
                    }
                }
                catch (Exception ex) {
                    Log.fehlerMeldung(613822015, 0, "StarterClass.Starten.run", ex);
                    continue;
                }
                break;
            }
        }

        private void startStarten(Start start) {
            start.datenDownload.startMelden(1);
            switch (start.datenDownload.getArt()) {
                case 2: {
                    StartenProgramm startenProgrammn = new StartenProgramm(start);
                    new Thread(startenProgrammn).start();
                    break;
                }
                case 1: {
                    StartenDonwnload startenDonwnload = new StartenDonwnload(start);
                    new Thread(startenDonwnload).start();
                    break;
                }
                default: {
                    Log.fehlerMeldung(789356001, 0, "StartetClass.startStarten", "StarterClass.Starten - Switch-default");
                }
            }
        }
    }
}

