/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io.starter;

import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.controller.io.starter.Start;
import mediathek.daten.DDaten;
import mediathek.daten.DatenDownload;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModel;

public class ListeStarts
extends LinkedList<Start> {
    DDaten ddaten;

    public ListeStarts(DDaten d) {
        this.ddaten = d;
    }

    synchronized void addStarts(Start start) {
        if (start != null && !this.contain(start)) {
            this.add(start);
            this.ddaten.history.add(start.datenDownload.arr[9]);
        }
        this.notifyStartEvent();
    }

    synchronized Start getStart(String url) {
        Start ret = null;
        for (Start s : this) {
            if (!s.datenDownload.arr[9].equals(url)) continue;
            ret = s;
            break;
        }
        return ret;
    }

    synchronized LinkedList<Start> getStarts(int quelle) {
        LinkedList<Start> ret = new LinkedList<Start>();
        for (Start s : this) {
            if (s.datenDownload.getQuelle() != quelle && quelle != -1) continue;
            ret.add(s);
        }
        return ret;
    }

    synchronized Start urlVorziehen(String url) {
        Start s = null;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            s = (Start)it.next();
            if (!s.datenDownload.arr[9].equals(url)) continue;
            if (s.status >= 2) break;
            it.remove();
            this.addFirst(s);
            break;
        }
        return s;
    }

    synchronized int getDownloadsWarten() {
        int ret = 0;
        for (Start s : this) {
            if (s.datenDownload.getQuelle() != 3 && s.datenDownload.getQuelle() != 2 || s.status != 1) continue;
            ++ret;
        }
        return ret;
    }

    synchronized int getDownloadsLaufen() {
        int ret = 0;
        for (Start s : this) {
            if (s.datenDownload.getQuelle() != 3 && s.datenDownload.getQuelle() != 2 || s.status != 2) continue;
            ++ret;
        }
        return ret;
    }

    void buttonStartsPutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Start s = (Start)it.next();
            if (s.datenDownload.getQuelle() != 1 || s.status == 2) continue;
            it.remove();
            gefunden = true;
        }
        if (gefunden) {
            this.notifyStartEvent();
        }
    }

    synchronized Start getListe() {
        Start s;
        Start ret = null;
        if (this.size() >= 0 && this.getDown() < Integer.parseInt(DDaten.system[18]) && (s = this.naechsterStart()) != null && s.status == 1) {
            ret = s;
        }
        return ret;
    }

    void delStart(String url) {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            Start s = (Start)it.next();
            if (!s.datenDownload.arr[9].equals(url)) continue;
            s.stoppen = true;
            it.remove();
            this.notifyStartEvent();
            break;
        }
    }

    void delAllStart() {
        block0: {
            ListIterator it = this.listIterator(0);
            if (!it.hasNext()) break block0;
            Start s = (Start)it.next();
            s.stoppen = true;
            it.remove();
            this.notifyStartEvent();
        }
    }

    private int getDown() {
        int ret = 0;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            Start s = (Start)it.next();
            if (s.status != 2) continue;
            ++ret;
        }
        return ret;
    }

    void aufraeumen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Start start = (Start)it.next();
            if (start.status < 3) continue;
            it.remove();
            gefunden = true;
        }
        if (gefunden) {
            this.notifyStartEvent();
        }
    }

    int getmax() {
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            if (((Start)it.next()).status >= 3) continue;
            return this.size();
        }
        return 0;
    }

    TModel getModelStarts(TModel model) {
        model.setRowCount(0);
        if (this.size() > 0) {
            Iterator iterator = this.iterator();
            int objLen = 23;
            Object[] object = new Object[objLen];
            while (iterator.hasNext()) {
                Start start = (Start)iterator.next();
                for (int k = 0; k < objLen; ++k) {
                    object[k] = k < 22 ? start.datenDownload.arr[k] : (start.datenDownload.istAbo() ? "Abo" : "");
                }
                model.addRow(object);
            }
        }
        return model;
    }

    public static TModel getEmptyModel() {
        int max = 23;
        Object[] titel = new String[max];
        for (int i = 0; i < max; ++i) {
            titel[i] = i < 22 ? DatenDownload.DOWNLOAD_COLUMN_NAMES[i] : "Art";
        }
        TModel model = new TModel(new Object[0][], titel);
        return model;
    }

    private boolean contain(Start start) {
        boolean ret = false;
        ListIterator it = this.listIterator(0);
        while (it.hasNext()) {
            Start s = (Start)it.next();
            if (!s.datenDownload.arr[9].equals(start.datenDownload.arr[9])) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private Start naechsterStart() {
        for (Start s : this) {
            if (s.status != 1 || this.maxSenderLaufen(s, 1)) continue;
            return s;
        }
        for (Start s : this) {
            if (s.status != 1 || this.maxSenderLaufen(s, 2)) continue;
            return s;
        }
        return null;
    }

    private boolean maxSenderLaufen(Start s, int max) {
        try {
            int counter = 0;
            String host = this.getHost(s);
            for (Start start : this) {
                if (start.status != 2 || !this.getHost(start).equalsIgnoreCase(host) || ++counter < max) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHost(Start s) {
        String host = "";
        try {
            try {
                URL url;
                String tmp;
                String uurl = s.datenDownload.arr[9];
                if (uurl.startsWith("rtmpt:")) {
                    uurl = uurl.toLowerCase().replace("rtmpt:", "http:");
                }
                if (uurl.startsWith("rtmp:")) {
                    uurl = uurl.toLowerCase().replace("rtmp:", "http:");
                }
                if (uurl.startsWith("mms:")) {
                    uurl = uurl.toLowerCase().replace("mms:", "http:");
                }
                if ((tmp = (url = new URL(uurl)).getHost()).contains(".")) {
                    host = tmp.substring(tmp.lastIndexOf("."));
                    host = (tmp = tmp.substring(0, tmp.lastIndexOf("."))).contains(".") ? tmp.substring(tmp.lastIndexOf(".") + 1) + host : (tmp.contains("/") ? tmp.substring(tmp.lastIndexOf("/") + 1) + host : "host");
                }
            }
            catch (Exception ex) {
                host = "host";
            }
            finally {
                if (host == null) {
                    host = "host";
                }
                if (host.equals("")) {
                    host = "host";
                }
            }
        }
        catch (Exception ex) {
            host = "exception";
        }
        return host;
    }

    private void notifyStartEvent() {
        ListenerMediathekView.notify(14, this.getClass().getSimpleName());
    }
}

