/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import mediathek.controller.filmeLaden.importieren.DatenFilmlistenServer;
import mediathek.controller.filmeLaden.importieren.DatenUrlFilmliste;
import mediathek.controller.filmeLaden.importieren.FilmlistenSuchen;
import mediathek.daten.DDaten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenBlacklist;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.ListeBlacklist;
import mediathek.daten.ListePset;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Konstanten;
import mediathek.tool.Log;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class IoXmlLesen {
    ZipOutputStream zipOutputStream = null;
    BZip2CompressorOutputStream bZip2CompressorOutputStream = null;

    public void datenLesen(DDaten daten) {
        this.xmlDatenLesen(daten);
    }

    public static boolean einstellungenExistieren() {
        try {
            String datei = Daten.getBasisVerzeichnis(false) + "mediathek.xml";
            if (new File(datei).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static ListePset importPset(String dateiUrl, boolean log) {
        int timeout = 10000;
        try {
            if (GuiFunktionen.istUrl(dateiUrl)) {
                URLConnection conn = new URL(dateiUrl).openConnection();
                conn.setConnectTimeout(timeout);
                conn.setReadTimeout(timeout);
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                return IoXmlLesen.importPset(conn.getInputStream(), log);
            }
            return IoXmlLesen.importPset(new FileInputStream(dateiUrl), log);
        }
        catch (Exception ex) {
            if (log) {
                Log.fehlerMeldung(630048926, 0, "IoXml.importPset", ex);
            }
            return null;
        }
    }

    public static ListePset importPset(InputStream datei, boolean log) {
        DatenPset datenPset = null;
        ListePset liste = new ListePset();
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            InputStreamReader in = new InputStreamReader(datei, "UTF-8");
            XMLStreamReader parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1) continue;
                if (parser.getLocalName().equals("Programmset")) {
                    datenPset = new DatenPset();
                    if (!IoXmlLesen.get(parser, event, "Programmset", DatenPset.PROGRAMMSET_COLUMN_NAMES, datenPset.arr, false)) {
                        datenPset = null;
                        continue;
                    }
                    liste.add(datenPset);
                    continue;
                }
                if (!parser.getLocalName().equals("Programm") || datenPset == null) continue;
                DatenProg datenProg = new DatenProg();
                if (!IoXmlLesen.get(parser, event, "Programm", DatenProg.PROGRAMM_COLUMN_NAMES, datenProg.arr, false)) continue;
                datenPset.addProg(datenProg);
            }
        }
        catch (Exception ex) {
            if (log) {
                Log.fehlerMeldung(467810360, 0, "IoXml.importPset", ex);
            }
            return null;
        }
        if (liste.size() == 0) {
            return null;
        }
        ListePset ll = new ListePset();
        ll.addVorlage(liste);
        return ll;
    }

    public static ListePset importPsetText(String text, boolean log) {
        DatenPset datenPset = null;
        ListePset liste = new ListePset();
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(text.getBytes()));
            XMLStreamReader parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("Programmset")) continue;
                datenPset = new DatenPset();
                if (!IoXmlLesen.get(parser, event, "Programmset", DatenPset.PROGRAMMSET_COLUMN_NAMES, datenPset.arr, false)) {
                    datenPset = null;
                } else {
                    liste.add(datenPset);
                }
                if (datenPset == null) continue;
                DatenProg datenProg = new DatenProg();
                if (!IoXmlLesen.get(parser, event, "Programm", DatenProg.PROGRAMM_COLUMN_NAMES, datenProg.arr, false)) continue;
                datenPset.addProg(datenProg);
            }
        }
        catch (Exception ex) {
            if (log) {
                Log.fehlerMeldung(100298325, 0, "IoXml.importPset", ex);
            }
            return null;
        }
        if (liste.size() == 0) {
            return null;
        }
        ListePset ll = new ListePset();
        ll.addVorlage(liste);
        return ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void xmlDatenLesen(DDaten ddaten) {
        try {
            String datei = Daten.getBasisVerzeichnis(false) + "mediathek.xml";
            if (new File(datei).exists()) {
                XMLInputFactory inFactory = XMLInputFactory.newInstance();
                inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
                DatenPset datenPset = null;
                InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(datei), "UTF-8");
                XMLStreamReader parser = inFactory.createXMLStreamReader(in);
                while (parser.hasNext()) {
                    int event = parser.next();
                    if (event != 1) continue;
                    if (parser.getLocalName().equals("system")) {
                        IoXmlLesen.get(parser, event, "system", Konstanten.SYSTEM_COLUMN_NAMES, DDaten.system);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programmset")) {
                        datenPset = new DatenPset();
                        if (!IoXmlLesen.get(parser, event, "Programmset", DatenPset.PROGRAMMSET_COLUMN_NAMES, datenPset.arr)) continue;
                        ddaten.listePset.add(datenPset);
                        continue;
                    }
                    if (parser.getLocalName().equals("Programm")) {
                        DatenProg datenProg = new DatenProg();
                        if (!IoXmlLesen.get(parser, event, "Programm", DatenProg.PROGRAMM_COLUMN_NAMES, datenProg.arr) || datenPset == null) continue;
                        datenPset.addProg(datenProg);
                        continue;
                    }
                    if (parser.getLocalName().equals("Abonnement")) {
                        DatenAbo datenAbo = new DatenAbo();
                        if (!IoXmlLesen.get(parser, event, "Abonnement", DatenAbo.ABO_COLUMN_NAMES, datenAbo.arr)) continue;
                        ddaten.listeAbo.addAbo(datenAbo);
                        continue;
                    }
                    if (parser.getLocalName().equals("Downlad")) {
                        DatenDownload d = new DatenDownload();
                        if (!IoXmlLesen.get(parser, event, "Downlad", DatenDownload.DOWNLOAD_COLUMN_NAMES, d.arr)) continue;
                        ddaten.listeDownloads.add(d);
                        continue;
                    }
                    if (parser.getLocalName().equals("Blacklist")) {
                        ListeBlacklist blacklist = ddaten.listeBlacklist;
                        DatenBlacklist datenBlacklist = new DatenBlacklist();
                        if (!IoXmlLesen.get(parser, event, "Blacklist", DatenBlacklist.BLACKLIST_COLUMN_NAMES, datenBlacklist.arr)) continue;
                        blacklist.add(datenBlacklist);
                        continue;
                    }
                    if (parser.getLocalName().equals("film-update-server")) {
                        DatenUrlFilmliste datenUrlFilmliste = new DatenUrlFilmliste();
                        if (!IoXmlLesen.get(parser, event, "film-update-server", FilmlistenSuchen.FILM_UPDATE_SERVER_COLUMN_NAMES, datenUrlFilmliste.arr)) continue;
                        DDaten.filmeLaden.getDownloadUrlsFilmlisten(false).addWithCheck(datenUrlFilmliste);
                        continue;
                    }
                    if (!parser.getLocalName().equals("film-listen-server")) continue;
                    DatenFilmlistenServer datenFilmlistenServer = new DatenFilmlistenServer();
                    if (!IoXmlLesen.get(parser, event, "film-listen-server", DatenFilmlistenServer.FILM_LISTEN_SERVER_COLUMN_NAMES, datenFilmlistenServer.arr)) continue;
                    DDaten.filmeLaden.getListeFilmlistnServer().add(datenFilmlistenServer);
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(392840096, 0, "IoXml.xmlDatenLesen", ex);
        }
        finally {
            ddaten.listeDownloads.listeNummerieren();
            DDaten.filmeLaden.getDownloadUrlsFilmlisten(false).sort();
        }
    }

    private static boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet) {
        return IoXmlLesen.get(parser, event, xmlElem, xmlNames, strRet, true);
    }

    private static boolean get(XMLStreamReader parser, int event, String xmlElem, String[] xmlNames, String[] strRet, boolean log) {
        boolean ret;
        block5: {
            int i;
            ret = true;
            int maxElem = strRet.length;
            for (i = 0; i < maxElem; ++i) {
                if (strRet[i] != null) continue;
                strRet[i] = "";
            }
            try {
                block3: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                    if (event != 1) continue;
                    for (i = 0; i < maxElem; ++i) {
                        if (!parser.getLocalName().equals(xmlNames[i])) continue;
                        strRet[i] = parser.getElementText();
                        continue block3;
                    }
                }
            }
            catch (Exception ex) {
                ret = false;
                if (!log) break block5;
                Log.fehlerMeldung(739530149, 0, "IoXmlLesen.get", ex);
            }
        }
        return ret;
    }
}

