/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.suchen.sender;

import java.util.LinkedList;
import java.util.ListIterator;
import mediathek.controller.filmeLaden.suchen.FilmeSuchenSender;
import mediathek.controller.io.GetUrl;
import mediathek.daten.DatenFilm;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.Log;

public class MediathekReader
implements Runnable {
    String nameSenderFilmliste = "";
    String nameSenderMReader = "";
    int maxThreadLaufen = 4;
    long wartenSeiteLaden = 500L;
    boolean updateOn = false;
    int threads = 0;
    int max = 0;
    int progress = 0;
    int startPrio = 1;
    LinkedListUrl listeThemen = new LinkedListUrl();
    GetUrl getUrlIo;
    FilmeSuchenSender suchen;

    public MediathekReader(FilmeSuchenSender ssearch, String nameMreader, int ssenderMaxThread, int ssenderWartenSeiteLaden, int sstartPrio) {
        this.suchen = ssearch;
        this.wartenSeiteLaden = ssenderWartenSeiteLaden;
        this.getUrlIo = new GetUrl(ssenderWartenSeiteLaden);
        this.nameSenderFilmliste = nameMreader;
        this.nameSenderMReader = nameMreader;
        this.maxThreadLaufen = ssenderMaxThread;
        this.startPrio = sstartPrio;
    }

    public int getStartPrio() {
        return this.startPrio;
    }

    public boolean checkNameSenderFilmliste(String name) {
        return this.nameSenderMReader.equalsIgnoreCase(name);
    }

    public String[] getNameSenderFilmliste() {
        return new String[]{this.nameSenderFilmliste};
    }

    public String getNameSenderMreader() {
        return this.nameSenderMReader;
    }

    @Override
    public void run() {
        try {
            this.updateOn = false;
            this.threads = 0;
            this.addToList();
        }
        catch (Exception ex) {
            Log.fehlerMeldung(-397543600, 2, "MediathekReader.run", ex, this.nameSenderMReader);
        }
    }

    void addToList() {
    }

    boolean addFilm(DatenFilm film) {
        return this.suchen.listeFilmeNeu.addFilmVomSender(film);
    }

    boolean istInListe(LinkedList<String[]> liste, String str, int nr) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String[])it.next())[nr].equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    boolean istInListe(LinkedList<String> liste, String str) {
        boolean ret = false;
        ListIterator it = liste.listIterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(str)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    synchronized void meldungStart() {
        this.max = 0;
        this.progress = 0;
        this.suchen.melden(this.nameSenderMReader, this.max, this.progress, "");
    }

    synchronized void meldungAddMax(int mmax) {
        this.max += mmax;
        this.suchen.melden(this.nameSenderMReader, this.max, this.progress, "");
    }

    synchronized void meldungAddThread() {
        ++this.threads;
        this.suchen.melden(this.nameSenderMReader, this.max, this.progress, "");
    }

    synchronized void meldungProgress(String text) {
        ++this.progress;
        this.suchen.melden(this.nameSenderMReader, this.max, this.progress, text);
    }

    synchronized void meldung(String text) {
        this.suchen.melden(this.nameSenderMReader, this.max, this.progress, text);
    }

    synchronized void meldungThreadUndFertig() {
        --this.threads;
        if (this.threads <= 0) {
            this.suchen.meldenFertig(this.nameSenderMReader);
        } else {
            this.suchen.melden(this.nameSenderMReader, this.max, this.progress, "");
        }
    }

    String addsUrl(String pfad1, String pfad2) {
        String ret = "";
        if (pfad1 != null && pfad2 != null && !pfad1.equals("") && !pfad2.equals("")) {
            ret = pfad1.charAt(pfad1.length() - 1) == '/' ? pfad1.substring(0, pfad1.length() - 1) : pfad1;
            ret = pfad2.charAt(0) == '/' ? ret + pfad2 : ret + '/' + pfad2;
        }
        if (ret.equals("")) {
            Log.fehlerMeldung(-469872800, 2, "MediathekReader.addsUrl", pfad1 + " " + pfad2);
        }
        return ret;
    }

    static void listeSort(LinkedList<String[]> liste, int stelle) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (liste != null) {
            for (int i = 1; i < liste.size(); ++i) {
                String str2;
                String str1;
                for (int k = i; k > 0 && sorter.compare(str1 = liste.get(k - 1)[stelle], str2 = liste.get(k)[stelle]) > 0; --k) {
                    liste.add(k - 1, liste.remove(k));
                }
            }
        }
    }

    class LinkedListUrl
    extends LinkedList<String[]> {
        LinkedListUrl() {
        }

        synchronized boolean addUrl(String[] e) {
            if (!MediathekReader.this.istInListe(this, e[0], 0)) {
                return super.add(e);
            }
            return false;
        }

        synchronized String[] getListeThemen() {
            return (String[])this.pollFirst();
        }
    }
}

