/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.filmeLaden.suchen.sender;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipInputStream;
import mediathek.controller.filmeLaden.suchen.FilmeSuchenSender;
import mediathek.controller.filmeLaden.suchen.sender.MediathekReader;
import mediathek.daten.Daten;
import mediathek.daten.DatenFilm;
import mediathek.tool.Log;

public class MediathekBr
extends MediathekReader
implements Runnable {
    public static final String SENDER = "BR";

    public MediathekBr(FilmeSuchenSender ssearch, int startPrio) {
        super(ssearch, SENDER, 2, 500, startPrio);
    }

    @Override
    void addToList() {
        new Thread(new ThemaLaden()).start();
    }

    private class ThemaLaden
    implements Runnable {
        private ThemaLaden() {
        }

        @Override
        public synchronized void run() {
            MediathekBr.this.meldungStart();
            MediathekBr.this.meldungAddMax(1);
            MediathekBr.this.meldungAddThread();
            try {
                this.laden();
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-761355948, 2, "MediathekBr.ThemaLaden.run", ex, "");
            }
            MediathekBr.this.meldungThreadUndFertig();
        }

        void laden() {
            MediathekBr.this.getUrlIo.getDummy(MediathekBr.this.nameSenderMReader);
            StringBuilder seite = new StringBuilder(0x190000);
            int pos = 0;
            String ITEM_1 = "<ausstrahlung";
            String ITEM_2 = "</ausstrahlung>";
            String MUSTER_URL = "<video ";
            String MUSTER_THEMA = "<titel>";
            String MUSTER_TITEL = "<nebentitel>";
            String MUSTER_DATUM = "<beginnPlan>";
            String ADRESSE = "http://rd.gl-systemhaus.de/br/b7/nc/archive/archive.xml.zip.adler32";
            MediathekBr.this.meldungProgress("http://rd.gl-systemhaus.de/br/b7/nc/archive/archive.xml.zip.adler32");
            try {
                int posEnde;
                int timeout = 30000;
                char[] zeichen = new char[1];
                URLConnection conn = new URL("http://rd.gl-systemhaus.de/br/b7/nc/archive/archive.xml.zip.adler32").openConnection();
                conn.setRequestProperty("User-Agent", Daten.getUserAgent());
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                ZipInputStream zipInputStream = new ZipInputStream(conn.getInputStream());
                zipInputStream.getNextEntry();
                InputStreamReader inReader = new InputStreamReader((InputStream)zipInputStream, "UTF-8");
                seite.setLength(0);
                while (!Daten.filmeLaden.getStop() && inReader.read(zeichen) != -1) {
                    seite.append(zeichen);
                }
                while ((pos = seite.indexOf("<ausstrahlung", pos)) != -1 && (posEnde = seite.indexOf("</ausstrahlung>", pos += "<ausstrahlung".length())) != -1) {
                    int pos2;
                    String url = "";
                    String thema = "";
                    String link = "";
                    String datum = "";
                    String zeit = "";
                    String titel = "";
                    int pos1 = pos;
                    while ((pos1 = seite.indexOf("<video ", pos1)) != -1 && ((pos2 = seite.indexOf("/>", pos1 += "<video ".length())) == -1 || pos1 <= posEnde && pos2 <= posEnde && !(url = seite.substring(pos1, pos2)).contains("xlarge"))) {
                    }
                    if (url.equals("")) continue;
                    pos1 = seite.indexOf("<titel>", pos);
                    if (pos1 != -1 && (pos2 = seite.indexOf("</", pos1 += "<titel>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                        thema = seite.substring(pos1, pos2);
                        thema = thema.replace("<!", "");
                        thema = thema.replace("[", "");
                        thema = thema.replace("CDATA", "");
                        thema = thema.replace("]", "");
                        thema = thema.replace(">", "");
                    }
                    if ((pos1 = seite.indexOf("<nebentitel>", pos)) != -1 && (pos2 = seite.indexOf("</", pos1 += "<nebentitel>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                        titel = seite.substring(pos1, pos2);
                        titel = titel.replace("<!", "");
                        titel = titel.replace("[", "");
                        titel = titel.replace("CDATA", "");
                        titel = titel.replace("]", "");
                        titel = titel.replace(">", "");
                    }
                    if (titel.equals("")) {
                        titel = thema;
                    }
                    if ((pos1 = seite.indexOf("<beginnPlan>", pos)) != -1 && (pos2 = seite.indexOf("<", pos1 += "<beginnPlan>".length())) != -1 && pos1 < posEnde && pos2 < posEnde) {
                        String tmp = seite.substring(pos1, pos2);
                        datum = this.convertDatum(tmp);
                        zeit = this.convertTime(tmp);
                    }
                    String host = "";
                    String app = "";
                    String play = "";
                    int p = url.indexOf("host=\"");
                    if (p != -1) {
                        host = url.substring(p += "host=\"".length(), url.indexOf("\"", p));
                    }
                    if ((p = url.indexOf("application=\"")) != -1) {
                        app = url.substring(p += "application=\"".length(), url.indexOf("\"", p));
                    }
                    if ((p = url.indexOf("stream=\"")) != -1) {
                        play = url.substring(p += "stream=\"".length(), url.indexOf("\"", p));
                    }
                    String urlOrg = "rtmp://" + host + "/" + app + "/" + play;
                    DatenFilm film = new DatenFilm(MediathekBr.this.nameSenderMReader, thema, link, titel, urlOrg, datum, zeit);
                    MediathekBr.this.addFilm(film);
                }
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-963486054, 2, "MediathekBr.laden", ex, "");
            }
        }

        public String convertDatum(String datum) {
            try {
                SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date filmDate = sdfIn.parse(datum);
                SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
                datum = sdfOut.format(filmDate);
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-210365944, 2, "MediathekBr.convertDatum", ex, "");
            }
            return datum;
        }

        public String convertTime(String datum) {
            try {
                SimpleDateFormat sdfIn = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Date filmDate = sdfIn.parse(datum);
                SimpleDateFormat sdfOut = new SimpleDateFormat("HH:mm:ss");
                datum = sdfOut.format(filmDate);
            }
            catch (Exception ex) {
                Log.fehlerMeldung(-573690176, 2, "MediatheBr.convertTime", ex, "");
            }
            return datum;
        }
    }
}

